﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    using System;
    using System.Collections.Generic;
    using NintendoWare.SoundFoundation.Logs;
    using NintendoWare.SoundFoundation.Projects;

    /// <summary>
    /// サウンドプロジェクトのコンバート機能を提供します。
    /// </summary>
    public interface ISoundProjectConvertService
    {
        /// <summary>
        /// 作成者を取得または設定します。
        /// </summary>
        string Generator { get; set; }

        /// <summary>
        /// 出力ディレクトリを取得します。
        /// </summary>
        string OutputDirectoryPath { get; }

        /// <summary>
        /// バイナリサウンドアーカイブファイルパスを取得します。
        /// </summary>
        string BinarySoundArchiveFilePath { get; }

        /// <summary>
        /// 並列コンバートスレッドの最大数を取得または設定します。
        /// </summary>
        uint ParallelConversionCountMax { get; set; }

        /// <summary>
        /// コンバート前コマンドを無効化するかどうかを取得または設定します。
        /// </summary>
        bool IsPreConvertCommandsIgnored { get; set; }

        /// <summary>
        /// コンバート後コマンドを無効化するかどうかを取得または設定します。
        /// </summary>
        bool IsPostConvertCommandsIgnored { get; set; }

        /// <summary>
        /// コンバート中かどうかを調べます。
        /// </summary>
        bool IsConverting { get; }

        /// <summary>
        /// 進捗状況の最大値を取得します。
        /// </summary>
        int ProgressMax { get; }

        /// <summary>
        /// 進捗状況の現在値を取得します。
        /// </summary>
        int ProgressCurrent { get; }

        /// <summary>
        /// コンバートが開始されると発生します。
        /// </summary>
        event EventHandler<SoundProjectConvertEventArgs> BeginConvert;

        /// <summary>
        /// コンバートが終了すると発生します。
        /// </summary>
        event EventHandler<SoundProjectConvertEventArgs> EndConvert;

        /// <summary>
        /// ライン出力の際に発生します。
        /// </summary>
        event EventHandler<OutputLineEventArgs> OutputLine;

        /// <summary>
        /// コンバートします。
        /// </summary>
        /// <param name="projectService">コンバートするプロジェクトサービスを指定します。</param>
        /// <param name="settings">コンバート設定を指定します。</param>
        void Convert(SoundProjectService projectService, SoundProjectConvertSettings settings);

        /// <summary>
        /// 指定アイテムのみを部分コンバートします。
        /// </summary>
        /// <remarks>
        /// 部分コンバートでは他のアイテムとの波形共有はできません。
        /// グループのコンバートも非対応です。
        /// </remarks>
        /// <param name="projectService">コンバートするプロジェクトサービスを指定します。</param>
        /// <param name="settings">コンバート設定を指定します。</param>
        void ConvertParts(SoundProjectService projectService, SoundProjectConvertPartsSettings settings);

        /// <summary>
        /// コンバートを中止します。
        /// </summary>
        void Cancel();

        /// <summary>
        /// コンバートが完了するまで待機します。
        /// </summary>
        void Wait();
    }
}
