﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    using Logs;
    using Projects;

    public class InternalErrorLine : ErrorLine
    {
        public InternalErrorLine(string text) : base(text)
        {
        }

        public InternalErrorLine(string text, Component component)
            : base(text, component)
        {
        }

        public InternalErrorLine(string text, params Component[] components)
            : base(text, components)
        {
        }

        protected override string Header
        {
            get
            {
                if (this.Components.Length == 0)
                {
                    return Resources.MessageResource.MessageHeader_Error_Internal;
                }

                return string.Format(
                    Resources.MessageResource.MessageHeader_Error_InternalWithName,
                    this.Components[0].Name);
            }
        }
    }
}
