﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion
{
    using System;
    using System.Collections.Generic;
    using NintendoWare.SoundFoundation.Logs;

    /// <summary>
    /// カスタムコンバートイベントのパラメータを格納します。
    /// </summary>
    public class CustomConversionEventArgs : EventArgs
    {
        private readonly ILogger logger;
        private readonly List<string> outputFilePaths = new List<string>();

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="logger">Logger を指定します。</param>
        public CustomConversionEventArgs(ILogger logger)
        {
            this.logger = logger;
        }

        /// <summary>
        /// Logger を取得します。
        /// </summary>
        public ILogger Logger
        {
            get { return this.logger; }
        }

        /// <summary>
        /// 出力ファイルパスリストを取得します。
        /// </summary>
        public IList<string> OutputFilePaths
        {
            get { return this.outputFilePaths; }
        }
    }
}
