﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareReport
{
    using System.Collections.Generic;
    using Projects;

    internal class SoundSetPlayerListInfoProvider : ListInfoProvider<PlayerBase>
    {
        private SoundSet soundSet;
        private bool isIgnoreDisableItems;

        public SoundSetPlayerListInfoProvider(
            SoundProjectReportTraits traits,
            SoundSet soundSet,
            bool isIgnoreDisableItems,
            ListOutput listOutput)
            : base(traits, listOutput)
        {
            this.soundSet = soundSet;
            this.isIgnoreDisableItems = isIgnoreDisableItems;
        }

        public override string Caption
        {
            get { return "Player List"; }
        }

        public override IEnumerable<PlayerBase> Items
        {
            get
            {
                foreach (SoundSetItem itemPack in soundSet.Children)
                {
                    if (itemPack is PlayerPack)
                    {
                        foreach (PlayerBase player in itemPack.Children)
                        {
                            if (this.isIgnoreDisableItems && !player.IsEnabled)
                            {
                                continue;
                            }
                            yield return player;
                        }
                    }
                }
            }
        }
    }
}
