﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareReport
{
    using System.Collections.Generic;
    using NintendoWare.SoundFoundation.Projects;
    using ToolDevelopmentKit;

    /// <summary>
    /// サウンドプロジェクトレポートの特性を管理します。
    /// </summary>
    public class SoundProjectReportTraits : ReportTraits
    {
        public static class ColumnName
        {
            public const string ActorPlayer = "ActorPlayer";
            public const string FileName = "FileName";
            public const string ItemIndex = "ItemIndex";
            public const string ItemType = "ItemType";
            public const string Name = "Name";
            public const string PlayerPriority = "PlayerPriority";
            public const string PlayerReference = "PlayerReference";
            public const string PlayerSoundLimit = "PlayerSoundLimit";
            public const string Volume = "Volume";
            public const string Comment = "Comment";
            public const string Comment1 = "Comment1";
            public const string Comment2 = "Comment2";
            public const string Comment3 = "Comment3";
            public const string Comment4 = "Comment4";
            public const string Comment5 = "Comment5";
            public const string Comment6 = "Comment6";
            public const string Comment7 = "Comment7";
            public const string Comment8 = "Comment8";
            public const string Comment9 = "Comment9";
            public const string UserParameter = "UserParameter";
            public const string UserParameter1 = "UserParameter1";
            public const string UserParameter2 = "UserParameter2";
            public const string UserParameter3 = "UserParameter3";
        }

        public SoundProjectReportTraits(SoundProject project)
            : base(project)
        {
        }

        protected override void InitializeColumns(IDictionary<string, Column> columns)
        {
            Assertion.Argument.NotNull(columns);

            columns.Add(ColumnName.ActorPlayer,
                        new Column(ColumnName.ActorPlayer, "Actor Player", ColumnSortType.Number));
            columns.Add(ColumnName.FileName,
                        new Column(ColumnName.FileName, "File Name", ColumnSortType.String));
            columns.Add(ColumnName.ItemIndex,
                        new Column(ColumnName.ItemIndex, "Index", ColumnSortType.Number));
            columns.Add(ColumnName.ItemType,
                        new Column(ColumnName.ItemType, "Type", ColumnSortType.String));
            columns.Add(ColumnName.Name,
                        new Column(ColumnName.Name, "Name", ColumnSortType.String));
            columns.Add(ColumnName.PlayerPriority,
                        new Column(ColumnName.PlayerPriority, "Player Priority", ColumnSortType.Number));
            columns.Add(ColumnName.PlayerReference,
                        new Column(ColumnName.PlayerReference, "Player", ColumnSortType.String));
            columns.Add(ColumnName.PlayerSoundLimit,
                        new Column(ColumnName.PlayerSoundLimit, "Sound Limit", ColumnSortType.Number));
            columns.Add(ColumnName.Volume,
                        new Column(ColumnName.Volume, "Volume", ColumnSortType.Number));
            columns.Add(ColumnName.Comment,
                        new Column(ColumnName.Comment,
                                   ColumnText("Comment", this.Project.CommentColumnText),
                                   ColumnSortType.String,
                                   true));
            columns.Add(ColumnName.Comment1,
                        new Column(ColumnName.Comment1,
                                   ColumnText("Comment1", this.Project.Comment1ColumnText),
                                   ColumnSortType.String,
                                   true));
            columns.Add(ColumnName.Comment2,
                        new Column(ColumnName.Comment2,
                                   ColumnText("Comment2", this.Project.Comment2ColumnText),
                                   ColumnSortType.String,
                                   true));
            columns.Add(ColumnName.Comment3,
                        new Column(ColumnName.Comment3,
                                   ColumnText("Comment3", this.Project.Comment3ColumnText),
                                   ColumnSortType.String,
                                   true));
            columns.Add(ColumnName.Comment4,
                        new Column(ColumnName.Comment4,
                                   ColumnText("Comment4", this.Project.Comment4ColumnText),
                                   ColumnSortType.String,
                                   true));
            columns.Add(ColumnName.Comment5,
                        new Column(ColumnName.Comment5,
                                   ColumnText("Comment5", this.Project.Comment5ColumnText),
                                   ColumnSortType.String,
                                   true));
            columns.Add(ColumnName.Comment6,
                        new Column(ColumnName.Comment6,
                                   ColumnText("Comment6", this.Project.Comment6ColumnText),
                                   ColumnSortType.String,
                                   true));
            columns.Add(ColumnName.Comment7,
                        new Column(ColumnName.Comment7,
                                   ColumnText("Comment7", this.Project.Comment7ColumnText),
                                   ColumnSortType.String,
                                   true));
            columns.Add(ColumnName.Comment8,
                        new Column(ColumnName.Comment8,
                                   ColumnText("Comment8", this.Project.Comment8ColumnText),
                                   ColumnSortType.String,
                                   true));
            columns.Add(ColumnName.Comment9,
                        new Column(ColumnName.Comment9,
                                   ColumnText("Comment9", this.Project.Comment9ColumnText),
                                   ColumnSortType.String,
                                   true));
            columns.Add(ColumnName.UserParameter,
                        new Column(ColumnName.UserParameter, "UserParam", ColumnSortType.Number));
            columns.Add(ColumnName.UserParameter1,
                        new Column(ColumnName.UserParameter1, "UserParam1", ColumnSortType.Number));
            columns.Add(ColumnName.UserParameter2,
                        new Column(ColumnName.UserParameter2, "UserParam2", ColumnSortType.Number));
            columns.Add(ColumnName.UserParameter3,
                        new Column(ColumnName.UserParameter3, "UserParam3", ColumnSortType.Number));
        }

        private string ColumnText(string org, string cus)
        {
            if (org == cus)
            {
                return org;
            }
            else
            {
                return cus + "<br>(" + org + ")";
            }
        }
    }
}
