﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareReport
{
    using System.Collections.Generic;
    using NintendoWare.SoundFoundation.Projects;
    using ToolDevelopmentKit;

    /// <summary>
    /// レポートの特性を管理します。
    /// </summary>
    public abstract class ReportTraits
    {
        public ReportTraits()
            : this(null)
        {
        }

        public ReportTraits(SoundProject project)
        {
            this.Project = project;
            this.Columns = new Dictionary<string, Column>();
            this.InitializeColumns(this.Columns);
        }

        public SoundProject Project { get; private set; }

        public IDictionary<string, Column> Columns { get; private set; }

        protected abstract void InitializeColumns(IDictionary<string, Column> columns);
    }
}
