﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Web;

namespace NintendoWare.SoundFoundation.Commands
{
    public class CommandUri
    {
        private const char CommandNameSeparator = '?';
        private const char ParameterSeparator = '&';
        private const char ParameterValueSeparator = '=';
        private static readonly char[] CommandNameSeparators = new char[] { CommandNameSeparator };
        private static readonly char[] ParameterSeparators = new char[] { ParameterSeparator };
        private static readonly char[] ParameterValueSeparators = new char[] { ParameterValueSeparator };

        private string _uri = string.Empty;
        private string _id = string.Empty;
        private CommandParameterDictionary _parameters = new CommandParameterDictionary();

        public CommandUri(string uri)
        {
            Parse(uri);
        }

        public string Uri
        {
            get { return _uri; }
        }

        public string ID
        {
            get { return _id; }
        }

        public IReadOnlyCommandParameterDictionary Parameters
        {
            get { return _parameters; }
        }

        public static CommandUri Create(string id, IEnumerable<KeyValuePair<string, string>> parameters)
        {
            if (null == id) { throw new ArgumentNullException("id"); }
            if (null == parameters) { throw new ArgumentNullException("parameters"); }

            StringBuilder uri = new StringBuilder(id);
            bool isFirstParameter = true;

            foreach (KeyValuePair<string, string> parameter in parameters)
            {

                uri.AppendFormat("{0}{1}={2}",
                        isFirstParameter ? CommandNameSeparator : ParameterSeparator,
                        parameter.Key,
                        HttpUtility.UrlEncode(parameter.Value));

                isFirstParameter = false;

            }

            return new CommandUri(uri.ToString());
        }

        private void Parse(string uri)
        {
            if (null == uri) { return; }

            _uri = uri;

            string[] items = uri.Split(CommandNameSeparators, 2);
            if (0 == items.Length) { return; }

            _id = items[0];

            if (1 == items.Length) { return; }
            ParseParameters(items[1]);
        }

        private void ParseParameters(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            string[] expressions = text.Split(ParameterSeparators);

            foreach (string expression in expressions)
            {

                string[] items = expression.Split(ParameterValueSeparators);
                if (2 != items.Length) { continue; }

                _parameters.Add(items[0], HttpUtility.UrlDecode(items[1]));

            }

        }
    }
}
