﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;

    public abstract class AddressWriter
    {
        private long position = -1;
        private ObjectReference reference = null;
        private ObjectReference originReference = null;

        public long Position
        {
            get { return this.position; }
        }

        public ObjectReference Reference
        {
            get
            {
                if (null == this.reference) { return ObjectReference.Null; }
                return this.reference;
            }
            set { this.reference = value; }
        }

        public ObjectReference OriginReference
        {
            get
            {
                if (null == this.originReference) { return ObjectReference.Null; }
                return this.originReference;
            }
            set { this.originReference = value; }
        }

        public void Reserve(DomWriterContext context)
        {
            if (null == context) { throw new ArgumentNullException("context"); }

            this.position = context.Writer.Position;
            context.Writer.Write(GetInitialValue(context));
        }

        public void Commit(DomWriterContext context)
        {
            if (null == context) { throw new ArgumentNullException("context"); }

            if (0 > position) { throw new ArgumentOutOfRangeException("position"); }

            long currentPosition = context.Writer.Position;
            context.Writer.Position = this.position;

            context.Writer.Write(GetValue(context));

            context.Writer.Position = currentPosition;
        }

        protected abstract object GetInitialValue(DomWriterContext context);

        protected abstract object GetValue(DomWriterContext context);
    }
}
