﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    /// <summary>
    /// DOM要素フィールドの名前を取得するためのインターフェイスです。
    /// </summary>
    public interface IDomElementFieldNameProvider
    {
        /// <summary>
        /// DOM要素フィールド名を取得または設定します。
        /// </summary>
        string Name { get; set; }

        /// <summary>
        /// 指定した値からDOM要素フィールド名を取得します。
        /// </summary>
        /// <param name="parent">親DOM要素を指定します。</param>
        /// <param name="value">値を指定します。</param>
        /// <returns>DOM要素フィールドの名前を返します。</returns>
        string GetNameFromValue(DomElement parent, object value);
    }
}
