﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;

    /// <summary>
    /// 属性を適用する対象を表します。
    /// </summary>
    [Flags]
    public enum DomAttributeTarget : uint
    {
        /// <summary>
        /// すべてを対象外とします。
        /// </summary>
        None = 0,

        /// <summary>
        /// すべてを対象とします。
        /// </summary>
        All = uint.MaxValue,

        /// <summary>
        /// フィールドを対象とします。
        /// 展開されたフィールドは対象外です。
        /// </summary>
        Field = 1,

        /// <summary>
        /// フィールドに関連するすべての値を対象とします。
        /// 展開されたフィールドを対象とします。
        /// </summary>
        FieldValues = 2,
    }
}
