﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundAdditionalInfoConverter.Binaries
{
    public struct BinaryVersion
    {
        private short _major;
        private byte _minor;
        private byte _micro;

        //-----------------------------------------------------------------

        internal BinaryVersion(short major, byte minor, byte micro)
        {
            this._major = major;
            this._minor = minor;
            this._micro = micro;
        }

        //-----------------------------------------------------------------

        internal short Major
        {
            get { return this._major; }
        }

        internal byte Minor
        {
            get { return this._minor; }
        }

        internal byte Micro
        {
            get { return this._micro; }
        }

        internal int ToInt()
        {
            return (this.Major << 16) | (this.Minor << 8) | (this.Micro);
        }

        internal int GetSize()
        {
            return sizeof(short) + sizeof(byte) + sizeof(byte);
        }
    }
}
