﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#define EXPORT
#include <UtilStringResource.h>

 /**
 *  言語設定です。
 *  文字リソースファイル(.csv) の列番号を示します。
 */
enum Language
{
    Language_Identifier = 0,
    Language_English = 1,
    Language_Japanese = 2,
    Language_End
};

Language                           g_Language = Language_Identifier;
std::map<std::string, std::string> g_ResourceMapArray;
bool                               g_IsInitialized = false;

bool InitializeStringResource()
{
    if (g_IsInitialized)
    {
        return false;
    }
    // 現在のロケールを取得 日本語は 1041
    if (GetUserDefaultLCID() == 1041)
    {
        g_Language = Language_Japanese;
    }
    else
    {
        g_Language = Language_English;
    }
    g_ResourceMapArray.clear();
    g_IsInitialized = true;
    return true;
}

bool FinalizeStringResource()
{
    if (g_IsInitialized)
    {
        g_ResourceMapArray.clear();
        g_Language = Language_Identifier;
        g_IsInitialized = false;
        return true;
    }
    else
    {
        return false;
    }
}

bool RegisterCsvFile(const char* filePath)
{
    std::ifstream stringResouceStream(filePath);
    if (g_IsInitialized && stringResouceStream.is_open())
    {
        // 1行づつ読み込む
        std::string line;
        while (getline(stringResouceStream, line))
        {
            std::istringstream stream(line);
            std::string field;
            std::string fieldDoubleQuote = "";
            std::vector<std::string> fieldList;
            // カンマ毎に読み込む
            while (getline(stream, field, ','))
            {
                // 先頭が " の場合
                if (fieldDoubleQuote.empty() && field[0] == '"')
                {
                    // " が奇数回連続する場合、フィールドは" "で囲まれている
                    size_t doubleQuoteCount = 0;
                    while (field[doubleQuoteCount] == '"')
                    {
                        doubleQuoteCount++;
                    }
                    if (doubleQuoteCount % 2 == 1)
                    {
                        field.erase(field.begin());
                        fieldDoubleQuote = field;
                    }
                }
                else if(!fieldDoubleQuote.empty())
                {
                    // フィールド内にカンマがある場合
                    fieldDoubleQuote += ',' + field;
                }

                if (!fieldDoubleQuote.empty())
                {
                    // 最後が " の場合
                    if (field.back() == '"')
                    {
                        // " が奇数回連続する場合、フィールドは" "で囲まれている
                        size_t doubleQuoteIndex = field.size() - 1;
                        while (field[doubleQuoteIndex] == '"' && doubleQuoteIndex > 0)
                        {
                            doubleQuoteIndex--;
                        }
                        if ((field.size() - 1 - doubleQuoteIndex) % 2 == 1)
                        {
                            fieldDoubleQuote.erase(fieldDoubleQuote.end() - 1);
                            fieldList.push_back(fieldDoubleQuote);
                            fieldDoubleQuote = "";
                        }
                    }
                }
                else
                {
                    fieldList.push_back(field);
                }
            }
            if (fieldList.size() > static_cast<size_t>(g_Language))
            {
                g_ResourceMapArray[fieldList.at(Language_Identifier)] = fieldList.at(g_Language);
            }
        }
        stringResouceStream.close();
        return true;
    }
    else
    {
        return false;
    }
}

const char* GetString(const char* identifier)
{
    if (g_IsInitialized)
    {
        if (g_ResourceMapArray.count(identifier))
        {
            return g_ResourceMapArray.at(identifier).c_str();
        }
    }
    return identifier;
}
