﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <map>

#ifdef EXPORT
#define STRING_RESOURCE_UTIL_API extern "C" __declspec( dllexport )
#else
#define STRING_RESOURCE_UTIL_API extern "C" __declspec( dllimport )
#endif

/**
* @brief StringResourceUtil を GetUserDefaultLCID() の言語で初期化します。
*
* @return 結果を返します。
*/
STRING_RESOURCE_UTIL_API bool InitializeStringResource();

/**
* @brief StringResourceUtil を破棄します。
*
* @return 結果を返します。
*/
STRING_RESOURCE_UTIL_API bool FinalizeStringResource();

/**
* @brief 文字リソースファイル(.csv) を初期化時に設定された言語で登録します。
*
* @param[in] filePath 初期化するリソースファイルのパス
*
* @return 結果を返します。
*
* @details
*  csv ファイルの仕様。
*  - 0 列目に識別子、1列目に英語、2列目に日本語を記述してください。
*  - 各フィールドはカンマで区切ってください。
*  - フィールドがカンマを含む場合は、フィールド全体をダブルクォートで括ってください。
*  - フィールドがダブルクォートを含む場合は、ダブルクォートを2つ並べてエスケープした上で、フィールド全体をダブルクォートで括ってください。
*
*/
STRING_RESOURCE_UTIL_API bool RegisterCsvFile(const char* filePath);

/**
* @brief 識別子に対応する文字列を取得します。
*
* @param[in] identifier 識別子
*
* @return 初期化時に設定された言語の文字列を返します。
*/
STRING_RESOURCE_UTIL_API const char* GetString(const char* identifier);
