﻿namespace Opal.Threading
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Utilities;

    /// <summary>
    /// ジョブ管理のインターフェースです。
    /// </summary>
    public interface IJobManager : IAnyManager
    {
        /// <summary>
        /// ジョブを追加します。
        /// </summary>
        /// <param name="job">追加するジョブです。</param>
        void AddJob(Job job);

        /// <summary>
        /// ジョブを削除します。
        /// </summary>
        /// <param name="job">削除するジョブです。</param>
        void RemoveJob(Job job);

        /// <summary>
        /// ジョブを取得します。
        /// </summary>
        /// <typeparam name="TJob">取得するジョブの型です。</typeparam>
        /// <param name="name">取得するジョブの名前です。</param>
        /// <returns>取得できたジョブを返します。</returns>
        TJob GetJob<TJob>(string name) where TJob : Job;

        /// <summary>
        /// 全てのジョブを停止します。
        /// </summary>
        void StopAllJobs();
    }
}
