﻿namespace Opal.Operations
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Operations;
    using Opal.Utilities;

    /// <summary>
    /// オペレーション管理のインターフェースです。
    /// </summary>
    public interface IOperationManager : IAnyManager
    {
        /// <summary>
        /// トランザクションを開始します。
        /// </summary>
        /// <param name="merge">trueの場合は、マージ可能なオペレーションをマージします。</param>
        /// <returns>トランザクションのインスタンスを返します。</returns>
        OperationTransaction BeginTransaction(bool merge);

        /// <summary>
        /// 実行します。
        /// </summary>
        /// <param name="operation">実行するオペレーションです。</param>
        void Execute(Operation operation);

        /// <summary>
        /// Undo が可能か判定します。
        /// </summary>
        /// <returns>Undo が可能ならば true です。</returns>
        bool CanUndo();

        /// <summary>
        /// Redo が可能か判定します。
        /// </summary>
        /// <returns>Redo が可能ならば true です。</returns>
        bool CanRedo();

        /// <summary>
        /// Redo します。
        /// </summary>
        void Redo();

        /// <summary>
        /// Undo します。
        /// </summary>
        void Undo();
    }
}
