﻿namespace Opal.Modules.Output
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.ComponentModel;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows.Data;
    using System.Windows.Documents;
    using System.Windows.Input;
    using Opal.Commands;
    using Opal.Logs;
    using Opal.Services;
    using Opal.ViewModels;

    /// <summary>
    /// ログ出力ビューモデルクラスです。
    /// </summary>
    public sealed class OutputViewModel : ToolViewModel
    {
        private readonly ObservableCollection<string> messages =
            new ObservableCollection<string>();

        private readonly ICollectionView messagesView;

        private readonly ICommand clearCommand;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public OutputViewModel()
        {
            BindingOperations.EnableCollectionSynchronization(this.messages, this.SyncRoot);
            this.messagesView = CollectionViewSource.GetDefaultView(this.messages);

            this.clearCommand =
                new RelayCommand(param => this.ExecuteClear(param), param => { return true; });
        }

        /// <summary>
        /// 推奨の配置を取得します。
        /// </summary>
        public override PaneLocation PreferredLocation
        {
            get
            {
                return PaneLocation.Bottom;
            }
        }

        /// <summary>
        /// ログメッセージを取得します。
        /// </summary>
        public ICollectionView Messages
        {
            get
            {
                return this.messagesView;
            }
        }

        /// <summary>
        /// クリアコマンドを取得します。
        /// </summary>
        public ICommand ClearCommand
        {
            get
            {
                return this.clearCommand;
            }
        }

        /// <summary>
        /// メッセージを追加します。
        /// </summary>
        /// <param name="message">追加するメッセージです。</param>
        internal void AddMessage(string message)
        {
            this.messages.Add(message);
            ((IOutputView)this.PaneView).ScrollToEnd();
        }

        /// <summary>
        /// オブジェクト破棄の内部処理です。継承した先で固有の処理を実装します。
        /// </summary>
        protected override void DisposeInternal()
        {
            BindingOperations.DisableCollectionSynchronization(this.messages);
        }

        private void ExecuteClear(object parameter)
        {
            this.messages.Clear();
        }
    }
}
