﻿namespace Opal.Modules.Output
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Logs;
    using Opal.Modules.Output;

    /// <summary>
    /// ログ出力ペイン用のログ処理クラスです。
    /// </summary>
    public sealed class OutputConductor : LogConductor
    {
        private OutputViewModel outputViewModel = null;

        /// <summary>
        /// ログ出力用のビューモデルを設定します。
        /// </summary>
        /// <param name="viewModel">設定対象のビューモデルです。</param>
        public void SetOutputViewModel(OutputViewModel viewModel)
        {
            Debug.Assert(viewModel != null);
            Debug.Assert(this.outputViewModel == null);

            this.outputViewModel = viewModel;
        }

        /// <summary>
        /// ログフラッシュの内部メソッドです。
        /// </summary>
        /// <param name="logs">フラッシュ対象のログです。</param>
        /// <returns>ログ書き込みが成功した場合は、true を返します。</returns>
        protected override bool FlushLogsInternal(ReadOnlyCollection<Log> logs)
        {
            // まだ、ログ出力が表示されていない場合は、設定がされていないので一旦抜ける。
            if (this.outputViewModel == null)
            {
                return false;
            }

            foreach (var log in logs)
            {
#if DEBUG
                StringBuilder builder = new StringBuilder();
                builder.AppendFormat("{0} => {1} : {2}({3})", log.Message, log.MemberName, log.FileName, log.FileLine);
                this.outputViewModel.AddMessage(builder.ToString());
#else
                this.outputViewModel.AddMessage(log.Message);
#endif
            }

            return true;
        }
    }
}
