﻿namespace Opal.Menus
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.ComponentModel;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows.Data;

    /// <summary>
    /// 階層構造のメニュープラグインの基底クラスです。
    /// </summary>
    public abstract class HierarchicalMenuPlugin : MenuPlugin
    {
        private readonly object syncRoot = new object();
        private readonly ObservableCollection<Menu> subMenus =
            new ObservableCollection<Menu>();

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="label">ラベル名です。</param>
        /// <param name="order">メニュの順番です。</param>
        public HierarchicalMenuPlugin(string label, int order)
            : base(label, order)
        {
            BindingOperations.EnableCollectionSynchronization(this.subMenus, this.syncRoot);
        }

        /// <summary>
        /// サブメニューを取得します。
        /// </summary>
        public ICollectionView SubMenus
        {
            get
            {
                return CollectionViewSource.GetDefaultView(this.subMenus);
            }
        }

        /// <summary>
        /// サブメニューを追加します。
        /// </summary>
        /// <param name="menu">追加するメニューです。</param>
        public void AddSubMenu(Menu menu)
        {
            lock (this.syncRoot)
            {
                this.subMenus.Add(menu);
            }
        }

        /// <summary>
        /// サブメニューを削除します。
        /// </summary>
        /// <param name="menu">削除するメニューです。</param>
        public void RemoveSubMenu(Menu menu)
        {
            lock (this.syncRoot)
            {
                this.subMenus.Remove(menu);
            }
        }

        /// <summary>
        /// オブジェクト破棄の内部処理です。継承した先で固有の処理を実装します。
        /// </summary>
        protected override void DisposeInternal()
        {
            BindingOperations.DisableCollectionSynchronization(this.subMenus);
        }
    }
}
