﻿namespace Nintendo.G3dTool.Entities
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// 中間ファイルの種類です。
    /// </summary>
    public enum IntermediateFileKind
    {
        /// <summary>
        /// モデルです。
        /// </summary>
        Model,

        /// <summary>
        /// マテリアルです。
        /// </summary>
        Material,

        /// <summary>
        /// テクスチャーです。
        /// </summary>
        Texture,

        /// <summary>
        /// スケルタルアニメーションです。
        /// </summary>
        SkeletalAnim,

        /// <summary>
        /// マテリアルアニメーションです。
        /// </summary>
        MaterialAnim,

        /// <summary>
        /// ボーンビジビリティアニメーションです。
        /// </summary>
        BoneVisibilityAnim,

        /// <summary>
        /// シェイプアニメーションです。
        /// </summary>
        ShapeAnim,

        /// <summary>
        /// シーンアニメーションです。
        /// </summary>
        SceneAnim,

        /// <summary>
        /// シェーダー設定です。
        /// </summary>
        ShaderConfig,

        /// <summary>
        /// シェーダー定義です。
        /// </summary>
        ShaderDefinition,

        /// <summary>
        /// シェーダーバリエーションです。
        /// </summary>
        ShaderVariation,

        /// <summary>
        /// コンバイナーシェーダーです。
        /// </summary>
        CombinerShader,
    }
}
