﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using nw.g3d.nw4f_3dif;
using Opal.Security.Cryptography;
using Nintendo.ToolFoundation.Collections;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.G3dTool.Entities.Internal;
namespace Nintendo.G3dTool.Entities{
    public class ComponentSelector : ObservableEntity<string>, IEquatable<ComponentSelector>
    {
        private readonly texture_info_comp_selValue[] values = new texture_info_comp_selValue[4];

        public ComponentSelector()
        {
        }

        public ComponentSelector(
            texture_info_comp_selValue elem0,
            texture_info_comp_selValue elem1,
            texture_info_comp_selValue elem2,
            texture_info_comp_selValue elem3)
            : this()
        {
            this[0] = elem0;
            this[1] = elem1;
            this[2] = elem2;
            this[3] = elem3;
        }

        internal texture_info_comp_selValue[] Values
        {
            get
            {
                return this.values;
            }
        }

        public texture_info_comp_selValue this[int index]
        {
            get
            {
                Nintendo.ToolFoundation.Contracts.Ensure.Argument.Range(index, 0, 4);
                return this.values[index];
            }

            set
            {
                Nintendo.ToolFoundation.Contracts.Ensure.Argument.Range(index, 0, 4);
                this.SetProperty(ref this.values[index], value, () => this.CalcCRC());
            }
        }



        public texture_info_comp_selValue R
        {
            get
            {
                return this.values[0];
            }

            set
            {
                this.SetProperty(ref this.values[0], value, () => this.CalcCRC());
            }
        }

        public texture_info_comp_selValue G
        {
            get
            {
                return this.values[1];
            }

            set
            {
                this.SetProperty(ref this.values[1], value, () => this.CalcCRC());
            }
        }

        public texture_info_comp_selValue B
        {
            get
            {
                return this.values[2];
            }

            set
            {
                this.SetProperty(ref this.values[2], value, () => this.CalcCRC());
            }
        }

        public texture_info_comp_selValue A
        {
            get
            {
                return this.values[3];
            }

            set
            {
                this.SetProperty(ref this.values[3], value, () => this.CalcCRC());
            }
        }

        /// <summary>
        /// 比較演算子
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>一致していれば true、そうでなければ false を返します。</returns>
        public bool Equals(ComponentSelector obj)
        {
            if (obj == null)
            {
                return false;
            }

            bool isEqual = true;
            for (int elemIndex = 0; elemIndex < 4; ++elemIndex)
            {
                isEqual &= (obj[elemIndex] == this[elemIndex]);
            }

            return isEqual;
        }

        public override string CreateSerializableData()
        {
            return this.ToString();
        }

        protected override uint CreateCRCInternal()
        {
            CRC32 crc = new CRC32();
            return crc.ComputeHashUInt32(this.ToString());
        }

        public override string ToString()
        {
            string result = string.Empty;
            for (int elemIndex = 0; elemIndex < 4; ++elemIndex)
            {
                result += StringUtility.ConvertValueToText(this[elemIndex]) + " ";
            }

            return result.TrimEnd();
        }

        public void DeepCopyFrom(ComponentSelector source)
        {
            for (int elemIndex = 0; elemIndex < 4; ++elemIndex)
            {
                this[elemIndex] = source.Values[elemIndex];
            }
        }
    }
}
