﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using nw.g3d.nw4f_3dif;
using App.res;

namespace App.Data
{
    /// <summary>
    /// ＵＩテキストクラス。
    /// </summary>
    public static partial class UIText
    {
        #region texture_info_dimensionType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(texture_info_dimensionType value)
        {
            switch(value)
            {
                case texture_info_dimensionType.Item1d:            return Strings.Enum_texture_info_dimensionType_Item1d;
                case texture_info_dimensionType.Item2d:            return Strings.Enum_texture_info_dimensionType_Item2d;
                case texture_info_dimensionType.Item3d:            return Strings.Enum_texture_info_dimensionType_Item3d;
                case texture_info_dimensionType.cube:            return Strings.Enum_texture_info_dimensionType_cube;
                case texture_info_dimensionType.Item1d_array:    return Strings.Enum_texture_info_dimensionType_Item1d_array;
                case texture_info_dimensionType.Item2d_array:    return Strings.Enum_texture_info_dimensionType_Item2d_array;
                case texture_info_dimensionType.cube_array:        return Strings.Enum_texture_info_dimensionType_cube_array;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region texture_info_quantize_typeType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(texture_info_quantize_typeType value)
        {
            switch(value)
            {
                case texture_info_quantize_typeType.unorm_8:                return Strings.Enum_texture_info_quantize_typeType_unorm_8;
                case texture_info_quantize_typeType.uint_8:                    return Strings.Enum_texture_info_quantize_typeType_uint_8;
                case texture_info_quantize_typeType.snorm_8:                return Strings.Enum_texture_info_quantize_typeType_snorm_8;
                case texture_info_quantize_typeType.sint_8:                    return Strings.Enum_texture_info_quantize_typeType_sint_8;
                case texture_info_quantize_typeType.unorm_4_4:                return Strings.Enum_texture_info_quantize_typeType_unorm_4_4;
                case texture_info_quantize_typeType.unorm_16:                return Strings.Enum_texture_info_quantize_typeType_unorm_16;
                case texture_info_quantize_typeType.uint_16:                return Strings.Enum_texture_info_quantize_typeType_uint_16;
                case texture_info_quantize_typeType.snorm_16:                return Strings.Enum_texture_info_quantize_typeType_snorm_16;
                case texture_info_quantize_typeType.sint_16:                return Strings.Enum_texture_info_quantize_typeType_sint_16;
                case texture_info_quantize_typeType.float_16:                return Strings.Enum_texture_info_quantize_typeType_float_16;
                case texture_info_quantize_typeType.unorm_8_8:                return Strings.Enum_texture_info_quantize_typeType_unorm_8_8;
                case texture_info_quantize_typeType.uint_8_8:                return Strings.Enum_texture_info_quantize_typeType_uint_8_8;
                case texture_info_quantize_typeType.snorm_8_8:                return Strings.Enum_texture_info_quantize_typeType_snorm_8_8;
                case texture_info_quantize_typeType.sint_8_8:                return Strings.Enum_texture_info_quantize_typeType_sint_8_8;
                case texture_info_quantize_typeType.unorm_5_6_5:            return Strings.Enum_texture_info_quantize_typeType_unorm_5_6_5;
                case texture_info_quantize_typeType.unorm_5_5_5_1:            return Strings.Enum_texture_info_quantize_typeType_unorm_5_5_5_1;
                case texture_info_quantize_typeType.unorm_4_4_4_4:            return Strings.Enum_texture_info_quantize_typeType_unorm_4_4_4_4;
                case texture_info_quantize_typeType.unorm_1_5_5_5:            return Strings.Enum_texture_info_quantize_typeType_unorm_1_5_5_5;
                case texture_info_quantize_typeType.uint_32:                return Strings.Enum_texture_info_quantize_typeType_uint_32;
                case texture_info_quantize_typeType.sint_32:                return Strings.Enum_texture_info_quantize_typeType_sint_32;
                case texture_info_quantize_typeType.float_32:                return Strings.Enum_texture_info_quantize_typeType_float_32;
                case texture_info_quantize_typeType.unorm_16_16:            return Strings.Enum_texture_info_quantize_typeType_unorm_16_16;
                case texture_info_quantize_typeType.uint_16_16:                return Strings.Enum_texture_info_quantize_typeType_uint_16_16;
                case texture_info_quantize_typeType.snorm_16_16:            return Strings.Enum_texture_info_quantize_typeType_snorm_16_16;
                case texture_info_quantize_typeType.sint_16_16:                return Strings.Enum_texture_info_quantize_typeType_sint_16_16;
                case texture_info_quantize_typeType.float_16_16:            return Strings.Enum_texture_info_quantize_typeType_float_16_16;
                case texture_info_quantize_typeType.float_11_11_10:            return Strings.Enum_texture_info_quantize_typeType_float_11_11_10;
                case texture_info_quantize_typeType.unorm_10_10_10_2:        return Strings.Enum_texture_info_quantize_typeType_unorm_10_10_10_2;
                case texture_info_quantize_typeType.uint_10_10_10_2:        return Strings.Enum_texture_info_quantize_typeType_uint_10_10_10_2;
                case texture_info_quantize_typeType.unorm_8_8_8_8:            return Strings.Enum_texture_info_quantize_typeType_unorm_8_8_8_8;
                case texture_info_quantize_typeType.uint_8_8_8_8:            return Strings.Enum_texture_info_quantize_typeType_uint_8_8_8_8;
                case texture_info_quantize_typeType.snorm_8_8_8_8:            return Strings.Enum_texture_info_quantize_typeType_snorm_8_8_8_8;
                case texture_info_quantize_typeType.sint_8_8_8_8:            return Strings.Enum_texture_info_quantize_typeType_sint_8_8_8_8;
                case texture_info_quantize_typeType.srgb_8_8_8_8:            return Strings.Enum_texture_info_quantize_typeType_srgb_8_8_8_8;
                case texture_info_quantize_typeType.unorm_2_10_10_10:        return Strings.Enum_texture_info_quantize_typeType_unorm_2_10_10_10;
                case texture_info_quantize_typeType.uint_2_10_10_10:        return Strings.Enum_texture_info_quantize_typeType_uint_2_10_10_10;
                case texture_info_quantize_typeType.uint_32_32:                return Strings.Enum_texture_info_quantize_typeType_uint_32_32;
                case texture_info_quantize_typeType.sint_32_32:                return Strings.Enum_texture_info_quantize_typeType_sint_32_32;
                case texture_info_quantize_typeType.float_32_32:            return Strings.Enum_texture_info_quantize_typeType_float_32_32;
                case texture_info_quantize_typeType.unorm_16_16_16_16:        return Strings.Enum_texture_info_quantize_typeType_unorm_16_16_16_16;
                case texture_info_quantize_typeType.uint_16_16_16_16:        return Strings.Enum_texture_info_quantize_typeType_uint_16_16_16_16;
                case texture_info_quantize_typeType.snorm_16_16_16_16:        return Strings.Enum_texture_info_quantize_typeType_snorm_16_16_16_16;
                case texture_info_quantize_typeType.sint_16_16_16_16:        return Strings.Enum_texture_info_quantize_typeType_sint_16_16_16_16;
                case texture_info_quantize_typeType.float_16_16_16_16:        return Strings.Enum_texture_info_quantize_typeType_float_16_16_16_16;
                case texture_info_quantize_typeType.uint_32_32_32_32:        return Strings.Enum_texture_info_quantize_typeType_uint_32_32_32_32;
                case texture_info_quantize_typeType.sint_32_32_32_32:        return Strings.Enum_texture_info_quantize_typeType_sint_32_32_32_32;
                case texture_info_quantize_typeType.float_32_32_32_32:        return Strings.Enum_texture_info_quantize_typeType_float_32_32_32_32;
                case texture_info_quantize_typeType.unorm_bc1:                return Strings.Enum_texture_info_quantize_typeType_unorm_bc1;
                case texture_info_quantize_typeType.srgb_bc1:                return Strings.Enum_texture_info_quantize_typeType_srgb_bc1;
                case texture_info_quantize_typeType.unorm_bc2:                return Strings.Enum_texture_info_quantize_typeType_unorm_bc2;
                case texture_info_quantize_typeType.srgb_bc2:                return Strings.Enum_texture_info_quantize_typeType_srgb_bc2;
                case texture_info_quantize_typeType.unorm_bc3:                return Strings.Enum_texture_info_quantize_typeType_unorm_bc3;
                case texture_info_quantize_typeType.srgb_bc3:                return Strings.Enum_texture_info_quantize_typeType_srgb_bc3;
                case texture_info_quantize_typeType.unorm_bc4:                return Strings.Enum_texture_info_quantize_typeType_unorm_bc4;
                case texture_info_quantize_typeType.snorm_bc4:                return Strings.Enum_texture_info_quantize_typeType_snorm_bc4;
                case texture_info_quantize_typeType.unorm_bc5:                return Strings.Enum_texture_info_quantize_typeType_unorm_bc5;
                case texture_info_quantize_typeType.snorm_bc5:                return Strings.Enum_texture_info_quantize_typeType_snorm_bc5;
                default:
                    {
                        return Enum.GetName(typeof(texture_info_quantize_typeType), value);
                    }
            }

            throw new NotImplementedException();
        }
        #endregion

        #region MipLevel
        /// <summary>
        /// ミップマップレベルの表示
        /// </summary>
        public static string MipLevel(int level)
        {
            return level > 1 ? level.ToString() : Strings.Texture_MipmapNone;
        }
        #endregion

        #region MipmapMinSize
        /// <summary>
        /// ミップマップ最小サイズ
        /// </summary>
        public static string MipmapMinSize(texture_infoType info)
        {
            int width = Math.Max(info.width >> (info.mip_level - 1), 1);
            int height = Math.Max(info.height >> (info.mip_level - 1), 1);
            return info.mip_level > 1 ? string.Format("{0} x {1}", width, height) : string.Empty;
        }
        #endregion
    }
}
