﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using System.Reflection;
using Microsoft.VisualBasic.ApplicationServices;

namespace App
{
    class WindowsFormsApplication : WindowsFormsApplicationBase
    {
        public WindowsFormsApplication(string[] args)
        {
            this.EnableVisualStyles = true;
            this.IsSingleInstance = true;
            this.MainForm = new MainForm(args);
            this.StartupNextInstance += (s, e) =>
            {
                if (e.CommandLine.Any())
                {
                    App.MainForm.This.LoadFromFile(e.CommandLine[0]);
                }
            };
        }


    }

    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main(string[] args)
        {
            if (!Environment.Is64BitOperatingSystem)
            {
                string errorMsg = Properties.Resources.ERROR_32BITOS;

                MessageBox.Show(errorMsg, "TextureViewer Error", MessageBoxButtons.OK);
                return;
            } // End if

            InitLocalization();

            Data.TexUtilsProxy.Initialize();
            BackgroundTaskManager.Initialize();
            {
                (new WindowsFormsApplication(args)).Run(args);
            }
            BackgroundTaskManager.Destroy();
            Data.TexUtilsProxy.Destroy();
        }

        //----------------------------------------------------------------------
        /// <summary>
        /// initialize localization
        /// </summary>
        //----------------------------------------------------------------------
        static void InitLocalization()
        {
            System.Globalization.CultureInfo uiCultureInfo = null;

            try
            {
                Assembly mainAssembly = Assembly.GetEntryAssembly();
                String executableDirectory = System.IO.Path.GetDirectoryName(mainAssembly.Location);
                executableDirectory = executableDirectory.Replace("/", "\\"); // Fix slash


                // ＵＩ言語初期化
                if (System.IO.File.Exists(executableDirectory + "\\en\\TextureViewer.resources.dll"))
                {
                    uiCultureInfo = new System.Globalization.CultureInfo("en", false);
                }

            }

            catch (System.Exception e)
            {
                // To shut up compiler
                if (e.Data != null)
                {
                } // End if

                uiCultureInfo = null;
            }

            if (uiCultureInfo != null)
            {
                System.Threading.Thread.CurrentThread.CurrentUICulture = uiCultureInfo;
            } // End if
        } // End of InitLocalization
    }
}
