﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;

namespace NintendoWare.ExtensionManager
{
    //==========================================================================
    /// <summary>
    /// RegistrationStatus for given file extension
    /// </summary>
    //==========================================================================
    public class RegistrationStatus : IDisposable
    {
        //----------------------------------------------------------------------
        /// <summary>
        /// Constructor
        /// </summary>
        //----------------------------------------------------------------------
        public RegistrationStatus( String extension )
        {
            ExtensionName     = extension;
            UseIconService    = true;
            UseInfoTipService = true;
            UsePreviewService = true;
            UseColumnService  = true;
        } // End of Constructor

        //----------------------------------------------------------------------
        /// <summary>
        /// Dispose
        /// </summary>
        //----------------------------------------------------------------------
        virtual public void Dispose()
        {
        } // End of Dispose

        #region Extension
        //----------------------------------------------------------------------
        /// <summary>
        /// Extension Name
        /// </summary>
        //----------------------------------------------------------------------
        public String ExtensionName
        {
            set;
            get;
        } // End of ExtensionName
        #endregion

        #region PlugIn Service
        //----------------------------------------------------------------------
        /// <summary>
        /// Icon Service
        /// </summary>
        //----------------------------------------------------------------------
        public bool UseIconService
        {
            set;
            get;
        } // End of UseIconService

        //----------------------------------------------------------------------
        /// <summary>
        /// Preview Service
        /// </summary>
        //----------------------------------------------------------------------
        public bool UsePreviewService
        {
            set;
            get;
        } // End of UsePreviewService

        //----------------------------------------------------------------------
        /// <summary>
        /// InfoTip Service
        /// </summary>
        //----------------------------------------------------------------------
        public bool UseInfoTipService
        {
            set;
            get;
        } // End of UseInfoTipService

        //----------------------------------------------------------------------
        /// <summary>
        /// Column Service
        /// </summary>
        //----------------------------------------------------------------------
        public bool UseColumnService
        {
            set;
            get;
        } // End of UseColumnService
        #endregion
    } // End of RegistrationStatus
} // End of NintendoWare.ExtensionManager
