﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Reflection;

namespace nw.g3d.bifedit
{
    public partial class AboutBox : Form
    {
        public AboutBox()
        {
            InitializeComponent();

            if (Application.OpenForms.Count > 0 && Application.OpenForms[0].Icon != null)
                pbxIcon.Image = Application.OpenForms[0].Icon.ToBitmap();

            var copyrightAttribute = GetAssemblyAttribute<AssemblyCopyrightAttribute>();
            if (copyrightAttribute != null)
                lblCopyright.Text = copyrightAttribute.Copyright;

            m_versionLabel.Text = string.Format("{0} ({1})",
                VersionInformation.Version,
                VersionInformation.BuildDate);
        }

        private void OnOk(object sender, EventArgs e)
        {
            this.Close();
        }

        private T GetAssemblyAttribute<T>() where T : Attribute
        {
            return assemblyAttributes.OfType<T>().FirstOrDefault();
        }

        private static readonly List<Attribute> assemblyAttributes = new List<Attribute>();

        static AboutBox()
        {
            foreach (Attribute attr in Assembly.GetEntryAssembly().GetCustomAttributes(false))
                assemblyAttributes.Add(attr);
        }
    }
}
