﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "SimpleAllocator.h"

void* SimpleAllocator::AllocateMemory(size_t size, size_t alignment)
{
    if (m_IsMemoryLeakCheckingEnabled)
    {
        m_OccupiedSize += size;
        if (m_MaxSize < m_OccupiedSize)
        {
            m_MaxSize = m_OccupiedSize;
        }
    }

    void* pBuffer = nns::nac::MemoryAllocator::Alloc(static_cast<size_t>(size), static_cast<size_t>(alignment));

    // メモリリストに追加
    MemoryList* pItem = static_cast<MemoryList*>(nns::nac::MemoryAllocator::Alloc(sizeof(MemoryList)));
    pItem->pNext = NULL;
    pItem->pAddress = pBuffer;
    pItem->size = size;
    pItem->isMemoryLeakCheckingEnabled = m_IsMemoryLeakCheckingEnabled;
    if (m_pTop == NULL)
    {
        m_pTop = pItem;
        m_pBottom = pItem;
    }
    else
    {
        m_pBottom->pNext = pItem;
        m_pBottom = pItem;
    }

    return pBuffer;
}

void SimpleAllocator::FreeMemory(void* pointer)
{
    if (pointer == NULL)
    {
        return;
    }

    // メモリリストから削除
    MemoryList* pPrev = NULL;
    MemoryList* pItem = m_pTop;
    while (pItem != NULL)
    {
        if (pItem->pAddress == pointer)
        {
            break;
        }
        pPrev = pItem;
        pItem = pItem->pNext;
    }
    NN_ASSERT(pItem != NULL, "Memory item was not found.");
    m_OccupiedSize -= pItem->size;
    if (pPrev == NULL)
    {
        m_pTop = pItem->pNext;
    }
    else
    {
        pPrev->pNext = pItem->pNext;
    }
    if (pItem->pNext == NULL)
    {
        m_pBottom = pPrev;
    }
    nns::nac::MemoryAllocator::Free(pItem);

    nns::nac::MemoryAllocator::Free(pointer);
}

int64_t SimpleAllocator::GetOccupiedSize() const
{
    return m_OccupiedSize;
}

int64_t SimpleAllocator::GetMaxSize() const
{
    return m_MaxSize;
}

void SimpleAllocator::PrintOccupiedMemory() const
{
    NN_LOG("Occupied memory: current = %lld, max = %lld\n", GetOccupiedSize(), GetMaxSize());

    MemoryList* pItem = m_pTop;
    while (pItem != NULL)
    {
        if (pItem->isMemoryLeakCheckingEnabled)
        {
            NN_LOG("Occupied memory: %d byte (0x%p)\n", pItem->size, pItem->pAddress);
        }
        pItem = pItem->pNext;
    }
}
