﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace TgaTest
{
    /// <summary>
    /// イメージ表示パネルクラス。
    /// </summary>
    public sealed partial class ImagePanel : UserControl
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ImagePanel()
        {
            InitializeComponent();
        }

        /// <summary>
        /// クリア。
        /// </summary>
        public void Clear()
        {
            if (pctColor.Image != null)
            {
                pctColor.Image.Dispose();
                pctColor.Image = null;
            }

            if (pctAlpha.Image != null)
            {
                pctAlpha.Image.Dispose();
                pctAlpha.Image = null;
            }
        }

        /// <summary>
        /// 設定。
        /// </summary>
        public void Set(Bitmap colorBitmap, Bitmap alphaBitmap)
        {
            // カラー
            {
                // 表示方法
                Size controlSize = pctColor.ClientSize;
                if (colorBitmap.Width <= controlSize.Width && colorBitmap.Height <= controlSize.Height)
                {
                    pctColor.SizeMode = PictureBoxSizeMode.CenterImage;
                }
                else
                {
                    pctColor.SizeMode = PictureBoxSizeMode.Zoom;
                }

                // 設定
                pctColor.Image = colorBitmap;
                pctColor.Invalidate();
            }

            // アルファ
            {
                // 表示方法
                Size controlSize = pctAlpha.ClientSize;
                if (alphaBitmap.Width <= controlSize.Width && alphaBitmap.Height <= controlSize.Height)
                {
                    pctAlpha.SizeMode = PictureBoxSizeMode.CenterImage;
                }
                else
                {
                    pctAlpha.SizeMode = PictureBoxSizeMode.Zoom;
                }

                // 設定
                pctAlpha.Image = alphaBitmap;
                pctAlpha.Invalidate();
            }
        }
    }
}
