﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NW4F.LayoutBinaryConverter.TexConv
{
    /// <summary>
    /// テクスチャ書き出しクラスのインタフェースです。
    /// いまのところ、テクスチャ変換クラスを列挙するのに、目印として利用するだけのインタフェースになっています。
    /// </summary>
    public interface ITexttureWriter
    {
        ConvertedImage ConvertSrcImageToNative2DArrayFormat(SrcImage[] texImage, string tileMode, bool useBntx);

        bool ExportSrcImageToFtxbFile(SrcImage texImage, string tileMode, string outputDir, string cacheDir);

        void SetLogSilent(bool isSilent);

        void SetGpuEncodingEnabled(string isGpuEncodigEnabled);
    }

    /// <summary>
    /// 変換後の画像です。（TODO:プラットフォーム抽象化）
    /// </summary>
    public class ConvertedImage
    {
        public Byte[] image;
        public Int32 neededAlignment;
        public Int32 tileMode;
    };
}
