﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Reflection;

namespace NW4F.LayoutBinaryConverter.TexConv
{
    public class CacheKeyGenerator : IDisposable
    {
        private MemoryStream hashSourceStream;
        private BinaryWriter hashSourceBinaryWriter;
        private string cacheKeyHashValue;

        public CacheKeyGenerator()
        {
            hashSourceStream = new MemoryStream();
            hashSourceBinaryWriter = new BinaryWriter(hashSourceStream);

            var assembly = Assembly.GetExecutingAssembly();

            // FontConverterCommon の AssemblyVersion にはビルド日時の情報が含まれる
            AddCacheKey(assembly.GetName().Version.Build);
            AddCacheKey(assembly.GetName().Version.Revision);
        }

        public void Dispose()
        {
            if (hashSourceStream != null)
            {
                hashSourceStream.Dispose();
                hashSourceStream = null;
            }

            if (hashSourceBinaryWriter != null)
            {
                hashSourceBinaryWriter.Dispose();
                hashSourceBinaryWriter = null;
            }
        }

        // キーに追加
        public void AddCacheKey(string value)
        {
            hashSourceBinaryWriter.Write("s");
            hashSourceBinaryWriter.Write(value.Length);
            hashSourceBinaryWriter.Write(value);
        }

        // キーに追加
        public void AddCacheKey(int num)
        {
            hashSourceBinaryWriter.Write("i");
            hashSourceBinaryWriter.Write(num);
        }

        // キーに追加
        public void AddCacheKey(bool value)
        {
            hashSourceBinaryWriter.Write("o");
            hashSourceBinaryWriter.Write(value);
        }

        // キーに追加
        public void AddCacheKey(byte[] bytes)
        {
            hashSourceBinaryWriter.Write("b");
            hashSourceBinaryWriter.Write(bytes.Length);
            hashSourceBinaryWriter.Write(bytes);
        }

        // ハッシュの取得
        public string GetCacheKeyHashValue()
        {
            if (cacheKeyHashValue == null)
            {
                hashSourceBinaryWriter.Flush();
                hashSourceStream.Position = 0;
                var sha1 = new System.Security.Cryptography.SHA1Managed();
                var hash = sha1.ComputeHash(hashSourceStream);
                cacheKeyHashValue = ToBase32(hash);
            }

            return cacheKeyHashValue;
        }

        // bytes を Base32 に変換
        private string ToBase32(byte[] bytes)
        {
            char[] base32Table = Enumerable.Range('A', 'Z' - 'A' + 1).Select(x => (char)x)
                .Concat(Enumerable.Range('2', '7' - '2' + 1).Select(x => (char)x))
                .ToArray();
            string str = "";
            int b = 0;
            int offset = 0;
            for (int i = 0; i < bytes.Length; i++)
            {
                b |= (bytes[i] << offset);
                offset += 8;
                while (offset >= 5)
                {
                    str += base32Table[b & 0x1F];
                    b >>= 5;
                    offset -= 5;
                }
            }
            if (offset > 0)
            {
                str += base32Table[b & 0x1F];
            }

            return str;
        }
    }
}
