﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace NW4F.LayoutBinaryConverter
{
    using Lan = Schema.Flan;

    public enum AnimContentType : int
    {
        Pane,
        Material,
        ExtUserData,

        MAX
    }

    public enum PaneAnimType
    {
        PaneSRT,
        Visibility,
        VertexColor,
        PerCharacterTransform,
        PerCharacterTransformCurve,

        ExtUserData,
        // 過去バージョンのバイナリデータ互換性を守るため、追加は ExtUserData 以下に行っています。
        Window,
        Mask,
        DropShadow,
        ProceduralShape,

        MAX
    }

    public enum MaterialAnimType
    {
        MaterialColor,
        TextureSRT,
        TexturePattern,
        IndTextureSRT,
        AlphaTest,
        FontShadowColor,
        MAX
    }

    public class AnimSection
    {
        Lan::AnimTag _animTag;

        int _tagOrder;

        public AnimSection(Lan::AnimTag animTag, int tagOrder)
        {
            _animTag = animTag;
            _tagOrder = tagOrder;
        }

        public Lan::AnimTag Tag { get { return _animTag; } }

        public int TagOrder { get { return _tagOrder; } }
    }

    public class MergeAnimContent
    {
        string _name;
        string _extUserDataTargetName;
        AnimContentType _type;
        List<Lan::AnimTarget>[] _tgtLists;

        public MergeAnimContent(AnimContentType contType, Lan::AnimContent cont)
        {
            _type = contType;
            _name = cont.name;
            _extUserDataTargetName = cont.extUserDataTargetName;
            int targetMax = contType == AnimContentType.Pane ? (int)PaneAnimType.MAX : (int)MaterialAnimType.MAX;
            _tgtLists = new List<Lan::AnimTarget>[targetMax];
        }

        public string Name { get { return _name; } }
        public string extUserDataTargetName { get { return _extUserDataTargetName; } }

        public List<Lan::AnimTarget>[] TargetLists { get { return _tgtLists; } }

        public AnimContentType ContentType { get { return _type; } }
    }

    public enum UserDataType
    {
        String,
        IntList,
        FloatList,
        SystemData,

        MAX
    }

    public class UserDataHead
    {
        public int nameStrOffset;
        public int dataOffset;
        public UserDataType type;
        public int num;
    }

    public enum DropShadowFlag
    {
        StrokeEnabled,
        OuterGlowEnabled,
        DropShadowEnabled,
        KnockoutEnabled,
        DrawEffectOnlyEnabled,
        StaticRenderingEnabled,

        MAX
    }

    public enum ProceduralShapeFlag
    {
        InnerStrokeEnabled,
        InnerShadowEnabled,
        ColorOverlayEnabled,
        GradationOverlayEnabled,
        OuterShadowEnabled,

        Max
    };
}
