﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Net;

namespace NW4F.LayoutBinaryConverter
{
    /// <summary>
    /// データ型をネットワークバイトオーダー（Big Endian）で出力する BinaryWriter です。
    /// </summary>
    /// <remarks>
    /// 現時点では、全てのメソッドをoverrideしていないことに注意してください。
    /// </remarks>
    class NetOrderBinaryWriter : BinaryWriter
    {
        public NetOrderBinaryWriter(Stream stream)
            : base(stream)
        {
        }

        public override void Write(char val)
        {
            ushort shortVal = val;
            this.Write(shortVal);
        }

        public override void Write(short val)
        {
            base.Write(IPAddress.HostToNetworkOrder(val));
        }

        public override void Write(ushort val)
        {
            this.Write((short)val);
        }

        public override void Write(int val)
        {
            base.Write(IPAddress.HostToNetworkOrder(val));
        }

        public override void Write(uint val)
        {
            this.Write((int)val);
        }

        public override void Write(long val)
        {
            base.Write(IPAddress.HostToNetworkOrder(val));
        }

        public override void Write(ulong val)
        {
            this.Write((long)val);
        }

        public override void Write(float val)
        {
            byte[] bytes = BitConverter.GetBytes(val);
            if (BitConverter.IsLittleEndian)
            {
                Array.Reverse(bytes);
            }
            base.Write(bytes);
        }

        public override void Write(double val)
        {
            byte[] bytes = BitConverter.GetBytes(val);
            if (BitConverter.IsLittleEndian)
            {
                Array.Reverse(bytes);
            }
            base.Write(bytes);
        }
    }
}
