﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "BinaryWriterBase.h"

#define NN_SDK_BUILD_RELEASE 1
#include <nn/ui2d/ui2d_Resources.h>

namespace NW4F
{
namespace LayoutBinaryConverter
{

public ref class BinaryCpxWriter : BinaryWriterBase
{
public:
                        BinaryCpxWriter(System::IO::Stream^ stream) : BinaryWriterBase(stream, false) {}

    void                WriteBinaryFileHeader(uint32_t fileSize, uint16_t dataBlocks);

    void                WriteResBitmapFontHeader(uint32_t offsetToStringTable);
    void                WriteResMultiScalableFontHeader(float size, uint32_t alternateChar, int lineFeedOffset, int count);
    void                WriteResPairFontHeader();
    void                WriteResScalableFontDesc(float boldWeight, uint32_t ttcFontIndex, uint32_t offsetToStringTable, uint8_t borderWidth, float scaleWidth, float scaleHeight, bool ignorePalt, bool deleteBearingX, int bearingOffsetX, bool forceMonospacedEnabled, int forceMonospacedWidth, int baselineOffset);
    void                WriteResCharMap(uint32_t first, uint32_t last);


    property System::IO::Stream^ Stream { System::IO::Stream^ get() { return stream_; } }

    literal uint32_t         TypeOfComplexFontResource   = nn::ui2d::ResourceTypeComplexFont;
    literal uint32_t         TypeOfScalableFontResource  = nn::ui2d::ResourceTypeScalableFont;
    literal uint32_t         TypeOfFontResource  = nn::ui2d::ResourceTypeFont;
};

}   // namespace LayoutBinaryConverter
}   // namespace NW4F
