﻿#pragma once

#include <nn/fontll/fontll_ScalableFontEngine.h>
#include <msclr/marshal.h>

using namespace System;
using namespace System::IO;
using namespace msclr::interop;
using namespace System::Xml;
using namespace System::Xml::Serialization;
using namespace System::Collections::Generic;

namespace NintendoWare { namespace FontInfoGetter {

    // バウンディングボックスです。
    public ref class BoundingBox
    {
    public:
        Int16 xMin;
        Int16 yMin;
        Int16 xMax;
        Int16 yMax;
    };

    // メトリクスです。
    public ref class Metrics
    {
    public:
        UInt16 unitsPerEm;
        UInt16 headMacStyle;
        Int16 os2WinAscent;
        Int16 os2WinDescent;
        Int16 os2Ascent;
        Int16 os2Descent;
        UInt16 os2FsSelection;
        UInt16 os2Leading;
        Int16 hheaAscent;
        Int16 hheaDescent;
        UInt16 hheaLeading;
        UInt16 embeddingBits;
        BoundingBox^ fontBoundingBox;
        UInt32 fontInTtcCount;
        UInt32 indexInTtc;
        String^ fontName;
        String^ fontFamilyName;
        String^ copyright;
        UInt16 metricsResolution;
        UInt32 glyphCount;
        UInt32 iconCount;
    };

    // カーニングです。
    public ref class Kerning
    {
    public:
        Char code1;
        Char code2;
        int value;
    };

    // スケーラブルフォントの情報です。
    public ref class ScalableFontInfo
    {
    public:
        Metrics^ metrics;
        array<Char>^ glyphExistence;
        bool kerningExistence;
        // array<Kerning^>^ kerning;
        bool gposKerningExistence;
        // array<Kerning^>^ gposKerning;
    };

    // フォント情報を取得するクラスです。
    public ref class FontInfoUtility
    {
    public:
        // スケーラブルフォントの情報を取得します。
        static ScalableFontInfo^ AcquireScalableFontInfo(String^ path);

    private:
        static const int GlyphMax = 0x10000; // UTF-16 の上限

        static Metrics^ AcquireMetrics(nn::fontll::ScalableFontEngine* pEngine);
        static array<Char>^ AcquireGlyphExistence(nn::fontll::ScalableFontEngine* pEngine);
        static array<Kerning^>^ AcquireKerning(nn::fontll::ScalableFontEngine* pEngine);
        static array<Kerning^>^ AcquireGposKerning(nn::fontll::ScalableFontEngine* pEngine, nn::fontll::OtfKerningTable* pOtfKerningTable);
    };

    // bfttf をデコードするクラスです。
    public class DecodeBfttf
    {
    public:
        // bfttf をデコードします。
        static void* Decode(void* pData, uint32_t dataSize);
    };
} } // namespace NintendoWare::FontInfoGetter
