﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FcpxMaker.CustomControl
{
    using FcpxMaker.DataModel;

    public partial class TextBoxStartEnd : UserControl
    {
        private int _id = 0;
        private bool _isHex = false;

        /// <summary>
        /// チェックが変更された時のイベントハンドラ。
        /// </summary>
        public event EventHandler CheckedChanged
        {
            add
            {
                _chkCheck.CheckedChanged += value;
            }
            remove
            {
                _chkCheck.CheckedChanged -= value;
            }
        }

        /// <summary>
        /// 開始が変更された時のイベントハンドラ。
        /// </summary>
        public event EventHandler StartValueChanged
        {
            add
            {
                _tbxStart.TextChanged += value;
            }
            remove
            {
                _tbxStart.TextChanged -= value;
            }
        }

        /// <summary>
        /// 終了が変更された時のイベントハンドラ。
        /// </summary>
        public event EventHandler EndValueChanged
        {
            add
            {
                _tbxEnd.TextChanged += value;
            }
            remove
            {
                _tbxEnd.TextChanged -= value;
            }
        }

        /// <summary>
        /// 開始でキーが押された時のイベントハンドラ。
        /// </summary>
        public event KeyPressEventHandler StartKeyPress
        {
            add
            {
                _tbxStart.KeyPress += value;
            }
            remove
            {
                _tbxStart.KeyPress -= value;
            }
        }

        /// <summary>
        /// 終了でキーが押された時のイベントハンドラ。
        /// </summary>
        public event KeyPressEventHandler EndKeyPress
        {
            add
            {
                _tbxEnd.KeyPress += value;
            }
            remove
            {
                _tbxEnd.KeyPress -= value;
            }
        }

        /// <summary>
        /// 開始のタグ。
        /// </summary>
        public int Id
        {
            get
            {
                return _id;
            }
            set
            {
                _id = value;
                _chkCheck.Tag = value;
                _tbxStart.Tag = value;
                _tbxEnd.Tag = value;
            }
        }

        /// <summary>
        /// チェック。
        /// </summary>
        public bool Checked
        {
            get
            {
                return _chkCheck.Checked;
            }
            set
            {
                _chkCheck.Checked = value;
                _tbxStart.Enabled = value || !UseCheckBox;
                _tbxEnd.Enabled = value || !UseCheckBox;
            }
        }

        /// <summary>
        /// チェックボックスを使うか。
        /// </summary>
        public bool UseCheckBox
        {
            get { return _chkCheck.Visible; }
            set { _chkCheck.Visible = value; }
        }

        /// <summary>
        /// ラベルのテキスト。
        /// </summary>
        public string LabelText
        {
            get { return _lblText.Text; }
            set { _lblText.Text = value; }
        }

        /// <summary>
        /// 16進数かどうか。
        /// </summary>
        public bool IsHex
        {
            get
            {
                return _isHex;
            }
            set
            {
                _isHex = value;
                ConverValue(value);
            }
        }

        /// <summary>
        /// 10進と16進を変換します。
        /// </summary>
        private void ConverValue(bool isHex)
        {
            if (isHex)
            {
                _tbxStart.Text = String.IsNullOrEmpty(_tbxStart.Text) ?
                    "0" : String.Format("{0:x}", Convert.ToUInt32(_tbxStart.Text));
                _tbxEnd.Text = String.IsNullOrEmpty(_tbxEnd.Text) ?
                    "0" : String.Format("{0:x}", Convert.ToUInt32(_tbxEnd.Text));
            }
            else
            {
                _tbxStart.Text = String.IsNullOrEmpty(_tbxStart.Text) ?
                    "0" : Convert.ToUInt32(_tbxStart.Text, 16).ToString();
                _tbxEnd.Text = String.IsNullOrEmpty(_tbxEnd.Text) ?
                    "0" : Convert.ToUInt32(_tbxEnd.Text, 16).ToString();
            }
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public TextBoxStartEnd()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 値を設定します。
        /// </summary>
        public void SetValue(CharCodeRange range)
        {
            _chkCheck.Checked = range.Checked;
            _tbxStart.Text = range.First.ToString();
            _tbxEnd.Text = range.Last.ToString();
        }

        /// <summary>
        /// チェックが変更された時のイベントハンドラです。
        /// </summary>
        private void Event_CheckedChanged(object sender, EventArgs e)
        {
            Checked = _chkCheck.Checked;
        }
    }
}
