﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LayoutEditor.Utility
{
    /// <summary>
    /// ヘルパー
    /// </summary>
    public static class TabControlHelper
    {
        /// <summary>
        ///
        /// </summary>
        public static void SelectByData(this TabControl tabCtrl, object data)
        {
            foreach (TabPage page in tabCtrl.TabPages)
            {
                if (page.Tag == data)
                {
                    tabCtrl.SelectedTab = page;
                    break;
                }
            }
        }
    }

    /// <summary>
    /// ComboBox用のヘルパーです。
    /// </summary>
    public static class ComboBoxHelper
    {
        /// <summary>
        /// 文字列で選択します。
        /// </summary>
        /// <param name="cb">コンボボックスです。</param>
        /// <param name="text">文字列です。</param>
        public static void SelectByText(this ComboBox cb, string text)
        {
            SelectByCondition(cb, (item) => item.ToString() == text);
        }

        /// <summary>
        /// 文字列で選択します。
        /// </summary>
        /// <param name="cb">コンボボックスです。</param>
        /// <param name="text">文字列です。</param>
        public static void SelectByCondition(this ComboBox cb, Func<object,bool> condition)
        {
            int tagIndex;
            for (tagIndex = cb.Items.Count - 1; tagIndex >= 0; tagIndex--)
            {
                if (condition(cb.Items[tagIndex]))
                {
                    break;
                }
            }

            cb.SelectedIndex = tagIndex;
            if (tagIndex == -1)
            {
                cb.Text = string.Empty;
            }
        }

        /// <summary>
        /// 文字列で選択します。
        /// </summary>
        /// <param name="cb">コンボボックスです。</param>
        /// <param name="text">文字列です。</param>
        public static void SelectByCondition(this ToolStripComboBox cb, Func<object, bool> condition)
        {
            SelectByCondition(cb.ComboBox, condition);
        }

        /// <summary>
        /// 条件で削除します。
        /// </summary>
        /// <param name="cb">コンボボックスです。</param>
        /// <param name="text">条件です。</param>
        public static void RemoveByCondition(this ToolStripComboBox cb, Func<object, bool> condition)
        {
            for (int tagIndex = cb.Items.Count - 1; tagIndex >= 0; tagIndex--)
            {
                if (condition(cb.Items[tagIndex]))
                {
                    cb.Items.RemoveAt(tagIndex);
                }
            }
        }
    }
}
