﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Diagnostics;
using System.Data;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.TimiControlWindow
{

    using LECore.Structures;
    using LECore.Structures.Core;

    /// <summary>
    /// TimeControlPanel の概要の説明です。
    /// </summary>
    public class TimeControlPanel : UserControl
    {
        #region デザイナ生成コード
        #region デザイナ変数

        private LayoutEditor.Controls.IntTextBox _tbxAnmEnd;
        private LayoutEditor.Controls.IntTextBox _tbxAnmPlayRangeEnd;
        private LayoutEditor.Controls.IntTextBox _tbxAnmPlayRangeStart;
        private LayoutEditor.Controls.IntTextBox _tbxAnmStart;
        #endregion デザイナ変数

        private LayoutEditor.Controls.DockContentToolTip ttpTimeCtrl;
        private TimeSliderControl _pnlTimeSlider;
        private System.ComponentModel.IContainer components;
        #region コンポーネント デザイナで生成されたコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(TimeControlPanel));
            this._pnlTimeSlider = new LayoutEditor.Forms.ToolWindows.TimiControlWindow.TimeSliderControl();
            this._tbxAnmEnd = new LayoutEditor.Controls.IntTextBox();
            this._tbxAnmPlayRangeEnd = new LayoutEditor.Controls.IntTextBox();
            this._tbxAnmPlayRangeStart = new LayoutEditor.Controls.IntTextBox();
            this._tbxAnmStart = new LayoutEditor.Controls.IntTextBox();
            this.ttpTimeCtrl = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this.SuspendLayout();
            //
            // _pnlTimeSlider
            //
            resources.ApplyResources(this._pnlTimeSlider, "_pnlTimeSlider");
            this._pnlTimeSlider.BackColor = System.Drawing.SystemColors.ButtonShadow;
            this._pnlTimeSlider.Name = "_pnlTimeSlider";
            this.ttpTimeCtrl.SetToolTip(this._pnlTimeSlider, resources.GetString("_pnlTimeSlider.ToolTip"));
            this._pnlTimeSlider.Tweakable = true;
            //
            // _tbxAnmEnd
            //
            resources.ApplyResources(this._tbxAnmEnd, "_tbxAnmEnd");
            this._tbxAnmEnd.Name = "_tbxAnmEnd";
            this.ttpTimeCtrl.SetToolTip(this._tbxAnmEnd, resources.GetString("_tbxAnmEnd.ToolTip"));
            this._tbxAnmEnd.ValueChanged += new System.EventHandler(this.Event_TbxAnmEnd_ValueChanged);
            //
            // _tbxAnmPlayRangeEnd
            //
            resources.ApplyResources(this._tbxAnmPlayRangeEnd, "_tbxAnmPlayRangeEnd");
            this._tbxAnmPlayRangeEnd.Name = "_tbxAnmPlayRangeEnd";
            this.ttpTimeCtrl.SetToolTip(this._tbxAnmPlayRangeEnd, resources.GetString("_tbxAnmPlayRangeEnd.ToolTip"));
            this._tbxAnmPlayRangeEnd.ValueChanged += new System.EventHandler(this.Event_TbxAnmPlayRangeEnd_ValueChanged);
            //
            // _tbxAnmPlayRangeStart
            //
            resources.ApplyResources(this._tbxAnmPlayRangeStart, "_tbxAnmPlayRangeStart");
            this._tbxAnmPlayRangeStart.Name = "_tbxAnmPlayRangeStart";
            this.ttpTimeCtrl.SetToolTip(this._tbxAnmPlayRangeStart, resources.GetString("_tbxAnmPlayRangeStart.ToolTip"));
            this._tbxAnmPlayRangeStart.ValueChanged += new System.EventHandler(this.Event_TbxAnmPlayRangeStart_ValueChanged);
            //
            // _tbxAnmStart
            //
            resources.ApplyResources(this._tbxAnmStart, "_tbxAnmStart");
            this._tbxAnmStart.Name = "_tbxAnmStart";
            this.ttpTimeCtrl.SetToolTip(this._tbxAnmStart, resources.GetString("_tbxAnmStart.ToolTip"));
            this._tbxAnmStart.ValueChanged += new System.EventHandler(this.Event_TbxAnmStart_ValueChanged);
            //
            // TimeControlPanel
            //
            this.Controls.Add(this._pnlTimeSlider);
            this.Controls.Add(this._tbxAnmEnd);
            this.Controls.Add(this._tbxAnmPlayRangeEnd);
            this.Controls.Add(this._tbxAnmPlayRangeStart);
            this.Controls.Add(this._tbxAnmStart);
            this.Name = "TimeControlPanel";
            resources.ApplyResources(this, "$this");
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion
        #endregion


        #region デリゲータ

        #endregion デリゲータ

        #region プロパティ

        /// <summary>
        /// グローバル時間クラス（クラス中でよく使用するので）
        /// </summary>
        GlobalTime _GrbTime
        {
            get{ return GlobalTime.Inst;}
        }
        #endregion プロパティ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TimeControlPanel()
        {
            // この呼び出しは、Windows.Forms フォーム デザイナで必要です。
            InitializeComponent();
            UpdateProperty();
        }

        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if(components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        /// <summary>
        /// UIを更新します。
        /// </summary>
        public void UpdateProperty()
        {
            GlobalTime      gt = GlobalTime.Inst;

            _tbxAnmStart.Text   = gt.AnimStartTime.ToString();
            _tbxAnmEnd.Text     = gt.AnimEndTime.ToString();
            _tbxAnmPlayRangeStart.Text   = gt.AnimPlayStartTime.ToString();
            _tbxAnmPlayRangeEnd.Text     = gt.AnimPlayEndTime.ToString();

            // 選択タグを再生範囲として使用するときは、再生範囲を編集不可にする
            bool isTimeSliderEditable = !(gt.UseTargetFrameSectionRangeAsPlayRange && gt.IsTargetFrameSectionSelected);
            _pnlTimeSlider.Tweakable
                = _tbxAnmPlayRangeStart.Enabled
                = _tbxAnmPlayRangeEnd.Enabled
                = isTimeSliderEditable;

            string tooltipText = isTimeSliderEditable ?
                string.Empty : // 独自描画処理とかち合ってちらつくので、編集可能なときは tooltip を出さない。
                StringResMgr.Get("TIMECONTROLPANEL_TOOLTIP_TWEAKE_DISABLED");
            ttpTimeCtrl.SetToolTip(_pnlTimeSlider, tooltipText);

            this.Invalidate( true );
        }


        #region  ------------------- UI イベントハンドラ -------------------

        #region テキストボックス

        private void Event_TbxAnmStart_ValueChanged(object sender, System.EventArgs e)
        {
            Controls.IntTextBox itb = sender as Controls.IntTextBox;
            if( itb.Value < _GrbTime.AnimEndTime )
            {
                _GrbTime.Set(
                    itb.Value,
                    _GrbTime.AnimEndTime,
                    _GrbTime.AnimPlayStartTime,
                    _GrbTime.AnimPlayEndTime );

                _pnlTimeSlider.Invalidate();
            }
            else
            {
                itb.SetValue( _GrbTime.AnimStartTime );
            }
        }

        private void Event_TbxAnmEnd_ValueChanged(object sender, System.EventArgs e)
        {
            Controls.IntTextBox itb = sender as Controls.IntTextBox;
            if( _GrbTime.AnimStartTime < itb.Value )
            {
                _GrbTime.Set(
                    _GrbTime.AnimStartTime,
                    itb.Value,
                    _GrbTime.AnimPlayStartTime,
                    _GrbTime.AnimPlayEndTime );

                _pnlTimeSlider.Invalidate();
            }
            else
            {
                itb.SetValue( _GrbTime.AnimEndTime );
            }
        }

        private void Event_TbxAnmPlayRangeStart_ValueChanged(object sender, System.EventArgs e)
        {
            Controls.IntTextBox itb = sender as Controls.IntTextBox;
            if( itb.Value < _GrbTime.AnimPlayEndTime )
            {
                _GrbTime.Set(
                    _GrbTime.AnimStartTime,
                    _GrbTime.AnimEndTime,
                     itb.Value,
                    _GrbTime.AnimPlayEndTime );

                _pnlTimeSlider.Invalidate();
            }
            else
            {
                itb.SetValue( _GrbTime.AnimPlayStartTime );
            }
        }

        private void Event_TbxAnmPlayRangeEnd_ValueChanged(object sender, System.EventArgs e)
        {
            Controls.IntTextBox itb = sender as Controls.IntTextBox;
            if( _GrbTime.AnimPlayStartTime < itb.Value )
            {
                _GrbTime.Set(
                    _GrbTime.AnimStartTime,
                    _GrbTime.AnimEndTime,
                    _GrbTime.AnimPlayStartTime,
                    itb.Value );

                _pnlTimeSlider.Invalidate();
            }
            else
            {
                itb.SetValue( _GrbTime.AnimPlayEndTime );
            }
        }

        #endregion テキストボックス

        #endregion  ------------------- UI イベントハンドラ -------------------
    }
}
