﻿using LECore.Structures;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LayoutEditor.src.Forms.ToolWindows.StateSettingWindow
{
    public partial class EditTransitionDlg : Form
    {
        private Action _OnOk { get; set; }

        //----------------------------------------------------------

        public EditTransitionDlg()
        {
            InitializeComponent();

            {
                _cmbEasingKind.Items.Clear();
                foreach (var kind in Enum.GetValues(typeof(EasingType)))
                {
                    _cmbEasingKind.Items.Add(kind.ToString());
                }
            }

            // TriggerKind
            {
                _cmbTriggerKind.Items.Clear();
                foreach (var kind in Enum.GetValues(typeof(TriggerKind)))
                {
                    _cmbTriggerKind.Items.Add(kind.ToString());
                }
            }

            // StateMachineOperator
            {
                _cmbStateMachineOperatorKind.Items.Clear();
                foreach (var kind in Enum.GetValues(typeof(StateMachineOperator)))
                {
                    _cmbStateMachineOperatorKind.Items.Add(kind.ToString());
                }
            }
        }

        public string StartStateName { get { return _cmbStartStateName.Text; } }

        public string EndStateName { get { return _cmbEndStateName.Text; } }

        public float TotalDuration { get { return (float)_nudTotalDuration.Value; } set { _nudTotalDuration.Value = (Decimal)value; } }

        public bool IsCancelable { get { return _chkIsCancelable.Checked; } set { _chkIsCancelable.Checked = value; } }

        public bool IsLoop { get { return _chkIsLoop.Checked; } set { _chkIsLoop.Checked = value; } }

        public EasingType EasingType
        {
            get
            {
                EasingType type;
                return (_cmbEasingKind.SelectedItem != null) && Enum.TryParse<EasingType>(_cmbEasingKind.SelectedItem.ToString(), out type) ? type : EasingType.Linear;
            }
        }

        public float EasingExtraParamater { get { return (float)_nudEasingParamater.Value; } set { _nudEasingParamater.Value = (Decimal)value; } }

        public TriggerKind TriggerKind
        {
            get
            {
                TriggerKind type;
                return (_cmbTriggerKind.SelectedItem != null) && Enum.TryParse<TriggerKind>(_cmbTriggerKind.SelectedItem.ToString(), out type) ? type : TriggerKind.IsAuto;
            }
        }

        public StateMachineOperator StateMachineOperator
        {
            get
            {
                StateMachineOperator type;
                return (_cmbStateMachineOperatorKind.SelectedItem != null) && Enum.TryParse<StateMachineOperator>(_cmbStateMachineOperatorKind.SelectedItem.ToString(), out type) ? type : StateMachineOperator.GreaterThan;
            }
        }

        public string VariableName
        {
            get
            {
                return (_cmbVariableNames.SelectedItem != null) ? _cmbVariableNames.SelectedItem.ToString() : string.Empty;
            }
        }

        public float VariableValue
        {
            get
            {
                return (float)_nudVariableValue.Value;
            }
        }

        //----------------------------------------------------------

        void SetupStateListView_(ComboBox comboBox, IStateLayer layer, string selectName)
        {
            comboBox.Items.Clear();

            int selectedIndex = -1;
            foreach (var state in layer.States)
            {
                if (state.Name == selectName)
                {
                    selectedIndex = comboBox.Items.Count;
                }

                comboBox.Items.Add(state.Name);
            }

            comboBox.SelectedIndex = selectedIndex;
        }

        public void Setup(IStateMachine stateMachine, string startName, string endName, IStateEasing stateEasing, TriggerKind triggerKind, Action onOk)
        {
            _OnOk = onOk;

            var layer = stateMachine.GetSelectedIStateLayer();
            if (layer == null)
            {
                Debug.Assert(false);
                return;
            }

            _cmbEasingKind.SelectedIndex = _cmbEasingKind.FindStringExact(stateEasing.EasingType.ToString());
            _nudEasingParamater.Value = (decimal)stateEasing.EasingExtraParamater;

            int indexTrigger = _cmbTriggerKind.FindStringExact(triggerKind.ToString());
            if (indexTrigger != -1)
            {
                _cmbTriggerKind.SelectedIndex = indexTrigger;
            }

            SetupStateListView_(_cmbStartStateName, layer, startName);
            SetupStateListView_(_cmbEndStateName, layer, endName);

            _cmbEasingKind_SelectedIndexChanged(null, null);
        }

        public void SetupVariableChangedTrigger(IStateMachine stateMachine, StateMachineOperator stateMachineOperator, string variableName, float variableValue)
        {
            _cmbStateMachineOperatorKind.SelectedIndex = _cmbStateMachineOperatorKind.FindStringExact(stateMachineOperator.ToString());

            {
                _cmbVariableNames.Items.Clear();
                foreach (var variable in stateMachine.Variables)
                {
                    _cmbVariableNames.Items.Add(variable.ToString());
                }

                _cmbVariableNames.SelectedIndex = _cmbVariableNames.FindStringExact(variableName);
            }

            _nudVariableValue.Value = (Decimal)variableValue;
        }

        void UpdateButtons_()
        {
            bool isValid = true;
            _btnOK.Enabled = isValid;

            _pnlVariable.Visible = this.TriggerKind == TriggerKind.IsVariableChanged;
        }

        //----------------------------------------------------------

        private void AddPropertyDlg_Deactivate(object sender, EventArgs e)
        {
            this.Hide();
        }

        //----------------------------------------------------------

        public void ShowInEditMode()
        {
            Show();
        }

        //----------------------------------------------------------

        private void _btnOK_Click(object sender, EventArgs e)
        {
            if(_OnOk != null)
            {
                _OnOk();
            }

            this.Hide();
        }

        private void _cmbTriggerKind_SelectedIndexChanged(object sender, EventArgs e)
        {
            UpdateButtons_();
        }

        private void _cmbEasingKind_SelectedIndexChanged(object sender, EventArgs e)
        {
            _nudEasingParamater.Enabled = this.EasingType.UseExtraParamater();
        }
    }
}
