﻿using LECore.Structures;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LayoutEditor.src.Forms.ToolWindows.StateSettingWindow
{
    public partial class AddPropertyDlg : Form
    {
        IEnumerable<IPane> _selectedPanes;
        Action<IEnumerable<IPane>, FeatureParamaterKind, bool> _OnPaneAdded { get; set; }

        bool _isEditMode = false;

        //----------------------------------------------------------

        public AddPropertyDlg()
        {
            InitializeComponent();
        }

        //----------------------------------------------------------

        public void Setup(IStateMachine stateMachine, IEnumerable<IPane> selectedPanes, Action<IEnumerable<IPane>, FeatureParamaterKind, bool> onPaneAdded)
        {
            _OnPaneAdded = onPaneAdded;

            _selectedPanes = selectedPanes;

            _lvwPanes.Clear();

            foreach (var pane in selectedPanes)
            {
                ListViewItem lvi = new ListViewItem(pane.PaneName);
                lvi.Tag = pane;

                _lvwPanes.Items.Add(lvi);
            }

            bool allHaveMaterial = selectedPanes.All(p => p.IMaterial.Count() > 0);

            _chkBlackColor.Enabled = allHaveMaterial;
            _chkWhiteColor.Enabled = allHaveMaterial;

            _chkStateEvent.Enabled = selectedPanes.All((p) => p.IsStateMachinePartsPane());


            // すでに登録済みなら、先頭のペインを使って、チェック状態の初期値を設定する。
            var currentLayrer = stateMachine.GetSelectedIStateLayer();
            if(currentLayrer != null)
            {
                var firstPane = selectedPanes.First();
                var paramaters = currentLayrer.FindFeatureParamaterByTargetName("Base", firstPane.PaneName);

                _chkT.Checked = paramaters.Any(p => p.Kind == FeatureParamaterKind.Position);
                _chkS.Checked = paramaters.Any(p => p.Kind == FeatureParamaterKind.Scale);
                _chkR.Checked = paramaters.Any(p => p.Kind == FeatureParamaterKind.RotateZ);
                _chkWhiteColor.Checked = paramaters.Any(p => p.Kind == FeatureParamaterKind.WhiteColor);
                _chkBlackColor.Checked = paramaters.Any(p => p.Kind == FeatureParamaterKind.BlackColor);
                _chkStateEvent.Checked = paramaters.Any(p => p.Kind == FeatureParamaterKind.StateMachineEvent);
            }
        }

        //----------------------------------------------------------

        private void AddPropertyDlg_Deactivate(object sender, EventArgs e)
        {
            _isEditMode = false;
            this.Hide();
        }

        //----------------------------------------------------------

        FeatureParamaterKind GetEnabledFlags_()
        {
            FeatureParamaterKind flag = FeatureParamaterKind.None;

            if (_chkT.Checked) flag |= FeatureParamaterKind.Position;
            if (_chkS.Checked) flag |= FeatureParamaterKind.Scale;
            if (_chkR.Checked) flag |= FeatureParamaterKind.RotateZ;
            if (_chkWhiteColor.Checked) flag |= FeatureParamaterKind.WhiteColor;
            if (_chkBlackColor.Checked) flag |= FeatureParamaterKind.BlackColor;
            if (_chkStateEvent.Checked) flag |= FeatureParamaterKind.StateMachineEvent;

            return flag;
        }

        //----------------------------------------------------------

        public void ShowInEditMode()
        {
            _isEditMode = true;
            Show();
        }

        //----------------------------------------------------------

        private void _btnOK_Click(object sender, EventArgs e)
        {
            if (_OnPaneAdded != null)
            {
                _OnPaneAdded(_selectedPanes, GetEnabledFlags_(), _isEditMode);
            }

            this.Hide();
        }
    }
}
