﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Linq;
using System.Diagnostics;
using System.Windows.Forms;
using LECore.Structures.Nsrif.Attributes;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using Adapters;
    using LayoutEditor.Controls;
    using LECore;
    using LECore.Manipulator;
    using LECore.Structures;
    using LECore.Structures.Core;
    using src.Controls;
    using System.Collections.Generic;
    using TextureControls;
    using HVLocation = Tuple<LECore.Structures.HorizontalLocation, LECore.Structures.VerticalLocation>;

    /// <summary>
    /// PropWndPaneProceduralShapePage の概要の説明です。
    /// </summary>
    public class PropWndPaneProceduralShapePage : PropertyPage
    {
        #region デザイナ生成フィールド
        private System.Windows.Forms.Label _lblRotZ;
        private LayoutEditor.Controls.DockContentToolTip _ttpPaneBasic;
        private System.ComponentModel.IContainer components;
        private GroupBox _grpStroke;
        private ColorEditPanel _colStrokeColor;
        private FloatEditSlider _fesStrokeSize;
        private UIComboBox _comboStrokeBlendMode;
        private UICheckBox _chkStrokeEnabled;
        private BindAnimationLabel _lblStrokeColor;
        private BindAnimationLabel _lblStrokeBlendMode;
        private BindAnimationLabel _lblStrokeSize;
        private UICheckBox _chkProceduralShapeEnabled;
        private UICheckBox _chkInnerShadowEnabled;
        private GroupBox _grpInnerShadow;
        private UIComboBox _comboInnerShadowType;
        private BindAnimationLabel _lblInnerShadowType;
        private BindAnimationLabel _lblInnerShadowSize;
        private BindAnimationLabel _lblInnerShadowDistance;
        private BindAnimationLabel _lblInnerShadowAngle;
        private BindAnimationLabel _lblInnerShadowBlendMode;
        private BindAnimationLabel _lblInnerShadowColor;
        private FloatEditSlider _fesInnerShadowSize;
        private FloatEditSlider _fesInnerShadowDistance;
        private FloatEditSlider _fesInnerShadowAngle;
        private UIComboBox _comboInnerShadowBlendMode;
        private ColorEditPanel _colInnerShadowColor;
        private GroupBox _grpProceduralShape;
        private BindAnimationLabel _lblProceduralShapeRadius;
        private BindAnimationLabel _lblProceduralShapeExp;
        private UICheckBox _chkOuterShadowEnabled;
        private GroupBox _grpOuterShadow;
        private UIComboBox _comboOuterShadowType;
        private BindAnimationLabel _lblOuterShadowType;
        private BindAnimationLabel _lblOuterShadowSize;
        private BindAnimationLabel _lblOuterShadowDistance;
        private BindAnimationLabel _lblOuterShadowAngle;
        private BindAnimationLabel _lblOuterShadowBlendMode;
        private BindAnimationLabel _lblOuterShadowColor;
        private FloatEditSlider _fesOuterShadowSize;
        private FloatEditSlider _fesOuterShadowDistance;
        private FloatEditSlider _fesOuterShadowAngle;
        private UIComboBox _comboOuterShadowBlendMode;
        private ColorEditPanel _colOuterShadowColor;
        private UICheckBox _chkColorOverlayEnabled;
        private GroupBox _grpColorOverlay;
        private BindAnimationLabel _lblColorOverlayBlendMode;
        private BindAnimationLabel _lblColorOverlayColor;
        private UIComboBox _comboColorOverlayBlendMode;
        private ColorEditPanel _colColorOverlayColor;
        private FloatEditSlider _fesProceduralShapeRadius;
        private FloatEditSlider _fesProceduralShapeExp;
        private GroupBox _grpGradationOverlay;
        private BindAnimationLabel _lblGradationOverlayAngle;
        private FloatEditSlider _fesGradationOverlayAngle;
        private GroupBox _grpGradationOverlayControl3;
        private BindAnimationLabel _lblGradationOverlayControlPoint3;
        private FloatEditSlider _fesGradationOverlayControlPoint3;
        private BindAnimationLabel _lblGradationOverlayColor3;
        private ColorEditPanel _colGradationOverlayColor3;
        private GroupBox _grpGradationOverlayControl2;
        private BindAnimationLabel _lblGradationOverlayControlPoint2;
        private FloatEditSlider _fesGradationOverlayControlPoint2;
        private BindAnimationLabel _lblGradationOverlayColor2;
        private ColorEditPanel _colGradationOverlayColor2;
        private GroupBox _grpGradationOverlayControl1;
        private BindAnimationLabel _lblGradationOverlayControlPoint1;
        private FloatEditSlider _fesGradationOverlayControlPoint1;
        private BindAnimationLabel _lblGradationOverlayColor1;
        private ColorEditPanel _colGradationOverlayColor1;
        private GroupBox _grpGradationOverlayControl0;
        private BindAnimationLabel _lblGradationOverlayControlPoint0;
        private FloatEditSlider _fesGradationOverlayControlPoint0;
        private BindAnimationLabel _lblGradationOverlayColor0;
        private ColorEditPanel _colGradationOverlayColor0;
        private BindAnimationLabel _lblGradationOverlayBlendMode;
        private UIComboBox _comboGradationOverlayBlendMode;
        private UICheckBox _chkGradationOverlayEnabled;
        private Label _lblControlPointCount;
        private NumericUpDown _numControlPointCount;
        private ErrorProvider _erpPaneNameChange;

        #endregion デザイナ生成フィールド

        #region デザイナ生成コード
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(PropWndPaneProceduralShapePage));
            this._lblRotZ = new System.Windows.Forms.Label();
            this._ttpPaneBasic = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this._chkStrokeEnabled = new LayoutEditor.Controls.UICheckBox();
            this._colStrokeColor = new LayoutEditor.Controls.ColorEditPanel();
            this._erpPaneNameChange = new System.Windows.Forms.ErrorProvider(this.components);
            this._grpStroke = new System.Windows.Forms.GroupBox();
            this._lblStrokeBlendMode = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblStrokeSize = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblStrokeColor = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._comboStrokeBlendMode = new LayoutEditor.Controls.UIComboBox();
            this._fesStrokeSize = new LayoutEditor.Controls.FloatEditSlider();
            this._chkProceduralShapeEnabled = new LayoutEditor.Controls.UICheckBox();
            this._grpProceduralShape = new System.Windows.Forms.GroupBox();
            this._fesProceduralShapeRadius = new LayoutEditor.Controls.FloatEditSlider();
            this._fesProceduralShapeExp = new LayoutEditor.Controls.FloatEditSlider();
            this._lblProceduralShapeRadius = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblProceduralShapeExp = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._chkInnerShadowEnabled = new LayoutEditor.Controls.UICheckBox();
            this._grpInnerShadow = new System.Windows.Forms.GroupBox();
            this._comboInnerShadowType = new LayoutEditor.Controls.UIComboBox();
            this._lblInnerShadowType = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblInnerShadowSize = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblInnerShadowDistance = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblInnerShadowAngle = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblInnerShadowBlendMode = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblInnerShadowColor = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._fesInnerShadowSize = new LayoutEditor.Controls.FloatEditSlider();
            this._fesInnerShadowDistance = new LayoutEditor.Controls.FloatEditSlider();
            this._fesInnerShadowAngle = new LayoutEditor.Controls.FloatEditSlider();
            this._comboInnerShadowBlendMode = new LayoutEditor.Controls.UIComboBox();
            this._colInnerShadowColor = new LayoutEditor.Controls.ColorEditPanel();
            this._chkColorOverlayEnabled = new LayoutEditor.Controls.UICheckBox();
            this._grpColorOverlay = new System.Windows.Forms.GroupBox();
            this._lblColorOverlayBlendMode = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblColorOverlayColor = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._comboColorOverlayBlendMode = new LayoutEditor.Controls.UIComboBox();
            this._colColorOverlayColor = new LayoutEditor.Controls.ColorEditPanel();
            this._chkOuterShadowEnabled = new LayoutEditor.Controls.UICheckBox();
            this._grpOuterShadow = new System.Windows.Forms.GroupBox();
            this._comboOuterShadowType = new LayoutEditor.Controls.UIComboBox();
            this._lblOuterShadowType = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblOuterShadowSize = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblOuterShadowDistance = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblOuterShadowAngle = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblOuterShadowBlendMode = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._lblOuterShadowColor = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._fesOuterShadowSize = new LayoutEditor.Controls.FloatEditSlider();
            this._fesOuterShadowDistance = new LayoutEditor.Controls.FloatEditSlider();
            this._fesOuterShadowAngle = new LayoutEditor.Controls.FloatEditSlider();
            this._comboOuterShadowBlendMode = new LayoutEditor.Controls.UIComboBox();
            this._colOuterShadowColor = new LayoutEditor.Controls.ColorEditPanel();
            this._chkGradationOverlayEnabled = new LayoutEditor.Controls.UICheckBox();
            this._grpGradationOverlay = new System.Windows.Forms.GroupBox();
            this._lblControlPointCount = new System.Windows.Forms.Label();
            this._numControlPointCount = new System.Windows.Forms.NumericUpDown();
            this._lblGradationOverlayAngle = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._fesGradationOverlayAngle = new LayoutEditor.Controls.FloatEditSlider();
            this._grpGradationOverlayControl3 = new System.Windows.Forms.GroupBox();
            this._lblGradationOverlayControlPoint3 = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._fesGradationOverlayControlPoint3 = new LayoutEditor.Controls.FloatEditSlider();
            this._lblGradationOverlayColor3 = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._colGradationOverlayColor3 = new LayoutEditor.Controls.ColorEditPanel();
            this._grpGradationOverlayControl2 = new System.Windows.Forms.GroupBox();
            this._lblGradationOverlayControlPoint2 = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._fesGradationOverlayControlPoint2 = new LayoutEditor.Controls.FloatEditSlider();
            this._lblGradationOverlayColor2 = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._colGradationOverlayColor2 = new LayoutEditor.Controls.ColorEditPanel();
            this._grpGradationOverlayControl1 = new System.Windows.Forms.GroupBox();
            this._lblGradationOverlayControlPoint1 = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._fesGradationOverlayControlPoint1 = new LayoutEditor.Controls.FloatEditSlider();
            this._lblGradationOverlayColor1 = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._colGradationOverlayColor1 = new LayoutEditor.Controls.ColorEditPanel();
            this._grpGradationOverlayControl0 = new System.Windows.Forms.GroupBox();
            this._lblGradationOverlayControlPoint0 = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._fesGradationOverlayControlPoint0 = new LayoutEditor.Controls.FloatEditSlider();
            this._lblGradationOverlayColor0 = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._colGradationOverlayColor0 = new LayoutEditor.Controls.ColorEditPanel();
            this._lblGradationOverlayBlendMode = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._comboGradationOverlayBlendMode = new LayoutEditor.Controls.UIComboBox();
            ((System.ComponentModel.ISupportInitialize)(this._erpPaneNameChange)).BeginInit();
            this._grpStroke.SuspendLayout();
            this._grpProceduralShape.SuspendLayout();
            this._grpInnerShadow.SuspendLayout();
            this._grpColorOverlay.SuspendLayout();
            this._grpOuterShadow.SuspendLayout();
            this._grpGradationOverlay.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._numControlPointCount)).BeginInit();
            this._grpGradationOverlayControl3.SuspendLayout();
            this._grpGradationOverlayControl2.SuspendLayout();
            this._grpGradationOverlayControl1.SuspendLayout();
            this._grpGradationOverlayControl0.SuspendLayout();
            this.SuspendLayout();
            //
            // _lblRotZ
            //
            resources.ApplyResources(this._lblRotZ, "_lblRotZ");
            this._lblRotZ.Name = "_lblRotZ";
            //
            // _chkStrokeEnabled
            //
            resources.ApplyResources(this._chkStrokeEnabled, "_chkStrokeEnabled");
            this._chkStrokeEnabled.Name = "_chkStrokeEnabled";
            this._chkStrokeEnabled.CheckedChanged += new System.EventHandler(this.Event_chkStrokeEnabled_CheckedChanged);
            //
            // _colStrokeColor
            //
            this._colStrokeColor.AllowDrop = true;
            resources.ApplyResources(this._colStrokeColor, "_colStrokeColor");
            this._colStrokeColor.Name = "_colStrokeColor";
            this._colStrokeColor.Tag = "";
            this._colStrokeColor.UseAnimationMark = true;
            this._colStrokeColor.ColorEdit += new LayoutEditor.Controls.ColorEditEventHandler(this.Event_colStrokeColor_ColorEdit);
            //
            // _erpPaneNameChange
            //
            this._erpPaneNameChange.ContainerControl = this;
            resources.ApplyResources(this._erpPaneNameChange, "_erpPaneNameChange");
            //
            // _grpStroke
            //
            this._grpStroke.Controls.Add(this._lblStrokeBlendMode);
            this._grpStroke.Controls.Add(this._lblStrokeSize);
            this._grpStroke.Controls.Add(this._lblStrokeColor);
            this._grpStroke.Controls.Add(this._comboStrokeBlendMode);
            this._grpStroke.Controls.Add(this._fesStrokeSize);
            this._grpStroke.Controls.Add(this._colStrokeColor);
            resources.ApplyResources(this._grpStroke, "_grpStroke");
            this._grpStroke.Name = "_grpStroke";
            this._grpStroke.TabStop = false;
            //
            // _lblStrokeBlendMode
            //
            resources.ApplyResources(this._lblStrokeBlendMode, "_lblStrokeBlendMode");
            this._lblStrokeBlendMode.Name = "_lblStrokeBlendMode";
            this._lblStrokeBlendMode.UseAnimationMark = false;
            this._lblStrokeBlendMode.UseContextMenu = false;
            //
            // _lblStrokeSize
            //
            resources.ApplyResources(this._lblStrokeSize, "_lblStrokeSize");
            this._lblStrokeSize.Name = "_lblStrokeSize";
            this._lblStrokeSize.UseAnimationMark = true;
            this._lblStrokeSize.UseContextMenu = true;
            //
            // _lblStrokeColor
            //
            resources.ApplyResources(this._lblStrokeColor, "_lblStrokeColor");
            this._lblStrokeColor.Name = "_lblStrokeColor";
            this._lblStrokeColor.UseAnimationMark = true;
            this._lblStrokeColor.UseContextMenu = true;
            //
            // _comboStrokeBlendMode
            //
            this._comboStrokeBlendMode.FormattingEnabled = true;
            this._comboStrokeBlendMode.Items.AddRange(new object[] {
            resources.GetString("_comboStrokeBlendMode.Items"),
            resources.GetString("_comboStrokeBlendMode.Items1"),
            resources.GetString("_comboStrokeBlendMode.Items2"),
            resources.GetString("_comboStrokeBlendMode.Items3")});
            resources.ApplyResources(this._comboStrokeBlendMode, "_comboStrokeBlendMode");
            this._comboStrokeBlendMode.Name = "_comboStrokeBlendMode";
            this._comboStrokeBlendMode.SelectedItemData = null;
            this._comboStrokeBlendMode.SelectedIndexChanged += new System.EventHandler(this.Event_comboStrokeBlendMode_SelectedIndexChanged);
            //
            // _fesStrokeSize
            //
            resources.ApplyResources(this._fesStrokeSize, "_fesStrokeSize");
            this._fesStrokeSize.Format = "f2";
            this._fesStrokeSize.MaxValue = 100F;
            this._fesStrokeSize.MinValue = 0F;
            this._fesStrokeSize.Name = "_fesStrokeSize";
            this._fesStrokeSize.RangeLabelFormat = "f2";
            this._fesStrokeSize.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesStrokeSize.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesStrokeSize.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesStrokeSize.TrackBarLargeChange = 0F;
            this._fesStrokeSize.TrackBarPrecision = 100;
            this._fesStrokeSize.TrackBarSmallChange = 0F;
            this._fesStrokeSize.UseAnimationMark = true;
            this._fesStrokeSize.Value = 3F;
            this._fesStrokeSize.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesStrokeSize_ValueEdit);
            //
            // _chkProceduralShapeEnabled
            //
            resources.ApplyResources(this._chkProceduralShapeEnabled, "_chkProceduralShapeEnabled");
            this._chkProceduralShapeEnabled.Name = "_chkProceduralShapeEnabled";
            this._chkProceduralShapeEnabled.CheckedChanged += new System.EventHandler(this.Event_chkProceduralShapeEnabled_CheckedChanged);
            //
            // _grpProceduralShape
            //
            this._grpProceduralShape.Controls.Add(this._fesProceduralShapeRadius);
            this._grpProceduralShape.Controls.Add(this._fesProceduralShapeExp);
            this._grpProceduralShape.Controls.Add(this._lblProceduralShapeRadius);
            this._grpProceduralShape.Controls.Add(this._lblProceduralShapeExp);
            resources.ApplyResources(this._grpProceduralShape, "_grpProceduralShape");
            this._grpProceduralShape.Name = "_grpProceduralShape";
            this._grpProceduralShape.TabStop = false;
            //
            // _fesProceduralShapeRadius
            //
            resources.ApplyResources(this._fesProceduralShapeRadius, "_fesProceduralShapeRadius");
            this._fesProceduralShapeRadius.Format = "f2";
            this._fesProceduralShapeRadius.MaxValue = 500F;
            this._fesProceduralShapeRadius.MinValue = 0F;
            this._fesProceduralShapeRadius.Name = "_fesProceduralShapeRadius";
            this._fesProceduralShapeRadius.RangeLabelFormat = "f2";
            this._fesProceduralShapeRadius.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesProceduralShapeRadius.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesProceduralShapeRadius.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesProceduralShapeRadius.TrackBarLargeChange = 0F;
            this._fesProceduralShapeRadius.TrackBarPrecision = 100;
            this._fesProceduralShapeRadius.TrackBarSmallChange = 0F;
            this._fesProceduralShapeRadius.UseAnimationMark = true;
            this._fesProceduralShapeRadius.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesProceduralShapeRadius_ValueEdit);
            //
            // _fesProceduralShapeExp
            //
            resources.ApplyResources(this._fesProceduralShapeExp, "_fesProceduralShapeExp");
            this._fesProceduralShapeExp.Format = "f2";
            this._fesProceduralShapeExp.MaxValue = 3F;
            this._fesProceduralShapeExp.MinValue = 0.5F;
            this._fesProceduralShapeExp.Name = "_fesProceduralShapeExp";
            this._fesProceduralShapeExp.RangeLabelFormat = "f2";
            this._fesProceduralShapeExp.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesProceduralShapeExp.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesProceduralShapeExp.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesProceduralShapeExp.TrackBarLargeChange = 0F;
            this._fesProceduralShapeExp.TrackBarPrecision = 100;
            this._fesProceduralShapeExp.TrackBarSmallChange = 0F;
            this._fesProceduralShapeExp.UseAnimationMark = true;
            this._fesProceduralShapeExp.Value = 1F;
            this._fesProceduralShapeExp.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesProceduralShapeExp_ValueEdit);
            //
            // _lblProceduralShapeRadius
            //
            resources.ApplyResources(this._lblProceduralShapeRadius, "_lblProceduralShapeRadius");
            this._lblProceduralShapeRadius.Name = "_lblProceduralShapeRadius";
            this._lblProceduralShapeRadius.UseAnimationMark = true;
            this._lblProceduralShapeRadius.UseContextMenu = true;
            //
            // _lblProceduralShapeExp
            //
            resources.ApplyResources(this._lblProceduralShapeExp, "_lblProceduralShapeExp");
            this._lblProceduralShapeExp.Name = "_lblProceduralShapeExp";
            this._lblProceduralShapeExp.UseAnimationMark = true;
            this._lblProceduralShapeExp.UseContextMenu = true;
            //
            // _chkInnerShadowEnabled
            //
            resources.ApplyResources(this._chkInnerShadowEnabled, "_chkInnerShadowEnabled");
            this._chkInnerShadowEnabled.Name = "_chkInnerShadowEnabled";
            this._chkInnerShadowEnabled.CheckedChanged += new System.EventHandler(this.Event_chkInnerShadowEnabled_CheckedChanged);
            //
            // _grpInnerShadow
            //
            this._grpInnerShadow.Controls.Add(this._comboInnerShadowType);
            this._grpInnerShadow.Controls.Add(this._lblInnerShadowType);
            this._grpInnerShadow.Controls.Add(this._lblInnerShadowSize);
            this._grpInnerShadow.Controls.Add(this._lblInnerShadowDistance);
            this._grpInnerShadow.Controls.Add(this._lblInnerShadowAngle);
            this._grpInnerShadow.Controls.Add(this._lblInnerShadowBlendMode);
            this._grpInnerShadow.Controls.Add(this._lblInnerShadowColor);
            this._grpInnerShadow.Controls.Add(this._fesInnerShadowSize);
            this._grpInnerShadow.Controls.Add(this._fesInnerShadowDistance);
            this._grpInnerShadow.Controls.Add(this._fesInnerShadowAngle);
            this._grpInnerShadow.Controls.Add(this._comboInnerShadowBlendMode);
            this._grpInnerShadow.Controls.Add(this._colInnerShadowColor);
            resources.ApplyResources(this._grpInnerShadow, "_grpInnerShadow");
            this._grpInnerShadow.Name = "_grpInnerShadow";
            this._grpInnerShadow.TabStop = false;
            //
            // _comboInnerShadowType
            //
            this._comboInnerShadowType.FormattingEnabled = true;
            this._comboInnerShadowType.Items.AddRange(new object[] {
            resources.GetString("_comboInnerShadowType.Items"),
            resources.GetString("_comboInnerShadowType.Items1"),
            resources.GetString("_comboInnerShadowType.Items2")});
            resources.ApplyResources(this._comboInnerShadowType, "_comboInnerShadowType");
            this._comboInnerShadowType.Name = "_comboInnerShadowType";
            this._comboInnerShadowType.SelectedItemData = null;
            this._comboInnerShadowType.SelectedIndexChanged += new System.EventHandler(this.Event_comboInnerShadowAttenuationType_SelectedIndexChanged);
            //
            // _lblInnerShadowType
            //
            resources.ApplyResources(this._lblInnerShadowType, "_lblInnerShadowType");
            this._lblInnerShadowType.Name = "_lblInnerShadowType";
            this._lblInnerShadowType.UseAnimationMark = false;
            this._lblInnerShadowType.UseContextMenu = false;
            //
            // _lblInnerShadowSize
            //
            resources.ApplyResources(this._lblInnerShadowSize, "_lblInnerShadowSize");
            this._lblInnerShadowSize.Name = "_lblInnerShadowSize";
            this._lblInnerShadowSize.UseAnimationMark = true;
            this._lblInnerShadowSize.UseContextMenu = true;
            //
            // _lblInnerShadowDistance
            //
            resources.ApplyResources(this._lblInnerShadowDistance, "_lblInnerShadowDistance");
            this._lblInnerShadowDistance.Name = "_lblInnerShadowDistance";
            this._lblInnerShadowDistance.UseAnimationMark = true;
            this._lblInnerShadowDistance.UseContextMenu = true;
            //
            // _lblInnerShadowAngle
            //
            resources.ApplyResources(this._lblInnerShadowAngle, "_lblInnerShadowAngle");
            this._lblInnerShadowAngle.Name = "_lblInnerShadowAngle";
            this._lblInnerShadowAngle.UseAnimationMark = true;
            this._lblInnerShadowAngle.UseContextMenu = true;
            //
            // _lblInnerShadowBlendMode
            //
            resources.ApplyResources(this._lblInnerShadowBlendMode, "_lblInnerShadowBlendMode");
            this._lblInnerShadowBlendMode.Name = "_lblInnerShadowBlendMode";
            this._lblInnerShadowBlendMode.UseAnimationMark = false;
            this._lblInnerShadowBlendMode.UseContextMenu = false;
            //
            // _lblInnerShadowColor
            //
            resources.ApplyResources(this._lblInnerShadowColor, "_lblInnerShadowColor");
            this._lblInnerShadowColor.Name = "_lblInnerShadowColor";
            this._lblInnerShadowColor.UseAnimationMark = true;
            this._lblInnerShadowColor.UseContextMenu = true;
            //
            // _fesInnerShadowSize
            //
            resources.ApplyResources(this._fesInnerShadowSize, "_fesInnerShadowSize");
            this._fesInnerShadowSize.Format = "f2";
            this._fesInnerShadowSize.MaxValue = 250F;
            this._fesInnerShadowSize.MinValue = 0F;
            this._fesInnerShadowSize.Name = "_fesInnerShadowSize";
            this._fesInnerShadowSize.RangeLabelFormat = "f2";
            this._fesInnerShadowSize.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesInnerShadowSize.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesInnerShadowSize.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesInnerShadowSize.TrackBarLargeChange = 0F;
            this._fesInnerShadowSize.TrackBarPrecision = 100;
            this._fesInnerShadowSize.TrackBarSmallChange = 0F;
            this._fesInnerShadowSize.UseAnimationMark = true;
            this._fesInnerShadowSize.Value = 5F;
            this._fesInnerShadowSize.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesInnerShadowSize_ValueEdit);
            //
            // _fesInnerShadowDistance
            //
            resources.ApplyResources(this._fesInnerShadowDistance, "_fesInnerShadowDistance");
            this._fesInnerShadowDistance.Format = "f2";
            this._fesInnerShadowDistance.MaxValue = 250F;
            this._fesInnerShadowDistance.MinValue = 0F;
            this._fesInnerShadowDistance.Name = "_fesInnerShadowDistance";
            this._fesInnerShadowDistance.RangeLabelFormat = "f2";
            this._fesInnerShadowDistance.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesInnerShadowDistance.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesInnerShadowDistance.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesInnerShadowDistance.TrackBarLargeChange = 0F;
            this._fesInnerShadowDistance.TrackBarPrecision = 100;
            this._fesInnerShadowDistance.TrackBarSmallChange = 0F;
            this._fesInnerShadowDistance.UseAnimationMark = true;
            this._fesInnerShadowDistance.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesInnerShadowDistance_ValueEdit);
            //
            // _fesInnerShadowAngle
            //
            resources.ApplyResources(this._fesInnerShadowAngle, "_fesInnerShadowAngle");
            this._fesInnerShadowAngle.Format = "f2";
            this._fesInnerShadowAngle.MaxValue = 360F;
            this._fesInnerShadowAngle.MinValue = 0F;
            this._fesInnerShadowAngle.Name = "_fesInnerShadowAngle";
            this._fesInnerShadowAngle.RangeLabelFormat = "f2";
            this._fesInnerShadowAngle.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesInnerShadowAngle.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesInnerShadowAngle.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesInnerShadowAngle.TrackBarLargeChange = 0F;
            this._fesInnerShadowAngle.TrackBarPrecision = 100;
            this._fesInnerShadowAngle.TrackBarSmallChange = 0F;
            this._fesInnerShadowAngle.UseAnimationMark = true;
            this._fesInnerShadowAngle.Value = 120F;
            this._fesInnerShadowAngle.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesInnerShadowAngle_ValueEdit);
            //
            // _comboInnerShadowBlendMode
            //
            this._comboInnerShadowBlendMode.FormattingEnabled = true;
            this._comboInnerShadowBlendMode.Items.AddRange(new object[] {
            resources.GetString("_comboInnerShadowBlendMode.Items"),
            resources.GetString("_comboInnerShadowBlendMode.Items1"),
            resources.GetString("_comboInnerShadowBlendMode.Items2"),
            resources.GetString("_comboInnerShadowBlendMode.Items3")});
            resources.ApplyResources(this._comboInnerShadowBlendMode, "_comboInnerShadowBlendMode");
            this._comboInnerShadowBlendMode.Name = "_comboInnerShadowBlendMode";
            this._comboInnerShadowBlendMode.SelectedItemData = null;
            this._comboInnerShadowBlendMode.SelectedIndexChanged += new System.EventHandler(this.Event_comboInnerShadowBlendMode_SelectedIndexChanged);
            //
            // _colInnerShadowColor
            //
            this._colInnerShadowColor.AllowDrop = true;
            resources.ApplyResources(this._colInnerShadowColor, "_colInnerShadowColor");
            this._colInnerShadowColor.Name = "_colInnerShadowColor";
            this._colInnerShadowColor.Tag = "";
            this._colInnerShadowColor.UseAnimationMark = true;
            this._colInnerShadowColor.ColorEdit += new LayoutEditor.Controls.ColorEditEventHandler(this.Event_colInnerShadowColor_ColorEdit);
            //
            // _chkColorOverlayEnabled
            //
            resources.ApplyResources(this._chkColorOverlayEnabled, "_chkColorOverlayEnabled");
            this._chkColorOverlayEnabled.Name = "_chkColorOverlayEnabled";
            this._chkColorOverlayEnabled.CheckedChanged += new System.EventHandler(this.Event_chkColorOverlayEnabled_CheckedChanged);
            //
            // _grpColorOverlay
            //
            this._grpColorOverlay.Controls.Add(this._lblColorOverlayBlendMode);
            this._grpColorOverlay.Controls.Add(this._lblColorOverlayColor);
            this._grpColorOverlay.Controls.Add(this._comboColorOverlayBlendMode);
            this._grpColorOverlay.Controls.Add(this._colColorOverlayColor);
            resources.ApplyResources(this._grpColorOverlay, "_grpColorOverlay");
            this._grpColorOverlay.Name = "_grpColorOverlay";
            this._grpColorOverlay.TabStop = false;
            //
            // _lblColorOverlayBlendMode
            //
            resources.ApplyResources(this._lblColorOverlayBlendMode, "_lblColorOverlayBlendMode");
            this._lblColorOverlayBlendMode.Name = "_lblColorOverlayBlendMode";
            this._lblColorOverlayBlendMode.UseAnimationMark = false;
            this._lblColorOverlayBlendMode.UseContextMenu = false;
            //
            // _lblColorOverlayColor
            //
            resources.ApplyResources(this._lblColorOverlayColor, "_lblColorOverlayColor");
            this._lblColorOverlayColor.Name = "_lblColorOverlayColor";
            this._lblColorOverlayColor.UseAnimationMark = true;
            this._lblColorOverlayColor.UseContextMenu = true;
            //
            // _comboColorOverlayBlendMode
            //
            this._comboColorOverlayBlendMode.FormattingEnabled = true;
            this._comboColorOverlayBlendMode.Items.AddRange(new object[] {
            resources.GetString("_comboColorOverlayBlendMode.Items"),
            resources.GetString("_comboColorOverlayBlendMode.Items1"),
            resources.GetString("_comboColorOverlayBlendMode.Items2"),
            resources.GetString("_comboColorOverlayBlendMode.Items3")});
            resources.ApplyResources(this._comboColorOverlayBlendMode, "_comboColorOverlayBlendMode");
            this._comboColorOverlayBlendMode.Name = "_comboColorOverlayBlendMode";
            this._comboColorOverlayBlendMode.SelectedItemData = null;
            this._comboColorOverlayBlendMode.SelectedIndexChanged += new System.EventHandler(this.Event_comboColorOverlayBlendMode_SelectedIndexChanged);
            //
            // _colColorOverlayColor
            //
            this._colColorOverlayColor.AllowDrop = true;
            resources.ApplyResources(this._colColorOverlayColor, "_colColorOverlayColor");
            this._colColorOverlayColor.Name = "_colColorOverlayColor";
            this._colColorOverlayColor.Tag = "";
            this._colColorOverlayColor.UseAnimationMark = true;
            this._colColorOverlayColor.ColorEdit += new LayoutEditor.Controls.ColorEditEventHandler(this.Event_colColorOverlayColor_ColorEdit);
            //
            // _chkOuterShadowEnabled
            //
            resources.ApplyResources(this._chkOuterShadowEnabled, "_chkOuterShadowEnabled");
            this._chkOuterShadowEnabled.Name = "_chkOuterShadowEnabled";
            this._chkOuterShadowEnabled.CheckedChanged += new System.EventHandler(this.Event_chkOuterShadowEnabled_CheckedChanged);
            //
            // _grpOuterShadow
            //
            this._grpOuterShadow.Controls.Add(this._comboOuterShadowType);
            this._grpOuterShadow.Controls.Add(this._lblOuterShadowType);
            this._grpOuterShadow.Controls.Add(this._lblOuterShadowSize);
            this._grpOuterShadow.Controls.Add(this._lblOuterShadowDistance);
            this._grpOuterShadow.Controls.Add(this._lblOuterShadowAngle);
            this._grpOuterShadow.Controls.Add(this._lblOuterShadowBlendMode);
            this._grpOuterShadow.Controls.Add(this._lblOuterShadowColor);
            this._grpOuterShadow.Controls.Add(this._fesOuterShadowSize);
            this._grpOuterShadow.Controls.Add(this._fesOuterShadowDistance);
            this._grpOuterShadow.Controls.Add(this._fesOuterShadowAngle);
            this._grpOuterShadow.Controls.Add(this._comboOuterShadowBlendMode);
            this._grpOuterShadow.Controls.Add(this._colOuterShadowColor);
            resources.ApplyResources(this._grpOuterShadow, "_grpOuterShadow");
            this._grpOuterShadow.Name = "_grpOuterShadow";
            this._grpOuterShadow.TabStop = false;
            //
            // _comboOuterShadowType
            //
            this._comboOuterShadowType.FormattingEnabled = true;
            this._comboOuterShadowType.Items.AddRange(new object[] {
            resources.GetString("_comboOuterShadowType.Items"),
            resources.GetString("_comboOuterShadowType.Items1"),
            resources.GetString("_comboOuterShadowType.Items2")});
            resources.ApplyResources(this._comboOuterShadowType, "_comboOuterShadowType");
            this._comboOuterShadowType.Name = "_comboOuterShadowType";
            this._comboOuterShadowType.SelectedItemData = null;
            this._comboOuterShadowType.SelectedIndexChanged += new System.EventHandler(this.Event_comboOuterShadowAttenuationType_SelectedIndexChanged);
            //
            // _lblOuterShadowType
            //
            resources.ApplyResources(this._lblOuterShadowType, "_lblOuterShadowType");
            this._lblOuterShadowType.Name = "_lblOuterShadowType";
            this._lblOuterShadowType.UseAnimationMark = false;
            this._lblOuterShadowType.UseContextMenu = false;
            //
            // _lblOuterShadowSize
            //
            resources.ApplyResources(this._lblOuterShadowSize, "_lblOuterShadowSize");
            this._lblOuterShadowSize.Name = "_lblOuterShadowSize";
            this._lblOuterShadowSize.UseAnimationMark = true;
            this._lblOuterShadowSize.UseContextMenu = true;
            //
            // _lblOuterShadowDistance
            //
            resources.ApplyResources(this._lblOuterShadowDistance, "_lblOuterShadowDistance");
            this._lblOuterShadowDistance.Name = "_lblOuterShadowDistance";
            this._lblOuterShadowDistance.UseAnimationMark = true;
            this._lblOuterShadowDistance.UseContextMenu = true;
            //
            // _lblOuterShadowAngle
            //
            resources.ApplyResources(this._lblOuterShadowAngle, "_lblOuterShadowAngle");
            this._lblOuterShadowAngle.Name = "_lblOuterShadowAngle";
            this._lblOuterShadowAngle.UseAnimationMark = true;
            this._lblOuterShadowAngle.UseContextMenu = true;
            //
            // _lblOuterShadowBlendMode
            //
            resources.ApplyResources(this._lblOuterShadowBlendMode, "_lblOuterShadowBlendMode");
            this._lblOuterShadowBlendMode.Name = "_lblOuterShadowBlendMode";
            this._lblOuterShadowBlendMode.UseAnimationMark = false;
            this._lblOuterShadowBlendMode.UseContextMenu = false;
            //
            // _lblOuterShadowColor
            //
            resources.ApplyResources(this._lblOuterShadowColor, "_lblOuterShadowColor");
            this._lblOuterShadowColor.Name = "_lblOuterShadowColor";
            this._lblOuterShadowColor.UseAnimationMark = true;
            this._lblOuterShadowColor.UseContextMenu = true;
            //
            // _fesOuterShadowSize
            //
            resources.ApplyResources(this._fesOuterShadowSize, "_fesOuterShadowSize");
            this._fesOuterShadowSize.Format = "f2";
            this._fesOuterShadowSize.MaxValue = 100F;
            this._fesOuterShadowSize.MinValue = 0F;
            this._fesOuterShadowSize.Name = "_fesOuterShadowSize";
            this._fesOuterShadowSize.RangeLabelFormat = "f2";
            this._fesOuterShadowSize.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesOuterShadowSize.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesOuterShadowSize.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesOuterShadowSize.TrackBarLargeChange = 0F;
            this._fesOuterShadowSize.TrackBarPrecision = 100;
            this._fesOuterShadowSize.TrackBarSmallChange = 0F;
            this._fesOuterShadowSize.UseAnimationMark = true;
            this._fesOuterShadowSize.Value = 5F;
            this._fesOuterShadowSize.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesOuterShadowSize_ValueEdit);
            //
            // _fesOuterShadowDistance
            //
            resources.ApplyResources(this._fesOuterShadowDistance, "_fesOuterShadowDistance");
            this._fesOuterShadowDistance.Format = "f2";
            this._fesOuterShadowDistance.MaxValue = 100F;
            this._fesOuterShadowDistance.MinValue = 0F;
            this._fesOuterShadowDistance.Name = "_fesOuterShadowDistance";
            this._fesOuterShadowDistance.RangeLabelFormat = "f2";
            this._fesOuterShadowDistance.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesOuterShadowDistance.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesOuterShadowDistance.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesOuterShadowDistance.TrackBarLargeChange = 0F;
            this._fesOuterShadowDistance.TrackBarPrecision = 100;
            this._fesOuterShadowDistance.TrackBarSmallChange = 0F;
            this._fesOuterShadowDistance.UseAnimationMark = true;
            this._fesOuterShadowDistance.Value = 5F;
            this._fesOuterShadowDistance.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesOuterShadowDistance_ValueEdit);
            //
            // _fesOuterShadowAngle
            //
            resources.ApplyResources(this._fesOuterShadowAngle, "_fesOuterShadowAngle");
            this._fesOuterShadowAngle.Format = "f2";
            this._fesOuterShadowAngle.MaxValue = 360F;
            this._fesOuterShadowAngle.MinValue = 0F;
            this._fesOuterShadowAngle.Name = "_fesOuterShadowAngle";
            this._fesOuterShadowAngle.RangeLabelFormat = "f2";
            this._fesOuterShadowAngle.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesOuterShadowAngle.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesOuterShadowAngle.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesOuterShadowAngle.TrackBarLargeChange = 0F;
            this._fesOuterShadowAngle.TrackBarPrecision = 100;
            this._fesOuterShadowAngle.TrackBarSmallChange = 0F;
            this._fesOuterShadowAngle.UseAnimationMark = true;
            this._fesOuterShadowAngle.Value = 120F;
            this._fesOuterShadowAngle.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesOuterShadowAngle_ValueEdit);
            //
            // _comboOuterShadowBlendMode
            //
            this._comboOuterShadowBlendMode.FormattingEnabled = true;
            this._comboOuterShadowBlendMode.Items.AddRange(new object[] {
            resources.GetString("_comboOuterShadowBlendMode.Items"),
            resources.GetString("_comboOuterShadowBlendMode.Items1"),
            resources.GetString("_comboOuterShadowBlendMode.Items2"),
            resources.GetString("_comboOuterShadowBlendMode.Items3")});
            resources.ApplyResources(this._comboOuterShadowBlendMode, "_comboOuterShadowBlendMode");
            this._comboOuterShadowBlendMode.Name = "_comboOuterShadowBlendMode";
            this._comboOuterShadowBlendMode.SelectedItemData = null;
            this._comboOuterShadowBlendMode.SelectedIndexChanged += new System.EventHandler(this.Event_comboOuterShadowBlendMode_SelectedIndexChanged);
            //
            // _colOuterShadowColor
            //
            this._colOuterShadowColor.AllowDrop = true;
            resources.ApplyResources(this._colOuterShadowColor, "_colOuterShadowColor");
            this._colOuterShadowColor.Name = "_colOuterShadowColor";
            this._colOuterShadowColor.Tag = "";
            this._colOuterShadowColor.UseAnimationMark = true;
            this._colOuterShadowColor.ColorEdit += new LayoutEditor.Controls.ColorEditEventHandler(this.Event_colOuterShadowColor_ColorEdit);
            //
            // _chkGradationOverlayEnabled
            //
            resources.ApplyResources(this._chkGradationOverlayEnabled, "_chkGradationOverlayEnabled");
            this._chkGradationOverlayEnabled.Name = "_chkGradationOverlayEnabled";
            this._chkGradationOverlayEnabled.CheckedChanged += new System.EventHandler(this.Event_chkGradationOverlayEnabled_CheckedChanged);
            //
            // _grpGradationOverlay
            //
            this._grpGradationOverlay.Controls.Add(this._lblControlPointCount);
            this._grpGradationOverlay.Controls.Add(this._numControlPointCount);
            this._grpGradationOverlay.Controls.Add(this._lblGradationOverlayAngle);
            this._grpGradationOverlay.Controls.Add(this._fesGradationOverlayAngle);
            this._grpGradationOverlay.Controls.Add(this._grpGradationOverlayControl3);
            this._grpGradationOverlay.Controls.Add(this._grpGradationOverlayControl2);
            this._grpGradationOverlay.Controls.Add(this._grpGradationOverlayControl1);
            this._grpGradationOverlay.Controls.Add(this._grpGradationOverlayControl0);
            this._grpGradationOverlay.Controls.Add(this._lblGradationOverlayBlendMode);
            this._grpGradationOverlay.Controls.Add(this._comboGradationOverlayBlendMode);
            resources.ApplyResources(this._grpGradationOverlay, "_grpGradationOverlay");
            this._grpGradationOverlay.Name = "_grpGradationOverlay";
            this._grpGradationOverlay.TabStop = false;
            //
            // _lblControlPointCount
            //
            resources.ApplyResources(this._lblControlPointCount, "_lblControlPointCount");
            this._lblControlPointCount.Name = "_lblControlPointCount";
            //
            // _numControlPointCount
            //
            resources.ApplyResources(this._numControlPointCount, "_numControlPointCount");
            this._numControlPointCount.Maximum = new decimal(new int[] {
            4,
            0,
            0,
            0});
            this._numControlPointCount.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this._numControlPointCount.Name = "_numControlPointCount";
            this._numControlPointCount.Value = new decimal(new int[] {
            4,
            0,
            0,
            0});
            this._numControlPointCount.ValueChanged += new System.EventHandler(this.Event_numControlPointCount_ValueChanged);
            //
            // _lblGradationOverlayAngle
            //
            resources.ApplyResources(this._lblGradationOverlayAngle, "_lblGradationOverlayAngle");
            this._lblGradationOverlayAngle.Name = "_lblGradationOverlayAngle";
            this._lblGradationOverlayAngle.UseAnimationMark = true;
            this._lblGradationOverlayAngle.UseContextMenu = true;
            //
            // _fesGradationOverlayAngle
            //
            resources.ApplyResources(this._fesGradationOverlayAngle, "_fesGradationOverlayAngle");
            this._fesGradationOverlayAngle.Format = "f2";
            this._fesGradationOverlayAngle.MaxValue = 360F;
            this._fesGradationOverlayAngle.MinValue = 0F;
            this._fesGradationOverlayAngle.Name = "_fesGradationOverlayAngle";
            this._fesGradationOverlayAngle.RangeLabelFormat = "f2";
            this._fesGradationOverlayAngle.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesGradationOverlayAngle.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size56;
            this._fesGradationOverlayAngle.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesGradationOverlayAngle.TrackBarLargeChange = 0F;
            this._fesGradationOverlayAngle.TrackBarPrecision = 100;
            this._fesGradationOverlayAngle.TrackBarSmallChange = 0F;
            this._fesGradationOverlayAngle.UseAnimationMark = true;
            this._fesGradationOverlayAngle.Value = 120F;
            this._fesGradationOverlayAngle.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesGradationOverlayAngle_ValueEdit);
            //
            // _grpGradationOverlayControl3
            //
            this._grpGradationOverlayControl3.Controls.Add(this._lblGradationOverlayControlPoint3);
            this._grpGradationOverlayControl3.Controls.Add(this._fesGradationOverlayControlPoint3);
            this._grpGradationOverlayControl3.Controls.Add(this._lblGradationOverlayColor3);
            this._grpGradationOverlayControl3.Controls.Add(this._colGradationOverlayColor3);
            resources.ApplyResources(this._grpGradationOverlayControl3, "_grpGradationOverlayControl3");
            this._grpGradationOverlayControl3.Name = "_grpGradationOverlayControl3";
            this._grpGradationOverlayControl3.TabStop = false;
            //
            // _lblGradationOverlayControlPoint3
            //
            resources.ApplyResources(this._lblGradationOverlayControlPoint3, "_lblGradationOverlayControlPoint3");
            this._lblGradationOverlayControlPoint3.Name = "_lblGradationOverlayControlPoint3";
            this._lblGradationOverlayControlPoint3.UseAnimationMark = true;
            this._lblGradationOverlayControlPoint3.UseContextMenu = true;
            //
            // _fesGradationOverlayControlPoint3
            //
            resources.ApplyResources(this._fesGradationOverlayControlPoint3, "_fesGradationOverlayControlPoint3");
            this._fesGradationOverlayControlPoint3.Format = "f2";
            this._fesGradationOverlayControlPoint3.MaxValue = 1F;
            this._fesGradationOverlayControlPoint3.MinValue = 0F;
            this._fesGradationOverlayControlPoint3.Name = "_fesGradationOverlayControlPoint3";
            this._fesGradationOverlayControlPoint3.RangeLabelFormat = "f2";
            this._fesGradationOverlayControlPoint3.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesGradationOverlayControlPoint3.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size48;
            this._fesGradationOverlayControlPoint3.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesGradationOverlayControlPoint3.TrackBarLargeChange = 0F;
            this._fesGradationOverlayControlPoint3.TrackBarPrecision = 100;
            this._fesGradationOverlayControlPoint3.TrackBarSmallChange = 0F;
            this._fesGradationOverlayControlPoint3.UseAnimationMark = true;
            this._fesGradationOverlayControlPoint3.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesGradationOverlayControlPoint3_ValueEdit);
            //
            // _lblGradationOverlayColor3
            //
            resources.ApplyResources(this._lblGradationOverlayColor3, "_lblGradationOverlayColor3");
            this._lblGradationOverlayColor3.Name = "_lblGradationOverlayColor3";
            this._lblGradationOverlayColor3.UseAnimationMark = true;
            this._lblGradationOverlayColor3.UseContextMenu = true;
            //
            // _colGradationOverlayColor3
            //
            this._colGradationOverlayColor3.AllowDrop = true;
            resources.ApplyResources(this._colGradationOverlayColor3, "_colGradationOverlayColor3");
            this._colGradationOverlayColor3.Name = "_colGradationOverlayColor3";
            this._colGradationOverlayColor3.Tag = "";
            this._colGradationOverlayColor3.UseAnimationMark = true;
            this._colGradationOverlayColor3.ColorEdit += new LayoutEditor.Controls.ColorEditEventHandler(this.Event_colGradationOverlayColor3_ColorEdit);
            //
            // _grpGradationOverlayControl2
            //
            this._grpGradationOverlayControl2.Controls.Add(this._lblGradationOverlayControlPoint2);
            this._grpGradationOverlayControl2.Controls.Add(this._fesGradationOverlayControlPoint2);
            this._grpGradationOverlayControl2.Controls.Add(this._lblGradationOverlayColor2);
            this._grpGradationOverlayControl2.Controls.Add(this._colGradationOverlayColor2);
            resources.ApplyResources(this._grpGradationOverlayControl2, "_grpGradationOverlayControl2");
            this._grpGradationOverlayControl2.Name = "_grpGradationOverlayControl2";
            this._grpGradationOverlayControl2.TabStop = false;
            //
            // _lblGradationOverlayControlPoint2
            //
            resources.ApplyResources(this._lblGradationOverlayControlPoint2, "_lblGradationOverlayControlPoint2");
            this._lblGradationOverlayControlPoint2.Name = "_lblGradationOverlayControlPoint2";
            this._lblGradationOverlayControlPoint2.UseAnimationMark = true;
            this._lblGradationOverlayControlPoint2.UseContextMenu = true;
            //
            // _fesGradationOverlayControlPoint2
            //
            resources.ApplyResources(this._fesGradationOverlayControlPoint2, "_fesGradationOverlayControlPoint2");
            this._fesGradationOverlayControlPoint2.Format = "f2";
            this._fesGradationOverlayControlPoint2.MaxValue = 1F;
            this._fesGradationOverlayControlPoint2.MinValue = 0F;
            this._fesGradationOverlayControlPoint2.Name = "_fesGradationOverlayControlPoint2";
            this._fesGradationOverlayControlPoint2.RangeLabelFormat = "f2";
            this._fesGradationOverlayControlPoint2.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesGradationOverlayControlPoint2.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size48;
            this._fesGradationOverlayControlPoint2.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesGradationOverlayControlPoint2.TrackBarLargeChange = 0F;
            this._fesGradationOverlayControlPoint2.TrackBarPrecision = 100;
            this._fesGradationOverlayControlPoint2.TrackBarSmallChange = 0F;
            this._fesGradationOverlayControlPoint2.UseAnimationMark = true;
            this._fesGradationOverlayControlPoint2.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesGradationOverlayControlPoint2_ValueEdit);
            //
            // _lblGradationOverlayColor2
            //
            resources.ApplyResources(this._lblGradationOverlayColor2, "_lblGradationOverlayColor2");
            this._lblGradationOverlayColor2.Name = "_lblGradationOverlayColor2";
            this._lblGradationOverlayColor2.UseAnimationMark = true;
            this._lblGradationOverlayColor2.UseContextMenu = true;
            //
            // _colGradationOverlayColor2
            //
            this._colGradationOverlayColor2.AllowDrop = true;
            resources.ApplyResources(this._colGradationOverlayColor2, "_colGradationOverlayColor2");
            this._colGradationOverlayColor2.Name = "_colGradationOverlayColor2";
            this._colGradationOverlayColor2.Tag = "";
            this._colGradationOverlayColor2.UseAnimationMark = true;
            this._colGradationOverlayColor2.ColorEdit += new LayoutEditor.Controls.ColorEditEventHandler(this.Event_colGradationOverlayColor2_ColorEdit);
            //
            // _grpGradationOverlayControl1
            //
            this._grpGradationOverlayControl1.Controls.Add(this._lblGradationOverlayControlPoint1);
            this._grpGradationOverlayControl1.Controls.Add(this._fesGradationOverlayControlPoint1);
            this._grpGradationOverlayControl1.Controls.Add(this._lblGradationOverlayColor1);
            this._grpGradationOverlayControl1.Controls.Add(this._colGradationOverlayColor1);
            resources.ApplyResources(this._grpGradationOverlayControl1, "_grpGradationOverlayControl1");
            this._grpGradationOverlayControl1.Name = "_grpGradationOverlayControl1";
            this._grpGradationOverlayControl1.TabStop = false;
            //
            // _lblGradationOverlayControlPoint1
            //
            resources.ApplyResources(this._lblGradationOverlayControlPoint1, "_lblGradationOverlayControlPoint1");
            this._lblGradationOverlayControlPoint1.Name = "_lblGradationOverlayControlPoint1";
            this._lblGradationOverlayControlPoint1.UseAnimationMark = true;
            this._lblGradationOverlayControlPoint1.UseContextMenu = true;
            //
            // _fesGradationOverlayControlPoint1
            //
            resources.ApplyResources(this._fesGradationOverlayControlPoint1, "_fesGradationOverlayControlPoint1");
            this._fesGradationOverlayControlPoint1.Format = "f2";
            this._fesGradationOverlayControlPoint1.MaxValue = 1F;
            this._fesGradationOverlayControlPoint1.MinValue = 0F;
            this._fesGradationOverlayControlPoint1.Name = "_fesGradationOverlayControlPoint1";
            this._fesGradationOverlayControlPoint1.RangeLabelFormat = "f2";
            this._fesGradationOverlayControlPoint1.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesGradationOverlayControlPoint1.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size48;
            this._fesGradationOverlayControlPoint1.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesGradationOverlayControlPoint1.TrackBarLargeChange = 0F;
            this._fesGradationOverlayControlPoint1.TrackBarPrecision = 100;
            this._fesGradationOverlayControlPoint1.TrackBarSmallChange = 0F;
            this._fesGradationOverlayControlPoint1.UseAnimationMark = true;
            this._fesGradationOverlayControlPoint1.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesGradationOverlayControlPoint1_ValueEdit);
            //
            // _lblGradationOverlayColor1
            //
            resources.ApplyResources(this._lblGradationOverlayColor1, "_lblGradationOverlayColor1");
            this._lblGradationOverlayColor1.Name = "_lblGradationOverlayColor1";
            this._lblGradationOverlayColor1.UseAnimationMark = true;
            this._lblGradationOverlayColor1.UseContextMenu = true;
            //
            // _colGradationOverlayColor1
            //
            this._colGradationOverlayColor1.AllowDrop = true;
            resources.ApplyResources(this._colGradationOverlayColor1, "_colGradationOverlayColor1");
            this._colGradationOverlayColor1.Name = "_colGradationOverlayColor1";
            this._colGradationOverlayColor1.Tag = "";
            this._colGradationOverlayColor1.UseAnimationMark = true;
            this._colGradationOverlayColor1.ColorEdit += new LayoutEditor.Controls.ColorEditEventHandler(this.Event_colGradationOverlayColor1_ColorEdit);
            //
            // _grpGradationOverlayControl0
            //
            this._grpGradationOverlayControl0.Controls.Add(this._lblGradationOverlayControlPoint0);
            this._grpGradationOverlayControl0.Controls.Add(this._fesGradationOverlayControlPoint0);
            this._grpGradationOverlayControl0.Controls.Add(this._lblGradationOverlayColor0);
            this._grpGradationOverlayControl0.Controls.Add(this._colGradationOverlayColor0);
            resources.ApplyResources(this._grpGradationOverlayControl0, "_grpGradationOverlayControl0");
            this._grpGradationOverlayControl0.Name = "_grpGradationOverlayControl0";
            this._grpGradationOverlayControl0.TabStop = false;
            //
            // _lblGradationOverlayControlPoint0
            //
            resources.ApplyResources(this._lblGradationOverlayControlPoint0, "_lblGradationOverlayControlPoint0");
            this._lblGradationOverlayControlPoint0.Name = "_lblGradationOverlayControlPoint0";
            this._lblGradationOverlayControlPoint0.UseAnimationMark = true;
            this._lblGradationOverlayControlPoint0.UseContextMenu = true;
            //
            // _fesGradationOverlayControlPoint0
            //
            resources.ApplyResources(this._fesGradationOverlayControlPoint0, "_fesGradationOverlayControlPoint0");
            this._fesGradationOverlayControlPoint0.Format = "f2";
            this._fesGradationOverlayControlPoint0.MaxValue = 1F;
            this._fesGradationOverlayControlPoint0.MinValue = 0F;
            this._fesGradationOverlayControlPoint0.Name = "_fesGradationOverlayControlPoint0";
            this._fesGradationOverlayControlPoint0.RangeLabelFormat = "f2";
            this._fesGradationOverlayControlPoint0.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._fesGradationOverlayControlPoint0.TextBoxSize = LayoutEditor.Controls.EditSliderTextBoxSize.Size48;
            this._fesGradationOverlayControlPoint0.TextBoxTextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this._fesGradationOverlayControlPoint0.TrackBarLargeChange = 0F;
            this._fesGradationOverlayControlPoint0.TrackBarPrecision = 100;
            this._fesGradationOverlayControlPoint0.TrackBarSmallChange = 0F;
            this._fesGradationOverlayControlPoint0.UseAnimationMark = true;
            this._fesGradationOverlayControlPoint0.ValueEdit += new LayoutEditor.Controls.ValueEditEventHandler(this.Event_fesGradationOverlayControlPoint0_ValueEdit);
            //
            // _lblGradationOverlayColor0
            //
            resources.ApplyResources(this._lblGradationOverlayColor0, "_lblGradationOverlayColor0");
            this._lblGradationOverlayColor0.Name = "_lblGradationOverlayColor0";
            this._lblGradationOverlayColor0.UseAnimationMark = true;
            this._lblGradationOverlayColor0.UseContextMenu = true;
            //
            // _colGradationOverlayColor0
            //
            this._colGradationOverlayColor0.AllowDrop = true;
            resources.ApplyResources(this._colGradationOverlayColor0, "_colGradationOverlayColor0");
            this._colGradationOverlayColor0.Name = "_colGradationOverlayColor0";
            this._colGradationOverlayColor0.Tag = "";
            this._colGradationOverlayColor0.UseAnimationMark = true;
            this._colGradationOverlayColor0.ColorEdit += new LayoutEditor.Controls.ColorEditEventHandler(this.Event_colGradationOverlayColor0_ColorEdit);
            //
            // _lblGradationOverlayBlendMode
            //
            resources.ApplyResources(this._lblGradationOverlayBlendMode, "_lblGradationOverlayBlendMode");
            this._lblGradationOverlayBlendMode.Name = "_lblGradationOverlayBlendMode";
            this._lblGradationOverlayBlendMode.UseAnimationMark = false;
            this._lblGradationOverlayBlendMode.UseContextMenu = false;
            //
            // _comboGradationOverlayBlendMode
            //
            this._comboGradationOverlayBlendMode.FormattingEnabled = true;
            this._comboGradationOverlayBlendMode.Items.AddRange(new object[] {
            resources.GetString("_comboGradationOverlayBlendMode.Items"),
            resources.GetString("_comboGradationOverlayBlendMode.Items1"),
            resources.GetString("_comboGradationOverlayBlendMode.Items2"),
            resources.GetString("_comboGradationOverlayBlendMode.Items3")});
            resources.ApplyResources(this._comboGradationOverlayBlendMode, "_comboGradationOverlayBlendMode");
            this._comboGradationOverlayBlendMode.Name = "_comboGradationOverlayBlendMode";
            this._comboGradationOverlayBlendMode.SelectedItemData = null;
            this._comboGradationOverlayBlendMode.SelectedIndexChanged += new System.EventHandler(this.Event_comboGradationOverlayBlendMode_SelectedIndexChanged);
            //
            // PropWndPaneProceduralShapePage
            //
            this.Controls.Add(this._grpGradationOverlay);
            this.Controls.Add(this._chkGradationOverlayEnabled);
            this.Controls.Add(this._chkOuterShadowEnabled);
            this.Controls.Add(this._grpOuterShadow);
            this.Controls.Add(this._chkColorOverlayEnabled);
            this.Controls.Add(this._grpColorOverlay);
            this.Controls.Add(this._chkInnerShadowEnabled);
            this.Controls.Add(this._grpInnerShadow);
            this.Controls.Add(this._grpProceduralShape);
            this.Controls.Add(this._chkProceduralShapeEnabled);
            this.Controls.Add(this._chkStrokeEnabled);
            this.Controls.Add(this._grpStroke);
            this.Name = "PropWndPaneProceduralShapePage";
            resources.ApplyResources(this, "$this");
            ((System.ComponentModel.ISupportInitialize)(this._erpPaneNameChange)).EndInit();
            this._grpStroke.ResumeLayout(false);
            this._grpStroke.PerformLayout();
            this._grpProceduralShape.ResumeLayout(false);
            this._grpProceduralShape.PerformLayout();
            this._grpInnerShadow.ResumeLayout(false);
            this._grpInnerShadow.PerformLayout();
            this._grpColorOverlay.ResumeLayout(false);
            this._grpColorOverlay.PerformLayout();
            this._grpOuterShadow.ResumeLayout(false);
            this._grpOuterShadow.PerformLayout();
            this._grpGradationOverlay.ResumeLayout(false);
            this._grpGradationOverlay.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this._numControlPointCount)).EndInit();
            this._grpGradationOverlayControl3.ResumeLayout(false);
            this._grpGradationOverlayControl3.PerformLayout();
            this._grpGradationOverlayControl2.ResumeLayout(false);
            this._grpGradationOverlayControl2.PerformLayout();
            this._grpGradationOverlayControl1.ResumeLayout(false);
            this._grpGradationOverlayControl1.PerformLayout();
            this._grpGradationOverlayControl0.ResumeLayout(false);
            this._grpGradationOverlayControl0.PerformLayout();
            this.ResumeLayout(false);

        }

        #endregion デザイナ生成コード

        #region ----------- プロパティ

        #endregion ----------- プロパティ

        #region ----------- 非公開プロパティ

        ProceduralShapeManipulator _TargetProceduralShapeMpn
        {
            get
            {
                return Target.Active.ProceduralShapeManipulator;
            }
        }

        // 値を更新中かどうか
        bool SettingDataToGUIControl = false;

        #endregion ----------- 非公開プロパティ

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        protected override void InitializeProperty()
        {
            // ViewManagerへのメッセージハンドラを設定します
            _fesProceduralShapeExp.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesProceduralShapeRadius.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);

            _fesStrokeSize.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _colStrokeColor.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);

            _colInnerShadowColor.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesInnerShadowAngle.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesInnerShadowDistance.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesInnerShadowSize.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);

            _colColorOverlayColor.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);

            _colGradationOverlayColor0.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _colGradationOverlayColor1.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _colGradationOverlayColor2.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _colGradationOverlayColor3.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesGradationOverlayControlPoint0.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesGradationOverlayControlPoint1.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesGradationOverlayControlPoint2.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesGradationOverlayControlPoint3.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesGradationOverlayAngle.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);

            _colOuterShadowColor.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesOuterShadowAngle.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesOuterShadowDistance.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            _fesOuterShadowSize.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
        }

        /// <summary>
        /// GUIの値を更新します。
        /// </summary>
        protected override void UpdateProperty()
        {
            if (_TargetProceduralShapeMpn == null)
            {
                return;
            }

            Debug.Assert(!SettingDataToGUIControl);
            SettingDataToGUIControl = true;

            // ターゲットを参照してUIを更新する
            IProceduralShape srcProceduralShape = _TargetProceduralShapeMpn.IProceduralShape;

            _fesProceduralShapeExp.SetTargetAttribute(srcProceduralShape.IExpAttr);
            _fesProceduralShapeRadius.SetTargetAttribute(srcProceduralShape.IRadiusAttr);

            _fesStrokeSize.SetTargetAttribute(srcProceduralShape.IInnerStrokeSizeAttr);
            _colStrokeColor.SetTargetAttribute(srcProceduralShape.IInnerStrokeColorAttr);

            _colInnerShadowColor.SetTargetAttribute(srcProceduralShape.IInnerShadowColorAttr);
            _fesInnerShadowAngle.SetTargetAttribute(srcProceduralShape.IInnerShadowAngleAttr);
            _fesInnerShadowDistance.SetTargetAttribute(srcProceduralShape.IInnerShadowDistanceAttr);
            _fesInnerShadowSize.SetTargetAttribute(srcProceduralShape.IInnerShadowSizeAttr);

            _colColorOverlayColor.SetTargetAttribute(srcProceduralShape.IColorOverlayColorAttr);

            _fesGradationOverlayControlPoint0.SetTargetAttribute(srcProceduralShape.IGradationOverlayControlPointAttrArray[0]);
            _fesGradationOverlayControlPoint1.SetTargetAttribute(srcProceduralShape.IGradationOverlayControlPointAttrArray[1]);
            _fesGradationOverlayControlPoint2.SetTargetAttribute(srcProceduralShape.IGradationOverlayControlPointAttrArray[2]);
            _fesGradationOverlayControlPoint3.SetTargetAttribute(srcProceduralShape.IGradationOverlayControlPointAttrArray[3]);

            _colGradationOverlayColor0.SetTargetAttribute(srcProceduralShape.IGradationOverlayColorAttrArray[0]);
            _colGradationOverlayColor1.SetTargetAttribute(srcProceduralShape.IGradationOverlayColorAttrArray[1]);
            _colGradationOverlayColor2.SetTargetAttribute(srcProceduralShape.IGradationOverlayColorAttrArray[2]);
            _colGradationOverlayColor3.SetTargetAttribute(srcProceduralShape.IGradationOverlayColorAttrArray[3]);

            _fesGradationOverlayAngle.SetTargetAttribute(srcProceduralShape.IGradationOverlayAngleAttr);

            _colOuterShadowColor.SetTargetAttribute(srcProceduralShape.IOuterShadowColorAttr);
            _fesOuterShadowAngle.SetTargetAttribute(srcProceduralShape.IOuterShadowAngleAttr);
            _fesOuterShadowDistance.SetTargetAttribute(srcProceduralShape.IOuterShadowDistanceAttr);
            _fesOuterShadowSize.SetTargetAttribute(srcProceduralShape.IOuterShadowSizeAttr);

            // 角丸
            _grpProceduralShape.Visible = srcProceduralShape.IsProceduralShapeEnabled;

            _chkProceduralShapeEnabled.SetChecked(srcProceduralShape.IsProceduralShapeEnabled);
            _fesProceduralShapeExp.SetValue(srcProceduralShape.Exp);
            _fesProceduralShapeRadius.SetValue(srcProceduralShape.Radius);

            // 境界線
            _chkStrokeEnabled.Enabled = srcProceduralShape.IsProceduralShapeEnabled;
            _grpStroke.Visible = srcProceduralShape.IsInnerStrokeEnabled;

            _chkStrokeEnabled.SetChecked(srcProceduralShape.IsInnerStrokeEnabled);
            _fesStrokeSize.SetValue(srcProceduralShape.InnerStrokeSize);
            _comboStrokeBlendMode.SetSelectedIndex((int)srcProceduralShape.InnerStrokeBlendMode);
            _colStrokeColor.Color = new FloatColor(srcProceduralShape.InnerStrokeColor);
            _colStrokeColor.Refresh();

            // ドロップシャドウ(内側)
            _chkInnerShadowEnabled.Enabled = srcProceduralShape.IsProceduralShapeEnabled;
            _grpInnerShadow.Visible = srcProceduralShape.IsInnerShadowEnabled;

            _chkInnerShadowEnabled.SetChecked(srcProceduralShape.IsInnerShadowEnabled);
            _comboInnerShadowBlendMode.SetSelectedIndex((int)srcProceduralShape.InnerShadowBlendMode);
            _colInnerShadowColor.Color = new FloatColor(srcProceduralShape.InnerShadowColor);
            _colInnerShadowColor.Refresh();
            _fesInnerShadowAngle.SetValue(srcProceduralShape.InnerShadowAngle);
            _fesInnerShadowDistance.SetValue(srcProceduralShape.InnerShadowDistance);
            _fesInnerShadowSize.SetValue(srcProceduralShape.InnerShadowSize);
            _comboInnerShadowType.SetSelectedIndex((int)srcProceduralShape.InnerShadowType);

            // カラーオーバーレイ
            _chkColorOverlayEnabled.Enabled = srcProceduralShape.IsProceduralShapeEnabled;
            _grpColorOverlay.Visible = srcProceduralShape.IsColorOverayEnabled;

            _chkColorOverlayEnabled.SetChecked(srcProceduralShape.IsColorOverayEnabled);
            _comboColorOverlayBlendMode.SetSelectedIndex((int)srcProceduralShape.ColorOverlayBlendMode);
            _colColorOverlayColor.Color = new FloatColor(srcProceduralShape.ColorOverlayColor);
            _colInnerShadowColor.Refresh();

            // グラデーションオーバーレイ
            _chkGradationOverlayEnabled.Enabled = srcProceduralShape.IsProceduralShapeEnabled;
            _grpGradationOverlay.Visible = srcProceduralShape.IsGradationOverayEnabled;

            _numControlPointCount.Value = srcProceduralShape.GradationOverlayControlPointCount;

            _chkGradationOverlayEnabled.SetChecked(srcProceduralShape.IsGradationOverayEnabled);
            _comboGradationOverlayBlendMode.SetSelectedIndex((int)srcProceduralShape.GradationOverlayBlendMode);
            _fesGradationOverlayControlPoint0.SetValue(srcProceduralShape.GetGradationOverlayControlPoint(0));
            _fesGradationOverlayControlPoint1.SetValue(srcProceduralShape.GetGradationOverlayControlPoint(1));
            _fesGradationOverlayControlPoint2.SetValue(srcProceduralShape.GetGradationOverlayControlPoint(2));
            _fesGradationOverlayControlPoint3.SetValue(srcProceduralShape.GetGradationOverlayControlPoint(3));
            _colGradationOverlayColor0.Color = new FloatColor(srcProceduralShape.GetGradationOverlayColor(0));
            _colGradationOverlayColor0.Refresh();

            _grpGradationOverlayControl1.Enabled = srcProceduralShape.GradationOverlayControlPointCount >= 2;
            _colGradationOverlayColor1.Color = new FloatColor(srcProceduralShape.GetGradationOverlayColor(1));
            _colGradationOverlayColor1.Refresh();

            _grpGradationOverlayControl2.Enabled = srcProceduralShape.GradationOverlayControlPointCount >= 3;
            _colGradationOverlayColor2.Color = new FloatColor(srcProceduralShape.GetGradationOverlayColor(2));
            _colGradationOverlayColor2.Refresh();

            _grpGradationOverlayControl3.Enabled = srcProceduralShape.GradationOverlayControlPointCount >= 4;
            _colGradationOverlayColor3.Color = new FloatColor(srcProceduralShape.GetGradationOverlayColor(3));
            _colGradationOverlayColor3.Refresh();
            _fesGradationOverlayAngle.SetValue(srcProceduralShape.GradationOverlayAngle);

            // ドロップシャドウ(外側)
            _chkOuterShadowEnabled.Enabled = false;// srcProceduralShape.IsProceduralShapeEnabled;
            _grpOuterShadow.Visible = srcProceduralShape.IsOuterShadowEnabled;

            _chkOuterShadowEnabled.SetChecked(srcProceduralShape.IsOuterShadowEnabled);
            _comboOuterShadowBlendMode.SetSelectedIndex((int)srcProceduralShape.OuterShadowBlendMode);
            _colOuterShadowColor.Color = new FloatColor(srcProceduralShape.OuterShadowColor);
            _colOuterShadowColor.Refresh();
            _fesOuterShadowAngle.SetValue(srcProceduralShape.OuterShadowAngle);
            _fesOuterShadowDistance.SetValue(srcProceduralShape.OuterShadowDistance);
            _fesOuterShadowSize.SetValue(srcProceduralShape.OuterShadowSize);
            _comboOuterShadowType.SetSelectedIndex((int)srcProceduralShape.OuterShadowType);

            SettingDataToGUIControl = false;

            UpdateAnimationMark();
        }

        // コンストラクタ
        public PropWndPaneProceduralShapePage()
        {
            InitializeComponent();

            // アニメーションマークを関連付ける
            _lblProceduralShapeExp.BindAnimationMark(_fesProceduralShapeExp.AnimationMarkInst);
            _lblProceduralShapeRadius.BindAnimationMark(_fesProceduralShapeRadius.AnimationMarkInst);

            // ラベルにコンテキストメニューを追加する
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblStrokeColor, _colStrokeColor.AnimationMarkArray);
            _lblStrokeSize.BindAnimationMark(_fesStrokeSize.AnimationMarkInst);

            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblInnerShadowColor, _colInnerShadowColor.AnimationMarkArray);
            _lblInnerShadowAngle.BindAnimationMark(_fesInnerShadowAngle.AnimationMarkInst);
            _lblInnerShadowDistance.BindAnimationMark(_fesInnerShadowDistance.AnimationMarkInst);
            _lblInnerShadowSize.BindAnimationMark(_fesInnerShadowSize.AnimationMarkInst);

            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblColorOverlayColor, _colColorOverlayColor.AnimationMarkArray);

            _lblGradationOverlayControlPoint0.BindAnimationMark(_fesGradationOverlayControlPoint0.AnimationMarkInst);
            _lblGradationOverlayControlPoint1.BindAnimationMark(_fesGradationOverlayControlPoint1.AnimationMarkInst);
            _lblGradationOverlayControlPoint2.BindAnimationMark(_fesGradationOverlayControlPoint2.AnimationMarkInst);
            _lblGradationOverlayControlPoint3.BindAnimationMark(_fesGradationOverlayControlPoint3.AnimationMarkInst);
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblGradationOverlayColor0, _colGradationOverlayColor0.AnimationMarkArray);
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblGradationOverlayColor1, _colGradationOverlayColor1.AnimationMarkArray);
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblGradationOverlayColor2, _colGradationOverlayColor2.AnimationMarkArray);
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblGradationOverlayColor3, _colGradationOverlayColor3.AnimationMarkArray);

            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(_lblOuterShadowColor, _colOuterShadowColor.AnimationMarkArray);
            _lblOuterShadowAngle.BindAnimationMark(_fesOuterShadowAngle.AnimationMarkInst);
            _lblOuterShadowDistance.BindAnimationMark(_fesOuterShadowDistance.AnimationMarkInst);
            _lblOuterShadowSize.BindAnimationMark(_fesOuterShadowSize.AnimationMarkInst);
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static PropertyPage CreateInstance(object arg)
        {
            var page = new PropWndPaneProceduralShapePage();
            page._OwnerPane = arg as IPane;

            return page;
        }

        public override void OnSceneModifyHandler(object sender, SceneModifyEventArgs e)
        {
            if (e.Target == SceneModifyEventArgs.Kind.PlatformChanged)
            {
                UpdateProperty();
            }
            else if (e.Target == SceneModifyEventArgs.Kind.PaneAnimAddRemove ||
                     e.Target == SceneModifyEventArgs.Kind.PaneAnimModify)
            {
                UpdateAnimationMark();
            }
            else
            {
                base.OnSceneModifyHandler(sender, e);
            }
        }

        /// <summary>
        /// アニメーションマークを更新します。
        /// </summary>
        private void UpdateAnimationMark()
        {
            // アニメーションマークの更新
            foreach (IAnimationMarkUsable ctrl in GetAnimationMarkUsableControl())
            {
                ctrl.UpdateAnimationMark();
            }
        }

        /// <summary>
        /// ページの表示内容と関係しているペインです。
        /// peneAdapterからマテリアル操作クラスを取得する際のキーとして利用します。
        /// </summary>
        private IPane _OwnerPane
        {
            get;
            set;
        }

        #region GUIハンドラ

        /// <summary>
        /// ターゲットアダプタ
        /// </summary>
        private MaskGUIAdapter TargetAdapter
        {
            get
            {
                MaskGUIAdapter maskAdapter = null;
                PaneGUIAdapter peneAdapter = base.Target.Active;

                if (peneAdapter != null)
                {
                    maskAdapter = peneAdapter.MaskGUIAdapter != null ? peneAdapter.MaskGUIAdapter : null;
                }
                return maskAdapter;
            }
        }

        /// <summary>
        /// ターゲットテクスチャマップ
        /// </summary>
        private TexMap TargetTexMap
        {
            get
            {
                MaskGUIAdapter maskAdapter = TargetAdapter;
                TexMapList texMapList = maskAdapter != null ? maskAdapter.TexMapList : null;
                return texMapList == null || texMapList.TexMaps.Count == 0 ? null : texMapList[0];
            }
        }

        /// <summary>
        /// 複数同時編集
        /// </summary>
        private void MultiEdit_(Action<ProceduralShapeManipulator> modifyAction)
        {
            if (SettingDataToGUIControl)
            {
                // 各コントロール等で弾いているはず
                Debug.Assert(false);
                return;
            }

            if (this.Owner.Target.IsMulti)
            {
                ISubScene subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
                subScene.BeginMassiveModify();
                {
                    ProceduralShapeManipulator proceduralShapeMnp = new ProceduralShapeManipulator();
                    foreach (IBaseGuiAdapter paneAdapter in this.Owner.Target.Objects)
                    {
                        if (paneAdapter.Target == null)
                        {
                            continue;
                        }
                        if (paneAdapter.Target.IPicture == null)
                        {
                            continue;
                        }
                        if (paneAdapter.Target.IPicture.IProceduralShape == null)
                        {
                            continue;
                        }

                        proceduralShapeMnp.BindTarget(paneAdapter.Target.IPicture.IProceduralShape);
                        modifyAction(proceduralShapeMnp);
                    }
                }
                subScene.EndMassiveModify();
            }
            else
            {
                // 変更実行途中での UI の更新を抑える
                ISubScene subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
                subScene.BeginMassiveModify();
                modifyAction(_TargetProceduralShapeMpn);
                subScene.EndMassiveModify();
            }
        }

        /// <summary>
        /// アニメーションマークが利用可能なコントロールの一覧を取得する。
        /// </summary>
        protected override IEnumerable<IAnimationMarkUsable> GetAnimationMarkUsableControl()
        {
            List<IAnimationMarkUsable> list = new List<IAnimationMarkUsable>();

            list.Add(_lblProceduralShapeExp);
            list.Add(_fesProceduralShapeExp);
            list.Add(_lblProceduralShapeRadius);
            list.Add(_fesProceduralShapeRadius);

            list.Add(_lblStrokeSize);
            list.Add(_fesStrokeSize);
            list.Add(_lblStrokeColor);
            list.Add(_colStrokeColor);

            list.Add(_lblInnerShadowColor);
            list.Add(_colInnerShadowColor);
            list.Add(_lblInnerShadowAngle);
            list.Add(_fesInnerShadowAngle);
            list.Add(_lblInnerShadowDistance);
            list.Add(_fesInnerShadowDistance);
            list.Add(_lblInnerShadowSize);
            list.Add(_fesInnerShadowSize);

            list.Add(_lblColorOverlayColor);
            list.Add(_colColorOverlayColor);

            list.Add(_lblGradationOverlayControlPoint0);
            list.Add(_fesGradationOverlayControlPoint0);
            list.Add(_lblGradationOverlayControlPoint1);
            list.Add(_fesGradationOverlayControlPoint1);
            list.Add(_lblGradationOverlayControlPoint2);
            list.Add(_fesGradationOverlayControlPoint2);
            list.Add(_lblGradationOverlayControlPoint3);
            list.Add(_fesGradationOverlayControlPoint3);
            list.Add(_lblGradationOverlayColor0);
            list.Add(_colGradationOverlayColor0);
            list.Add(_lblGradationOverlayColor1);
            list.Add(_colGradationOverlayColor1);
            list.Add(_lblGradationOverlayColor2);
            list.Add(_colGradationOverlayColor2);
            list.Add(_lblGradationOverlayColor3);
            list.Add(_colGradationOverlayColor3);
            list.Add(_lblGradationOverlayAngle);
            list.Add(_fesGradationOverlayAngle);

            list.Add(_lblOuterShadowColor);
            list.Add(_colOuterShadowColor);
            list.Add(_lblOuterShadowAngle);
            list.Add(_fesOuterShadowAngle);
            list.Add(_lblOuterShadowDistance);
            list.Add(_fesOuterShadowDistance);
            list.Add(_lblOuterShadowSize);
            list.Add(_fesOuterShadowSize);


            return list;
        }

        #region 角丸
        private void Event_chkProceduralShapeEnabled_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) =>
            {
                proceduralShapeMnp.IsProceduralShapeEnabled = _chkProceduralShapeEnabled.Checked;
            });
        }

        private void Event_fesProceduralShapeExp_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.Exp = _fesProceduralShapeExp.Value);
            }
        }

        private void Event_fesProceduralShapeRadius_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.Radius = _fesProceduralShapeRadius.Value);
            }
        }
        #endregion

        #region 境界線

        private void Event_chkStrokeEnabled_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) =>
            {
                proceduralShapeMnp.IsInnerStrokeEnabled = _chkStrokeEnabled.Checked;
            });
        }

        private void Event_fesStrokeSize_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.InnerStrokeSize = _fesStrokeSize.Value);
            }
        }

        private void Event_comboStrokeBlendMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.InnerStrokeBlendMode = (LECore.Structures.LECoreInterface.ProceduralShapeEffectBlendMode)_comboStrokeBlendMode.SelectedIndex);
        }

        private void Event_colStrokeColor_ColorEdit(object sender, ColorEditEventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.InnerStrokeColor = _colStrokeColor.Color.ToRGBAColor());
        }

        #endregion

        #region ドロップシャドウ(内側)

        private void Event_chkInnerShadowEnabled_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) =>
            {
                proceduralShapeMnp.IsInnerShadowEnabled = _chkInnerShadowEnabled.Checked;
            });
        }

        private void Event_comboInnerShadowBlendMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.InnerShadowBlendMode = (LECore.Structures.LECoreInterface.ProceduralShapeEffectBlendMode)_comboInnerShadowBlendMode.SelectedIndex);
        }

        private void Event_colInnerShadowColor_ColorEdit(object sender, ColorEditEventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.InnerShadowColor = _colInnerShadowColor.Color.ToRGBAColor());
        }

        private void Event_fesInnerShadowAngle_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.InnerShadowAngle = _fesInnerShadowAngle.Value);
            }
        }

        private void Event_fesInnerShadowDistance_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.InnerShadowDistance = _fesInnerShadowDistance.Value);
            }
        }

        private void Event_fesInnerShadowSize_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.InnerShadowSize = _fesInnerShadowSize.Value);
            }
        }

        private void Event_comboInnerShadowAttenuationType_SelectedIndexChanged(object sender, EventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.InnerShadowType = (LECore.Structures.LECoreInterface.ProceduralShapeShadowType)_comboInnerShadowType.SelectedIndex);
        }

        #endregion

        #region カラーオーバーレイ

        private void Event_chkColorOverlayEnabled_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) =>
            {
                proceduralShapeMnp.IsColorOverayEnabled = _chkColorOverlayEnabled.Checked;
            });
        }

        private void Event_comboColorOverlayBlendMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.ColorOverlayBlendMode = (LECore.Structures.LECoreInterface.ProceduralShapeEffectBlendMode)_comboColorOverlayBlendMode.SelectedIndex);
        }

        private void Event_colColorOverlayColor_ColorEdit(object sender, ColorEditEventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.ColorOverlayColor = _colColorOverlayColor.Color.ToRGBAColor());
        }

        #endregion

        #region グラデーションオーバーレイ

        private void Event_chkGradationOverlayEnabled_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) =>
            {
                proceduralShapeMnp.IsGradationOverayEnabled = _chkGradationOverlayEnabled.Checked;
            });
        }

        private void Event_comboGradationOverlayBlendMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.GradationOverlayBlendMode = (LECore.Structures.LECoreInterface.ProceduralShapeEffectBlendMode)_comboGradationOverlayBlendMode.SelectedIndex);
        }

        private void Event_numControlPointCount_ValueChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }
            MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.GradationOverlayControlPointCount = (int)_numControlPointCount.Value);
        }

        private void Event_fesGradationOverlayControlPoint0_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.SetGradationOverlayControlPoint(0,_fesGradationOverlayControlPoint0.Value));
            }
        }

        private void Event_fesGradationOverlayControlPoint1_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.SetGradationOverlayControlPoint(1,_fesGradationOverlayControlPoint1.Value));
            }
        }

        private void Event_fesGradationOverlayControlPoint2_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.SetGradationOverlayControlPoint(2,_fesGradationOverlayControlPoint2.Value));
            }
        }

        private void Event_fesGradationOverlayControlPoint3_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.SetGradationOverlayControlPoint(3,_fesGradationOverlayControlPoint3.Value));
            }
        }

        private void Event_colGradationOverlayColor0_ColorEdit(object sender, ColorEditEventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) =>
            {
                proceduralShapeMnp.SetGradationOverlayColor(0, _colGradationOverlayColor0.Color.ToRGBAColor());
            });
        }

        private void Event_colGradationOverlayColor1_ColorEdit(object sender, ColorEditEventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) =>
            {
                proceduralShapeMnp.SetGradationOverlayColor(1, _colGradationOverlayColor1.Color.ToRGBAColor());
            });
        }

        private void Event_colGradationOverlayColor2_ColorEdit(object sender, ColorEditEventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) =>
            {
                proceduralShapeMnp.SetGradationOverlayColor(2, _colGradationOverlayColor2.Color.ToRGBAColor());
            });
        }

        private void Event_colGradationOverlayColor3_ColorEdit(object sender, ColorEditEventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) =>
            {
                proceduralShapeMnp.SetGradationOverlayColor(3, _colGradationOverlayColor3.Color.ToRGBAColor());
            });
        }

        private void Event_fesGradationOverlayAngle_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.GradationOverlayAngle = _fesGradationOverlayAngle.Value);
            }
        }

        #endregion

        #region ドロップシャドウ(外側)

        private void Event_chkOuterShadowEnabled_CheckedChanged(object sender, EventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) =>
            {
                proceduralShapeMnp.IsOuterShadowEnabled = _chkOuterShadowEnabled.Checked;
            });
        }

        private void Event_comboOuterShadowBlendMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.OuterShadowBlendMode = (LECore.Structures.LECoreInterface.ProceduralShapeEffectBlendMode)_comboOuterShadowBlendMode.SelectedIndex);
        }

        private void Event_colOuterShadowColor_ColorEdit(object sender, ColorEditEventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.OuterShadowColor = _colOuterShadowColor.Color.ToRGBAColor());
        }

        private void Event_fesOuterShadowAngle_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.OuterShadowAngle = _fesOuterShadowAngle.Value);
            }
        }

        private void Event_fesOuterShadowDistance_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.OuterShadowDistance = _fesOuterShadowDistance.Value);
            }
        }

        private void Event_fesOuterShadowSize_ValueEdit(object sender, ValueEditEventArgs e)
        {
            if (e.EditFixed)
            {
                MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.OuterShadowSize = _fesOuterShadowSize.Value);
            }
        }

        private void Event_comboOuterShadowAttenuationType_SelectedIndexChanged(object sender, EventArgs e)
        {
            MultiEdit_((proceduralShapeMnp) => proceduralShapeMnp.OuterShadowType = (LECore.Structures.LECoreInterface.ProceduralShapeShadowType)_comboOuterShadowType.SelectedIndex);
        }


        #endregion

        #endregion
    }
}
