﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Linq;
using System.Diagnostics;
using System.Windows.Forms;
using LECore.Structures.Nsrif.Attributes;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using Adapters;
    using LayoutEditor.Controls;
    using LECore;
    using LECore.Manipulator;
    using LECore.Structures;
    using LECore.Structures.Core;
    using System.Collections.Generic;
    using TextureControls;
    using HVLocation = Tuple<LECore.Structures.HorizontalLocation, LECore.Structures.VerticalLocation>;

    /// <summary>
    /// PropWndPaneMaskPage の概要の説明です。
    /// </summary>
    public class PropWndPaneMaskPage : PropertyPage
    {
        #region デザイナ生成フィールド
        private System.Windows.Forms.Label _lblRotZ;
        private LayoutEditor.Controls.DockContentToolTip _ttpPaneBasic;
        private System.ComponentModel.IContainer components;
        private GroupBox _grpMask;
        private TextureControls.TexMapBox ctlTexMap0;
        private Button btnAttrChangeImage;
        private Panel pnlAttr;
        private Label lblAttrName;
        private Label lblAttrSize;
        private Label lblAttrSizeT;
        private Label lblAttrFormat;
        private Label lblAttrFormatT;
        private Label lblAttrColor;
        private ThumbnailBox ctlAttrColor;
        private ThumbnailBox ctlAttrAlpha;
        private Label lblAttrAlpha;
        private GroupBox grpImgFilter;
        private Panel pnlImgFilterMin;
        private Label lblImgFilterMin;
        private UIRadioButton radImgFilterMinN;
        private UIRadioButton radImgFilterMinL;
        private Panel pnlImgFilterMag;
        private Label lblImgFilterMag;
        private UIRadioButton radImgFilterMagN;
        private UIRadioButton radImgFilterMagL;
        private GroupBox grpImgWrap;
        private Panel pnlImgWrapS;
        private Label lblImgWrapS;
        private UIRadioButton radImgWrapSClamp;
        private UIRadioButton radImgWrapSRepeat;
        private UIRadioButton radImgWrapSMirror;
        private Panel pnlImgWrapT;
        private Label lblImgWrapT;
        private UIRadioButton radImgWrapTClamp;
        private UIRadioButton radImgWrapTRepeat;
        private UIRadioButton radImgWrapTMirror;
        private UICheckBox _chkEnabled;
        private UICheckBox _chkMaskWithPane;
        private GroupBox _grpSrtMtx;
        private TextureSRTMtxEditPanel _pnlTextureMtx;
        private PictureBox picMaskDescription;
        private Label _lblMaskWarning;
        private ErrorProvider _erpPaneNameChange;

        #endregion デザイナ生成フィールド

        #region デザイナ生成コード
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(PropWndPaneMaskPage));
            this._lblRotZ = new System.Windows.Forms.Label();
            this._ttpPaneBasic = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this._chkEnabled = new LayoutEditor.Controls.UICheckBox();
            this._erpPaneNameChange = new System.Windows.Forms.ErrorProvider(this.components);
            this._grpMask = new System.Windows.Forms.GroupBox();
            this.picMaskDescription = new System.Windows.Forms.PictureBox();
            this._grpSrtMtx = new System.Windows.Forms.GroupBox();
            this._pnlTextureMtx = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls.TextureSRTMtxEditPanel();
            this._chkMaskWithPane = new LayoutEditor.Controls.UICheckBox();
            this.grpImgFilter = new System.Windows.Forms.GroupBox();
            this.pnlImgFilterMin = new System.Windows.Forms.Panel();
            this.lblImgFilterMin = new System.Windows.Forms.Label();
            this.radImgFilterMinN = new LayoutEditor.Controls.UIRadioButton();
            this.radImgFilterMinL = new LayoutEditor.Controls.UIRadioButton();
            this.pnlImgFilterMag = new System.Windows.Forms.Panel();
            this.lblImgFilterMag = new System.Windows.Forms.Label();
            this.radImgFilterMagN = new LayoutEditor.Controls.UIRadioButton();
            this.radImgFilterMagL = new LayoutEditor.Controls.UIRadioButton();
            this.grpImgWrap = new System.Windows.Forms.GroupBox();
            this.pnlImgWrapS = new System.Windows.Forms.Panel();
            this.lblImgWrapS = new System.Windows.Forms.Label();
            this.radImgWrapSClamp = new LayoutEditor.Controls.UIRadioButton();
            this.radImgWrapSRepeat = new LayoutEditor.Controls.UIRadioButton();
            this.radImgWrapSMirror = new LayoutEditor.Controls.UIRadioButton();
            this.pnlImgWrapT = new System.Windows.Forms.Panel();
            this.lblImgWrapT = new System.Windows.Forms.Label();
            this.radImgWrapTClamp = new LayoutEditor.Controls.UIRadioButton();
            this.radImgWrapTRepeat = new LayoutEditor.Controls.UIRadioButton();
            this.radImgWrapTMirror = new LayoutEditor.Controls.UIRadioButton();
            this.pnlAttr = new System.Windows.Forms.Panel();
            this.lblAttrName = new System.Windows.Forms.Label();
            this.lblAttrSize = new System.Windows.Forms.Label();
            this.lblAttrSizeT = new System.Windows.Forms.Label();
            this.lblAttrFormat = new System.Windows.Forms.Label();
            this.lblAttrFormatT = new System.Windows.Forms.Label();
            this.lblAttrColor = new System.Windows.Forms.Label();
            this.ctlAttrColor = new LayoutEditor.Controls.ThumbnailBox();
            this.ctlAttrAlpha = new LayoutEditor.Controls.ThumbnailBox();
            this.lblAttrAlpha = new System.Windows.Forms.Label();
            this.btnAttrChangeImage = new System.Windows.Forms.Button();
            this.ctlTexMap0 = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls.TexMapBox();
            this._lblMaskWarning = new System.Windows.Forms.Label();
            ((System.ComponentModel.ISupportInitialize)(this._erpPaneNameChange)).BeginInit();
            this._grpMask.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picMaskDescription)).BeginInit();
            this._grpSrtMtx.SuspendLayout();
            this.grpImgFilter.SuspendLayout();
            this.pnlImgFilterMin.SuspendLayout();
            this.pnlImgFilterMag.SuspendLayout();
            this.grpImgWrap.SuspendLayout();
            this.pnlImgWrapS.SuspendLayout();
            this.pnlImgWrapT.SuspendLayout();
            this.pnlAttr.SuspendLayout();
            this.SuspendLayout();
            //
            // _lblRotZ
            //
            resources.ApplyResources(this._lblRotZ, "_lblRotZ");
            this._lblRotZ.Name = "_lblRotZ";
            //
            // _chkEnabled
            //
            resources.ApplyResources(this._chkEnabled, "_chkEnabled");
            this._chkEnabled.Name = "_chkEnabled";
            this._ttpPaneBasic.SetToolTip(this._chkEnabled, resources.GetString("_chkEnabled.ToolTip"));
            this._chkEnabled.CheckedChanged += new System.EventHandler(this.Event_chkEnabled_CheckedChanged);
            //
            // _erpPaneNameChange
            //
            this._erpPaneNameChange.ContainerControl = this;
            resources.ApplyResources(this._erpPaneNameChange, "_erpPaneNameChange");
            //
            // _grpMask
            //
            this._grpMask.Controls.Add(this.picMaskDescription);
            this._grpMask.Controls.Add(this._grpSrtMtx);
            this._grpMask.Controls.Add(this._chkMaskWithPane);
            this._grpMask.Controls.Add(this.grpImgFilter);
            this._grpMask.Controls.Add(this.grpImgWrap);
            this._grpMask.Controls.Add(this.pnlAttr);
            this._grpMask.Controls.Add(this.btnAttrChangeImage);
            this._grpMask.Controls.Add(this.ctlTexMap0);
            resources.ApplyResources(this._grpMask, "_grpMask");
            this._grpMask.Name = "_grpMask";
            this._grpMask.TabStop = false;
            //
            // picMaskDescription
            //
            this.picMaskDescription.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            resources.ApplyResources(this.picMaskDescription, "picMaskDescription");
            this.picMaskDescription.Name = "picMaskDescription";
            this.picMaskDescription.TabStop = false;
            //
            // _grpSrtMtx
            //
            this._grpSrtMtx.Controls.Add(this._pnlTextureMtx);
            resources.ApplyResources(this._grpSrtMtx, "_grpSrtMtx");
            this._grpSrtMtx.Name = "_grpSrtMtx";
            this._grpSrtMtx.TabStop = false;
            //
            // _pnlTextureMtx
            //
            resources.ApplyResources(this._pnlTextureMtx, "_pnlTextureMtx");
            this._pnlTextureMtx.ControlColor = System.Drawing.Color.Empty;
            this._pnlTextureMtx.Name = "_pnlTextureMtx";
            this._pnlTextureMtx.TargetTexMtx = null;
            this._pnlTextureMtx.UseAnimationMark = false;
            this._pnlTextureMtx.OnMatrixChanged += new System.EventHandler(this.Event_PnlTextureMtx_Changed);
            //
            // _chkMaskWithPane
            //
            resources.ApplyResources(this._chkMaskWithPane, "_chkMaskWithPane");
            this._chkMaskWithPane.Name = "_chkMaskWithPane";
            this._chkMaskWithPane.CheckedChanged += new System.EventHandler(this.Event_chkMaskWithPane_CheckedChanged);
            //
            // grpImgFilter
            //
            this.grpImgFilter.Controls.Add(this.pnlImgFilterMin);
            this.grpImgFilter.Controls.Add(this.pnlImgFilterMag);
            resources.ApplyResources(this.grpImgFilter, "grpImgFilter");
            this.grpImgFilter.Name = "grpImgFilter";
            this.grpImgFilter.TabStop = false;
            //
            // pnlImgFilterMin
            //
            this.pnlImgFilterMin.Controls.Add(this.lblImgFilterMin);
            this.pnlImgFilterMin.Controls.Add(this.radImgFilterMinN);
            this.pnlImgFilterMin.Controls.Add(this.radImgFilterMinL);
            resources.ApplyResources(this.pnlImgFilterMin, "pnlImgFilterMin");
            this.pnlImgFilterMin.Name = "pnlImgFilterMin";
            //
            // lblImgFilterMin
            //
            resources.ApplyResources(this.lblImgFilterMin, "lblImgFilterMin");
            this.lblImgFilterMin.Name = "lblImgFilterMin";
            //
            // radImgFilterMinN
            //
            resources.ApplyResources(this.radImgFilterMinN, "radImgFilterMinN");
            this.radImgFilterMinN.Name = "radImgFilterMinN";
            //
            // radImgFilterMinL
            //
            resources.ApplyResources(this.radImgFilterMinL, "radImgFilterMinL");
            this.radImgFilterMinL.Name = "radImgFilterMinL";
            //
            // pnlImgFilterMag
            //
            this.pnlImgFilterMag.Controls.Add(this.lblImgFilterMag);
            this.pnlImgFilterMag.Controls.Add(this.radImgFilterMagN);
            this.pnlImgFilterMag.Controls.Add(this.radImgFilterMagL);
            resources.ApplyResources(this.pnlImgFilterMag, "pnlImgFilterMag");
            this.pnlImgFilterMag.Name = "pnlImgFilterMag";
            //
            // lblImgFilterMag
            //
            resources.ApplyResources(this.lblImgFilterMag, "lblImgFilterMag");
            this.lblImgFilterMag.Name = "lblImgFilterMag";
            //
            // radImgFilterMagN
            //
            resources.ApplyResources(this.radImgFilterMagN, "radImgFilterMagN");
            this.radImgFilterMagN.Name = "radImgFilterMagN";
            //
            // radImgFilterMagL
            //
            resources.ApplyResources(this.radImgFilterMagL, "radImgFilterMagL");
            this.radImgFilterMagL.Name = "radImgFilterMagL";
            //
            // grpImgWrap
            //
            this.grpImgWrap.Controls.Add(this.pnlImgWrapS);
            this.grpImgWrap.Controls.Add(this.pnlImgWrapT);
            resources.ApplyResources(this.grpImgWrap, "grpImgWrap");
            this.grpImgWrap.Name = "grpImgWrap";
            this.grpImgWrap.TabStop = false;
            //
            // pnlImgWrapS
            //
            this.pnlImgWrapS.Controls.Add(this.lblImgWrapS);
            this.pnlImgWrapS.Controls.Add(this.radImgWrapSClamp);
            this.pnlImgWrapS.Controls.Add(this.radImgWrapSRepeat);
            this.pnlImgWrapS.Controls.Add(this.radImgWrapSMirror);
            resources.ApplyResources(this.pnlImgWrapS, "pnlImgWrapS");
            this.pnlImgWrapS.Name = "pnlImgWrapS";
            //
            // lblImgWrapS
            //
            resources.ApplyResources(this.lblImgWrapS, "lblImgWrapS");
            this.lblImgWrapS.Name = "lblImgWrapS";
            //
            // radImgWrapSClamp
            //
            resources.ApplyResources(this.radImgWrapSClamp, "radImgWrapSClamp");
            this.radImgWrapSClamp.Name = "radImgWrapSClamp";
            //
            // radImgWrapSRepeat
            //
            resources.ApplyResources(this.radImgWrapSRepeat, "radImgWrapSRepeat");
            this.radImgWrapSRepeat.Name = "radImgWrapSRepeat";
            //
            // radImgWrapSMirror
            //
            resources.ApplyResources(this.radImgWrapSMirror, "radImgWrapSMirror");
            this.radImgWrapSMirror.Name = "radImgWrapSMirror";
            //
            // pnlImgWrapT
            //
            this.pnlImgWrapT.Controls.Add(this.lblImgWrapT);
            this.pnlImgWrapT.Controls.Add(this.radImgWrapTClamp);
            this.pnlImgWrapT.Controls.Add(this.radImgWrapTRepeat);
            this.pnlImgWrapT.Controls.Add(this.radImgWrapTMirror);
            resources.ApplyResources(this.pnlImgWrapT, "pnlImgWrapT");
            this.pnlImgWrapT.Name = "pnlImgWrapT";
            //
            // lblImgWrapT
            //
            resources.ApplyResources(this.lblImgWrapT, "lblImgWrapT");
            this.lblImgWrapT.Name = "lblImgWrapT";
            //
            // radImgWrapTClamp
            //
            resources.ApplyResources(this.radImgWrapTClamp, "radImgWrapTClamp");
            this.radImgWrapTClamp.Name = "radImgWrapTClamp";
            //
            // radImgWrapTRepeat
            //
            resources.ApplyResources(this.radImgWrapTRepeat, "radImgWrapTRepeat");
            this.radImgWrapTRepeat.Name = "radImgWrapTRepeat";
            //
            // radImgWrapTMirror
            //
            resources.ApplyResources(this.radImgWrapTMirror, "radImgWrapTMirror");
            this.radImgWrapTMirror.Name = "radImgWrapTMirror";
            //
            // pnlAttr
            //
            resources.ApplyResources(this.pnlAttr, "pnlAttr");
            this.pnlAttr.Controls.Add(this.lblAttrName);
            this.pnlAttr.Controls.Add(this.lblAttrSize);
            this.pnlAttr.Controls.Add(this.lblAttrSizeT);
            this.pnlAttr.Controls.Add(this.lblAttrFormat);
            this.pnlAttr.Controls.Add(this.lblAttrFormatT);
            this.pnlAttr.Controls.Add(this.lblAttrColor);
            this.pnlAttr.Controls.Add(this.ctlAttrColor);
            this.pnlAttr.Controls.Add(this.ctlAttrAlpha);
            this.pnlAttr.Controls.Add(this.lblAttrAlpha);
            this.pnlAttr.Name = "pnlAttr";
            //
            // lblAttrName
            //
            resources.ApplyResources(this.lblAttrName, "lblAttrName");
            this.lblAttrName.BackColor = System.Drawing.SystemColors.Window;
            this.lblAttrName.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblAttrName.Name = "lblAttrName";
            //
            // lblAttrSize
            //
            resources.ApplyResources(this.lblAttrSize, "lblAttrSize");
            this.lblAttrSize.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblAttrSize.Name = "lblAttrSize";
            //
            // lblAttrSizeT
            //
            resources.ApplyResources(this.lblAttrSizeT, "lblAttrSizeT");
            this.lblAttrSizeT.Name = "lblAttrSizeT";
            //
            // lblAttrFormat
            //
            resources.ApplyResources(this.lblAttrFormat, "lblAttrFormat");
            this.lblAttrFormat.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblAttrFormat.Name = "lblAttrFormat";
            //
            // lblAttrFormatT
            //
            resources.ApplyResources(this.lblAttrFormatT, "lblAttrFormatT");
            this.lblAttrFormatT.Name = "lblAttrFormatT";
            //
            // lblAttrColor
            //
            resources.ApplyResources(this.lblAttrColor, "lblAttrColor");
            this.lblAttrColor.Name = "lblAttrColor";
            //
            // ctlAttrColor
            //
            resources.ApplyResources(this.ctlAttrColor, "ctlAttrColor");
            this.ctlAttrColor.Name = "ctlAttrColor";
            //
            // ctlAttrAlpha
            //
            this.ctlAttrAlpha.ImageMode = LayoutEditor.Controls.ThumbnailBoxImageMode.Alpha;
            resources.ApplyResources(this.ctlAttrAlpha, "ctlAttrAlpha");
            this.ctlAttrAlpha.Name = "ctlAttrAlpha";
            //
            // lblAttrAlpha
            //
            resources.ApplyResources(this.lblAttrAlpha, "lblAttrAlpha");
            this.lblAttrAlpha.Name = "lblAttrAlpha";
            //
            // btnAttrChangeImage
            //
            resources.ApplyResources(this.btnAttrChangeImage, "btnAttrChangeImage");
            this.btnAttrChangeImage.Name = "btnAttrChangeImage";
            this.btnAttrChangeImage.Click += new System.EventHandler(this.Event_BtnAttrChangeImage_Click);
            //
            // ctlTexMap0
            //
            this.ctlTexMap0.IsDraggable = false;
            resources.ApplyResources(this.ctlTexMap0, "ctlTexMap0");
            this.ctlTexMap0.Name = "ctlTexMap0";
            this.ctlTexMap0.Selected = false;
            this.ctlTexMap0.TargetMaterialGUIAdapter = null;
            this.ctlTexMap0.TexMap = null;
            //
            // _lblMaskWarning
            //
            resources.ApplyResources(this._lblMaskWarning, "_lblMaskWarning");
            this._lblMaskWarning.Name = "_lblMaskWarning";
            //
            // PropWndPaneMaskPage
            //
            this.Controls.Add(this._lblMaskWarning);
            this.Controls.Add(this._grpMask);
            this.Controls.Add(this._chkEnabled);
            this.Name = "PropWndPaneMaskPage";
            resources.ApplyResources(this, "$this");
            ((System.ComponentModel.ISupportInitialize)(this._erpPaneNameChange)).EndInit();
            this._grpMask.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.picMaskDescription)).EndInit();
            this._grpSrtMtx.ResumeLayout(false);
            this.grpImgFilter.ResumeLayout(false);
            this.pnlImgFilterMin.ResumeLayout(false);
            this.pnlImgFilterMin.PerformLayout();
            this.pnlImgFilterMag.ResumeLayout(false);
            this.pnlImgFilterMag.PerformLayout();
            this.grpImgWrap.ResumeLayout(false);
            this.pnlImgWrapS.ResumeLayout(false);
            this.pnlImgWrapS.PerformLayout();
            this.pnlImgWrapT.ResumeLayout(false);
            this.pnlImgWrapT.PerformLayout();
            this.pnlAttr.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

        }

        #endregion デザイナ生成コード

        #region ----------- フィールド

        PaneGuiAdapterGroup _oldTarget = null;
        TexImage _oldImage = null;
        MaskManipulator _maskMnp = new MaskManipulator();

        #endregion ----------- フィールド

        #region ----------- プロパティ

        #endregion ----------- プロパティ

        #region ----------- 非公開プロパティ

        MaskManipulator _TargetMaskMpn
        {
            get
            {
                return Target.Active.MaskManipulator;
            }
        }

        // テクスチャマップ管理
        private readonly TexMapBox _texMapBox;

        #endregion ----------- 非公開プロパティ

        private readonly Image _imgMask1 = ImageResMgr.GetManifestResourcePng("mask1.png");
        private readonly Image _imgMask2 = ImageResMgr.GetManifestResourcePng("mask2.png");

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        protected override void InitializeProperty()
        {
            radImgWrapSClamp.Tag = AttrTexWrap.Clamp;
            radImgWrapSRepeat.Tag = AttrTexWrap.Repeat;
            radImgWrapSMirror.Tag = AttrTexWrap.Mirror;
            this.radImgWrapSClamp.RadioChecked += new System.EventHandler(this.Event_RadImgWrapS_RadioChecked);
            this.radImgWrapSRepeat.RadioChecked += new System.EventHandler(this.Event_RadImgWrapS_RadioChecked);
            this.radImgWrapSMirror.RadioChecked += new System.EventHandler(this.Event_RadImgWrapS_RadioChecked);

            radImgWrapTClamp.Tag = AttrTexWrap.Clamp;
            radImgWrapTRepeat.Tag = AttrTexWrap.Repeat;
            radImgWrapTMirror.Tag = AttrTexWrap.Mirror;
            this.radImgWrapTClamp.RadioChecked += new System.EventHandler(this.Event_RadImgWrapT_RadioChecked);
            this.radImgWrapTRepeat.RadioChecked += new System.EventHandler(this.Event_RadImgWrapT_RadioChecked);
            this.radImgWrapTMirror.RadioChecked += new System.EventHandler(this.Event_RadImgWrapT_RadioChecked);

            radImgFilterMagN.Tag = AttrTexFilterMag.Near;
            radImgFilterMagL.Tag = AttrTexFilterMag.Linear;
            this.radImgFilterMagN.RadioChecked += new System.EventHandler(this.Event_RadImgFilterMag_RadioChecked);
            this.radImgFilterMagL.RadioChecked += new System.EventHandler(this.Event_RadImgFilterMag_RadioChecked);

            radImgFilterMinN.Tag = AttrTexFilterMin.Near;
            radImgFilterMinL.Tag = AttrTexFilterMin.Linear;
            this.radImgFilterMinN.RadioChecked += new System.EventHandler(this.Event_RadImgFilterMin_RadioChecked);
            this.radImgFilterMinL.RadioChecked += new System.EventHandler(this.Event_RadImgFilterMin_RadioChecked);

            // ViewManagerへのメッセージハンドラを設定します
            _pnlTextureMtx.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
        }

        /// <summary>
        /// GUIの値を更新します。
        /// </summary>
        protected override void UpdateProperty()
        {
            if (_TargetMaskMpn == null)
            {
                return;
            }

            // パネルがアニメーションマークを利用するかを設定します
            _pnlTextureMtx.UseAnimationMark = this.CanUseAnimationMark(
                _TargetMaskMpn.IMask.OwnerPane?.OwnerSubScene);

            // TextureSRT パネルに値を設定します。
            _pnlTextureMtx.Enabled = TargetTexMap != null;
            if (TargetTexMap != null)
            {
                TexMtx texMtx = TargetTexMap.TexGen.TexMtx;
                _pnlTextureMtx.TargetTexMtx = TargetAdapter.IMaterial.ITexMtxSet[0];
                _pnlTextureMtx.Set(texMtx.ScaleS, texMtx.ScaleT, texMtx.Rotate, texMtx.TransS, texMtx.TransT);
            }

            // ターゲットを参照してUIを更新する
            IMaterialTexMap maskTexMap = _TargetMaskMpn.IMask.MaskTexMap;

            _grpMask.Visible = _TargetMaskMpn.IMask.IsMaskEnabled;
            _chkEnabled.SetChecked(_TargetMaskMpn.IMask.IsMaskEnabled);
            _chkMaskWithPane.SetChecked(_TargetMaskMpn.IMask.IsMaskWithPane);
            radImgWrapSClamp.SetCheckedByTag(maskTexMap.WrapS);
            radImgWrapSRepeat.SetCheckedByTag(maskTexMap.WrapS);
            radImgWrapSMirror.SetCheckedByTag(maskTexMap.WrapS);
            radImgWrapTClamp.SetCheckedByTag(maskTexMap.WrapT);
            radImgWrapTRepeat.SetCheckedByTag(maskTexMap.WrapT);
            radImgWrapTMirror.SetCheckedByTag(maskTexMap.WrapT);
            radImgFilterMagN.SetCheckedByTag(maskTexMap.MagFilter);
            radImgFilterMagL.SetCheckedByTag(maskTexMap.MagFilter);
            radImgFilterMinN.SetCheckedByTag(maskTexMap.MinFilter);
            radImgFilterMinL.SetCheckedByTag(maskTexMap.MinFilter);
            picMaskDescription.BackgroundImage = _TargetMaskMpn.IMask.IsMaskWithPane ? _imgMask2 : _imgMask1;

            _texMapBox.TexMap = TargetTexMap;

            TexMap texMap = Target.Active.MaskGUIAdapter.TexMap;
            if (texMap == null)
            {
                pnlAttr.Visible = false;
            }
            else
            {
                pnlAttr.Visible = true;

                TexImage texImage = texMap.TexImage;

                // サムネイル
                ctlAttrColor.Thumbnail = texImage;
                ctlAttrAlpha.Thumbnail = texImage;

                // アトリビュート
                lblAttrName.Text = texImage.Texture.Name;
                lblAttrFormat.Text = texImage.Texture.FormatText;
                lblAttrSize.Text = texImage.Texture.SizeText;

                // 連動ボタンの更新
                if (_oldTarget != Target ||
                    _oldImage != texImage)
                {
                    _oldTarget = Target;
                    _oldImage = texImage;
                    _pnlTextureMtx.UpdateLinkButton();
                }
            }

            // 同時編集の設定
            Color color = GetMultiEditColor();
            Color panelColor = GetMultiEditPanelColor();
            _chkEnabled.BackColor = panelColor;
            grpImgWrap.BackColor = panelColor;
            grpImgFilter.BackColor = panelColor;
            _pnlTextureMtx.ControlColor = color;
        }

        // コンストラクタ
        public PropWndPaneMaskPage()
        {
            InitializeComponent();

            _texMapBox = ctlTexMap0;
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static PropertyPage CreateInstance(object arg)
        {
            var page = new PropWndPaneMaskPage();
            page._OwnerPane = arg as IPane;

            return page;
        }

        public override void OnSceneModifyHandler(object sender, SceneModifyEventArgs e)
        {
            if (e.Target == SceneModifyEventArgs.Kind.PlatformChanged)
            {
                using (new GUIUpdating(this))
                {
                    UpdateProperty();
                }
            }
            else if (e.Target == SceneModifyEventArgs.Kind.PaneAnimAddRemove ||
                     e.Target == SceneModifyEventArgs.Kind.PaneAnimModify)
            {
                UpdateAnimationMark();
            }
            else
            {
                base.OnSceneModifyHandler(sender, e);
            }
        }

        /// <summary>
        /// アニメーションマークを更新します。
        /// </summary>
        private void UpdateAnimationMark()
        {
            _pnlTextureMtx.UpdateAnimationMark();
        }

        /// <summary>
        /// ページの表示内容と関係しているペインです。
        /// peneAdapterからマテリアル操作クラスを取得する際のキーとして利用します。
        /// </summary>
        private IPane _OwnerPane
        {
            get;
            set;
        }

        /// <summary>
        /// 再描画前の対象更新です。
        /// </summary>
        protected override void BeforeUpdateTargetUpdate()
        {
            LECore.LayoutEditorCore.Scene.CurrentISubScene.BeginMassiveModify();
            MaskGUIAdapter maskAdapter = TargetAdapter;
            Ensure.Operation.ObjectNotNull(maskAdapter);
            maskAdapter.SetCoreDataToGUIMock();
            LECore.LayoutEditorCore.Scene.CurrentISubScene.EndMassiveModify();
        }

        /// <summary>
        /// 変更を通知します。
        /// </summary>
        protected override void NotifyPropertyChanged()
        {
            OnModifyTargetAdapterUpdate_();
        }

        /// <summary>
        /// 変更を通知します。
        /// </summary>
        protected override void NotifyPropertyChanged(IBaseGuiAdapter paneAdapter)
        {
            OnModifyTargetAdapterUpdate_();
        }

        private void OnModifyTargetAdapterUpdate_()
        {
            LECore.LayoutEditorCore.Scene.CurrentISubScene.BeginMassiveModify();

            foreach (MaskGUIAdapter adapter in TargetAdapters)
            {
                Ensure.Operation.ObjectNotNull(adapter);
                adapter.OnModified(this, false);
            }

            LECore.LayoutEditorCore.Scene.CurrentISubScene.EndMassiveModify();
        }

        #region GUIハンドラ

        /// <summary>
        /// ターゲットアダプタ
        /// </summary>
        private MaskGUIAdapter TargetAdapter
        {
            get
            {
                MaskGUIAdapter maskAdapter = null;
                PaneGUIAdapter peneAdapter = base.Target.Active;

                if (peneAdapter != null)
                {
                    maskAdapter = peneAdapter.MaskGUIAdapter != null ? peneAdapter.MaskGUIAdapter : null;
                }
                return maskAdapter;
            }
        }

        /// <summary>
        /// ターゲットアダプタ
        /// </summary>
        private IEnumerable<MaskGUIAdapter> TargetAdapters
        {
            get
            {
                return Target.Objects.Select(adpt => (adpt as PaneGUIAdapter).MaskGUIAdapter);
            }
        }

        /// <summary>
        /// ターゲットテクスチャマップ
        /// </summary>
        private TexMap TargetTexMap
        {
            get
            {
                return TargetAdapter.TexMap;
            }
        }

        private void Event_chkEnabled_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            bool check = _chkEnabled.Checked;
            MultiEdit_((obj) =>
            {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _maskMnp.BindTarget(adapter.Target.IMask);

                _maskMnp.IsMaskEnabled = _chkEnabled.Checked;

                IPane ownerPane = _maskMnp.IMask.OwnerPane;
                if (check && ownerPane != null)
                {
                    _maskMnp.CreateCaptureTextureForMask(ownerPane, ownerPane.OwnerSubScene.ITextureMgr);
                }
            }, this.Owner.Target.Active, this.Owner.Target.Objects);
        }

        private void Event_chkMaskWithPane_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            bool check = _chkMaskWithPane.Checked;
            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _maskMnp.BindTarget(adapter.Target.IMask);

                _maskMnp.IsMaskWithPane = check;

            }, this.Owner.Target.Active, this.Owner.Target.Objects);
        }

        private void Event_BtnAttrChangeImage_Click(object sender, EventArgs e)
        {
            TexImage texImageOld = TargetTexMap == null ? null : TargetTexMap.TexImage;

            if (texImageOld == null)
            {
                // ダイアログ表示
                TextureAddDialog dlg = new TextureAddDialog(Target.Active.MaskGUIAdapter, AppSetting.ProjectSettings.CaptureTextureFunctionEnabled);
                if (dlg.ShowDialog(this.Owner.Owner) == DialogResult.OK)
                {
                    LETexGenMethod method = dlg.Method;
                    Texture texture = dlg.Texture;
                    TexMapKind kind = dlg.Kind;
                    if (texture == null)
                    {
                        return;
                    }

                    // 設定された名前のテクスチャがキャプチャテクスチャの場合、このマテリアルに設定可能かチェックします。
                    IPane obstaclePane = null;
                    if (Target.Active.MaskGUIAdapter.IMaterial != null)
                    {
                        obstaclePane = PaneHelper.FindInvalidPaneForMaterialCaptureTextureInput(Target.Active.MaskGUIAdapter.IMaterial.OwnerPane, texture.Name);
                    }
                    if (obstaclePane != null)
                    {
                        string msg = StringResMgr.Get("PROP_MAT_TEX_MSG_ADD_TEXTURE_FAILED_BECAUSE_CAPTURE_TEXTURE_IN_PARENT_TREE", obstaclePane.PaneName);
                        MessageBox.Show(this, msg, LayoutEditor.StringResMgr.Get("PROP_MAT_CATEGORY_TEXTURE"), MessageBoxButtons.OK);
                        return;
                    }

                    // 作成
                    Target.Active.MaskGUIAdapter.TexMapList.TexMaps.Clear();
                    Target.Active.MaskGUIAdapter.TexMapList.TexMaps.Add(
                        new TexMap(TexImage.Create(texture), method, kind, AttrTextureResourceType.LocalFile)
                        );

                    using (new GUIUpdating(this))
                    {
                        UpdateProperty();
                    }
                    NotifyPropertyChanged();
                }
            }
            else
            {
                IPane dynamicCapturePane = null;
                if (AppSetting.ProjectSettings.CaptureTextureFunctionEnabled &&
                    Target.Active.MaskGUIAdapter.IMaterial.OwnerPane != null &&
                    Target.Active.MaskGUIAdapter.IMaterial.OwnerPane.OwnerSubScene.IPartsLayout == null)
                {
                    dynamicCapturePane = Target.Active.MaskGUIAdapter.IMaterial.OwnerPane;
                }

                TextureSelectDialog dlg = new TextureSelectDialog(texImageOld, dynamicCapturePane);
                if (dlg.ShowDialog(this.Owner.Owner) == DialogResult.OK)
                {
                    if (dlg.Texture == null)
                    {
                        return;
                    }

                    TexImage texImageNew = TexImage.Create(dlg.Texture);

                    // 異なる場合のみ
                    if (texImageNew != texImageOld)
                    {
                        // 設定された名前のテクスチャがキャプチャテクスチャの場合、このマテリアルに設定可能かチェックします。
                        IPane obstaclePane = null;
                        if (Target.Active.MaskGUIAdapter.IMaterial != null)
                        {
                            obstaclePane = PaneHelper.FindInvalidPaneForMaterialCaptureTextureInput(Target.Active.MaskGUIAdapter.IMaterial.OwnerPane, dlg.Texture.Name);
                        }

                        if (obstaclePane != null)
                        {
                            string msg = StringResMgr.Get("PROP_MAT_TEX_MSG_ADD_TEXTURE_FAILED_BECAUSE_CAPTURE_TEXTURE_IN_PARENT_TREE", obstaclePane.PaneName);
                            MessageBox.Show(this, msg, LayoutEditor.StringResMgr.Get("PROP_MAT_CATEGORY_TEXTURE"), MessageBoxButtons.OK);
                            return;
                        }

                        TargetTexMap.TexImage = texImageNew;

                        using (new GUIUpdating(this))
                        {
                            UpdateProperty();
                        }
                        NotifyPropertyChanged();
                    }
                }
            }
        }

        private void Event_RadImgWrapS_RadioChecked(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _maskMnp.BindTarget(adapter.Target.IMask);

                _maskMnp.WrapS = (AttrTexWrap)((UIRadioButton)sender).Tag;

            }, this.Owner.Target.Active, this.Owner.Target.Objects);
        }

        private void Event_RadImgWrapT_RadioChecked(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _maskMnp.BindTarget(adapter.Target.IMask);

                _maskMnp.WrapT = (AttrTexWrap)((UIRadioButton)sender).Tag;

            }, this.Owner.Target.Active, this.Owner.Target.Objects);
        }

        private void Event_RadImgFilterMag_RadioChecked(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _maskMnp.BindTarget(adapter.Target.IMask);

                _maskMnp.MagFilter = (AttrTexFilterMag)((UIRadioButton)sender).Tag;

            }, this.Owner.Target.Active, this.Owner.Target.Objects);
        }

        private void Event_RadImgFilterMin_RadioChecked(object sender, EventArgs e)
        {
            if (IsGUIUpdating) return;

            MultiEdit_((obj) => {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _maskMnp.BindTarget(adapter.Target.IMask);

                _maskMnp.MinFilter = (AttrTexFilterMin)((UIRadioButton)sender).Tag;

            }, this.Owner.Target.Active, this.Owner.Target.Objects);
        }

        private void Event_PnlTextureMtx_Changed(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            MaterialTextureEditEventArgs args = e as MaterialTextureEditEventArgs;

            MultiEdit_((obj) =>
            {
                PaneGUIAdapter adapter = obj as PaneGUIAdapter;
                _maskMnp.BindTarget(adapter.Target.IMask);

                FVec2 trans = _maskMnp.MtxTrans;
                float rotate = _maskMnp.MtxRotate;
                FVec2 scale = _maskMnp.MtxScale;

                if ((args.Kind & MaterialTextureEditEventKind.Trans_U) != 0)
                    trans.X = _pnlTextureMtx.MtxTrans.X;
                if ((args.Kind & MaterialTextureEditEventKind.Trans_V) != 0)
                    trans.Y = _pnlTextureMtx.MtxTrans.Y;
                if ((args.Kind & MaterialTextureEditEventKind.Rotate) != 0)
                    rotate = _pnlTextureMtx.MtxRotate;
                if ((args.Kind & MaterialTextureEditEventKind.Scale_U) != 0)
                    scale.X = _pnlTextureMtx.MtxScale.X;
                if ((args.Kind & MaterialTextureEditEventKind.Scale_V) != 0)
                    scale.Y = _pnlTextureMtx.MtxScale.Y;

                _maskMnp.MtxTrans = trans;
                _maskMnp.MtxRotate = rotate;
                _maskMnp.MtxScale = scale;
            }, this.Owner.Target.Active, this.Owner.Target.Objects);
        }

        #endregion
    }
}
