﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;
using System.IO;
using System.Linq;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using LayoutEditor.Controls;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters;
    using LayoutEditor.Utility;

    using LECore.Manipulator;
    using LECore.Structures;
    using LECore;
    using LECore.Structures.Core;
    using System.Collections.Generic;

    /// <summary>
    /// CapturePanePage の概要の説明です。
    /// </summary>
    public class AlignmentPanePage : PropertyPage
    {
        private System.ComponentModel.IContainer components;
        private src.Controls.BindAnimationLabel _lblDefaultMargin;
        private Panel _pnlPositionH;
        private UIRadioButton _radPosHCenter;
        private UIRadioButton _radPosHLeft;
        private UIRadioButton _radPosHRight;
        private Label _lblPositionH;
        private Button _btnDoAlign;
        private src.Controls.AnimationMarkFloatTextBox _nudDefaultMargin;
        private Label _lblBorderNotice;
        private ToolTip _ttpMain;
        private Label _lblNotice;
        private GroupBox groupBox1;
        private GroupBox groupBox2;
        private Panel panel1;
        private UIRadioButton _radPosVCenter;
        private UIRadioButton _radPosVUp;
        private UIRadioButton _radPosVBottom;
        private Label _lblPositionV;
        private CheckBox _chkExpandEdgeV;
        private src.Controls.BindAnimationLabel _lblDefaultMarginV;
        private src.Controls.AnimationMarkFloatTextBox _nudDefaultMarginV;
        private UIRadioButton _radHorizontalAlignmentEnable;
        private UIRadioButton _radVerticalAlignmentEnable;
        private CheckBox _chkExpandEdge;
        #region デザイナメンバ



        #endregion デザイナメンバ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public AlignmentPanePage()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 捜査対象ペインアダプタ
        /// </summary>
        PaneGUIAdapter _TargetPane
        {
            get
            {
                PaneGUIAdapter paneAdapter = Target.Active;
                return paneAdapter;
            }
        }

        /// <summary>
        /// 操作対象ペインを操作するクラスを取得します。
        /// </summary>
        protected AlignmentManipulator _TargetAlignmentMnp
        {
            get
            {
                return _TargetPane.FindTargetAlignmentManipulator(_TargetIndex);
            }
        }

        /// <summary>
        /// 複数が対象にある場合に、何番目を対象とするかを指定します。
        /// </summary>
        protected int _TargetIndex
        {
            get;
            set;
        }

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        protected override void InitializeProperty()
        {
            // GUIに関するユーザ独自の初期化処理を記述します。
            _radPosHLeft.Tag = HorizontalLocation.Left;
            _radPosHCenter.Tag = HorizontalLocation.Center;
            _radPosHRight.Tag = HorizontalLocation.Right;

            // GUIに関するユーザ独自の初期化処理を記述します。
            _radPosVUp.Tag = VerticalLocation.Top;
            _radPosVCenter.Tag = VerticalLocation.Center;
            _radPosVBottom.Tag = VerticalLocation.Bottom;

        }

        /// <summary>
        /// GUIを更新します。
        /// </summary>
        protected override void UpdateProperty()
        {
            _nudDefaultMargin.UseAnimationMark = false;

            // ターゲットを参照してUIを更新する
            _radHorizontalAlignmentEnable.SetChecked(_TargetAlignmentMnp.IAlignment.IsAlignmentHorizontalEnabled);
            _radVerticalAlignmentEnable.SetChecked(_TargetAlignmentMnp.IAlignment.IsAlignmentVerticalEnabled);

            bool isAlignmentHorizontalEnabled = _TargetAlignmentMnp.IAlignment.IsAlignmentHorizontalEnabled;
            bool isAlignmentVerticalEnabled = _TargetAlignmentMnp.IAlignment.IsAlignmentVerticalEnabled;

            _radPosHLeft.SetCheckedByTag(_TargetAlignmentMnp.IAlignment.Horizontal);
            _radPosHCenter.SetCheckedByTag(_TargetAlignmentMnp.IAlignment.Horizontal);
            _radPosHRight.SetCheckedByTag(_TargetAlignmentMnp.IAlignment.Horizontal);

            _radPosHLeft.Enabled = isAlignmentHorizontalEnabled;
            _radPosHCenter.Enabled = isAlignmentHorizontalEnabled;
            _radPosHRight.Enabled = isAlignmentHorizontalEnabled;
            _lblPositionH.Enabled = isAlignmentHorizontalEnabled;
            _lblDefaultMargin.Enabled = isAlignmentHorizontalEnabled;
            _nudDefaultMargin.Enabled = isAlignmentHorizontalEnabled;
            _chkExpandEdge.Enabled = isAlignmentHorizontalEnabled;

            _radPosVUp.SetCheckedByTag(_TargetAlignmentMnp.IAlignment.Vertical);
            _radPosVCenter.SetCheckedByTag(_TargetAlignmentMnp.IAlignment.Vertical);
            _radPosVBottom.SetCheckedByTag(_TargetAlignmentMnp.IAlignment.Vertical);

            _radPosVUp.Enabled = isAlignmentVerticalEnabled;
            _radPosVCenter.Enabled = isAlignmentVerticalEnabled;
            _radPosVBottom.Enabled = isAlignmentVerticalEnabled;
            _lblPositionV.Enabled = isAlignmentVerticalEnabled;
            _lblDefaultMarginV.Enabled = isAlignmentVerticalEnabled;
            _nudDefaultMarginV.Enabled = isAlignmentVerticalEnabled;
            _chkExpandEdgeV.Enabled = isAlignmentVerticalEnabled;

            _nudDefaultMargin.SetValue(_TargetAlignmentMnp.IAlignment.DefaultHorizontalMargin);
            _nudDefaultMarginV.SetValue(_TargetAlignmentMnp.IAlignment.DefaultVerticalMargin);

            _chkExpandEdge.Checked = _TargetAlignmentMnp.IAlignment.IsExtendEdgeHorizontalEnabled;
            _chkExpandEdgeV.Checked = _TargetAlignmentMnp.IAlignment.IsExtendEdgeVerticalEnabled;

            // 整列対象が一つもない場合は、ボタンを無効にして、用法をUI上で示す。
            bool hasAlignmentPaneTarget = _TargetAlignmentMnp.IAlignment.HasAlignmentPaneTarget();
            _btnDoAlign.Enabled = hasAlignmentPaneTarget;
        }

        #region デザイナ生成コード
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(AlignmentPanePage));
            this._nudDefaultMargin = new LayoutEditor.src.Controls.AnimationMarkFloatTextBox();
            this._btnDoAlign = new System.Windows.Forms.Button();
            this._pnlPositionH = new System.Windows.Forms.Panel();
            this._radPosHCenter = new LayoutEditor.Controls.UIRadioButton();
            this._radPosHLeft = new LayoutEditor.Controls.UIRadioButton();
            this._radPosHRight = new LayoutEditor.Controls.UIRadioButton();
            this._lblPositionH = new System.Windows.Forms.Label();
            this._lblDefaultMargin = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._chkExpandEdge = new System.Windows.Forms.CheckBox();
            this._lblBorderNotice = new System.Windows.Forms.Label();
            this._ttpMain = new System.Windows.Forms.ToolTip(this.components);
            this._chkExpandEdgeV = new System.Windows.Forms.CheckBox();
            this._lblDefaultMarginV = new LayoutEditor.src.Controls.BindAnimationLabel();
            this._nudDefaultMarginV = new LayoutEditor.src.Controls.AnimationMarkFloatTextBox();
            this._lblNotice = new System.Windows.Forms.Label();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.panel1 = new System.Windows.Forms.Panel();
            this._radPosVCenter = new LayoutEditor.Controls.UIRadioButton();
            this._radPosVUp = new LayoutEditor.Controls.UIRadioButton();
            this._radPosVBottom = new LayoutEditor.Controls.UIRadioButton();
            this._lblPositionV = new System.Windows.Forms.Label();
            this._radHorizontalAlignmentEnable = new LayoutEditor.Controls.UIRadioButton();
            this._radVerticalAlignmentEnable = new LayoutEditor.Controls.UIRadioButton();
            this._pnlPositionH.SuspendLayout();
            this.groupBox1.SuspendLayout();
            this.groupBox2.SuspendLayout();
            this.panel1.SuspendLayout();
            this.SuspendLayout();
            //
            // _nudDefaultMargin
            //
            this._nudDefaultMargin.AnimationMarkSize = new System.Drawing.Size(5, 19);
            resources.ApplyResources(this._nudDefaultMargin, "_nudDefaultMargin");
            this._nudDefaultMargin.Name = "_nudDefaultMargin";
            this._nudDefaultMargin.TextBoxAccessibleRole = System.Windows.Forms.AccessibleRole.None;
            this._nudDefaultMargin.TextBoxAlign = System.Windows.Forms.HorizontalAlignment.Left;
            this._nudDefaultMargin.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._nudDefaultMargin.TextBoxFormat = "F2";
            this._nudDefaultMargin.TextBoxMaxValue = 100000F;
            this._nudDefaultMargin.TextBoxMinValue = -100000F;
            this._nudDefaultMargin.TextBoxSize = new System.Drawing.Size(48, 19);
            this._nudDefaultMargin.TextBoxValue = 0F;
            this._ttpMain.SetToolTip(this._nudDefaultMargin, resources.GetString("_nudDefaultMargin.ToolTip"));
            this._nudDefaultMargin.UseAnimationMark = false;
            this._nudDefaultMargin.TextBoxValueChanged += new System.EventHandler(this._nudDefaultMargin_ValueChanged);
            //
            // _btnDoAlign
            //
            resources.ApplyResources(this._btnDoAlign, "_btnDoAlign");
            this._btnDoAlign.Name = "_btnDoAlign";
            this._btnDoAlign.UseVisualStyleBackColor = true;
            this._btnDoAlign.Click += new System.EventHandler(this._btnDoAlign_Click);
            //
            // _pnlPositionH
            //
            this._pnlPositionH.Controls.Add(this._radPosHCenter);
            this._pnlPositionH.Controls.Add(this._radPosHLeft);
            this._pnlPositionH.Controls.Add(this._radPosHRight);
            this._pnlPositionH.Controls.Add(this._lblPositionH);
            resources.ApplyResources(this._pnlPositionH, "_pnlPositionH");
            this._pnlPositionH.Name = "_pnlPositionH";
            //
            // _radPosHCenter
            //
            resources.ApplyResources(this._radPosHCenter, "_radPosHCenter");
            this._radPosHCenter.Name = "_radPosHCenter";
            this._radPosHCenter.CheckedChanged += new System.EventHandler(this._radPosHLeft_CheckedChanged);
            //
            // _radPosHLeft
            //
            resources.ApplyResources(this._radPosHLeft, "_radPosHLeft");
            this._radPosHLeft.Name = "_radPosHLeft";
            this._radPosHLeft.CheckedChanged += new System.EventHandler(this._radPosHLeft_CheckedChanged);
            //
            // _radPosHRight
            //
            resources.ApplyResources(this._radPosHRight, "_radPosHRight");
            this._radPosHRight.Name = "_radPosHRight";
            this._radPosHRight.CheckedChanged += new System.EventHandler(this._radPosHLeft_CheckedChanged);
            //
            // _lblPositionH
            //
            resources.ApplyResources(this._lblPositionH, "_lblPositionH");
            this._lblPositionH.Name = "_lblPositionH";
            //
            // _lblDefaultMargin
            //
            resources.ApplyResources(this._lblDefaultMargin, "_lblDefaultMargin");
            this._lblDefaultMargin.Name = "_lblDefaultMargin";
            this._ttpMain.SetToolTip(this._lblDefaultMargin, resources.GetString("_lblDefaultMargin.ToolTip"));
            this._lblDefaultMargin.UseAnimationMark = false;
            this._lblDefaultMargin.UseContextMenu = false;
            //
            // _chkExpandEdge
            //
            resources.ApplyResources(this._chkExpandEdge, "_chkExpandEdge");
            this._chkExpandEdge.Name = "_chkExpandEdge";
            this._ttpMain.SetToolTip(this._chkExpandEdge, resources.GetString("_chkExpandEdge.ToolTip"));
            this._chkExpandEdge.CheckedChanged += new System.EventHandler(this._chkExpandEdge_CheckedChanged);
            //
            // _lblBorderNotice
            //
            this._lblBorderNotice.BackColor = System.Drawing.SystemColors.Control;
            resources.ApplyResources(this._lblBorderNotice, "_lblBorderNotice");
            this._lblBorderNotice.Name = "_lblBorderNotice";
            this._ttpMain.SetToolTip(this._lblBorderNotice, resources.GetString("_lblBorderNotice.ToolTip"));
            //
            // _chkExpandEdgeV
            //
            resources.ApplyResources(this._chkExpandEdgeV, "_chkExpandEdgeV");
            this._chkExpandEdgeV.Name = "_chkExpandEdgeV";
            this._ttpMain.SetToolTip(this._chkExpandEdgeV, resources.GetString("_chkExpandEdgeV.ToolTip"));
            this._chkExpandEdgeV.CheckedChanged += new System.EventHandler(this._chkExpandEdgeV_CheckedChanged);
            //
            // _lblDefaultMarginV
            //
            resources.ApplyResources(this._lblDefaultMarginV, "_lblDefaultMarginV");
            this._lblDefaultMarginV.Name = "_lblDefaultMarginV";
            this._ttpMain.SetToolTip(this._lblDefaultMarginV, resources.GetString("_lblDefaultMarginV.ToolTip"));
            this._lblDefaultMarginV.UseAnimationMark = false;
            this._lblDefaultMarginV.UseContextMenu = false;
            //
            // _nudDefaultMarginV
            //
            this._nudDefaultMarginV.AnimationMarkSize = new System.Drawing.Size(5, 19);
            resources.ApplyResources(this._nudDefaultMarginV, "_nudDefaultMarginV");
            this._nudDefaultMarginV.Name = "_nudDefaultMarginV";
            this._nudDefaultMarginV.TextBoxAccessibleRole = System.Windows.Forms.AccessibleRole.None;
            this._nudDefaultMarginV.TextBoxAlign = System.Windows.Forms.HorizontalAlignment.Left;
            this._nudDefaultMarginV.TextBoxBackColor = System.Drawing.SystemColors.Window;
            this._nudDefaultMarginV.TextBoxFormat = "F2";
            this._nudDefaultMarginV.TextBoxMaxValue = 100000F;
            this._nudDefaultMarginV.TextBoxMinValue = -100000F;
            this._nudDefaultMarginV.TextBoxSize = new System.Drawing.Size(48, 19);
            this._nudDefaultMarginV.TextBoxValue = 0F;
            this._ttpMain.SetToolTip(this._nudDefaultMarginV, resources.GetString("_nudDefaultMarginV.ToolTip"));
            this._nudDefaultMarginV.UseAnimationMark = false;
            this._nudDefaultMarginV.TextBoxValueChanged += new System.EventHandler(this._nudDefaultMarginV_ValueChanged);
            //
            // _lblNotice
            //
            this._lblNotice.BackColor = System.Drawing.SystemColors.ControlLight;
            resources.ApplyResources(this._lblNotice, "_lblNotice");
            this._lblNotice.ForeColor = System.Drawing.SystemColors.GrayText;
            this._lblNotice.Name = "_lblNotice";
            //
            // groupBox1
            //
            this.groupBox1.Controls.Add(this._pnlPositionH);
            this.groupBox1.Controls.Add(this._chkExpandEdge);
            this.groupBox1.Controls.Add(this._lblBorderNotice);
            this.groupBox1.Controls.Add(this._lblDefaultMargin);
            this.groupBox1.Controls.Add(this._nudDefaultMargin);
            resources.ApplyResources(this.groupBox1, "groupBox1");
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.TabStop = false;
            //
            // groupBox2
            //
            this.groupBox2.Controls.Add(this.panel1);
            this.groupBox2.Controls.Add(this._chkExpandEdgeV);
            this.groupBox2.Controls.Add(this._lblDefaultMarginV);
            this.groupBox2.Controls.Add(this._nudDefaultMarginV);
            resources.ApplyResources(this.groupBox2, "groupBox2");
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.TabStop = false;
            //
            // panel1
            //
            this.panel1.Controls.Add(this._radPosVCenter);
            this.panel1.Controls.Add(this._radPosVUp);
            this.panel1.Controls.Add(this._radPosVBottom);
            this.panel1.Controls.Add(this._lblPositionV);
            resources.ApplyResources(this.panel1, "panel1");
            this.panel1.Name = "panel1";
            //
            // _radPosVCenter
            //
            resources.ApplyResources(this._radPosVCenter, "_radPosVCenter");
            this._radPosVCenter.Name = "_radPosVCenter";
            this._radPosVCenter.CheckedChanged += new System.EventHandler(this._radPosVUp_CheckedChanged);
            //
            // _radPosVUp
            //
            resources.ApplyResources(this._radPosVUp, "_radPosVUp");
            this._radPosVUp.Name = "_radPosVUp";
            this._radPosVUp.CheckedChanged += new System.EventHandler(this._radPosVUp_CheckedChanged);
            //
            // _radPosVBottom
            //
            resources.ApplyResources(this._radPosVBottom, "_radPosVBottom");
            this._radPosVBottom.Name = "_radPosVBottom";
            this._radPosVBottom.CheckedChanged += new System.EventHandler(this._radPosVUp_CheckedChanged);
            //
            // _lblPositionV
            //
            resources.ApplyResources(this._lblPositionV, "_lblPositionV");
            this._lblPositionV.Name = "_lblPositionV";
            //
            // _radHorizontalAlignmentEnable
            //
            resources.ApplyResources(this._radHorizontalAlignmentEnable, "_radHorizontalAlignmentEnable");
            this._radHorizontalAlignmentEnable.Name = "_radHorizontalAlignmentEnable";
            this._radHorizontalAlignmentEnable.TabStop = true;
            this._radHorizontalAlignmentEnable.UseVisualStyleBackColor = true;
            this._radHorizontalAlignmentEnable.CheckedChanged += new System.EventHandler(this._radHorizontalAlignmentEnable_CheckedChanged);
            //
            // _radVerticalAlignmentEnable
            //
            resources.ApplyResources(this._radVerticalAlignmentEnable, "_radVerticalAlignmentEnable");
            this._radVerticalAlignmentEnable.Name = "_radVerticalAlignmentEnable";
            this._radVerticalAlignmentEnable.TabStop = true;
            this._radVerticalAlignmentEnable.UseVisualStyleBackColor = true;
            this._radVerticalAlignmentEnable.CheckedChanged += new System.EventHandler(this._radVerticalAlignmentEnable_CheckedChanged);
            //
            // AlignmentPanePage
            //
            this.Controls.Add(this._radVerticalAlignmentEnable);
            this.Controls.Add(this._radHorizontalAlignmentEnable);
            this.Controls.Add(this.groupBox2);
            this.Controls.Add(this.groupBox1);
            this.Controls.Add(this._lblNotice);
            this.Controls.Add(this._btnDoAlign);
            this.Name = "AlignmentPanePage";
            resources.ApplyResources(this, "$this");
            this._pnlPositionH.ResumeLayout(false);
            this.groupBox1.ResumeLayout(false);
            this.groupBox1.PerformLayout();
            this.groupBox2.ResumeLayout(false);
            this.groupBox2.PerformLayout();
            this.panel1.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion デザイナ生成コード

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static PropertyPage CreateInstance(object arg)
        {
            var newInstance = new AlignmentPanePage();
            newInstance._TargetIndex = (arg == null) ? 0 : (int)arg;

            return newInstance;
        }

        private void _radPosHLeft_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            _TargetAlignmentMnp.Horizontal = (HorizontalLocation)(sender as UIRadioButton).Tag;
        }

        private void _chkExpandEdge_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            _TargetAlignmentMnp.IsExtendEdgeEnabled = _chkExpandEdge.Checked;
        }

        private void _chkExpandEdgeV_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            _TargetAlignmentMnp.IsExtendEdgeVerticalEnabled = _chkExpandEdgeV.Checked;
        }

        private void _btnDoAlign_Click(object sender, EventArgs e)
        {
            _TargetAlignmentMnp.DoAlign();
        }

        private void _nudDefaultMargin_ValueChanged(object sender, EventArgs e)
        {
            _TargetAlignmentMnp.DefaultMargin = _nudDefaultMargin.TextBoxValue;
        }

        private void _nudDefaultMarginV_ValueChanged(object sender, EventArgs e)
        {
            _TargetAlignmentMnp.DefaultVerticalMargin = _nudDefaultMarginV.TextBoxValue;
        }

        private void _radPosVUp_CheckedChanged(Object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            _TargetAlignmentMnp.Vertical = (VerticalLocation)(sender as UIRadioButton).Tag;
        }

        private void _radHorizontalAlignmentEnable_CheckedChanged(Object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            _TargetAlignmentMnp.IsAlignmentHorizontalEnabled = _radHorizontalAlignmentEnable.Checked;
        }

        private void _radVerticalAlignmentEnable_CheckedChanged(Object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            _TargetAlignmentMnp.IsAlignmentVerticalEnabled = _radVerticalAlignmentEnable.Checked;
        }
    }
}

