﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Material.Texture
{
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters;
    using LECore.Structures.LECoreInterface;

    public partial class TexturePatternAddDialog : Form
    {
        public TexturePatternAddDialog(IEnumerable<Texture> textures)
        {
            InitializeComponent();

            _lvwFullList.BeginUpdate();
            foreach (var texture in textures)
            {
                var item = new ListViewItem();
                item.Text = texture.Name;
                item.SubItems.Add(texture.Size.Width.ToString());
                item.SubItems.Add(texture.Size.Height.ToString());
                item.SubItems.Add(texture.FormatText);

                item.ImageIndex = _lvwFullList.SmallImageList.Images.Count;
                Bitmap thumnail = new Bitmap(
                    texture.ColorImage,
                    new Size(imageList.ImageSize.Width, imageList.ImageSize.Height));
                _lvwFullList.SmallImageList.Images.Add(texture.Name, thumnail);

                if (texture.SourceType == TextureSourceType.Dynamic)
                {
                    item.BackColor = LECore.AppConstants.ActiveCatpureTextureBackColor;
                }

                _lvwFullList.Items.Add(item);
            }
            _lvwFullList.EndUpdate();

        }

        private void _lvwFullList_ItemChecked(object sender, ItemCheckedEventArgs e)
        {
            btnOK.Enabled = _lvwFullList.Items.OfType<ListViewItem>().Any(x => x.Checked);
        }

        public IEnumerable<string> SelectedItems
        {
            get
            {
                return _lvwFullList.Items.OfType<ListViewItem>().Where(x => x.Checked).Select(x => x.Text);
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }
    }
}
