﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages
{
    using LayoutEditor.Controls;
    using LayoutEditor.Utility;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters ;
    using App = LayoutEditor;

    /// <summary>
    /// マテリアルＴＥＶＫカラーページクラス。
    /// </summary>
    public class MaterialTevKColorPage : MaterialPage
    {
        #region デザイナ変数

        private System.Windows.Forms.GroupBox grpCol2;
        private System.Windows.Forms.GroupBox grpCol1;
        private System.Windows.Forms.GroupBox grpCol0;
        private System.Windows.Forms.GroupBox grpCol3;
        private App.Controls.ColorEditPanel ctlColor2;
        private App.Controls.ColorEditPanel ctlColor1;
        private App.Controls.ColorEditPanel ctlColor0;
        private App.Controls.ColorEditPanel ctlColor3;
        private System.ComponentModel.IContainer components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(MaterialTevKColorPage));
            this.grpCol2 = new System.Windows.Forms.GroupBox();
            this.ctlColor2 = new App.Controls.ColorEditPanel();
            this.grpCol1 = new System.Windows.Forms.GroupBox();
            this.ctlColor1 = new App.Controls.ColorEditPanel();
            this.grpCol0 = new System.Windows.Forms.GroupBox();
            this.ctlColor0 = new App.Controls.ColorEditPanel();
            this.grpCol3 = new System.Windows.Forms.GroupBox();
            this.ctlColor3 = new App.Controls.ColorEditPanel();
            this.grpCol2.SuspendLayout();
            this.grpCol1.SuspendLayout();
            this.grpCol0.SuspendLayout();
            this.grpCol3.SuspendLayout();
            this.SuspendLayout();
            //
            // grpCol2
            //
            this.grpCol2.AccessibleDescription = resources.GetString("grpCol2.AccessibleDescription");
            this.grpCol2.AccessibleName = resources.GetString("grpCol2.AccessibleName");
            this.grpCol2.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("grpCol2.Anchor")));
            this.grpCol2.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("grpCol2.BackgroundImage")));
            this.grpCol2.Controls.Add(this.ctlColor2);
            this.grpCol2.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("grpCol2.Dock")));
            this.grpCol2.Enabled = ((bool)(resources.GetObject("grpCol2.Enabled")));
            this.grpCol2.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this.grpCol2.Font = ((System.Drawing.Font)(resources.GetObject("grpCol2.Font")));
            this.grpCol2.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("grpCol2.ImeMode")));
            this.grpCol2.Location = ((System.Drawing.Point)(resources.GetObject("grpCol2.Location")));
            this.grpCol2.Name = "grpCol2";
            this.grpCol2.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("grpCol2.RightToLeft")));
            this.grpCol2.Size = ((System.Drawing.Size)(resources.GetObject("grpCol2.Size")));
            this.grpCol2.TabIndex = ((int)(resources.GetObject("grpCol2.TabIndex")));
            this.grpCol2.TabStop = false;
            this.grpCol2.Text = resources.GetString("grpCol2.Text");
            this.grpCol2.Visible = ((bool)(resources.GetObject("grpCol2.Visible")));
            //
            // ctlColor2
            //
            this.ctlColor2.AccessibleDescription = resources.GetString("ctlColor2.AccessibleDescription");
            this.ctlColor2.AccessibleName = resources.GetString("ctlColor2.AccessibleName");
            this.ctlColor2.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("ctlColor2.Anchor")));
            this.ctlColor2.AutoScroll = ((bool)(resources.GetObject("ctlColor2.AutoScroll")));
            this.ctlColor2.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("ctlColor2.AutoScrollMargin")));
            this.ctlColor2.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("ctlColor2.AutoScrollMinSize")));
            this.ctlColor2.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("ctlColor2.BackgroundImage")));
            this.ctlColor2.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("ctlColor2.Dock")));
            this.ctlColor2.Enabled = ((bool)(resources.GetObject("ctlColor2.Enabled")));
            this.ctlColor2.Font = ((System.Drawing.Font)(resources.GetObject("ctlColor2.Font")));
            this.ctlColor2.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("ctlColor2.ImeMode")));
            this.ctlColor2.Location = ((System.Drawing.Point)(resources.GetObject("ctlColor2.Location")));
            this.ctlColor2.Name = "ctlColor2";
            this.ctlColor2.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("ctlColor2.RightToLeft")));
            this.ctlColor2.Size = ((System.Drawing.Size)(resources.GetObject("ctlColor2.Size")));
            this.ctlColor2.TabIndex = ((int)(resources.GetObject("ctlColor2.TabIndex")));
            this.ctlColor2.Tag = "";
            this.ctlColor2.Visible = ((bool)(resources.GetObject("ctlColor2.Visible")));
            //
            // grpCol1
            //
            this.grpCol1.AccessibleDescription = resources.GetString("grpCol1.AccessibleDescription");
            this.grpCol1.AccessibleName = resources.GetString("grpCol1.AccessibleName");
            this.grpCol1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("grpCol1.Anchor")));
            this.grpCol1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("grpCol1.BackgroundImage")));
            this.grpCol1.Controls.Add(this.ctlColor1);
            this.grpCol1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("grpCol1.Dock")));
            this.grpCol1.Enabled = ((bool)(resources.GetObject("grpCol1.Enabled")));
            this.grpCol1.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this.grpCol1.Font = ((System.Drawing.Font)(resources.GetObject("grpCol1.Font")));
            this.grpCol1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("grpCol1.ImeMode")));
            this.grpCol1.Location = ((System.Drawing.Point)(resources.GetObject("grpCol1.Location")));
            this.grpCol1.Name = "grpCol1";
            this.grpCol1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("grpCol1.RightToLeft")));
            this.grpCol1.Size = ((System.Drawing.Size)(resources.GetObject("grpCol1.Size")));
            this.grpCol1.TabIndex = ((int)(resources.GetObject("grpCol1.TabIndex")));
            this.grpCol1.TabStop = false;
            this.grpCol1.Text = resources.GetString("grpCol1.Text");
            this.grpCol1.Visible = ((bool)(resources.GetObject("grpCol1.Visible")));
            //
            // ctlColor1
            //
            this.ctlColor1.AccessibleDescription = resources.GetString("ctlColor1.AccessibleDescription");
            this.ctlColor1.AccessibleName = resources.GetString("ctlColor1.AccessibleName");
            this.ctlColor1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("ctlColor1.Anchor")));
            this.ctlColor1.AutoScroll = ((bool)(resources.GetObject("ctlColor1.AutoScroll")));
            this.ctlColor1.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("ctlColor1.AutoScrollMargin")));
            this.ctlColor1.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("ctlColor1.AutoScrollMinSize")));
            this.ctlColor1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("ctlColor1.BackgroundImage")));
            this.ctlColor1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("ctlColor1.Dock")));
            this.ctlColor1.Enabled = ((bool)(resources.GetObject("ctlColor1.Enabled")));
            this.ctlColor1.Font = ((System.Drawing.Font)(resources.GetObject("ctlColor1.Font")));
            this.ctlColor1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("ctlColor1.ImeMode")));
            this.ctlColor1.Location = ((System.Drawing.Point)(resources.GetObject("ctlColor1.Location")));
            this.ctlColor1.Name = "ctlColor1";
            this.ctlColor1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("ctlColor1.RightToLeft")));
            this.ctlColor1.Size = ((System.Drawing.Size)(resources.GetObject("ctlColor1.Size")));
            this.ctlColor1.TabIndex = ((int)(resources.GetObject("ctlColor1.TabIndex")));
            this.ctlColor1.Tag = "";
            this.ctlColor1.Visible = ((bool)(resources.GetObject("ctlColor1.Visible")));
            //
            // grpCol0
            //
            this.grpCol0.AccessibleDescription = resources.GetString("grpCol0.AccessibleDescription");
            this.grpCol0.AccessibleName = resources.GetString("grpCol0.AccessibleName");
            this.grpCol0.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("grpCol0.Anchor")));
            this.grpCol0.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("grpCol0.BackgroundImage")));
            this.grpCol0.Controls.Add(this.ctlColor0);
            this.grpCol0.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("grpCol0.Dock")));
            this.grpCol0.Enabled = ((bool)(resources.GetObject("grpCol0.Enabled")));
            this.grpCol0.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this.grpCol0.Font = ((System.Drawing.Font)(resources.GetObject("grpCol0.Font")));
            this.grpCol0.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("grpCol0.ImeMode")));
            this.grpCol0.Location = ((System.Drawing.Point)(resources.GetObject("grpCol0.Location")));
            this.grpCol0.Name = "grpCol0";
            this.grpCol0.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("grpCol0.RightToLeft")));
            this.grpCol0.Size = ((System.Drawing.Size)(resources.GetObject("grpCol0.Size")));
            this.grpCol0.TabIndex = ((int)(resources.GetObject("grpCol0.TabIndex")));
            this.grpCol0.TabStop = false;
            this.grpCol0.Text = resources.GetString("grpCol0.Text");
            this.grpCol0.Visible = ((bool)(resources.GetObject("grpCol0.Visible")));
            //
            // ctlColor0
            //
            this.ctlColor0.AccessibleDescription = resources.GetString("ctlColor0.AccessibleDescription");
            this.ctlColor0.AccessibleName = resources.GetString("ctlColor0.AccessibleName");
            this.ctlColor0.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("ctlColor0.Anchor")));
            this.ctlColor0.AutoScroll = ((bool)(resources.GetObject("ctlColor0.AutoScroll")));
            this.ctlColor0.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("ctlColor0.AutoScrollMargin")));
            this.ctlColor0.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("ctlColor0.AutoScrollMinSize")));
            this.ctlColor0.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("ctlColor0.BackgroundImage")));
            this.ctlColor0.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("ctlColor0.Dock")));
            this.ctlColor0.Enabled = ((bool)(resources.GetObject("ctlColor0.Enabled")));
            this.ctlColor0.Font = ((System.Drawing.Font)(resources.GetObject("ctlColor0.Font")));
            this.ctlColor0.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("ctlColor0.ImeMode")));
            this.ctlColor0.Location = ((System.Drawing.Point)(resources.GetObject("ctlColor0.Location")));
            this.ctlColor0.Name = "ctlColor0";
            this.ctlColor0.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("ctlColor0.RightToLeft")));
            this.ctlColor0.Size = ((System.Drawing.Size)(resources.GetObject("ctlColor0.Size")));
            this.ctlColor0.TabIndex = ((int)(resources.GetObject("ctlColor0.TabIndex")));
            this.ctlColor0.Tag = "";
            this.ctlColor0.Visible = ((bool)(resources.GetObject("ctlColor0.Visible")));
            //
            // grpCol3
            //
            this.grpCol3.AccessibleDescription = resources.GetString("grpCol3.AccessibleDescription");
            this.grpCol3.AccessibleName = resources.GetString("grpCol3.AccessibleName");
            this.grpCol3.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("grpCol3.Anchor")));
            this.grpCol3.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("grpCol3.BackgroundImage")));
            this.grpCol3.Controls.Add(this.ctlColor3);
            this.grpCol3.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("grpCol3.Dock")));
            this.grpCol3.Enabled = ((bool)(resources.GetObject("grpCol3.Enabled")));
            this.grpCol3.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this.grpCol3.Font = ((System.Drawing.Font)(resources.GetObject("grpCol3.Font")));
            this.grpCol3.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("grpCol3.ImeMode")));
            this.grpCol3.Location = ((System.Drawing.Point)(resources.GetObject("grpCol3.Location")));
            this.grpCol3.Name = "grpCol3";
            this.grpCol3.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("grpCol3.RightToLeft")));
            this.grpCol3.Size = ((System.Drawing.Size)(resources.GetObject("grpCol3.Size")));
            this.grpCol3.TabIndex = ((int)(resources.GetObject("grpCol3.TabIndex")));
            this.grpCol3.TabStop = false;
            this.grpCol3.Text = resources.GetString("grpCol3.Text");
            this.grpCol3.Visible = ((bool)(resources.GetObject("grpCol3.Visible")));
            //
            // ctlColor3
            //
            this.ctlColor3.AccessibleDescription = resources.GetString("ctlColor3.AccessibleDescription");
            this.ctlColor3.AccessibleName = resources.GetString("ctlColor3.AccessibleName");
            this.ctlColor3.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("ctlColor3.Anchor")));
            this.ctlColor3.AutoScroll = ((bool)(resources.GetObject("ctlColor3.AutoScroll")));
            this.ctlColor3.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("ctlColor3.AutoScrollMargin")));
            this.ctlColor3.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("ctlColor3.AutoScrollMinSize")));
            this.ctlColor3.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("ctlColor3.BackgroundImage")));
            this.ctlColor3.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("ctlColor3.Dock")));
            this.ctlColor3.Enabled = ((bool)(resources.GetObject("ctlColor3.Enabled")));
            this.ctlColor3.Font = ((System.Drawing.Font)(resources.GetObject("ctlColor3.Font")));
            this.ctlColor3.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("ctlColor3.ImeMode")));
            this.ctlColor3.Location = ((System.Drawing.Point)(resources.GetObject("ctlColor3.Location")));
            this.ctlColor3.Name = "ctlColor3";
            this.ctlColor3.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("ctlColor3.RightToLeft")));
            this.ctlColor3.Size = ((System.Drawing.Size)(resources.GetObject("ctlColor3.Size")));
            this.ctlColor3.TabIndex = ((int)(resources.GetObject("ctlColor3.TabIndex")));
            this.ctlColor3.Tag = "";
            this.ctlColor3.Visible = ((bool)(resources.GetObject("ctlColor3.Visible")));
            //
            // MaterialTevKColorPage
            //
            this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
            this.AccessibleName = resources.GetString("$this.AccessibleName");
            this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
            this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
            this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
            this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
            this.Controls.Add(this.grpCol3);
            this.Controls.Add(this.grpCol2);
            this.Controls.Add(this.grpCol1);
            this.Controls.Add(this.grpCol0);
            this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
            this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
            this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
            this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
            this.Name = "MaterialTevKColorPage";
            this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
            this.Size = ((System.Drawing.Size)(resources.GetObject("$this.Size")));
            this.grpCol2.ResumeLayout(false);
            this.grpCol1.ResumeLayout(false);
            this.grpCol0.ResumeLayout(false);
            this.grpCol3.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public MaterialTevKColorPage()
        {
            InitializeComponent();
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static ObjPropertyPage CreateInstance(object arg)
        {
            ObjPropertyPage page = new MaterialTevKColorPage();
            return page;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        public override PropertyPageID PageID
        {
            get { return PropertyPageID.MaterialTevKColor; }
        }



        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void InitializeProperty()
        {
            ctlColor0.Tag = 0;
            ctlColor1.Tag = 1;
            ctlColor2.Tag = 2;
            ctlColor3.Tag = 3;

            ctlColor0.ColorEdit += new ColorEditEventHandler(Event_CtlColor_ColorEdit);
            ctlColor1.ColorEdit += new ColorEditEventHandler(Event_CtlColor_ColorEdit);
            ctlColor2.ColorEdit += new ColorEditEventHandler(Event_CtlColor_ColorEdit);
            ctlColor3.ColorEdit += new ColorEditEventHandler(Event_CtlColor_ColorEdit);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void UpdateProperty()
        {
            TevKColors target = this.ActiveTarget.TevData.KColors;

            ctlColor0.Color = target[0].Color.ToColor();
            ctlColor1.Color = target[1].Color.ToColor();
            ctlColor2.Color = target[2].Color.ToColor();
            ctlColor3.Color = target[3].Color.ToColor();
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region コピー＆ペースト
        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy(){ return true; }

        /// <summary>
        /// コピー。
        /// </summary>
        public override Object Copy()
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static Object Copy(MaterialGUIAdapter target)
        {
            return new TevKColors(target.TevData.KColors);
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(Object pasteObject)
        {
            Paste(ActiveTarget, pasteObject);
            UpdateProperty();
            NotifyPropertyChanged();
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static void Paste(MaterialGUIAdapter destination, Object pasteObject)
        {
            Debug.Assert(pasteObject is TevKColors);
            TevKColors source = (TevKColors)pasteObject;
            destination.TevData.KColors.Set(source);

            // MCS
//			MaterialTevConstantColorMessage.Send(destination, source);
        }
        #endregion

        /// <summary>
        /// イベントハンドラ。
        /// </summary>
        private void Event_CtlColor_ColorEdit(object sender, ColorEditEventArgs e)
        {
            ColorEditPanel control = (ColorEditPanel)sender;
            int index = (int)control.Tag;
            if (e.EditFixed)
            {
                TevKColors     target  = this.ActiveTarget.TevData.KColors;
                target[index].Color.Set(e.Color);
                this.NotifyPropertyChanged();
            }

            // MCS
//			MaterialTevConstantColorMessage.Send(
//				this.ActiveTarget, index, new Rgba(e.Color));
        }
    }
}

