﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters
{
    /// <summary>
    /// テクスチャマネージャクラス。
    /// </summary>
    public sealed class TextureManager
    {
        // テクスチャリスト
        private static readonly List<Texture> _textures = new List<Texture>();
        // 最後にリセットされた時間
        public static DateTime LastResetTime { get; set; }

        /// <summary>
        /// 初期化処理。
        /// </summary>
        public static void Initialize()
        {
        }

        /// <summary>
        /// テクスチャリスト。
        /// </summary>
        public static IReadOnlyCollection<Texture> TexturesOwnedByCurrentSubScene
        {
            get { return _textures.Where((tex) => tex.IsOwnedByCurrentSubScene && !tex.IsHidingFromList).ToList().AsReadOnly(); }
        }

        /// <summary>
        /// テクスチャを追加。
        /// </summary>
        public static void Add(Texture texture)
        {
            Debug.Assert(texture != null);

            if(_textures.Find((tex) => tex.Name == texture.Name) == null)
            {
                _textures.Add(texture);
            }
        }

        /// <summary>
        /// テクスチャを削除。
        /// </summary>
        public static void Remove(Texture texture)
        {
            Debug.Assert(texture != null);
            Debug.Assert(_textures.Contains(texture));

            _textures.Remove(texture);
        }

        /// <summary>
        /// マネージャの内容をリセットします。
        /// </summary>
        public static void Reset()
        {
            LastResetTime = DateTime.Now;
            _textures.Clear();
        }

        /// <summary>
        /// テクスチャを名前で検索。
        /// </summary>
        public static Texture Search(string name)
        {
            Debug.Assert(name != null);

            return _textures.FirstOrDefault((tex) => tex.Name == name);
        }

        /// <summary>
        /// 利用可能なテクスチャを保持しているかどうか。
        /// </summary>
        public static bool HasUsableTextures()
        {
            // １個もなければ駄目
            if (TexturesOwnedByCurrentSubScene.Count == 0)
            {
                return false;
            }
            return true;
        }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TextureManager() {}
    }
}
