﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.Diagnostics;
using System.IO;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters
{

    /// <summary>
    /// Guiアダプタフォント
    /// </summary>
    public sealed class GuiFont
    {
        /// <summary>
        /// フォントファイル名
        /// </summary>
        readonly string _fontPath = string.Empty;


        /// <summary>
        /// フォントファイル名を取得します。
        /// </summary>
        public string FileName
        {
            get { return Path.GetFileNameWithoutExtension(_fontPath); }
        }

        /// <summary>
        /// フォントファイル名を取得します。
        /// </summary>
        public string FontPath
        {
            get { return _fontPath; }
        }

        /// <summary>
        /// フォントファイル名を取得します。
        /// </summary>
        public string FontName
        {
            get;
            set;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="fileName"></param>
        public GuiFont(string fontPath, string fontName)
        {
            _fontPath = fontPath;
            FontName = fontName;
        }
    }

    /// <summary>
    /// フォントマネージャクラス。
    /// GUIアダプタのためのフォントマネージャです。
    /// 余り意味のある働きをしていないので、
    /// 直接、LECoreのフォントマネージャを参照しても問題ないでしょう。
    /// モジュール依存性低減のために、現状のままとします。
    /// </summary>
    public sealed class FontManager
    {
        static readonly ArrayList     _guiFontSet = new ArrayList();

        /// <summary>
        /// 登録フォントセットを取得します。
        /// </summary>
        static public GuiFont[] GuiFontSet
        {
            get{ return _guiFontSet.ToArray( typeof( GuiFont ) ) as GuiFont[]; }
        }

        /// <summary>
        /// 初期化処理。
        /// </summary>
        public static void Initialize()
        {

        }



        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public FontManager() {}

        /// <summary>
        /// フォントを登録します。
        /// 重複登録は無視されます。
        /// </summary>
        /// <param name="font">Guiフォント</param>
        static public void Add( GuiFont font )
        {
            if (FindFontByFontName(font.FontName) == null)
            {
               _guiFontSet.Add( font );
            }
        }

        /// <summary>
        /// フォント登録をリセットします。
        /// </summary>
        static public void Reset()
        {
            _guiFontSet.Clear();
        }

        /// <summary>
        /// ファイル名でフォントを検索します。
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns>フォント・インスタンス</returns>
        static public GuiFont FindFontByFontName( string fontName )
        {
            foreach( GuiFont font in _guiFontSet )
            {
                if (font.FontName == fontName)
                {
                    return font;
                }
            }
            return null;
        }
    }
}


