﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Linq;
using System.Windows.Forms;
using System.Xml.Linq;

namespace LayoutEditor.Forms.ToolWindows.LayoutWindow
{
    using System.Text;
    using System.Xml.Serialization;
    using Dialogs;
    using LayoutEditor.Controls;
    using LayoutEditor.Utility;
    using LECore;
    using LECore.Manipulator;
    using LECore.Save_Load;
    using LECore.Structures;
    using LECore.Structures.Core;
    using LECore.Structures.Core.Command;
    using LECore.Util;
    using Structures.SerializableObject;

    /// <summary>
    /// LayoutWindow の概要の説明です。
    /// </summary>
    public class LayoutWindow :
        WeifenLuo.WinFormsUI.Docking.DockContent,
        ILEToolWindow,
        IViewManagerMessageSender
    {
        private IContainer components;

        #region 対象シーンセーブ状態

        /// <summary>
        /// サブシーン保存状態
        /// </summary>
        public class TargetSubSceneSaveState : LayoutDocument
        {
            public float Magnify { get; set; }
            public PointF ScreenOrigInScene { get; set; }

            /// <summary>
            /// コンストラクタ
            /// </summary
            public TargetSubSceneSaveState(LayoutDocument lytDoc, DateTime time)
                : base(lytDoc, time)
            {
            }
        }

        #endregion 対象シーンセーブ状態

        #region 対象シーンバイナリセーブ状態

        /// <summary>
        /// バイナリ出力情報
        /// </summary>
        struct BinaryFileExportingInfo
        {
            string _outPath;
            string _outFileName;

            /// <summary>
            /// 出力パス
            /// </summary>
            public string OutPath
            {
                get { return _outPath; }
            }

            /// <summary>
            /// 出力ファイル名
            /// </summary>
            public string OutFileName
            {
                get { return _outFileName; }
            }

            /// <summary>
            /// 設定
            /// </summary>
            public void Set(string outPath, string outFileName)
            {
                _outPath = outPath;
                _outFileName = outFileName;
            }
        }

        #endregion 対象シーンバイナリセーブ状態

        #region デザイナ生成コード
        #region デザイナ変数

        private System.Windows.Forms.Panel pnlClient;

        // 子コントロール
        private MainViewBar _mainViewBar = null;


        private System.Windows.Forms.StatusBarPanel _pnlPaneState;
        private System.Windows.Forms.StatusBarPanel _pnlZoomDummy;

        private LayoutEditor.Forms.ToolWindows.LayoutWindow.MainView _mainView;
        private System.Windows.Forms.StatusBar _stbMainView;
        private StatusBarPanel _pnlMouseMode;
        private StatusBarPanel _pnlTransMode;
        private ImageList _imgTransMode;
        private MenuStrip _mspMain;
        private ToolStripMenuItem _tmiFile;
        private ToolStripMenuItem _tmiEdit;
        private ToolStripMenuItem _tmiPane;
        private ToolStripMenuItem _tmiSelect;
        private ToolStripMenuItem _tmiView;
        private ToolStripMenuItem _tmiTool;
        private ToolStripMenuItem _tmiDebug;
        private ToolStripMenuItem _tmiOpenAsAddition;
        private ToolStripMenuItem _tmiSave;
        private ToolStripMenuItem _tmiSaveAs;
        private ToolStripMenuItem _tmiClose;
        private ToolStripMenuItem _tmiClose2;
        private ToolStripSeparator toolStripSeparator1;
        private ToolStripMenuItem _tmiExportBinary;
        private ToolStripMenuItem _tmiEditUndo;
        private ToolStripMenuItem _tmiEditRedo;
        private ToolStripSeparator toolStripSeparator2;
        private ToolStripMenuItem _tmiEditCut;
        private ToolStripMenuItem _tmiEditCopy;
        private ToolStripMenuItem _tmiEditPaste;
        private ToolStripMenuItem _tmiEditDelete;
        private ToolStripMenuItem _tmiEditCopyAnimation;
        private ToolStripSeparator toolStripSeparator3;
        private ToolStripMenuItem _tmiPaneCreatePane;
        private ToolStripMenuItem _tmiPaneSetHire;
        private ToolStripMenuItem _tmiPaneResetHire;
        private ToolStripMenuItem _tmiPaneMakeGroup;
        private ToolStripMenuItem _tmiPaneEditGroup;
        private ToolStripMenuItem _tmiPaneLockSelected;
        private ToolStripMenuItem _tmiPaneUnlockSelected;
        private ToolStripMenuItem _tmiPaneHideLocked;
        private ToolStripMenuItem _tmiPaneLockRegionPane;
        private ToolStripMenuItem _tmiPaneHideSlected;
        private ToolStripMenuItem _tmiPaneShowAllHidden;
        private ToolStripMenuItem _tmiPaneLockHidden;
        private ToolStripSeparator toolStripSeparator4;
        private ToolStripSeparator toolStripSeparator5;
        private ToolStripSeparator toolStripSeparator6;
        private ToolStripSeparator toolStripSeparator7;
        private ToolStripSeparator toolStripSeparator8;
        private ToolStripMenuItem _tmiPaneProperty;
        private ToolStripMenuItem _tmiPaneCreatePaneNull;
        private ToolStripMenuItem _tmiPaneCreatePanePicture;
        private ToolStripMenuItem _tmiPaneCreatePaneTextbox;
        private ToolStripMenuItem _tmiPaneCreatePaneWindow;
        private ToolStripMenuItem _tmiPaneCreatePaneRegion;
        private ToolStripMenuItem _tmiPaneTransAffectsChildren;
        private ToolStripMenuItem _tmiSelectAll;
        private ToolStripMenuItem _tmiSelectReset;
        private ToolStripMenuItem _tmiSelectInvert;
        private ToolStripSeparator toolStripSeparator9;
        private ToolStripMenuItem _tmiSelectPrev;
        private ToolStripMenuItem _tmiSelectNext;
        private ToolStripMenuItem _tmiViewOutline;
        private ToolStripMenuItem _tmiViewBoundingBoxDisabled;
        private ToolStripMenuItem _tmiViewZoomIn;
        private ToolStripSeparator toolStripSeparator11;
        private ToolStripMenuItem _tmiViewZoomOut;
        private ToolStripMenuItem _tmiViewWindowExpand;
        private ToolStripMenuItem _tmiViewWindowShrink;
        private ToolStripMenuItem _tmiViewAll;
        private ToolStripMenuItem _tmiViewForcus;
        private ToolStripSeparator toolStripSeparator12;
        private ToolStripMenuItem _tmiViewShowGrid;
        private ToolStripMenuItem _tmiViewSnapToGrid;
        private ToolStripMenuItem _tmiToolTransportToViewer;
        private ToolStripMenuItem _tmiDebugShowDebugDraw;
        private ToolStripMenuItem _tmiDeleteUnusedFont;
        private ToolStripMenuItem _tmiTextureFileSetImport;
        private ToolStripSeparator toolStripSeparator13;
        private ToolStripMenuItem _tmiPaneDragModifiesSize;
        private ToolStripMenuItem _tmiSetTextureFontPath;
        private ToolStripSeparator toolStripSeparator15;
        private ToolStripSeparator toolStripSeparator14;
        private ToolStripMenuItem _tmiToolTransportToViewerForceAnimMode;
        private ToolStripSeparator toolStripSeparator10;
        private ToolStripMenuItem _tmiReloadPartsPane;
        private ToolStripMenuItem _tmiCreatePartsBySelectedNull;
        private ToolStripMenuItem tmiLaunchAEViewer;
        private ToolStripMenuItem _tmiCapturePCViewer;
        private ToolStripMenuItem _tmiOpenPartsLayout;
        private ToolStripMenuItem _tmiPaneTreeCompression;
        private ToolStripMenuItem _tmiViewBoundingPaneEnabled;
        private LayoutEditor.Controls.UI.UIButton _btnParts;
        private StatusBarPanel _pnlPartsDummy;
        private LayoutEditor.Controls.UIPictureBox _pnlOriginalLayout;
        private LayoutEditor.Controls.DockContentToolTip _ttpMain;
        private LayoutEditor.Controls.DockContentToolTip _ttpPartsAutoReloaded;
        private Timer _timerAutoReloadMsg;
        private ToolStripMenuItem _tmiViewPartsPaneEnabled;
        private StatusBarPanel _pnlMetrics;
        private LayoutEditor.Controls.UI.UIButton _btnMetrics;
        private StatusBarPanel _pnlPerspective;
        private LayoutEditor.Controls.UI.UIButton _btnPersepective;
        private ToolStripMenuItem _tmiAlignment;
        private ToolStripMenuItem _tmiAlignmentL;
        private ToolStripMenuItem _tmiAlignmentHC;
        private ToolStripMenuItem _tmiAlignmentR;
        private ToolStripSeparator toolStripSeparator17;
        private ToolStripMenuItem _tmiAlignmentT;
        private ToolStripMenuItem _tmiAlignmentVC;
        private ToolStripMenuItem _tmiAlignmentB;
        private ToolStripSeparator toolStripSeparator16;
        private ToolStripMenuItem _tmiAlignmentTrimH;
        private ToolStripMenuItem _tmiAlignmentTrimV;
        private ToolStripMenuItem _tmiResizeToTextureSize;
        private ToolStripSeparator _tssUserCommand;
        private ToolStripMenuItem _tmiUserCommand;
        private ToolStripMenuItem _tmiPaneCreatePaneCapture;
        private ToolStripMenuItem _tmiCreateCapturePaneWithChildren;
        private ToolStripMenuItem _tmiViewCapturePaneEnabled;
        private ToolStripMenuItem _tmiPaneCreatePaneAlignment;
        private ToolStripMenuItem _tmiPaneCreatePaneScissor;
        private ToolStripSeparator toolStripMenuItem1;
        private ToolStripMenuItem _tmiAsChild;
        private ToolStripMenuItem _tmiAsParent;
        private ToolStripMenuItem _tmiCreateNullPaneAndAddChild;
        private ToolStripMenuItem _tmiEditDuplicate;
        private ToolStripSeparator _toolStripMenuItemForCombinerEditor;
        private ToolStripMenuItem _tmiLaunchCombinerEditor;
        private ToolStripSeparator toolStripSeparator18;


        #endregion デザイナ変数


        #region Windows フォーム デザイナで生成されたコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(LayoutWindow));
            LECore.Structures.Core.DrawableOption drawableOption1 = new LECore.Structures.Core.DrawableOption();
            this.pnlClient = new System.Windows.Forms.Panel();
            this._pnlOriginalLayout = new LayoutEditor.Controls.UIPictureBox();
            this._mainView = new LayoutEditor.Forms.ToolWindows.LayoutWindow.MainView();
            this._stbMainView = new System.Windows.Forms.StatusBar();
            this._pnlPaneState = new System.Windows.Forms.StatusBarPanel();
            this._pnlMouseMode = new System.Windows.Forms.StatusBarPanel();
            this._pnlMetrics = new System.Windows.Forms.StatusBarPanel();
            this._pnlTransMode = new System.Windows.Forms.StatusBarPanel();
            this._pnlPerspective = new System.Windows.Forms.StatusBarPanel();
            this._pnlPartsDummy = new System.Windows.Forms.StatusBarPanel();
            this._pnlZoomDummy = new System.Windows.Forms.StatusBarPanel();
            this._imgTransMode = new System.Windows.Forms.ImageList(this.components);
            this._mspMain = new System.Windows.Forms.MenuStrip();
            this._tmiFile = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiOpenAsAddition = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiSave = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiSaveAs = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiClose = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiClose2 = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiExportBinary = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiEdit = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiEditUndo = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiEditRedo = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiEditCut = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiEditCopy = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiEditPaste = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiEditDuplicate = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiEditDelete = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator13 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiEditCopyAnimation = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator3 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiPane = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneCreatePane = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneCreatePaneNull = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneCreatePanePicture = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneCreatePaneTextbox = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneCreatePaneWindow = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneCreatePaneRegion = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneCreatePaneCapture = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneCreatePaneAlignment = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneCreatePaneScissor = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator4 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiPaneSetHire = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneResetHire = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneTransAffectsChildren = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneDragModifiesSize = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator5 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiPaneMakeGroup = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneEditGroup = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator6 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiPaneLockSelected = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneUnlockSelected = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneHideLocked = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneLockRegionPane = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator7 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiPaneHideSlected = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneShowAllHidden = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneLockHidden = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator18 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiAlignment = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiAlignmentL = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiAlignmentHC = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiAlignmentR = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator17 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiAlignmentT = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiAlignmentVC = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiAlignmentB = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator16 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiAlignmentTrimH = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiAlignmentTrimV = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiResizeToTextureSize = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiCreateCapturePaneWithChildren = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator8 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiPaneProperty = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator10 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiReloadPartsPane = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiCreatePartsBySelectedNull = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiOpenPartsLayout = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem1 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiAsChild = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiAsParent = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiCreateNullPaneAndAddChild = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiSelect = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiSelectAll = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiSelectReset = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiSelectInvert = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator9 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiSelectPrev = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiSelectNext = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiView = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewOutline = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewBoundingBoxDisabled = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewBoundingPaneEnabled = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewPartsPaneEnabled = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewCapturePaneEnabled = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator11 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiViewZoomIn = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewZoomOut = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewWindowExpand = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewWindowShrink = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewAll = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewForcus = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator12 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiViewShowGrid = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiViewSnapToGrid = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiTool = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiDeleteUnusedFont = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiTextureFileSetImport = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiSetTextureFontPath = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator15 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiToolTransportToViewer = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiToolTransportToViewerForceAnimMode = new System.Windows.Forms.ToolStripMenuItem();
            this.tmiLaunchAEViewer = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator14 = new System.Windows.Forms.ToolStripSeparator();
            this._tmiCapturePCViewer = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiPaneTreeCompression = new System.Windows.Forms.ToolStripMenuItem();
            this._tssUserCommand = new System.Windows.Forms.ToolStripSeparator();
            this._tmiUserCommand = new System.Windows.Forms.ToolStripMenuItem();
            this._toolStripMenuItemForCombinerEditor = new System.Windows.Forms.ToolStripSeparator();
            this._tmiLaunchCombinerEditor = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiDebug = new System.Windows.Forms.ToolStripMenuItem();
            this._tmiDebugShowDebugDraw = new System.Windows.Forms.ToolStripMenuItem();
            this._timerAutoReloadMsg = new System.Windows.Forms.Timer(this.components);
            this._btnPersepective = new LayoutEditor.Controls.UI.UIButton();
            this._btnMetrics = new LayoutEditor.Controls.UI.UIButton();
            this._btnParts = new LayoutEditor.Controls.UI.UIButton();
            this._mainViewBar = new LayoutEditor.Forms.ToolWindows.LayoutWindow.MainViewBar();
            this._ttpMain = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this._ttpPartsAutoReloaded = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this.pnlClient.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._pnlOriginalLayout)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._pnlPaneState)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._pnlMouseMode)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._pnlMetrics)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._pnlTransMode)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._pnlPerspective)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._pnlPartsDummy)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this._pnlZoomDummy)).BeginInit();
            this._mspMain.SuspendLayout();
            this.SuspendLayout();
            //
            // pnlClient
            //
            this.pnlClient.BackColor = System.Drawing.SystemColors.ControlDarkDark;
            this.pnlClient.Controls.Add(this._pnlOriginalLayout);
            this.pnlClient.Controls.Add(this._mainView);
            resources.ApplyResources(this.pnlClient, "pnlClient");
            this.pnlClient.Name = "pnlClient";
            //
            // _pnlOriginalLayout
            //
            resources.ApplyResources(this._pnlOriginalLayout, "_pnlOriginalLayout");
            this._pnlOriginalLayout.BackColor = System.Drawing.SystemColors.Control;
            this._pnlOriginalLayout.DrawCheckBG = false;
            this._pnlOriginalLayout.Name = "_pnlOriginalLayout";
            this._pnlOriginalLayout.StretchDraw = true;
            this._pnlOriginalLayout.TabStop = false;
            this._ttpMain.SetToolTip(this._pnlOriginalLayout, resources.GetString("_pnlOriginalLayout.ToolTip"));
            this._pnlOriginalLayout.Click += new System.EventHandler(this.Event_pnlOriginalLayout_Click);
            //
            // _mainView
            //
            this._mainView._TargetActiveSubScene = null;
            this._mainView.AllowDrop = true;
            this._mainView.BackColor = System.Drawing.SystemColors.ControlDark;
            resources.ApplyResources(this._mainView, "_mainView");
            drawableOption1.DrawableOptionFlag = LECore.Structures.Core.DrawableOptionFlag.None;
            drawableOption1.SystemBlue = System.Drawing.Color.Blue;
            drawableOption1.SystemDarkRed = System.Drawing.Color.DarkRed;
            drawableOption1.SystemGray = System.Drawing.Color.Gray;
            drawableOption1.SystemGreen = System.Drawing.Color.Green;
            drawableOption1.SystemOpeBlue = System.Drawing.Color.FromArgb(((int)(((byte)(64)))), ((int)(((byte)(0)))), ((int)(((byte)(0)))), ((int)(((byte)(255)))));
            drawableOption1.SystemOpeGreen = System.Drawing.Color.FromArgb(((int)(((byte)(64)))), ((int)(((byte)(0)))), ((int)(((byte)(128)))), ((int)(((byte)(0)))));
            drawableOption1.SystemOpeMagenta = System.Drawing.Color.FromArgb(((int)(((byte)(64)))), ((int)(((byte)(255)))), ((int)(((byte)(0)))), ((int)(((byte)(255)))));
            drawableOption1.SystemOpeYellow = System.Drawing.Color.FromArgb(((int)(((byte)(64)))), ((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(0)))));
            drawableOption1.SystemRed = System.Drawing.Color.Red;
            drawableOption1.SystemWhite = System.Drawing.Color.White;
            drawableOption1.TerminateDrawTraverse = false;
            this._mainView.DrawableOption = drawableOption1;
            this._mainView.Magnify = 1F;
            this._mainView.Name = "_mainView";
            this._mainView.PaneDragModifierChangesSize = true;
            this._mainView.ScreenOrigInScene = ((System.Drawing.PointF)(resources.GetObject("_mainView.ScreenOrigInScene")));
            this._mainView.TargetSubScene = null;
            this._ttpPartsAutoReloaded.SetToolTip(this._mainView, resources.GetString("_mainView.ToolTip"));
            this._mainView.TransAffectsChildren = false;
            this._mainView.TransAffectsChildrenFlip = true;
            this._mainView.DragDrop += new System.Windows.Forms.DragEventHandler(this.Event_MainView_DragDrop);
            this._mainView.DragEnter += new System.Windows.Forms.DragEventHandler(this.Event_MainView_DragEnter);
            //
            // _stbMainView
            //
            resources.ApplyResources(this._stbMainView, "_stbMainView");
            this._stbMainView.Name = "_stbMainView";
            this._stbMainView.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
            this._pnlPaneState,
            this._pnlMouseMode,
            this._pnlMetrics,
            this._pnlTransMode,
            this._pnlPerspective,
            this._pnlPartsDummy,
            this._pnlZoomDummy});
            this._stbMainView.ShowPanels = true;
            this._stbMainView.SizeChanged += new System.EventHandler(this.Event_stbMainView_SizeChanged);
            //
            // _pnlPaneState
            //
            this._pnlPaneState.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
            resources.ApplyResources(this._pnlPaneState, "_pnlPaneState");
            //
            // _pnlMouseMode
            //
            resources.ApplyResources(this._pnlMouseMode, "_pnlMouseMode");
            //
            // _pnlMetrics
            //
            resources.ApplyResources(this._pnlMetrics, "_pnlMetrics");
            //
            // _pnlTransMode
            //
            resources.ApplyResources(this._pnlTransMode, "_pnlTransMode");
            //
            // _pnlPerspective
            //
            resources.ApplyResources(this._pnlPerspective, "_pnlPerspective");
            //
            // _pnlPartsDummy
            //
            resources.ApplyResources(this._pnlPartsDummy, "_pnlPartsDummy");
            //
            // _pnlZoomDummy
            //
            this._pnlZoomDummy.BorderStyle = System.Windows.Forms.StatusBarPanelBorderStyle.None;
            resources.ApplyResources(this._pnlZoomDummy, "_pnlZoomDummy");
            //
            // _imgTransMode
            //
            this._imgTransMode.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("_imgTransMode.ImageStream")));
            this._imgTransMode.TransparentColor = System.Drawing.Color.Transparent;
            this._imgTransMode.Images.SetKeyName(0, "layout_mousemode_hier_on_16.ico");
            this._imgTransMode.Images.SetKeyName(1, "layout_mousemode_hier_off_16.ico");
            //
            // _mspMain
            //
            this._mspMain.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiFile,
            this._tmiEdit,
            this._tmiPane,
            this._tmiSelect,
            this._tmiView,
            this._tmiTool,
            this._tmiDebug});
            resources.ApplyResources(this._mspMain, "_mspMain");
            this._mspMain.Name = "_mspMain";
            //
            // _tmiFile
            //
            this._tmiFile.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiOpenAsAddition,
            this._tmiSave,
            this._tmiSaveAs,
            this._tmiClose,
            this._tmiClose2,
            this.toolStripSeparator1,
            this._tmiExportBinary});
            this._tmiFile.MergeAction = System.Windows.Forms.MergeAction.MatchOnly;
            this._tmiFile.MergeIndex = 0;
            this._tmiFile.Name = "_tmiFile";
            resources.ApplyResources(this._tmiFile, "_tmiFile");
            //
            // _tmiOpenAsAddition
            //
            this._tmiOpenAsAddition.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiOpenAsAddition.MergeIndex = 2;
            this._tmiOpenAsAddition.Name = "_tmiOpenAsAddition";
            resources.ApplyResources(this._tmiOpenAsAddition, "_tmiOpenAsAddition");
            this._tmiOpenAsAddition.Click += new System.EventHandler(this.Event_MniOpenAsAddition_Click);
            //
            // _tmiSave
            //
            this._tmiSave.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiSave.MergeIndex = 3;
            this._tmiSave.Name = "_tmiSave";
            resources.ApplyResources(this._tmiSave, "_tmiSave");
            this._tmiSave.Click += new System.EventHandler(this.Event_MniFileSave_Click);
            //
            // _tmiSaveAs
            //
            this._tmiSaveAs.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiSaveAs.MergeIndex = 4;
            this._tmiSaveAs.Name = "_tmiSaveAs";
            resources.ApplyResources(this._tmiSaveAs, "_tmiSaveAs");
            this._tmiSaveAs.Click += new System.EventHandler(this.Event_MniSaveAs_Click);
            //
            // _tmiClose
            //
            this._tmiClose.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiClose.MergeIndex = 5;
            this._tmiClose.Name = "_tmiClose";
            resources.ApplyResources(this._tmiClose, "_tmiClose");
            this._tmiClose.Click += new System.EventHandler(this.Event_MniClose_Click);
            //
            // _tmiClose2
            //
            this._tmiClose2.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiClose2.MergeIndex = 6;
            this._tmiClose2.Name = "_tmiClose2";
            resources.ApplyResources(this._tmiClose2, "_tmiClose2");
            this._tmiClose2.Click += new System.EventHandler(this.Event_MniClose_Click);
            //
            // toolStripSeparator1
            //
            this.toolStripSeparator1.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this.toolStripSeparator1.MergeIndex = 7;
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            resources.ApplyResources(this.toolStripSeparator1, "toolStripSeparator1");
            //
            // _tmiExportBinary
            //
            this._tmiExportBinary.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiExportBinary.MergeIndex = 8;
            this._tmiExportBinary.Name = "_tmiExportBinary";
            resources.ApplyResources(this._tmiExportBinary, "_tmiExportBinary");
            this._tmiExportBinary.Click += new System.EventHandler(this.Event_MniExportBinary_Click);
            //
            // _tmiEdit
            //
            this._tmiEdit.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiEditUndo,
            this._tmiEditRedo,
            this.toolStripSeparator2,
            this._tmiEditCut,
            this._tmiEditCopy,
            this._tmiEditPaste,
            this._tmiEditDuplicate,
            this._tmiEditDelete,
            this.toolStripSeparator13,
            this._tmiEditCopyAnimation,
            this.toolStripSeparator3});
            this._tmiEdit.MergeAction = System.Windows.Forms.MergeAction.MatchOnly;
            this._tmiEdit.MergeIndex = 8;
            this._tmiEdit.Name = "_tmiEdit";
            resources.ApplyResources(this._tmiEdit, "_tmiEdit");
            //
            // _tmiEditUndo
            //
            this._tmiEditUndo.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiEditUndo.MergeIndex = 0;
            this._tmiEditUndo.Name = "_tmiEditUndo";
            resources.ApplyResources(this._tmiEditUndo, "_tmiEditUndo");
            this._tmiEditUndo.Click += new System.EventHandler(this.Event_MniEditUndo);
            //
            // _tmiEditRedo
            //
            this._tmiEditRedo.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiEditRedo.MergeIndex = 1;
            this._tmiEditRedo.Name = "_tmiEditRedo";
            resources.ApplyResources(this._tmiEditRedo, "_tmiEditRedo");
            this._tmiEditRedo.Click += new System.EventHandler(this.Event_MniEditRedo);
            //
            // toolStripSeparator2
            //
            this.toolStripSeparator2.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this.toolStripSeparator2.MergeIndex = 2;
            this.toolStripSeparator2.Name = "toolStripSeparator2";
            resources.ApplyResources(this.toolStripSeparator2, "toolStripSeparator2");
            //
            // _tmiEditCut
            //
            this._tmiEditCut.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiEditCut.MergeIndex = 3;
            this._tmiEditCut.Name = "_tmiEditCut";
            resources.ApplyResources(this._tmiEditCut, "_tmiEditCut");
            this._tmiEditCut.Click += new System.EventHandler(this.Event_MniEditCut);
            //
            // _tmiEditCopy
            //
            this._tmiEditCopy.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiEditCopy.MergeIndex = 4;
            this._tmiEditCopy.Name = "_tmiEditCopy";
            resources.ApplyResources(this._tmiEditCopy, "_tmiEditCopy");
            this._tmiEditCopy.Click += new System.EventHandler(this.Event_MniEditCopy);
            //
            // _tmiEditPaste
            //
            this._tmiEditPaste.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiEditPaste.MergeIndex = 5;
            this._tmiEditPaste.Name = "_tmiEditPaste";
            resources.ApplyResources(this._tmiEditPaste, "_tmiEditPaste");
            this._tmiEditPaste.Click += new System.EventHandler(this.Event_MniEditPaste);
            //
            // _tmiEditDuplicate
            //
            this._tmiEditDuplicate.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiEditDuplicate.MergeIndex = 6;
            this._tmiEditDuplicate.Name = "_tmiEditDuplicate";
            resources.ApplyResources(this._tmiEditDuplicate, "_tmiEditDuplicate");
            this._tmiEditDuplicate.Click += new System.EventHandler(this.Event_MniEditDuplicate);
            //
            // _tmiEditDelete
            //
            this._tmiEditDelete.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiEditDelete.MergeIndex = 7;
            this._tmiEditDelete.Name = "_tmiEditDelete";
            resources.ApplyResources(this._tmiEditDelete, "_tmiEditDelete");
            this._tmiEditDelete.Click += new System.EventHandler(this.Event_MniEditDelete);
            //
            // toolStripSeparator13
            //
            this.toolStripSeparator13.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this.toolStripSeparator13.MergeIndex = 8;
            this.toolStripSeparator13.Name = "toolStripSeparator13";
            resources.ApplyResources(this.toolStripSeparator13, "toolStripSeparator13");
            //
            // _tmiEditCopyAnimation
            //
            this._tmiEditCopyAnimation.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiEditCopyAnimation.MergeIndex = 9;
            this._tmiEditCopyAnimation.Name = "_tmiEditCopyAnimation";
            resources.ApplyResources(this._tmiEditCopyAnimation, "_tmiEditCopyAnimation");
            this._tmiEditCopyAnimation.Click += new System.EventHandler(this.Event_MniCopyAnimation_Click);
            this._tmiEditCopyAnimation.Paint += new System.Windows.Forms.PaintEventHandler(this.Event_MniEdit_Paint);
            //
            // toolStripSeparator3
            //
            this.toolStripSeparator3.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this.toolStripSeparator3.MergeIndex = 9;
            this.toolStripSeparator3.Name = "toolStripSeparator3";
            resources.ApplyResources(this.toolStripSeparator3, "toolStripSeparator3");
            //
            // _tmiPane
            //
            this._tmiPane.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiPaneCreatePane,
            this.toolStripSeparator4,
            this._tmiPaneSetHire,
            this._tmiPaneResetHire,
            this._tmiPaneTransAffectsChildren,
            this._tmiPaneDragModifiesSize,
            this.toolStripSeparator5,
            this._tmiPaneMakeGroup,
            this._tmiPaneEditGroup,
            this.toolStripSeparator6,
            this._tmiPaneLockSelected,
            this._tmiPaneUnlockSelected,
            this._tmiPaneHideLocked,
            this._tmiPaneLockRegionPane,
            this.toolStripSeparator7,
            this._tmiPaneHideSlected,
            this._tmiPaneShowAllHidden,
            this._tmiPaneLockHidden,
            this.toolStripSeparator18,
            this._tmiAlignment,
            this._tmiResizeToTextureSize,
            this._tmiCreateCapturePaneWithChildren,
            this.toolStripSeparator8,
            this._tmiPaneProperty,
            this.toolStripSeparator10,
            this._tmiReloadPartsPane,
            this._tmiCreatePartsBySelectedNull,
            this._tmiOpenPartsLayout,
            this.toolStripMenuItem1,
            this._tmiAsChild,
            this._tmiAsParent,
            this._tmiCreateNullPaneAndAddChild});
            this._tmiPane.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiPane.MergeIndex = 2;
            this._tmiPane.Name = "_tmiPane";
            resources.ApplyResources(this._tmiPane, "_tmiPane");
            this._tmiPane.DropDownOpened += new System.EventHandler(this.Event_TmiPane_DropDownOpened);
            //
            // _tmiPaneCreatePane
            //
            this._tmiPaneCreatePane.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiPaneCreatePaneNull,
            this._tmiPaneCreatePanePicture,
            this._tmiPaneCreatePaneTextbox,
            this._tmiPaneCreatePaneWindow,
            this._tmiPaneCreatePaneRegion,
            this._tmiPaneCreatePaneCapture,
            this._tmiPaneCreatePaneAlignment,
            this._tmiPaneCreatePaneScissor});
            this._tmiPaneCreatePane.MergeIndex = 0;
            this._tmiPaneCreatePane.Name = "_tmiPaneCreatePane";
            resources.ApplyResources(this._tmiPaneCreatePane, "_tmiPaneCreatePane");
            //
            // _tmiPaneCreatePaneNull
            //
            this._tmiPaneCreatePaneNull.Name = "_tmiPaneCreatePaneNull";
            resources.ApplyResources(this._tmiPaneCreatePaneNull, "_tmiPaneCreatePaneNull");
            this._tmiPaneCreatePaneNull.Click += new System.EventHandler(this.Event_MniObjectCreatePaneNull_Click);
            //
            // _tmiPaneCreatePanePicture
            //
            this._tmiPaneCreatePanePicture.Name = "_tmiPaneCreatePanePicture";
            resources.ApplyResources(this._tmiPaneCreatePanePicture, "_tmiPaneCreatePanePicture");
            this._tmiPaneCreatePanePicture.Click += new System.EventHandler(this.Event_MniObjectCreatePanePicture_Click);
            //
            // _tmiPaneCreatePaneTextbox
            //
            this._tmiPaneCreatePaneTextbox.Name = "_tmiPaneCreatePaneTextbox";
            resources.ApplyResources(this._tmiPaneCreatePaneTextbox, "_tmiPaneCreatePaneTextbox");
            this._tmiPaneCreatePaneTextbox.Click += new System.EventHandler(this.Event_MniObjectCreatePaneTextbox_Click);
            //
            // _tmiPaneCreatePaneWindow
            //
            this._tmiPaneCreatePaneWindow.Name = "_tmiPaneCreatePaneWindow";
            resources.ApplyResources(this._tmiPaneCreatePaneWindow, "_tmiPaneCreatePaneWindow");
            this._tmiPaneCreatePaneWindow.Click += new System.EventHandler(this.Event_MniObjectCreatePaneWindow_Click);
            //
            // _tmiPaneCreatePaneRegion
            //
            this._tmiPaneCreatePaneRegion.Name = "_tmiPaneCreatePaneRegion";
            resources.ApplyResources(this._tmiPaneCreatePaneRegion, "_tmiPaneCreatePaneRegion");
            this._tmiPaneCreatePaneRegion.Click += new System.EventHandler(this.Event_MniObjectCreatePaneBounding_Click);
            //
            // _tmiPaneCreatePaneCapture
            //
            this._tmiPaneCreatePaneCapture.Name = "_tmiPaneCreatePaneCapture";
            resources.ApplyResources(this._tmiPaneCreatePaneCapture, "_tmiPaneCreatePaneCapture");
            this._tmiPaneCreatePaneCapture.Click += new System.EventHandler(this.Event_MniObjectCreatePaneCapture_Click);
            //
            // _tmiPaneCreatePaneAlignment
            //
            this._tmiPaneCreatePaneAlignment.Name = "_tmiPaneCreatePaneAlignment";
            resources.ApplyResources(this._tmiPaneCreatePaneAlignment, "_tmiPaneCreatePaneAlignment");
            this._tmiPaneCreatePaneAlignment.Click += new System.EventHandler(this.Event_MniObjectCreatePaneAddAlignment_Click);
            //
            // _tmiPaneCreatePaneScissor
            //
            this._tmiPaneCreatePaneScissor.Name = "_tmiPaneCreatePaneScissor";
            resources.ApplyResources(this._tmiPaneCreatePaneScissor, "_tmiPaneCreatePaneScissor");
            this._tmiPaneCreatePaneScissor.Click += new System.EventHandler(this.Event_MniObjectCreatePaneScissor_Click);
            //
            // toolStripSeparator4
            //
            this.toolStripSeparator4.MergeIndex = 0;
            this.toolStripSeparator4.Name = "toolStripSeparator4";
            resources.ApplyResources(this.toolStripSeparator4, "toolStripSeparator4");
            //
            // _tmiPaneSetHire
            //
            this._tmiPaneSetHire.MergeIndex = 0;
            this._tmiPaneSetHire.Name = "_tmiPaneSetHire";
            resources.ApplyResources(this._tmiPaneSetHire, "_tmiPaneSetHire");
            this._tmiPaneSetHire.Click += new System.EventHandler(this.Event_MniObjectMakeHier_Click);
            //
            // _tmiPaneResetHire
            //
            this._tmiPaneResetHire.MergeIndex = 0;
            this._tmiPaneResetHire.Name = "_tmiPaneResetHire";
            resources.ApplyResources(this._tmiPaneResetHire, "_tmiPaneResetHire");
            this._tmiPaneResetHire.Click += new System.EventHandler(this.Event_MniObjectBreakHier_Click);
            //
            // _tmiPaneTransAffectsChildren
            //
            this._tmiPaneTransAffectsChildren.MergeIndex = 0;
            this._tmiPaneTransAffectsChildren.Name = "_tmiPaneTransAffectsChildren";
            resources.ApplyResources(this._tmiPaneTransAffectsChildren, "_tmiPaneTransAffectsChildren");
            this._tmiPaneTransAffectsChildren.Click += new System.EventHandler(this.Event_MniTransAffectsChildren_Click);
            this._tmiPaneTransAffectsChildren.Paint += new System.Windows.Forms.PaintEventHandler(this.Event_TmiPane_Paint);
            //
            // _tmiPaneDragModifiesSize
            //
            this._tmiPaneDragModifiesSize.Name = "_tmiPaneDragModifiesSize";
            resources.ApplyResources(this._tmiPaneDragModifiesSize, "_tmiPaneDragModifiesSize");
            this._tmiPaneDragModifiesSize.Click += new System.EventHandler(this.Event_TmiPaneDragModifiesSize_Click);
            this._tmiPaneDragModifiesSize.Paint += new System.Windows.Forms.PaintEventHandler(this.Event_TmiPane_Paint);
            //
            // toolStripSeparator5
            //
            this.toolStripSeparator5.MergeIndex = 0;
            this.toolStripSeparator5.Name = "toolStripSeparator5";
            resources.ApplyResources(this.toolStripSeparator5, "toolStripSeparator5");
            //
            // _tmiPaneMakeGroup
            //
            this._tmiPaneMakeGroup.MergeIndex = 0;
            this._tmiPaneMakeGroup.Name = "_tmiPaneMakeGroup";
            resources.ApplyResources(this._tmiPaneMakeGroup, "_tmiPaneMakeGroup");
            this._tmiPaneMakeGroup.Click += new System.EventHandler(this.Event_MniObjectMakeGroup_Click);
            //
            // _tmiPaneEditGroup
            //
            this._tmiPaneEditGroup.MergeIndex = 0;
            this._tmiPaneEditGroup.Name = "_tmiPaneEditGroup";
            resources.ApplyResources(this._tmiPaneEditGroup, "_tmiPaneEditGroup");
            this._tmiPaneEditGroup.Click += new System.EventHandler(this.Event_MniObjectEditGroup_Click);
            //
            // toolStripSeparator6
            //
            this.toolStripSeparator6.MergeIndex = 0;
            this.toolStripSeparator6.Name = "toolStripSeparator6";
            resources.ApplyResources(this.toolStripSeparator6, "toolStripSeparator6");
            //
            // _tmiPaneLockSelected
            //
            this._tmiPaneLockSelected.MergeIndex = 0;
            this._tmiPaneLockSelected.Name = "_tmiPaneLockSelected";
            resources.ApplyResources(this._tmiPaneLockSelected, "_tmiPaneLockSelected");
            this._tmiPaneLockSelected.Click += new System.EventHandler(this.Event_MniObjectLock_Click);
            //
            // _tmiPaneUnlockSelected
            //
            this._tmiPaneUnlockSelected.MergeIndex = 0;
            this._tmiPaneUnlockSelected.Name = "_tmiPaneUnlockSelected";
            resources.ApplyResources(this._tmiPaneUnlockSelected, "_tmiPaneUnlockSelected");
            this._tmiPaneUnlockSelected.Click += new System.EventHandler(this.Event_MniObjectShowLocked_Click);
            //
            // _tmiPaneHideLocked
            //
            this._tmiPaneHideLocked.MergeIndex = 0;
            this._tmiPaneHideLocked.Name = "_tmiPaneHideLocked";
            resources.ApplyResources(this._tmiPaneHideLocked, "_tmiPaneHideLocked");
            this._tmiPaneHideLocked.Click += new System.EventHandler(this.Event_MniObjectLockedToHidden_Click);
            //
            // _tmiPaneLockRegionPane
            //
            this._tmiPaneLockRegionPane.MergeIndex = 0;
            this._tmiPaneLockRegionPane.Name = "_tmiPaneLockRegionPane";
            resources.ApplyResources(this._tmiPaneLockRegionPane, "_tmiPaneLockRegionPane");
            this._tmiPaneLockRegionPane.Click += new System.EventHandler(this.Event_MniObjectLockBoundingPane_Click);
            //
            // toolStripSeparator7
            //
            this.toolStripSeparator7.MergeIndex = 0;
            this.toolStripSeparator7.Name = "toolStripSeparator7";
            resources.ApplyResources(this.toolStripSeparator7, "toolStripSeparator7");
            //
            // _tmiPaneHideSlected
            //
            this._tmiPaneHideSlected.MergeIndex = 0;
            this._tmiPaneHideSlected.Name = "_tmiPaneHideSlected";
            resources.ApplyResources(this._tmiPaneHideSlected, "_tmiPaneHideSlected");
            this._tmiPaneHideSlected.Click += new System.EventHandler(this.Event_MniObjectHide_Click);
            //
            // _tmiPaneShowAllHidden
            //
            this._tmiPaneShowAllHidden.MergeIndex = 0;
            this._tmiPaneShowAllHidden.Name = "_tmiPaneShowAllHidden";
            resources.ApplyResources(this._tmiPaneShowAllHidden, "_tmiPaneShowAllHidden");
            this._tmiPaneShowAllHidden.Click += new System.EventHandler(this.Event_MniObjectResetHidden_Click);
            //
            // _tmiPaneLockHidden
            //
            this._tmiPaneLockHidden.MergeIndex = 0;
            this._tmiPaneLockHidden.Name = "_tmiPaneLockHidden";
            resources.ApplyResources(this._tmiPaneLockHidden, "_tmiPaneLockHidden");
            this._tmiPaneLockHidden.Click += new System.EventHandler(this.Event_MniObjectHiddenToLocked_Click);
            //
            // toolStripSeparator18
            //
            this.toolStripSeparator18.Name = "toolStripSeparator18";
            resources.ApplyResources(this.toolStripSeparator18, "toolStripSeparator18");
            //
            // _tmiAlignment
            //
            this._tmiAlignment.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiAlignmentL,
            this._tmiAlignmentHC,
            this._tmiAlignmentR,
            this.toolStripSeparator17,
            this._tmiAlignmentT,
            this._tmiAlignmentVC,
            this._tmiAlignmentB,
            this.toolStripSeparator16,
            this._tmiAlignmentTrimH,
            this._tmiAlignmentTrimV});
            this._tmiAlignment.Name = "_tmiAlignment";
            resources.ApplyResources(this._tmiAlignment, "_tmiAlignment");
            //
            // _tmiAlignmentL
            //
            resources.ApplyResources(this._tmiAlignmentL, "_tmiAlignmentL");
            this._tmiAlignmentL.Name = "_tmiAlignmentL";
            this._tmiAlignmentL.Click += new System.EventHandler(this.Event_tmiAlignmentL_Click);
            //
            // _tmiAlignmentHC
            //
            resources.ApplyResources(this._tmiAlignmentHC, "_tmiAlignmentHC");
            this._tmiAlignmentHC.Name = "_tmiAlignmentHC";
            this._tmiAlignmentHC.Click += new System.EventHandler(this.Event_tmiAlignmentHC_Click);
            //
            // _tmiAlignmentR
            //
            resources.ApplyResources(this._tmiAlignmentR, "_tmiAlignmentR");
            this._tmiAlignmentR.Name = "_tmiAlignmentR";
            this._tmiAlignmentR.Click += new System.EventHandler(this.Event_tmiAlignmentR_Click);
            //
            // toolStripSeparator17
            //
            this.toolStripSeparator17.Name = "toolStripSeparator17";
            resources.ApplyResources(this.toolStripSeparator17, "toolStripSeparator17");
            //
            // _tmiAlignmentT
            //
            resources.ApplyResources(this._tmiAlignmentT, "_tmiAlignmentT");
            this._tmiAlignmentT.Name = "_tmiAlignmentT";
            this._tmiAlignmentT.Click += new System.EventHandler(this.Event_tmiAlignmentT_Click);
            //
            // _tmiAlignmentVC
            //
            resources.ApplyResources(this._tmiAlignmentVC, "_tmiAlignmentVC");
            this._tmiAlignmentVC.Name = "_tmiAlignmentVC";
            this._tmiAlignmentVC.Click += new System.EventHandler(this.Event_tmiAlignmentVC_Click);
            //
            // _tmiAlignmentB
            //
            resources.ApplyResources(this._tmiAlignmentB, "_tmiAlignmentB");
            this._tmiAlignmentB.Name = "_tmiAlignmentB";
            this._tmiAlignmentB.Click += new System.EventHandler(this.Event_tmiAlignmentB_Click);
            //
            // toolStripSeparator16
            //
            this.toolStripSeparator16.Name = "toolStripSeparator16";
            resources.ApplyResources(this.toolStripSeparator16, "toolStripSeparator16");
            //
            // _tmiAlignmentTrimH
            //
            resources.ApplyResources(this._tmiAlignmentTrimH, "_tmiAlignmentTrimH");
            this._tmiAlignmentTrimH.Name = "_tmiAlignmentTrimH";
            this._tmiAlignmentTrimH.Click += new System.EventHandler(this.Event_tmiAlignmentTrimH_Click);
            //
            // _tmiAlignmentTrimV
            //
            resources.ApplyResources(this._tmiAlignmentTrimV, "_tmiAlignmentTrimV");
            this._tmiAlignmentTrimV.Name = "_tmiAlignmentTrimV";
            this._tmiAlignmentTrimV.Click += new System.EventHandler(this.Event_tmiAlignmentTrimV_Click);
            //
            // _tmiResizeToTextureSize
            //
            this._tmiResizeToTextureSize.Name = "_tmiResizeToTextureSize";
            resources.ApplyResources(this._tmiResizeToTextureSize, "_tmiResizeToTextureSize");
            this._tmiResizeToTextureSize.Click += new System.EventHandler(this.Event_tmiResizeToTextureSize_Click);
            //
            // _tmiCreateCapturePaneWithChildren
            //
            this._tmiCreateCapturePaneWithChildren.Name = "_tmiCreateCapturePaneWithChildren";
            resources.ApplyResources(this._tmiCreateCapturePaneWithChildren, "_tmiCreateCapturePaneWithChildren");
            this._tmiCreateCapturePaneWithChildren.Click += new System.EventHandler(this.Event_tmiCreateCapturePaneWithChildren_Click);
            //
            // toolStripSeparator8
            //
            this.toolStripSeparator8.MergeIndex = 0;
            this.toolStripSeparator8.Name = "toolStripSeparator8";
            resources.ApplyResources(this.toolStripSeparator8, "toolStripSeparator8");
            //
            // _tmiPaneProperty
            //
            this._tmiPaneProperty.MergeIndex = 0;
            this._tmiPaneProperty.Name = "_tmiPaneProperty";
            resources.ApplyResources(this._tmiPaneProperty, "_tmiPaneProperty");
            this._tmiPaneProperty.Click += new System.EventHandler(this.Event_MniProperties_Click);
            //
            // toolStripSeparator10
            //
            this.toolStripSeparator10.Name = "toolStripSeparator10";
            resources.ApplyResources(this.toolStripSeparator10, "toolStripSeparator10");
            //
            // _tmiReloadPartsPane
            //
            this._tmiReloadPartsPane.Name = "_tmiReloadPartsPane";
            resources.ApplyResources(this._tmiReloadPartsPane, "_tmiReloadPartsPane");
            this._tmiReloadPartsPane.Click += new System.EventHandler(this.Event_TmiReloatPartsPane_Click);
            //
            // _tmiCreatePartsBySelectedNull
            //
            this._tmiCreatePartsBySelectedNull.Name = "_tmiCreatePartsBySelectedNull";
            resources.ApplyResources(this._tmiCreatePartsBySelectedNull, "_tmiCreatePartsBySelectedNull");
            this._tmiCreatePartsBySelectedNull.Click += new System.EventHandler(this.Event_TmiCreatePartsBySelectedNull_Click);
            //
            // _tmiOpenPartsLayout
            //
            this._tmiOpenPartsLayout.Name = "_tmiOpenPartsLayout";
            resources.ApplyResources(this._tmiOpenPartsLayout, "_tmiOpenPartsLayout");
            this._tmiOpenPartsLayout.Click += new System.EventHandler(this.Event_TmiOpenPartsLayout_Click);
            //
            // toolStripMenuItem1
            //
            this.toolStripMenuItem1.Name = "toolStripMenuItem1";
            resources.ApplyResources(this.toolStripMenuItem1, "toolStripMenuItem1");
            //
            // _tmiAsChild
            //
            this._tmiAsChild.Name = "_tmiAsChild";
            resources.ApplyResources(this._tmiAsChild, "_tmiAsChild");
            this._tmiAsChild.Click += new System.EventHandler(this.Event_tmiAsChild_Click);
            //
            // _tmiAsParent
            //
            this._tmiAsParent.Name = "_tmiAsParent";
            resources.ApplyResources(this._tmiAsParent, "_tmiAsParent");
            this._tmiAsParent.Click += new System.EventHandler(this.Event_tmiAsParent_Click);
            //
            // _tmiCreateNullPaneAndAddChild
            //
            this._tmiCreateNullPaneAndAddChild.Name = "_tmiCreateNullPaneAndAddChild";
            resources.ApplyResources(this._tmiCreateNullPaneAndAddChild, "_tmiCreateNullPaneAndAddChild");
            this._tmiCreateNullPaneAndAddChild.Click += new System.EventHandler(this.Event_tmiCreateNullPaneAndAddChild_Click);
            //
            // _tmiSelect
            //
            this._tmiSelect.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiSelectAll,
            this._tmiSelectReset,
            this._tmiSelectInvert,
            this.toolStripSeparator9,
            this._tmiSelectPrev,
            this._tmiSelectNext});
            this._tmiSelect.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiSelect.MergeIndex = 3;
            this._tmiSelect.Name = "_tmiSelect";
            resources.ApplyResources(this._tmiSelect, "_tmiSelect");
            //
            // _tmiSelectAll
            //
            this._tmiSelectAll.MergeIndex = 0;
            this._tmiSelectAll.Name = "_tmiSelectAll";
            resources.ApplyResources(this._tmiSelectAll, "_tmiSelectAll");
            this._tmiSelectAll.Click += new System.EventHandler(this.Event_MniSelectAll_Click);
            //
            // _tmiSelectReset
            //
            this._tmiSelectReset.MergeIndex = 0;
            this._tmiSelectReset.Name = "_tmiSelectReset";
            resources.ApplyResources(this._tmiSelectReset, "_tmiSelectReset");
            this._tmiSelectReset.Click += new System.EventHandler(this.Event_MniSelectReset_Click);
            //
            // _tmiSelectInvert
            //
            this._tmiSelectInvert.MergeIndex = 0;
            this._tmiSelectInvert.Name = "_tmiSelectInvert";
            resources.ApplyResources(this._tmiSelectInvert, "_tmiSelectInvert");
            this._tmiSelectInvert.Click += new System.EventHandler(this.Event_MniSelectInv);
            //
            // toolStripSeparator9
            //
            this.toolStripSeparator9.MergeIndex = 0;
            this.toolStripSeparator9.Name = "toolStripSeparator9";
            resources.ApplyResources(this.toolStripSeparator9, "toolStripSeparator9");
            //
            // _tmiSelectPrev
            //
            this._tmiSelectPrev.MergeIndex = 0;
            this._tmiSelectPrev.Name = "_tmiSelectPrev";
            resources.ApplyResources(this._tmiSelectPrev, "_tmiSelectPrev");
            this._tmiSelectPrev.Click += new System.EventHandler(this.Event_TmiSelectPrev_Click);
            //
            // _tmiSelectNext
            //
            this._tmiSelectNext.MergeIndex = 0;
            this._tmiSelectNext.Name = "_tmiSelectNext";
            resources.ApplyResources(this._tmiSelectNext, "_tmiSelectNext");
            this._tmiSelectNext.Click += new System.EventHandler(this.Evnet_TmiSelectNext_Click);
            //
            // _tmiView
            //
            this._tmiView.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiViewOutline,
            this._tmiViewBoundingBoxDisabled,
            this._tmiViewBoundingPaneEnabled,
            this._tmiViewPartsPaneEnabled,
            this._tmiViewCapturePaneEnabled,
            this.toolStripSeparator11,
            this._tmiViewZoomIn,
            this._tmiViewZoomOut,
            this._tmiViewWindowExpand,
            this._tmiViewWindowShrink,
            this._tmiViewAll,
            this._tmiViewForcus,
            this.toolStripSeparator12,
            this._tmiViewShowGrid,
            this._tmiViewSnapToGrid});
            this._tmiView.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiView.MergeIndex = 4;
            this._tmiView.Name = "_tmiView";
            resources.ApplyResources(this._tmiView, "_tmiView");
            this._tmiView.DropDownOpened += new System.EventHandler(this.Event_TmiView_DropDownOpened);
            //
            // _tmiViewOutline
            //
            this._tmiViewOutline.MergeIndex = 1;
            this._tmiViewOutline.Name = "_tmiViewOutline";
            resources.ApplyResources(this._tmiViewOutline, "_tmiViewOutline");
            this._tmiViewOutline.Click += new System.EventHandler(this.Event_MniViewOutline_Click);
            //
            // _tmiViewBoundingBoxDisabled
            //
            this._tmiViewBoundingBoxDisabled.MergeIndex = 1;
            this._tmiViewBoundingBoxDisabled.Name = "_tmiViewBoundingBoxDisabled";
            resources.ApplyResources(this._tmiViewBoundingBoxDisabled, "_tmiViewBoundingBoxDisabled");
            this._tmiViewBoundingBoxDisabled.Click += new System.EventHandler(this.Event_MniViewBV_Click);
            this._tmiViewBoundingBoxDisabled.Paint += new System.Windows.Forms.PaintEventHandler(this.Event_TmiViewBoundingBoxDisabled_Paint);
            //
            // _tmiViewBoundingPaneEnabled
            //
            this._tmiViewBoundingPaneEnabled.Name = "_tmiViewBoundingPaneEnabled";
            resources.ApplyResources(this._tmiViewBoundingPaneEnabled, "_tmiViewBoundingPaneEnabled");
            this._tmiViewBoundingPaneEnabled.Click += new System.EventHandler(this.Event_MniViewBoundingPane_Click);
            //
            // _tmiViewPartsPaneEnabled
            //
            this._tmiViewPartsPaneEnabled.Name = "_tmiViewPartsPaneEnabled";
            resources.ApplyResources(this._tmiViewPartsPaneEnabled, "_tmiViewPartsPaneEnabled");
            this._tmiViewPartsPaneEnabled.Click += new System.EventHandler(this.Event_MniViewPartsPane_Click);
            //
            // _tmiViewCapturePaneEnabled
            //
            this._tmiViewCapturePaneEnabled.Name = "_tmiViewCapturePaneEnabled";
            resources.ApplyResources(this._tmiViewCapturePaneEnabled, "_tmiViewCapturePaneEnabled");
            this._tmiViewCapturePaneEnabled.Click += new System.EventHandler(this.Event_tmiViewCapturePaneEnabled_Click);
            //
            // toolStripSeparator11
            //
            this.toolStripSeparator11.MergeIndex = 1;
            this.toolStripSeparator11.Name = "toolStripSeparator11";
            resources.ApplyResources(this.toolStripSeparator11, "toolStripSeparator11");
            //
            // _tmiViewZoomIn
            //
            this._tmiViewZoomIn.MergeIndex = 1;
            this._tmiViewZoomIn.Name = "_tmiViewZoomIn";
            resources.ApplyResources(this._tmiViewZoomIn, "_tmiViewZoomIn");
            this._tmiViewZoomIn.Click += new System.EventHandler(this.Event_MniViewZoomIn_Click);
            //
            // _tmiViewZoomOut
            //
            this._tmiViewZoomOut.MergeIndex = 1;
            this._tmiViewZoomOut.Name = "_tmiViewZoomOut";
            resources.ApplyResources(this._tmiViewZoomOut, "_tmiViewZoomOut");
            this._tmiViewZoomOut.Click += new System.EventHandler(this.Event_MniViewZoomOut_Click);
            //
            // _tmiViewWindowExpand
            //
            this._tmiViewWindowExpand.MergeIndex = 1;
            this._tmiViewWindowExpand.Name = "_tmiViewWindowExpand";
            resources.ApplyResources(this._tmiViewWindowExpand, "_tmiViewWindowExpand");
            this._tmiViewWindowExpand.Click += new System.EventHandler(this.Event_MniWindowExpand_Click);
            //
            // _tmiViewWindowShrink
            //
            this._tmiViewWindowShrink.MergeIndex = 1;
            this._tmiViewWindowShrink.Name = "_tmiViewWindowShrink";
            resources.ApplyResources(this._tmiViewWindowShrink, "_tmiViewWindowShrink");
            this._tmiViewWindowShrink.Click += new System.EventHandler(this.Event_MniWindowShrink_Click);
            //
            // _tmiViewAll
            //
            this._tmiViewAll.MergeIndex = 1;
            this._tmiViewAll.Name = "_tmiViewAll";
            resources.ApplyResources(this._tmiViewAll, "_tmiViewAll");
            this._tmiViewAll.Click += new System.EventHandler(this.Event_MniAdjustView_Click);
            //
            // _tmiViewForcus
            //
            this._tmiViewForcus.MergeIndex = 1;
            this._tmiViewForcus.Name = "_tmiViewForcus";
            resources.ApplyResources(this._tmiViewForcus, "_tmiViewForcus");
            this._tmiViewForcus.Click += new System.EventHandler(this.Event_MniAdjustViewToSelected_Click);
            //
            // toolStripSeparator12
            //
            this.toolStripSeparator12.MergeIndex = 1;
            this.toolStripSeparator12.Name = "toolStripSeparator12";
            resources.ApplyResources(this.toolStripSeparator12, "toolStripSeparator12");
            //
            // _tmiViewShowGrid
            //
            this._tmiViewShowGrid.MergeIndex = 1;
            this._tmiViewShowGrid.Name = "_tmiViewShowGrid";
            resources.ApplyResources(this._tmiViewShowGrid, "_tmiViewShowGrid");
            this._tmiViewShowGrid.Click += new System.EventHandler(this.Event_MniViewGrid_Click);
            //
            // _tmiViewSnapToGrid
            //
            this._tmiViewSnapToGrid.MergeIndex = 1;
            this._tmiViewSnapToGrid.Name = "_tmiViewSnapToGrid";
            resources.ApplyResources(this._tmiViewSnapToGrid, "_tmiViewSnapToGrid");
            this._tmiViewSnapToGrid.Click += new System.EventHandler(this.Event_MniViewGridSnap_Click);
            //
            // _tmiTool
            //
            this._tmiTool.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiDeleteUnusedFont,
            this._tmiTextureFileSetImport,
            this._tmiSetTextureFontPath,
            this.toolStripSeparator15,
            this._tmiToolTransportToViewer,
            this._tmiToolTransportToViewerForceAnimMode,
            this.tmiLaunchAEViewer,
            this.toolStripSeparator14,
            this._tmiCapturePCViewer,
            this._tmiPaneTreeCompression,
            this._tssUserCommand,
            this._tmiUserCommand,
            this._toolStripMenuItemForCombinerEditor,
            this._tmiLaunchCombinerEditor});
            this._tmiTool.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiTool.MergeIndex = 5;
            this._tmiTool.Name = "_tmiTool";
            resources.ApplyResources(this._tmiTool, "_tmiTool");
            //
            // _tmiDeleteUnusedFont
            //
            this._tmiDeleteUnusedFont.MergeIndex = 0;
            this._tmiDeleteUnusedFont.Name = "_tmiDeleteUnusedFont";
            resources.ApplyResources(this._tmiDeleteUnusedFont, "_tmiDeleteUnusedFont");
            this._tmiDeleteUnusedFont.Click += new System.EventHandler(this.Event_TmiDeleteUnusedFont_Click);
            //
            // _tmiTextureFileSetImport
            //
            this._tmiTextureFileSetImport.Name = "_tmiTextureFileSetImport";
            resources.ApplyResources(this._tmiTextureFileSetImport, "_tmiTextureFileSetImport");
            this._tmiTextureFileSetImport.Click += new System.EventHandler(this.Event_TmiTextureFileSetImport_Click);
            //
            // _tmiSetTextureFontPath
            //
            this._tmiSetTextureFontPath.Name = "_tmiSetTextureFontPath";
            resources.ApplyResources(this._tmiSetTextureFontPath, "_tmiSetTextureFontPath");
            this._tmiSetTextureFontPath.Click += new System.EventHandler(this.Event_TmiSetTextureFontPath_Click_);
            //
            // toolStripSeparator15
            //
            this.toolStripSeparator15.Name = "toolStripSeparator15";
            resources.ApplyResources(this.toolStripSeparator15, "toolStripSeparator15");
            //
            // _tmiToolTransportToViewer
            //
            this._tmiToolTransportToViewer.MergeIndex = 1;
            this._tmiToolTransportToViewer.Name = "_tmiToolTransportToViewer";
            resources.ApplyResources(this._tmiToolTransportToViewer, "_tmiToolTransportToViewer");
            this._tmiToolTransportToViewer.Click += new System.EventHandler(this.Event_MniRunPreviewer_Click);
            //
            // _tmiToolTransportToViewerForceAnimMode
            //
            this._tmiToolTransportToViewerForceAnimMode.Name = "_tmiToolTransportToViewerForceAnimMode";
            resources.ApplyResources(this._tmiToolTransportToViewerForceAnimMode, "_tmiToolTransportToViewerForceAnimMode");
            this._tmiToolTransportToViewerForceAnimMode.Click += new System.EventHandler(this.Event_TmiToolTransportToViewerForceAnimMode_Click);
            //
            // tmiLaunchAEViewer
            //
            this.tmiLaunchAEViewer.Name = "tmiLaunchAEViewer";
            resources.ApplyResources(this.tmiLaunchAEViewer, "tmiLaunchAEViewer");
            this.tmiLaunchAEViewer.Click += new System.EventHandler(this.Event_TmiLaunchAEViewer_Click);
            //
            // toolStripSeparator14
            //
            this.toolStripSeparator14.Name = "toolStripSeparator14";
            resources.ApplyResources(this.toolStripSeparator14, "toolStripSeparator14");
            //
            // _tmiCapturePCViewer
            //
            this._tmiCapturePCViewer.Name = "_tmiCapturePCViewer";
            resources.ApplyResources(this._tmiCapturePCViewer, "_tmiCapturePCViewer");
            this._tmiCapturePCViewer.Click += new System.EventHandler(this.Event_TmiCapturePCViewer_Click);
            //
            // _tmiPaneTreeCompression
            //
            this._tmiPaneTreeCompression.Name = "_tmiPaneTreeCompression";
            resources.ApplyResources(this._tmiPaneTreeCompression, "_tmiPaneTreeCompression");
            this._tmiPaneTreeCompression.Click += new System.EventHandler(this.Event_TmiPaneTreeCompression_Click);
            //
            // _tssUserCommand
            //
            this._tssUserCommand.MergeIndex = 0;
            this._tssUserCommand.Name = "_tssUserCommand";
            resources.ApplyResources(this._tssUserCommand, "_tssUserCommand");
            //
            // _tmiUserCommand
            //
            this._tmiUserCommand.Name = "_tmiUserCommand";
            resources.ApplyResources(this._tmiUserCommand, "_tmiUserCommand");
            //
            // _toolStripMenuItemForCombinerEditor
            //
            this._toolStripMenuItemForCombinerEditor.Name = "_toolStripMenuItemForCombinerEditor";
            resources.ApplyResources(this._toolStripMenuItemForCombinerEditor, "_toolStripMenuItemForCombinerEditor");
            //
            // _tmiLaunchCombinerEditor
            //
            this._tmiLaunchCombinerEditor.Name = "_tmiLaunchCombinerEditor";
            resources.ApplyResources(this._tmiLaunchCombinerEditor, "_tmiLaunchCombinerEditor");
            this._tmiLaunchCombinerEditor.Click += new System.EventHandler(this.tmiLaunchCombinerEditor_Click);
            //
            // _tmiDebug
            //
            this._tmiDebug.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._tmiDebugShowDebugDraw});
            this._tmiDebug.MergeAction = System.Windows.Forms.MergeAction.Insert;
            this._tmiDebug.MergeIndex = 10;
            this._tmiDebug.Name = "_tmiDebug";
            resources.ApplyResources(this._tmiDebug, "_tmiDebug");
            this._tmiDebug.DropDownOpening += new System.EventHandler(this.Event_MniDebug_Popup);
            //
            // _tmiDebugShowDebugDraw
            //
            this._tmiDebugShowDebugDraw.Name = "_tmiDebugShowDebugDraw";
            resources.ApplyResources(this._tmiDebugShowDebugDraw, "_tmiDebugShowDebugDraw");
            this._tmiDebugShowDebugDraw.Click += new System.EventHandler(this.Event_MniDebugShowDbgDraw_Click);
            //
            // _btnPersepective
            //
            resources.ApplyResources(this._btnPersepective, "_btnPersepective");
            this._btnPersepective.BackColor = System.Drawing.SystemColors.GradientInactiveCaption;
            this._btnPersepective.FlatAppearance.BorderColor = System.Drawing.SystemColors.ActiveCaption;
            this._btnPersepective.ForeColor = System.Drawing.SystemColors.ActiveCaption;
            this._btnPersepective.Name = "_btnPersepective";
            this._ttpMain.SetToolTip(this._btnPersepective, resources.GetString("_btnPersepective.ToolTip"));
            this._btnPersepective.Click += new System.EventHandler(this.Event_btnPersepective_Click);
            //
            // _btnMetrics
            //
            resources.ApplyResources(this._btnMetrics, "_btnMetrics");
            this._btnMetrics.BackColor = System.Drawing.SystemColors.Control;
            this._btnMetrics.FlatAppearance.BorderColor = System.Drawing.SystemColors.Control;
            this._btnMetrics.FlatAppearance.BorderSize = 0;
            this._btnMetrics.ForeColor = System.Drawing.SystemColors.Control;
            this._btnMetrics.Name = "_btnMetrics";
            this._btnMetrics.Click += new System.EventHandler(this.Event_mainViewBar_Click);
            this._btnMetrics.MouseEnter += new System.EventHandler(this.Event_btnMetrics_MouseEnter);
            //
            // _btnParts
            //
            resources.ApplyResources(this._btnParts, "_btnParts");
            this._btnParts.BackColor = System.Drawing.SystemColors.GradientInactiveCaption;
            this._btnParts.FlatAppearance.BorderColor = System.Drawing.SystemColors.ActiveCaption;
            this._btnParts.ForeColor = System.Drawing.SystemColors.ActiveCaption;
            this._btnParts.Name = "_btnParts";
            this._ttpMain.SetToolTip(this._btnParts, resources.GetString("_btnParts.ToolTip"));
            this._btnParts.Click += new System.EventHandler(this.Event_btnParts_MouseEnter);
            //
            // _mainViewBar
            //
            resources.ApplyResources(this._mainViewBar, "_mainViewBar");
            this._mainViewBar.BackColor = System.Drawing.SystemColors.Control;
            this._mainViewBar.Name = "_mainViewBar";
            //
            // _ttpPartsAutoReloaded
            //
            this._ttpPartsAutoReloaded.Active = false;
            this._ttpPartsAutoReloaded.IsBalloon = true;
            this._ttpPartsAutoReloaded.ToolTipIcon = System.Windows.Forms.ToolTipIcon.Info;
            this._ttpPartsAutoReloaded.ToolTipTitle = "部品ペインが自動リロードされました";
            //
            // LayoutWindow
            //
            this.AllowDrop = true;
            resources.ApplyResources(this, "$this");
            this.Controls.Add(this._btnPersepective);
            this.Controls.Add(this._btnMetrics);
            this.Controls.Add(this._btnParts);
            this.Controls.Add(this._mainViewBar);
            this.Controls.Add(this.pnlClient);
            this.Controls.Add(this._stbMainView);
            this.Controls.Add(this._mspMain);
            this.DockAreas = WeifenLuo.WinFormsUI.Docking.DockAreas.Document;
            this.KeyPreview = true;
            this.MainMenuStrip = this._mspMain;
            this.Name = "LayoutWindow";
            this.Activated += new System.EventHandler(this.LayoutWindow_Activated);
            this.Closing += new System.ComponentModel.CancelEventHandler(this.Event_LayoutWindow_Closing);
            this.Deactivate += new System.EventHandler(this.LayoutWindow_Deactivate);
            this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.Event_LayoutWindow_KeyDown);
            this.KeyUp += new System.Windows.Forms.KeyEventHandler(this.Event_LayoutWindow_KeyUp);
            this.MouseDown += new System.Windows.Forms.MouseEventHandler(this.Event_LayoutWindow_MouseDown);
            this.MouseMove += new System.Windows.Forms.MouseEventHandler(this.Event_LayoutWindow_MouseMove);
            this.Move += new System.EventHandler(this.LayoutWindow_Move);
            this.pnlClient.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this._pnlOriginalLayout)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._pnlPaneState)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._pnlMouseMode)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._pnlMetrics)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._pnlTransMode)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._pnlPerspective)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._pnlPartsDummy)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this._pnlZoomDummy)).EndInit();
            this._mspMain.ResumeLayout(false);
            this._mspMain.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion

        #endregion デザイナ生成コード

        #region フィールド
        /// <summary>
        /// マウス位置
        /// </summary>
        PointF _currentMousePosInScene = Point.Empty;

        /// <summary>
        /// ファイル保存を無視するフラグ
        /// </summary>
        bool _closeIgnoreSaving;


        /// <summary>
        /// マウスモードごとのアイコン
        /// </summary>
        readonly List<Icon> _mouseModeIconSet = new List<Icon>();

        readonly ToolStripItem[] _paneMenuItemSet;

        /// <summary>
        /// コンテキストメニュー関連
        /// </summary>
        ContextMenuStrip _cmsMain = null;

        /// <summary>
        /// コンテキストメニューを開いた位置(クライアント座標)
        /// </summary>
        Point? _cmsMainOpenedPoint;

        /// <summary>
        /// ユーザーコマンドのショートカットに対するアクション
        /// </summary>
        private readonly Dictionary<Keys, Action> _userCommandShortCutKeyActions = new Dictionary<Keys, Action>();

        /// <summary>
        /// 連番ファイル読み込みダイアログ
        /// </summary>
        readonly TextureFileSetImporterDlg _textureFileSetImporterDlg;

        /// <summary>
        /// ファイルを閉じるダイアログ
        /// </summary>
        readonly DocumentsCloseDlg _closeDlg = new DocumentsCloseDlg();

        /// <summary>
        /// 部品を開くダイアログ
        /// </summary>
        readonly SelectSubPartsDlg _selectSubPartsDlg = new SelectSubPartsDlg();

        /// <summary>
        /// 表示シーンのセーブ状態
        /// </summary>
        readonly List<TargetSubSceneSaveState> _targetSubSceneStates = new List<TargetSubSceneSaveState>();

        /// <summary>
        /// アイコン
        /// </summary>
        static readonly Image _pserpectiveIcon;
        static readonly Image _orthoIcon;

        /// <summary>
        /// テキストボックス生成ダイアログ
        /// </summary>
        CreateTextBoxDlg _createTextBoxDlg = new CreateTextBoxDlg();

        #endregion フィールド

        #region プロパティ
        /// <summary>
        /// シーンを取得します。
        /// </summary>
        IScene _Scene
        {
            get { return LayoutEditorCore.Scene; }
        }

        /// <summary>
        /// 対象サブシーンを取得します。
        /// </summary>
        public ISubScene CurrentSubScene
        {
            get { return _mainView.TargetSubScene; }
        }

        /// <summary>
        /// メインビューを取得します。
        /// </summary>
        public MainView MainView
        {
            get { return _mainView; }
        }

        /// <summary>
        /// 先頭のサブシーンを取得します。
        /// </summary>
        public ISubScene InitialSubScene
        {
            get { return _InitialSubSceneState?.ISubScene; }
        }

        /// <summary>
        /// これまでにレイアウトウインドウで表示したサブシーンを列挙します。
        /// </summary>
        public IEnumerable<ISubScene> LoadedSubScenes
        {
            get { return _targetSubSceneStates.Select(x => x.ISubScene); }
        }

        /// <summary>
        /// 現在編集中の(レンダリングされている)シーン状態
        /// </summary>
        private TargetSubSceneSaveState _CurrentSubSceneState
        {
            get { return FindSubSceneState_(CurrentSubScene); }
        }

        /// <summary>
        /// 最初に読み込まれたレイアウトシーン状態（通常Nullは無い）
        /// </summary>
        private TargetSubSceneSaveState _InitialSubSceneState
        {
            get { return _targetSubSceneStates.FirstOrDefault(); }
        }

        /// <summary>
        /// 表示中のレイアウトファイルパス
        /// </summary>
        public string FilePath
        {
            get { return _CurrentSubSceneState.LastSavedFilePath; }
        }

        /// <summary>
        /// アプリケーション設定を設定します。
        /// </summary>
        public AppSetting AppSetting
        {
            set { _mainView.SetAppSetting(value); }
            get { return _mainView.GetAppSetting(); }
        }

        /// <summary>
        /// グローバル時間クラス
        /// </summary>
        GlobalTime _GrbTime
        {
            get { return GlobalTime.Inst; }
        }

        /// <summary>
        /// 操作対象のサブシーンを取得します。
        /// 複数の表示対象サブシーンの中から、
        /// アクティブなものがひとつ返されます。
        /// </summary>
        ISubScene _TargetActiveSubScene
        {
            get { return _mainView._TargetActiveSubScene; }
            set { _mainView._TargetActiveSubScene = value; }
        }

        /// <summary>
        /// 操作対象のサブシーン操作クラスの取得
        /// </summary>
        SubSceneManipulator _subSceneManipulator
        {
            get { return _mainView.ActiveSubSceneMnp; }
        }

        /// <summary>
        /// 平行移動操作を子供に影響させるかどうか設定、取得します。
        /// </summary>
        public bool TransAffectsChildrenFlip
        {
            get { return _mainView.TransAffectsChildrenFlip; }
            set
            {
                if (_mainView.TransAffectsChildrenFlip != value)
                {
                    _mainView.TransAffectsChildrenFlip = value;
                    UpdateTransModePanel_();
                }
            }

        }

        // ドッキング復帰用の ID
        public string PersistString
        {
            get;
            set;
        }

        #endregion プロパティ

        protected override string GetPersistString()
        {
            return PersistString ?? typeof(LayoutWindow).FullName;
        }

        private string previousFilePath = string.Empty;
        /// <summary>
        /// ウインドウタイトル文字列を更新します。
        /// </summary>
        void UpdateWindowTitleText_()
        {
            var updatedMark = _CurrentSubSceneState.IsUpdated ? "*" : "";

            var text = $"{updatedMark}{this._CurrentSubSceneState.LastSavedFileName} - [{_CurrentSubSceneState.LastSavedFilePath}]";
            if (text != Text)
            {
                Text = text;
                SendMessageToViewManager_(new ViewManagerMessage(ViewManagerMessageKind.UpdateWindowTitle));
            }

            if (previousFilePath != this._CurrentSubSceneState.LastSavedFilePath)
            {
                previousFilePath = this._CurrentSubSceneState.LastSavedFilePath;
                SendMessageToViewManager_(new ViewManagerMessage(ViewManagerMessageKind.SaveStateChanged, _CurrentSubSceneState));
            }
        }

        /// <summary>
        /// ステータスバーにメッセージを表示します。
        /// </summary>
        /// <param name="msg"></param>
        void ShowMsgToStatusBar_(string msg)
        {
            _stbMainView.Panels[0].Text = msg;
        }

        /// <summary>
        /// マウスモード表示を更新します。
        /// </summary>
        void Event_MainView_MouseStateChange(object sender, EventArgs e)
        {
            MainView.MainViewMouseState.MouseState state = sender as MainView.MainViewMouseState.MouseState;
            _pnlMouseMode.Text = state.StateName;
            _pnlMouseMode.Tag = state;
        }

        /// <summary>
        ///
        /// </summary>
        static LayoutWindow()
        {
            _pserpectiveIcon = ImageResMgr.GetManifestResourcePng("pers.png");
            _orthoIcon = ImageResMgr.GetManifestResourcePng("orth.png");
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public LayoutWindow(AppSetting appsetting)
        {
            InitializeComponent();
            _mainViewBar.View = _mainView;
            AppSetting = appsetting;

            _textureFileSetImporterDlg = new TextureFileSetImporterDlg(AppSetting);

#if !DEBUG
            _tmiDebug.Visible = false;
#endif

            // タイトルの設定
            this.Text = AppConstants.InitialFileName;

            // メインビューのマウスダウンイベントを受け取るように設定します。
            _mainView.MouseDown += new MouseEventHandler(Event_LayoutWindow_MouseDown);
            _mainView.MouseMove += new MouseEventHandler(Event_LayoutWindow_MouseMove);

            _mainView.MouseStateChange += new EventHandler(Event_MainView_MouseStateChange);
            _mainView.IsPaneValidToPaste += this.IsPaneValidToPaste_;

            _mouseModeIconSet.Add(ImageResMgr.GetManifestResourceIcon("layout_mousemode_hier_on_16.ico"));
            _mouseModeIconSet.Add(ImageResMgr.GetManifestResourceIcon("layout_mousemode_hier_off_16.ico"));

            _ttpPartsAutoReloaded.ToolTipTitle = StringResMgr.Get("SYSTEM_RELOAD_NOTIFYT_TOOLTIP_TITLE"); // "部品ペインが自動リロードされました";

            if (!appsetting.ProjectSettings.CaptureTextureFunctionEnabled)
            {
                this._tmiPaneCreatePane.DropDownItems.Remove(_tmiPaneCreatePaneCapture);
                _tmiPane.DropDownItems.Remove(_tmiCreateCapturePaneWithChildren);
                _tmiViewCapturePaneEnabled.Visible = false;
            }

            // マージ前の状態のメニュー項目を配列に保存します。
            _paneMenuItemSet = new ToolStripItem[_tmiPane.DropDownItems.Count];
            _tmiPane.DropDownItems.CopyTo(_paneMenuItemSet, 0);
            _tmiPane.DropDownOpened += (s, e) =>
            {
                // コンテキストメニューの情報は消去
                _cmsMainOpenedPoint = null;
            };

            UpdateTransModePanel_();

            // 部品一覧ダイアログの初期化
            // this を _selectSubPartsDlg.Owner に 設定している場合に
            // _selectSubPartsDlg.Hide()時に、他の LayoutWindow の Activate イベントが
            // 発生して他のレイアウトウインドウが編集対象になってしまう不具合が
            // あったので、対症療法として _selectSubPartsDlg.Owner を未設定にしている。
            _selectSubPartsDlg.OnSceneSelected += OpenPartsDlgOnPartsSelect_;

            _pnlOriginalLayout.OnCustumPaint += Event_pnlOriginalLayout_OnCustumPaint;
            _pnlOriginalLayout.MouseEnter += Event_pnlOriginalLayout_MouseEnter;
            _pnlOriginalLayout.MouseLeave += Event_pnlOriginalLayout_MouseLeave;

            // メニューでの切り替えで右下のアイコンが切り替わるように修正
            _tmiPaneTransAffectsChildren.CheckStateChanged += (sender, args) => UpdateTransModePanel_();

            // 自動リロードメッセージ
            _timerAutoReloadMsg.Interval = 3000;
            _timerAutoReloadMsg.Tick += new EventHandler((s, e) =>
            {
                _timerAutoReloadMsg.Stop();
                _ttpPartsAutoReloaded.Active = false;
            });

            // ユーザコマンド用のメニューの設定
            AddUserCommandMenu(_tmiUserCommand);

            if (!appsetting.ProjectSettings.CaptureTextureFunctionEnabled)
            {
                this._tmiPaneCreatePane.DropDownItems.Remove(_tmiPaneCreatePaneCapture);
                _tmiViewCapturePaneEnabled.Visible = false;
            }

            if (!appsetting.ProjectSettings.AlignmentPaneEnabled)
            {
                this._tmiPaneCreatePane.DropDownItems.Remove(_tmiPaneCreatePaneAlignment);
                _tmiPaneCreatePaneAlignment.Visible = false;
            }

            if (_tmiUserCommand.DropDownItems.Count == 0)
            {
                _tssUserCommand.Visible = false;
                _tmiUserCommand.Visible = false;
            }

            // コンバイナエディタとの連携
            var combiner = LayoutEditor.src.CombinerEditor.CombinerCommunicationManager.CommunicationBridge;
            if (combiner != null)
            {
                combiner.ShaderChanged += this.OnShaderChanged;
            }
        }

        /// <summary>
        /// シーン状態を取得します。
        /// </summary>
        private TargetSubSceneSaveState FindSubSceneState_(ISubScene subScene)
        {
            return _targetSubSceneStates.Find((s) => object.ReferenceEquals(s.ISubScene, subScene));
        }

        /// <summary>
        /// 編集対象のシーンを設定します。
        /// </summary>
        private void SetCurrentSubScene_(TargetSubSceneSaveState subSceneState)
        {
            ISubScene subScene = subSceneState.ISubScene;

            // 表示ターゲットを変更する前後で、表示倍率などのステートを記録、復元します。
            if (_CurrentSubSceneState != null)
            {
                _CurrentSubSceneState.ISubScene.ISubSceneCmdQueue.QueueStateChangedEvent -= cmdQueue_QueueStateChangedEvent;
                _CurrentSubSceneState.Magnify = _mainView.Magnify;
                _CurrentSubSceneState.ScreenOrigInScene = _mainView.ScreenOrigInScene;
            }

            _ttpPartsAutoReloaded.Active = false;
            _mainView.TargetSubScene = subScene;

            SceneManipulator sceneMnp = new SceneManipulator();
            sceneMnp.BindTarget(_Scene);
            sceneMnp.CurrentISubScene = subScene;

            ISubSceneCmdQueue cmdQueue = subScene.ISubSceneCmdQueue;
            cmdQueue.QueueStateChangedEvent += cmdQueue_QueueStateChangedEvent;

            // Undo 回数の表示を更新
            UpdateUndoStateMessage_();

            TargetSubSceneSaveState subSceneSaveState = FindSubSceneState_(subScene);
            if (subSceneSaveState != null)
            {
                _mainView.Magnify = subSceneSaveState.Magnify;
                _mainView.ScreenOrigInScene = subSceneSaveState.ScreenOrigInScene;

                UpdateWindowTitleText_();
            }

            // メニュー更新
            UpdateProperty_();

            // 自動リロード処理
            foreach (var partsPane in subSceneState.ISubScene.FindPanesByKind(PaneKind.Parts))
            {
                // 新しい表示対象が依存する部品レイアウトを列挙する
                List<string> relatedFiles = new List<string>(partsPane.IPartsLayout.EnumlateReferencingLayoutFiles());

                // 編集中のファイルから探す
                // 最新リロード時間よりもあとに保存されていなかチェックする。
                var loadedFileStates = _targetSubSceneStates.Where((state) => relatedFiles.Contains(Path.GetFileName(state.LastSavedFileName)));
                if (loadedFileStates.Any((state) => state.LastSavedTime > subSceneState.LastReloadedTime))
                {
                    // リロードを実行する。
                    Event_TmiReloatPartsPane_Click(null, null);

                    _ttpPartsAutoReloaded.Active = true;
                    _ttpPartsAutoReloaded.Show(StringResMgr.Get("SYSTEM_RELOAD_NOTIFYT_TOOLTIP_TEXT"), this._pnlOriginalLayout);
                    _timerAutoReloadMsg.Start();
                }
            }
        }

        /// <summary>
        /// 表示対象のシーンを追加します。
        /// </summary>
        public TargetSubSceneSaveState AddTargetSubScene(LayoutDocument lytDoc)
        {
            ISubScene subScene = lytDoc.ISubScene;
            TargetSubSceneSaveState state = FindSubSceneState_(subScene);
            if (state == null)
            {
                // 最初の登録時間は、最初に開いたレイアウトの時間と同じ時間を設定しておく。
                DateTime lastSavedTime = _InitialSubSceneState != null ? _InitialSubSceneState.LastSavedTime : lytDoc.LastReloadedTime;

                state = new TargetSubSceneSaveState(lytDoc, lastSavedTime);
                state.Magnify = _mainView.Magnify;
                state.ScreenOrigInScene = _mainView.ScreenOrigInScene;

                _targetSubSceneStates.Add(state);
            }

            SetCurrentSubScene_(state);

            return state;
        }

        /// <summary>
        /// Undo 回数の表示を更新
        /// </summary>
        void UpdateUndoStateMessage_()
        {
            if (CurrentSubScene != null)
            {
                _pnlPaneState.Text = string.Format("[{0}={1} ({2})]", StringResMgr.Get("SYSTEM_TAG_UNDO"),
                    CurrentSubScene.CmdQueueInternalState.NumUndoCmd, CurrentSubScene.CmdQueueInternalState.NumRedoCmd);
            }
        }

        /// <summary>
        /// コマンド変更ハンドラ
        /// </summary>
        void cmdQueue_QueueStateChangedEvent(ISubSceneCmdQueue sender, CmdQueueChangedEventKind kind, ICommand cmd)
        {
            UpdateWindowTitleText_();
            UpdateUndoStateMessage_();

            if (kind == CmdQueueChangedEventKind.Undo ||
                kind == CmdQueueChangedEventKind.Redo)
            {
                _mainView.Invalidate();
            }
        }

        ///
        protected override void OnLoad(EventArgs e)
        {
            // 投影モードアイコンを更新。
            _btnPersepective.Image = _mainView.Renderer.PersepectiveRendering ? _pserpectiveIcon : _orthoIcon;

            // 一度配下の部品のサムネイルを生成しておきます。
            _selectSubPartsDlg.Setup(_targetSubSceneStates, _CurrentSubSceneState.LastSavedFilePath, AppSetting);
        }

        /// <summary>
        /// 移動モードパネルを更新します。
        /// </summary>
        void UpdateTransModePanel_()
        {
            Icon newIcon = _mainView.TransAffectsChildren ? _mouseModeIconSet[0] : _mouseModeIconSet[1];
            if (_pnlTransMode.Icon != newIcon)
            {
                _pnlTransMode.Icon = newIcon;
            }
        }


        /// <summary>
        /// 指定サブシーンが対象に含まれるか、調査します。
        /// </summary>
        public bool Targets(ISubScene subScene)
        {
            ISubScene targetSubScene = _mainView.TargetSubScene;
            if (targetSubScene != null)
            {
                if (targetSubScene == subScene)
                {
                    return true;
                }
            }
            return false;
        }

        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            // コンバイナエディタとの連携
            var combiner = LayoutEditor.src.CombinerEditor.CombinerCommunicationManager.CommunicationBridge;
            if (combiner != null)
            {
                combiner.ShaderChanged -= this.OnShaderChanged;
            }

            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }

                _selectSubPartsDlg.Dispose();
            }

            base.Dispose(disposing);
        }

        /// <summary>
        /// ファイル保存を確認せずに終了します。
        /// </summary>
        public void CloseIgnoreSaving()
        {
            try
            {
                _closeIgnoreSaving = true;
                Close();
            }
            finally
            {
                _closeIgnoreSaving = false;
            }
        }

        /// <summary>
        /// ビューの中心をシーン中心に設定します。
        /// </summary>
        public void SetViewDefalut()
        {
            ISubScene target = _mainView._TargetActiveSubScene;


            if (target != null)
            {
                // _mainViewのサイズを計算し、差分量を求めます。
                Size currentViewSize = _mainView.ClientSize;

                int newW = (int)(target.BackGround.ScreenSize.X * 1.2f) + SystemInformation.VerticalScrollBarWidth;
                int newH = (int)(target.BackGround.ScreenSize.Y * 1.2f) + SystemInformation.HorizontalScrollBarHeight;

                Rectangle workRect = System.Windows.Forms.Screen.PrimaryScreen.WorkingArea;
                float maxSizeMargineScale = 0.7f;

                Size newSize = new Size(
                    Math.Min(newW, (int)(workRect.Width * maxSizeMargineScale)),
                    Math.Min(newH, (int)(workRect.Height * maxSizeMargineScale)));


                Size diffSize = MathUtil.SubVec(newSize, currentViewSize);

                // 差分量を足すことで、サイズが変化しないコントロールの影響を排除して、
                // Formのサイズを設定することが可能です。
                this.ClientSize = MathUtil.AddVec(this.ClientSize, diffSize);
            }

            this.SetViewCenter();
        }

        /// <summary>
        ///
        /// </summary>
        public void SetViewCenter()
        {
            _mainView.SetViewDefault();
            UpdateProperty_();
        }

        /// <summary>
        /// ビューを選択中のペインにフォーカスします。
        /// </summary>
        public void SetViewFocus()
        {
            Event_MniAdjustViewToSelected_Click(this, null);
        }

        /// <summary>
        /// 再描画をします。
        /// </summary>
        void UpdateProperty_()
        {
            // 表示・非表示メニュー
            _tmiViewShowGrid.Checked = _mainView.BackGround.GridVisible;
            _tmiViewSnapToGrid.Checked = _mainView.BackGround.GridSnapEnalbed;
            _tmiViewOutline.Checked = _mainView.Renderer != null && (_mainView.Renderer.OptionFlag & IRenderOptionFlag.DrawOutline) != 0;
            _tmiViewBoundingPaneEnabled.Checked = !_mainView.DrawableOption.CheckActive(DrawableOptionFlag.IgnoreBoundingPaneDrawing);
            _tmiViewPartsPaneEnabled.Checked = !_mainView.DrawableOption.CheckActive(DrawableOptionFlag.IgnorePartsPaneRectDrawing);
            _tmiViewCapturePaneEnabled.Checked = !_mainView.DrawableOption.CheckActive(DrawableOptionFlag.IgnoreCapturePaneDrawing);

            // 境界矩形を描画しない
            // 状態によってメニューテキストを更新します。
            DrawableOptionFlag optionFlag = _mainView.DrawableOption.DrawableOptionFlag &
                (DrawableOptionFlag.IgnoreBVDrawing | DrawableOptionFlag.IgnoreDummyObjectDrawing);
            if (optionFlag == DrawableOptionFlag.None)
            {
                // ペイン境界線を隠す
                _tmiViewBoundingBoxDisabled.Text =
                    StringResMgr.Get("LAYOUT_MENU_VIEW_HIDE_BB");
            }
            else if (optionFlag == DrawableOptionFlag.IgnoreBVDrawing)
            {
                // ペイン境界線とNullペインを隠す
                _tmiViewBoundingBoxDisabled.Text =
                    StringResMgr.Get("LAYOUT_MENU_VIEW_HIDE_BB_NULLPANE");
            }
            else if (optionFlag == (DrawableOptionFlag.IgnoreBVDrawing |
                                     DrawableOptionFlag.IgnoreDummyObjectDrawing))
            {
                // ペイン境界線とNullペインを表示
                _tmiViewBoundingBoxDisabled.Text =
                    StringResMgr.Get("LAYOUT_MENU_VIEW_SHOW_BB_NULLPANE");
            }

            // 部品一覧の有効・無効
            _btnParts.Enabled = _InitialSubSceneState.ISubScene.ContainsPartsPane();

            // メニュー項目の状態。
            UpdateObjectMenuItemState_();
            UpdateToolMenuItemState_();



            //
            if (_mainView.Visible)
            {
                LEToolWindow.DbgReportUpdate(this);
                this._mainView.Invalidate(true);
            }
        }


        #region イベントハンドラ

        #region キーイベント

        /// <summary>
        /// Ctrl + Alt + XXX のショートカットを処理します。
        /// .NETフレームワークの規定の種類に含まれないショートカットキーです。
        /// </summary>
        void HandleShortcut_Ctrl_Alt_(object sender, KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
                case Keys.D2:
                    Event_MniObjectShowLocked_Click(this, null);
                    break;
                case Keys.D3:
                    Event_MniObjectResetHidden_Click(this, null);
                    break;
                // ウインドウ拡大
                case Keys.Add:
                case Keys.Oemplus:
                    Event_MniWindowExpand_Click(this, null);
                    break;
                // ウインドウ縮小
                case Keys.Subtract:
                case Keys.OemMinus:
                    Event_MniWindowShrink_Click(this, null);
                    break;
            }
        }

        /// <summary>
        /// Ctrl + Alt + XXX のショートカットを処理します。
        /// .NETフレームワークの規定の種類に含まれないショートカットキーです。
        /// </summary>
        void HandleShortcut_Ctrl_Shift_(object sender, KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
                // グリッド吸着する
                // このショートカット記述は、英語キーボードにおいても
                // 同様に機能します。
                // Keys.OemSemicolon は 英語キーボードのSemicolonキーに対応します。
                // 英語キーボードの : は Shift + Semicolonキーです。
                case Keys.OemSemicolon:
                    Event_MniViewGridSnap_Click(_tmiViewSnapToGrid, null);
                    break;

                // ズームイン・ズームアウト
                case Keys.Add:
                case Keys.Oemplus:
                    _mainView.ZoomIn();
                    break;
                case Keys.Subtract:
                case Keys.OemMinus:
                    _mainView.ZoomOut();
                    break;
            }
        }

        /// <summary>
        /// Ctrl + XXX のショートカットを処理します。
        /// .NETフレームワークの規定の種類に含まれないショートカットキーです。
        /// </summary>
        void HandleShortcut_Ctrl_(object sender, KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
                // ズームイン・ズームアウト
                case Keys.Add:
                case Keys.Oemplus:
                    _mainView.ZoomIn();
                    break;
                case Keys.Subtract:
                case Keys.OemMinus:
                    _mainView.ZoomOut();
                    break;
            }
        }

        /// <summary>
        /// ショートカットキー
        /// .NETフレームワークの規定の種類に含まれないショートカットキーです。
        /// </summary>
        void HandleShortcut_NoModify_(object sender, KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
                case Keys.S:
                    // カーブツリービューで選択されている項目にキーを追加する。
                    SendMessageToViewManager_(new ViewManagerMessage(ViewManagerMessageKind.CreateKeyFrameOnTargetCurve));
                    break;
                case Keys.A:
                    // 全体表示
                    SetViewDefalut();
                    break;
                case Keys.F:
                    // 選択部分を全体表示
                    SetViewFocus();
                    break;
                case Keys.Back:
                    // 消去
                    Event_MniEditDelete(this, null);
                    break;
                case Keys.Shift | Keys.P:
                case Keys.P:
                    {
                        HierarchyControl_(e.KeyData);
                    }
                    break;
                case Keys.G:
                    AddPaneAsNullPaneChild(_TargetActiveSubScene.ISelectedSet.IPaneArray);
                    break;
            }
        }


        /// <summary>
        /// ショートカットキー
        /// .NETフレームワークの規定の種類に含まれないショートカットキーです。
        /// </summary>
        void HandleShortcut_Always_(object sender, KeyEventArgs e)
        {
            // 矢印キーによる移動 => MainViewに移動しました。
        }

        /// <summary>
        /// キーダウン
        /// </summary>
        private void Event_LayoutWindow_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
        {
            if (e.KeyCode == Keys.ControlKey)
            {
                this.TransAffectsChildrenFlip = true;
            }

            // 明示的に（選択的に）、子コントロールにメッセージを伝播します。
            _mainView.Event_MainView_KeyDown(sender, e);
            e.Handled = true;

            if (e.Alt && e.Control)
            {
                HandleShortcut_Ctrl_Alt_(sender, e);
            }
            else if (e.Control && e.Shift)
            {
                HandleShortcut_Ctrl_Shift_(sender, e);
            }
            else if (e.Control)
            {
                HandleShortcut_Ctrl_(sender, e);
            }
            else
            {
                HandleShortcut_NoModify_(sender, e);
            }

            HandleShortcut_Always_(sender, e);
        }

        /// <summary>
        /// 通常キーかどうか判定します。
        /// 通常キーとして、キーイベントを受け取りたいキーで
        /// true を返してください。
        /// (注意：KeyPreview == true なので、子コントロールも同一の振る舞いをするようになります)
        /// </summary>
        protected override bool ProcessDialogKey(Keys keyData)
        {
            // IMEの状態をOFFにします。
            {
                _mainView.Focus();
                IntPtr hImc = LECore.Win32.Imm32.ImmGetContext(_mainView.Handle);
                if (hImc != IntPtr.Zero)
                {
                    if (LECore.Win32.Imm32.ImmGetOpenStatus(hImc))
                    {
                        LECore.Win32.Imm32.ImmSetOpenStatus(hImc, false);
                    }
                    LECore.Win32.Imm32.ImmReleaseContext(_mainView.Handle, hImc);
                }
            }

            // ズームイン・アウト操作時に、メニュー項目が表示されてしまう
            // のを回避しています。
            if ((Control.ModifierKeys & Keys.Alt) != 0)
            {
                if (LECore.Win32.User32.GetKeyState(LECore.Win32.VK.VK_SPACE) < 0)
                {
                    return true;
                }
            }

            switch (keyData)
            {
                // 矢印キー各種
                case Keys.Up: return false;
                case Keys.Down: return false;
                case Keys.Left: return false;
                case Keys.Right: return false;
            }
            return base.ProcessDialogKey(keyData);
        }

        private void Event_LayoutWindow_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
        {
            if (e.KeyCode == Keys.ControlKey)
            {
                this.TransAffectsChildrenFlip = false;
            }

            // 明示的に（選択的に）、子コントロールにメッセージを伝播します。
            _mainView.Event_MainView_KeyUp(sender, e);
            e.Handled = true;
        }
        #endregion キーイベント

        #region マウスイベント

        /// <summary>
        /// ツールメニューの更新
        /// </summary>
        private void UpdateToolMenuItemState_()
        {
            tmiLaunchAEViewer.Enabled
                = !string.IsNullOrEmpty(LECore.LayoutEditorCore.PlatformDetail.PlatformPreference.TargetViewerRunnnerPath);

            // プロジェクト設定ファイル内のコンバイナエディタが有効な場合のみメニューにセパレータを含め表示します。
            bool bCombinerEditor = AppSetting.ProjectSettings.IsCombinerUserShaderEnabled;
            _tmiLaunchCombinerEditor.Visible = bCombinerEditor;
            _toolStripMenuItemForCombinerEditor.Visible = bCombinerEditor;

        }

        ///
        void UpdateObjectMenuItemState_()
        {
            // 選択ペインが存在する場合有効になるメニュー
            bool bPaneSelected = !_TargetActiveSubScene.ISelectedSet.Empty;

            _tmiPaneMakeGroup.Enabled = bPaneSelected;
            _tmiPaneLockSelected.Enabled = bPaneSelected;
            _tmiPaneHideSlected.Enabled = bPaneSelected;
            _tmiPaneProperty.Enabled = bPaneSelected;
            _tmiPaneEditGroup.Enabled = bPaneSelected &&
            _TargetActiveSubScene.ILEGroupMgr.GroupSet.Length != 0;
            _tmiAlignment.Enabled = bPaneSelected;

            bool bHiddenExists = SubSceneHelper.GetHiddenPaneSet(_TargetActiveSubScene).Length != 0;
            bool bLockenExists = SubSceneHelper.GetLockedPaneSet(_TargetActiveSubScene).Length != 0;
            bool bLockenAndAppearExists = SubSceneHelper.GetLockedAndAppearPaneSet(_TargetActiveSubScene).Length != 0;
            bool bHiddenAndUnLockExists = SubSceneHelper.GetHiddenAndUnLockedPaneSet(_TargetActiveSubScene).Length != 0;

            _tmiPaneLockHidden.Enabled = bHiddenAndUnLockExists;
            _tmiPaneShowAllHidden.Enabled = bHiddenExists;

            _tmiPaneHideLocked.Enabled = bLockenAndAppearExists;
            _tmiPaneUnlockSelected.Enabled = bLockenExists;

            bool bBoundingPaneExists = SubSceneHelper.GetPaneSet(_TargetActiveSubScene, PaneKind.Bounding, true).Length != 0;

            _tmiPaneLockRegionPane.Enabled = bBoundingPaneExists;

            _tmiPaneTransAffectsChildren.Checked = _mainView.TransAffectsChildren;

            _tmiPaneDragModifiesSize.Checked = _mainView.PaneDragModifierChangesSize;

            _tmiReloadPartsPane.Enabled = _TargetActiveSubScene.ContainsPartsPane();

            var panes = _TargetActiveSubScene.ISelectedSet.IPaneArray;

            _tmiOpenPartsLayout.Enabled =
                panes.Count() == 1 &&
                panes.First().PaneKind == PaneKind.Parts;

            _tmiCreatePartsBySelectedNull.Enabled =
                panes.Count() == 1 &&
                panes.First().PaneKind == PaneKind.Null &&
                panes.First().Children.Count() > 0;

            _tmiResizeToTextureSize.Enabled = panes.Any(
                pane => pane.PaneKind == PaneKind.Picture &&
                pane.EnumrateAllTextureName().Count() == 1);

            _tmiCreateCapturePaneWithChildren.Enabled =
                bPaneSelected;

            _tmiAsChild.Enabled = panes.Count() >= 2;
            _tmiAsParent.Enabled = panes.Where(pane => !(pane.Parent as IPane).IsRootPane()).Count() > 0;
            _tmiCreateNullPaneAndAddChild.Enabled = CreateNullPaneAndAddChildEnable_();
        }

        private bool CreateNullPaneAndAddChildEnable_()
        {
            return _TargetActiveSubScene.ISelectedSet.IPaneArray.Count() > 0;
        }

        // メニュー生成の補助のための情報
        private class UserCommandMenuNode
        {
            public string name;
            public UserCommand command;
            public string prog;
            public List<UserCommandMenuNode> children = new List<UserCommandMenuNode>();
        }

        // ユーザーコマンド用のメニューの追加
        public void AddUserCommandMenu(ToolStripMenuItem menu)
        {
            var root = new UserCommandMenuNode();
            foreach (var command in AppSetting.ProjectSettings.UserCommands)
            {
                string basePath;
                string[] commands;
                try
                {
                    basePath = command.GetBaseDirectoryName();
                    commands = command.Commands.ToArray();
                }
                catch
                {
                    // 検索に失敗したら無視
                    continue;
                }

                if (commands.Length == 0)
                {
                    continue;
                }

                var menuTree = command.Name.Split(new[] { '/' }, StringSplitOptions.RemoveEmptyEntries);

                var mni = root;

                // 名前に基づいた階層の作成
                foreach (var s in menuTree)
                {
                    var cmni = mni.children.Where(x => x.name == s && x.command == null).FirstOrDefault();
                    if (cmni == null)
                    {
                        cmni = new UserCommandMenuNode()
                        {
                            name = s,
                        };
                        mni.children.Add(cmni);
                    }
                    mni = cmni;
                }

                foreach (var prog in commands)
                {
                    var dmni = mni;
                    try
                    {
                        if (!string.IsNullOrEmpty(basePath))
                        {
                            // ディレクトリに基づいた階層の作成
                            var directory = Path.GetDirectoryName(prog);
                            var relativePath = LECore.Win32.Utility.GetRelativePath(basePath + @"\", directory + @"\");
                            var nodes = relativePath.Split(new[] { '\\' }, StringSplitOptions.RemoveEmptyEntries);
                            foreach (var s in nodes)
                            {
                                var cmni = dmni.children.Where(x => x.name == s && x.command == null).FirstOrDefault();
                                if (cmni == null)
                                {
                                    cmni = new UserCommandMenuNode()
                                    {
                                        name = s,
                                    };
                                    dmni.children.Add(cmni);
                                }
                                dmni = cmni;
                            }
                        }
                    }
                    catch
                    {
                        Debug.Assert(false);
                        continue;
                    }

                    {
                        var cmni = new UserCommandMenuNode()
                        {
                            name = Path.GetFileNameWithoutExtension(prog),
                            prog = prog,
                            command = command,
                        };

                        dmni.children.Add(cmni);
                    }
                }
            }

            ConvertUserCommandNodeToMenuItem(menu, root);
        }

        // ユーザーコマンド用のメニューの作成
        private void ConvertUserCommandNodeToMenuItem(ToolStripMenuItem mni, UserCommandMenuNode node)
        {
            if (node.name != null)
            {
                mni.Text = node.name;
            }

            bool promoted = false;
            // 子が一つならノードを省略
            if (node.children.Count == 1 && node.children[0].command != null && node.name != null)
            {
                promoted = true;
                node = node.children[0];
            }

            if (node.command != null)
            {
                mni.ToolTipText = node.prog;
                mni.Click += (s, e) => CallUserCommand(node.prog, node.command, node.name);
                Keys keys = ConvertToKeys(node.command.ShortCut);

                if (promoted && keys != Keys.None)
                {
                    // 詳しく調査していないが、例外になった
                    //mni.ShortcutKeys = keys;

                    _userCommandShortCutKeyActions[keys] = () => CallUserCommand(node.prog, node.command, node.name);
                    mni.ShortcutKeyDisplayString = node.command.ShortCut;
                }
            }
            else
            {
                foreach (var child in node.children)
                {
                    var cmni = new ToolStripMenuItem();
                    mni.DropDownItems.Add(cmni);
                    ConvertUserCommandNodeToMenuItem(cmni, child);
                }
            }
        }

        // Keys に変換
        private Keys ConvertToKeys(string text)
        {
            if (string.IsNullOrEmpty(text))
            {
                return Keys.None;
            }

            var keys = text.ToUpper().Split(new[] { '+', ' ' }, StringSplitOptions.RemoveEmptyEntries);
            var keybind = Keys.None;

            var hasKey = false;
            foreach (var key in keys)
            {
                switch (key)
                {
                    case "CTRL":
                    case "CONTROL":
                        keybind |= Keys.Control;
                        break;
                    case "SHIFT":
                        keybind |= Keys.Shift;
                        break;
                    case "ALT":
                        keybind |= Keys.Alt;
                        break;
                    case "ESC":
                    case "ESCAPE":
                        keybind |= Keys.Escape;
                        hasKey = true;
                        break;
                    default:
                        {
                            // 複数のキーは登録できない
                            if (hasKey)
                            {
                                return Keys.None;
                            }

                            var mainkey = Keys.None;
                            try
                            {
                                var keyconv = new KeysConverter();
                                var k = keyconv.ConvertFromString(key);
                                if (k == null)
                                {
                                    Keys result;
                                    if (Enum.TryParse<Keys>(key, true, out result))
                                    {
                                        k = result;
                                    }
                                }
                                mainkey = k != null ? (Keys)k : Keys.None;
                            }
                            catch (Exception)
                            {
                                mainkey = Keys.None;
                            }

                            if (mainkey == Keys.None)
                            {
                                return Keys.None;
                            }

                            keybind |= mainkey;
                            hasKey = true;
                        }
                        break;
                }
            }

            if (hasKey)
            {
                return keybind;
            }

            return Keys.None;
        }

        /// <summary>
        /// ユーザーコマンドの呼び出し
        /// </summary>
        private bool CallUserCommand(string userCommandPath, UserCommand command, string commandName)
        {
            if (!_CurrentSubSceneState.IsFileSaved)
            {
                MessageBox.Show(string.Format(StringResMgr.Get("USER_COMMAND_NOT_SAVED"), _CurrentSubSceneState.LastSavedFileName, commandName));
                return false;
            }

            if (command.ConfirmSave && _CurrentSubSceneState.IsUpdated)
            {
                MessageBox.Show(string.Format(StringResMgr.Get("USER_COMMAND_MODIFIED"), _CurrentSubSceneState.LastSavedFileName, commandName));
                return false;
            }

            var args = command.Args;
            if (!String.IsNullOrEmpty(args))
            {
                args = Environment.ExpandEnvironmentVariables(args);

                const string layoutFile = "$(LayoutFile)";
                if (args.Contains(layoutFile))
                {
                    args = args.Replace(layoutFile, _CurrentSubSceneState.LastSavedFilePath);
                }

                const string panes = "$(Panes)";
                if (args.Contains(panes))
                {

                    args = args.Replace(panes,
                        String.Join(" ", _TargetActiveSubScene.ISelectedSet.IPaneArray.Select(x => x.PaneName)));
                }
            }

            try
            {
                var process = Process.Start(userCommandPath, args ?? "");

                if (process == null)
                {
                    MessageBox.Show(string.Format(StringResMgr.Get("USER_COMMAND_FAILED"), commandName, userCommandPath + " " + args ?? "", ""));
                    return true;
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(string.Format(StringResMgr.Get("USER_COMMAND_FAILED"), commandName, userCommandPath + " " + args ?? "", e.Message));
                return false;
            }

            return true;
        }


        /// <summary>
        /// コンテキストメニューの表示を処理します。
        /// クリック位置から、メニュー内容を変更します。
        /// </summary>
        void OnContextMenuShow_(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            // オブジェクトメニューの状態を更新します。
            UpdateObjectMenuItemState_();

            if (_cmsMain != null)
            {
                _cmsMain.Dispose();
            }
            _cmsMain = common.ToolStripMenuItemHelper.MakeContextMenuStripFromToolStripMenuItem(_paneMenuItemSet);

            // 重なったペインの選択メニュー
            {
                _cmsMain.Items.Insert(1, new ToolStripSeparator());

                ToolStripMenuItem selectPanesNode = CreateMenuForSelectOverwrapPanes_();

                _cmsMain.Items.Insert(2, selectPanesNode);
            }

            Control ctrl = sender as Control;
            Debug.Assert(ctrl != null);

            // 開いたときのマウスの位置
            _cmsMainOpenedPoint = new Point(e.X, e.Y);

            // メッセージ送り主の子供として、表示します。
            _cmsMain.Show(ctrl, _cmsMainOpenedPoint.Value);
        }

        /// <summary>
        /// 重なったペインを選択するメニューを作ります。
        /// </summary>
        private ToolStripMenuItem CreateMenuForSelectOverwrapPanes_()
        {
            var scenePos = _mainView.ScreenToScene(_mainView.PointToClient(Control.MousePosition));
            var hitPanes = _TargetActiveSubScene.IPaneArray.Where((pane) => pane.GetBoundingVolumeInWorld().Contains(scenePos));

            var selectPanesNode = new ToolStripMenuItem(LECoreStringResMgr.Get("LECORE_SELECT_OVERWRAPPANE"));

            selectPanesNode.Enabled = hitPanes.Count() > 0;
            foreach (var pane in hitPanes)
            {
                ToolStripMenuItem paneItem = new ToolStripMenuItem(pane.PaneName);
                paneItem.Image = PaneItemImageHelper.GetPaneImage(pane);

                paneItem.Click += new EventHandler((sndr, arg) =>
                {
                    SubSceneManipulator subSceneMnp = new SubSceneManipulator();

                    subSceneMnp.BindTarget(_TargetActiveSubScene);

                    subSceneMnp.BeginSelectSetChange();
                    subSceneMnp.ResetSelectedSet();
                    subSceneMnp.SelectPanesByPaneRef(pane);
                    subSceneMnp.EndSelectSetChange();
                });

                selectPanesNode.DropDownItems.Add(paneItem);
            }

            return selectPanesNode;
        }


        /// <summary>
        /// 注意：
        /// 本フォームは、
        /// コンストラクタで、子コントロールのマウスイベントを受け取るように、
        /// 設定されています。
        /// </summary>
        private void Event_LayoutWindow_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                // スペースが押されていない。
                if (LECore.Win32.User32.GetKeyState(LECore.Win32.VK.VK_SPACE) >= 0)
                {
                    // ダブルクリックされた場合、
                    if (e.Clicks == 2)
                    {
                        // 選択ペインのプロパティダイアログを開きます。
                        if (!_TargetActiveSubScene.ISelectedSet.Empty)
                        {
                            SendMessageToViewManager_(ViewManagerMessage.ShowPropertyWndMsg);
                        }
                    }
                }
            }
            else if (e.Button == MouseButtons.Right)
            {
                // 右クリックされた場合は、コンテキストメニューを表示します。
                // クリック位置によって表示するメニュー項目を変更します。
                OnContextMenuShow_(sender, e);
            }
        }

        /// <summary>
        /// マウスムーブハンドラ
        /// </summary>
        private void Event_LayoutWindow_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            // ステータスバーなどの情報を更新します。
            _currentMousePosInScene = _mainView.ScreenToScene(_mainView.PointToClient(Control.MousePosition));
            if (_pnlMouseMode.Text == "" || _pnlMouseMode.Tag == null)
            {
                _pnlMouseMode.Text = string.Format("{0}, {1}", (int)_currentMousePosInScene.X, (int)_currentMousePosInScene.Y);
                _pnlMouseMode.Tag = null;
            }
        }
        #endregion マウスイベント

        #region メニュー関連

        /// <summary>
        /// メニュー > 閉じる
        /// </summary>
        private void Event_MniClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary>
        /// Undo
        /// </summary>
        private void Event_MniEditUndo(object sender, System.EventArgs e)
        {
            if (_GrbTime.IsPlaying != false)
            {
                return;
            }

            SubSceneManipulator subSceneMnp = new SubSceneManipulator();
            subSceneMnp.BindTarget(_TargetActiveSubScene);

            subSceneMnp.Undo();
        }

        /// <summary>
        /// Redo
        /// </summary>
        private void Event_MniEditRedo(object sender, System.EventArgs e)
        {
            if (_GrbTime.IsPlaying != false)
            {
                return;
            }

            SubSceneManipulator subSceneMnp = new SubSceneManipulator();
            subSceneMnp.BindTarget(_TargetActiveSubScene);

            subSceneMnp.Redo();
        }

        /// <summary>
        /// すべてのペインの選択状態を判定します。
        /// </summary>
        void InvertSelectionAll_()
        {
            foreach (IPane pane in _subSceneManipulator.ISubScene.IPaneArray)
            {
                _subSceneManipulator.InvertSelection(pane);
            }
        }

        /// <summary>
        /// 全体選択
        /// </summary>
        private void Event_MniSelectAll_Click(object sender, System.EventArgs e)
        {
            // _sceneManipulator.BindTarget( _TargetActiveSubScene );

            _subSceneManipulator.BeginSelectSetChange();
            // リセットして反転
            _subSceneManipulator.ResetSelectedSet();
            InvertSelectionAll_();
            _subSceneManipulator.EndSelectSetChange();

        }

        /// <summary>
        /// 一つ前を選択
        /// </summary>
        private void Event_TmiSelectPrev_Click(object sender, EventArgs e)
        {
            IPane[] selsectedSet = _TargetActiveSubScene.ISelectedSet.IPaneArray;

            if (selsectedSet.Length > 0)
            {
                PaneHelper.SortPaneSetByDrawOrder(selsectedSet);
                IPane frontPane = selsectedSet[0];

                frontPane = PaneHelper.GetFrontPane(frontPane);
                if (frontPane != null && !frontPane.IsRootPane())
                {
                    // 選択変更
                    _subSceneManipulator.BeginSelectSetChange();
                    _subSceneManipulator.ResetSelectedSet();
                    _subSceneManipulator.SelectPanesByPaneRef(frontPane);
                    _subSceneManipulator.EndSelectSetChange();
                }

            }
        }

        /// <summary>
        /// 一つ後を選択
        /// </summary>
        private void Evnet_TmiSelectNext_Click(object sender, EventArgs e)
        {
            IPane[] selsectedSet = _TargetActiveSubScene.ISelectedSet.IPaneArray;

            if (selsectedSet.Length > 0)
            {
                PaneHelper.SortPaneSetByDrawOrder(selsectedSet);
                IPane backPane = selsectedSet[selsectedSet.Length - 1];
                backPane = PaneHelper.GetBackPane(backPane);
                if (backPane != null && !backPane.IsRootPane())
                {
                    // 選択変更
                    _subSceneManipulator.BeginSelectSetChange();
                    _subSceneManipulator.ResetSelectedSet();
                    _subSceneManipulator.SelectPanesByPaneRef(backPane);
                    _subSceneManipulator.EndSelectSetChange();
                }
            }
        }

        #region 未使用フォントを削除
        /// <summary>
        /// シーンからリソースを削除する関数。
        /// </summary>
        delegate string[] _ResourceRemoveFunction();

        /// <summary>
        /// シーンからリソースを削除します。
        /// </summary>
        void RemoveResources_(string resourceKind, _ResourceRemoveFunction removeFunc)
        {
            // APPFORM_MSG_DELETE_UNUSED_TITLE "未使用{0}を削除"
            // APPFORM_MSG_DELETE_UNUSED_DELETED "以下の{0}が削除されました.\n"
            // APPFORM_MSG_DELETE_UNUSED_NOTDELETED "{0}は削除されませんでした"
            // APPFORM_MSG_DELETE_UNUSED_MESSAGE  "取り消し情報(Undo)、およびエディタ内部のクリップボード情報が破棄されます。よろしいですか？"
            string titleString = StringResMgr.Get("APPFORM_MSG_DELETE_UNUSED_TITLE", resourceKind);
            string reportMsg = StringResMgr.Get("APPFORM_MSG_DELETE_UNUSED_DELETED", resourceKind);
            string reportNotRemoveMsg = StringResMgr.Get("APPFORM_MSG_DELETE_UNUSED_NOTDELETED", resourceKind);

            DialogResult res = MessageBox.Show(StringResMgr.Get("APPFORM_MSG_DELETE_UNUSED_MESSAGE"), titleString, MessageBoxButtons.OKCancel);
            if (res == DialogResult.OK)
            {
                string[] deletedTexNameSet = removeFunc();

                if (deletedTexNameSet.Length != 0)
                {
                    foreach (string texName in deletedTexNameSet)
                    {
                        reportMsg += texName + "\n";
                    }
                    MessageBox.Show(reportMsg, titleString);
                }
                else
                {
                    MessageBox.Show(reportNotRemoveMsg, titleString);
                }
            }
        }

        /// <summary>
        /// 未使用フォントを削除
        /// </summary>
        private void Event_TmiDeleteUnusedFont_Click(object sender, EventArgs e)
        {
            RemoveResources_(StringResMgr.Get("APPFORM_MSG_DELETE_UNUSED_FONT"), new _ResourceRemoveFunction(_subSceneManipulator.DeleteUnusedFont));
        }
        #endregion 未使用フォントを削除

        #region メニューハンドラ:開く
        /// <summary>
        /// ファイル名を設定する。（仮）
        /// </summary>
        public void SetFileName(string fileName)
        {
            Debug.Assert(Path.IsPathRooted(fileName));
            UpdateSaveState_(_CurrentSubSceneState, fileName);
        }

        /// <summary>
        /// ファイルを読み込みます。
        /// </summary>
        private bool DoAdditionalImportAll_(string filePath)
        {
            bool result = false;

            BackGround backGround = new BackGround();
            backGround.Set(_TargetActiveSubScene.BackGround);
            _mainView.Visible = false;

            bool isAdditionalImport = true;
            result = LayoutEditorCore.ImportFromFileAll(_TargetActiveSubScene, filePath, isAdditionalImport);

            _mainView.Visible = true;
            _TargetActiveSubScene.BackGround.Set(backGround);
            _mainView.Invalidate();

            return result;
        }

        #endregion メニューハンドラ:開く

        #region メニューハンドラ：追加で開く

        /// <summary>
        ///
        /// </summary>
        private void ForceSetDirty(ISubScene subScene)
        {
            SubSceneManipulator subSceneMnp = new SubSceneManipulator();
            subSceneMnp.BindTarget(subScene);

            subSceneMnp.ResetUndoState();
            _CurrentSubSceneState.ResetModifyState();
            _CurrentSubSceneState.ForceModifyStateDirty();
        }

        /// <summary>
        ///
        /// </summary>
        private void AdditionalLoadFile(string filePath)
        {
            try
            {
                if (DoAdditionalImportAll_(filePath) != false)
                {
                    ForceSetDirty(_TargetActiveSubScene);
                    UpdateWindowTitleText_();
                }
            }
            catch
            {
                LayoutEditorCore.MsgReporter.ReportError(LECoreStringResMgr.Get("LECORE_DLG_TITLE_LOAD"), LECoreStringResMgr.Get("LAYOUT_ERROR_ADDITIONAL_READ"));
                return;
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void AdditionalLoadFile()
        {
            string[] loadedFilePathSet;
            if (SaveLoadUIHelper.AskInputFilePath(ImportExportFileKind.All, out loadedFilePathSet))
            {
                foreach (string loadedFilePath in loadedFilePathSet)
                {
                    DoAdditionalImportAll_(loadedFilePath);
                }
            }

            if (loadedFilePathSet.Length > 0)
            {
                ForceSetDirty(_TargetActiveSubScene);
                UpdateWindowTitleText_();
            }
        }

        /// <summary> メニューハンドラ：追加で開く </summary>
        private void Event_MniOpenAsAddition_Click(object sender, System.EventArgs e)
        {
            AdditionalLoadFile();
        }

        #endregion 追加で開く

        #region メニューハンドラ:保存

        #region 保存関連
        /// <summary>
        /// すべてを保存します。
        /// </summary>
        /// <returns>成否</returns>
        bool SaveAllFiles_(IEnumerable<TargetSubSceneSaveState> targetSceneStates, string[] names)
        {
            if (SubSceneHelper.IsPartsReloading)
            {
                MessageBox.Show(LECoreStringResMgr.Get("WARNING_CACEL_SAVE_RELOADING"), AppConstants.AppName);
                return false;
            }

            bool bResult = true;
            foreach (TargetSubSceneSaveState saveState in targetSceneStates)
            {
                // すでにセーブされている場合は、そのファイル名でセーブします。
                if (saveState.IsFileSaved)
                {
                    string filePath = saveState.LastSavedFilePath;
                    if (names != null && !names.Contains(filePath))
                    {
                        continue;
                    }

                    Debug.Assert(Path.IsPathRooted(filePath));
                    ExportOption exportOption = new ExportOption() {
                        UseBaseValue = true,
                        Frame = GlobalTime.Inst.Time,
                        CreateThumbnail = AppSetting.ProjectSettings.SaveThumbnailImage,
                    };
                    if (LayoutEditorCore.ExportToFileAll(saveState.ISubScene, filePath, exportOption))
                    {
                        this.TryNeedlessAnimationFileDeletion_(saveState.ISubScene, filePath);
                        UpdateSaveState_(saveState, filePath);
                    }
                    else
                    {
                        bResult &= false;
                    }
                }
                else
                {
                    bResult &= SaveAllAsNewFiles_(saveState);
                }
            }

            return bResult;
        }

        /// <summary>
        /// すべてを新しいファイルとして保存します。
        /// </summary>
        bool SaveAllAsNewFiles_(TargetSubSceneSaveState saveState)
        {
            string resultPath;
            if (DoExportAll_(saveState, out resultPath))
            {
                UpdateSaveState_(saveState, resultPath);
                return true;
            }

            return false;
        }

        /// <summary>
        /// 指定種類を出力します。
        /// </summary>
        bool DoExportAll_(TargetSubSceneSaveState saveState, out string outFilePath) //
        {
            if (SubSceneHelper.IsPartsReloading)
            {
                MessageBox.Show(LECoreStringResMgr.Get("WARNING_CACEL_SAVE_RELOADING"), AppConstants.AppName);
                outFilePath = string.Empty;

                return false;
            }

            if (!SaveLoadUIHelper.AskOutputFilePath(ImportExportFileKind.All, saveState.LastSavedFilePath, out outFilePath))
            {
                return false;
            }

            ExportOption exportOption = new ExportOption() {
                UseBaseValue = true,
                Frame = GlobalTime.Inst.Time,
                CreateThumbnail = AppSetting.ProjectSettings.SaveThumbnailImage,
            };
            bool bResult = LayoutEditorCore.ExportToFileAll(saveState.ISubScene, outFilePath, exportOption);
            if (bResult)
            {
                this.TryNeedlessAnimationFileDeletion_(saveState.ISubScene, outFilePath);
            }

            return bResult;
        }

        /// <summary>
        /// アニメーションファイルの削除を確認します。
        /// </summary>
        void TryNeedlessAnimationFileDeletion_(ISubScene subScene, string outFilePath)
        {
            string animFilePath = Path.ChangeExtension(outFilePath, AppConstants.AnimationFileExt);
            if (File.Exists(animFilePath))
            {
                // 何もアニメーション情報を持っていない。
                if (!SubSceneHelper.HasAnyAnimationOrTexturePatternTexMap(subScene))
                {
                    // アニメーションファイルを消去しますか？
                    if (MessageBox.Show(
                        StringResMgr.Get("CONFIRM_DELETE_USELESS_ANIM", Path.GetFileName(animFilePath), animFilePath),
                        LECoreStringResMgr.Get("LECORE_FILESAVE"), MessageBoxButtons.YesNo) == DialogResult.Yes)
                    {
                        LayoutEditorCore.FileDelete(animFilePath, (file) =>
                        {
                            try
                            {
                                File.Delete(file);
                            }
                            catch (System.Exception ex)
                            {
                                DbgConsole.WriteLine("ERROR : {0}", ex.ToString());
                                return false;
                            }

                            return true;
                        });
                    }
                }
            }
        }

        /// <summary>
        /// LayoutWindowのセーブ状態を更新します。
        /// </summary>
        void UpdateSaveState_(TargetSubSceneSaveState saveState, string savedPath)
        {
            Debug.Assert(Path.IsPathRooted(savedPath));

            // セーブファイル名を更新します。
            saveState.SetStateSaved(savedPath);

            UpdateWindowTitleText_();
        }

        #endregion 保存関連

        /// <summary>
        /// 保存 > すべて
        /// </summary>
        private void Event_MniFileSave_Click(object sender, System.EventArgs e)
        {
            SaveAllFiles_(new TargetSubSceneSaveState[] { _CurrentSubSceneState }, null);
        }

        /// <summary>
        /// 別名で保存 > すべて
        /// </summary>
        private void Event_MniSaveAs_Click(object sender, System.EventArgs e)
        {
            // 表示中のファイルだけ保存する。
            SaveAllAsNewFiles_(_CurrentSubSceneState);
        }

        #endregion メニューハンドラ:保存

        #region メニューハンドラ：バイナリ出力

        /// <summary>
        /// 指定されたパス、ファイル名でバイナリファイルを出力します。
        /// ExportBinaryFileDlgに渡す、デリゲータとして使用されます。
        /// </summary>
        bool ExportTemporaryFileForBinayFileExport_(string outPath, string outName, object saveOption)//
        {
            bool fixInfinity = (bool)saveOption;
            ExportOption option = new ExportOption() {
                BakeAnimationInfinityCurve = fixInfinity,
                UseBaseValue = true,
                Frame = GlobalTime.Inst.Time
            };
            string outFileName = Path.Combine(outPath, outName);

            bool result = LayoutEditorCore.ExportToFileAll(_TargetActiveSubScene, outFileName, option);
            if (result)
            {
                TryNeedlessAnimationFileDeletion_(_TargetActiveSubScene, outFileName);
            }

            return result;
        }

        /// <summary>
        /// バイナリ出力
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Event_MniExportBinary_Click(object sender, System.EventArgs e)
        {
            // バイナリファイル名等が指定されていない場合は、
            // ソースレイアウトの情報を指定します。
            string filePath = (AppSetting.LastExportedBinaryFilePath != string.Empty) ?
                AppSetting.LastExportedBinaryFilePath :
                Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData);

            string fileName = (_CurrentSubSceneState.IsFileSaved) ?
                Path.GetFileNameWithoutExtension(_CurrentSubSceneState.LastSavedFilePath) :
                "input_binary_file_name";


            // ダイアログを開いて、出力パラメータを収集後、
            // バイナリファイル出力をします。
            ExportBinaryFileDlg outBinDlg =
                new ExportBinaryFileDlg(
                    ExportTemporaryFileForBinayFileExport_,
                    filePath,
                    fileName,
                    AppSetting);

            if (outBinDlg.ShowDialog() == DialogResult.OK)
            {
                // 何もしません。
            }
        }
        #endregion メニューハンドラ：バイナリ出力

        #region メニューハンドラ:オブジェクト

        /// <summary>
        /// ドロップダウン
        /// </summary>
        private void Event_TmiPane_DropDownOpened(object sender, EventArgs e)
        {
            UpdateObjectMenuItemState_();
        }


        /// <summary>
        /// 選択ペインのプロパティダイアログを開きます。
        /// </summary>
        private void Event_MniProperties_Click(object sender, System.EventArgs e)
        {
            // 選択ペインのプロパティダイアログを開きます。
            SendMessageToViewManager_(ViewManagerMessage.ShowPropertyWndMsg);
        }

        /// <summary>
        /// 階層設定開始
        /// </summary>
        private void Event_MniObjectMakeHier_Click(object sender, System.EventArgs e)
        {
            _mainView.StartHierarchyMaking();
        }

        /// <summary>
        /// 階層解除開始
        /// </summary>
        private void Event_MniObjectBreakHier_Click(object sender, System.EventArgs e)
        {
            _mainView.StartHierarchyBreaking();
        }
        /// <summary>
        /// 平行移動を子に影響させる。
        /// </summary>
        private void Event_MniTransAffectsChildren_Click(object sender, System.EventArgs e)
        {
            _mainView.TransAffectsChildren = !_mainView.TransAffectsChildren;
            UpdateObjectMenuItemState_();
        }

        /// <summary>
        /// 調整点のドラッグでペインサイズを変更する
        /// </summary>
        private void Event_TmiPaneDragModifiesSize_Click(object sender, EventArgs e)
        {
            _mainView.PaneDragModifierChangesSize = !_mainView.PaneDragModifierChangesSize;
            UpdateObjectMenuItemState_();
        }


        /// <summary>
        /// 選択からグループを作成
        /// </summary>
        private void Event_MniObjectMakeGroup_Click(object sender, System.EventArgs e)
        {
            IPane[] paneSet = _subSceneManipulator.ISubScene.ISelectedSet.IPaneArray;
            ILEGroupMgr groupMgr = _subSceneManipulator.ISubScene.ILEGroupMgr;

            // 同じグループが存在しないか確認。
            // 同一グループによる処理の中断を確認します。
            //
            // 同一内容グループ は妥当であるため、上記処理は廃止しました。


            // 選択セットから、新規にグループを作成します。
            // グループを作成します。
            GroupMgrManipulator groupMgrMnp = new GroupMgrManipulator();
            groupMgrMnp.BindTarget(groupMgr);
            groupMgrMnp.MakeNewGroupFromPaneSet(paneSet, AppSetting.ProjectSettings.GetNewGroupPaneName());


            // 選択を解除します。
            _subSceneManipulator.ResetSelectedSet();
        }

        /// <summary>
        /// グループを編集
        /// 編集用のダイアログを
        /// </summary>
        private void Event_MniObjectEditGroup_Click(object sender, EventArgs e)
        {
            PaneGroupEditDlg ged = new PaneGroupEditDlg(_TargetActiveSubScene);
            ged.ShowDialog(this);
        }


        #region ペイン生成
        /// <summary>
        /// 新規に登録したペインの位置を
        /// 現在のマウス位置に対応するシーン位置に設定します。
        /// 選択中のペインがあればその中心位置に設定します。
        /// </summary>
        void SetNewPanePositionToContextMenuPos_(IPane newPane)
        {
            float transX, transY, transZ;

            // コンテキストメニューからの呼び出しか？
            if (!_cmsMainOpenedPoint.HasValue)
            {
                transX = 0.0f;
                transY = 0.0f;
                transZ = newPane.Trans.Z;
            }
            else
            {
                PointF pos = _mainView.ScreenToScene(_cmsMainOpenedPoint.Value);

                // コンテキストメニューの表示位置をペイン作成位置の候補にする
                transX = (float)Math.Round(pos.X);
                transY = (float)Math.Round(pos.Y);
                transZ = newPane.Trans.Z;

                IPane[] selectedPanes = _TargetActiveSubScene.ISelectedSet.IPaneArray;

                // 選択ペインの上で右クリックしたときは選択ペインの位置に合わせる
                if (selectedPanes.Length > 0)
                {
                    foreach (IPane pane in selectedPanes)
                    {
                        var rectangle = pane.GetBoundingVolumeInWorld();

                        if (rectangle.Contains(pos))
                        {
                            transX = pane.XInWorld4x4;
                            transY = pane.YInWorld4x4;
                            break;
                        }
                    }
                }
            }

            // ペインの位置を設定
            PaneManipulator paneMnp = new PaneManipulator();
            paneMnp.BindTarget(newPane);
            paneMnp.TransWithoutCmdMaking = new FVec3(transX, transY, transZ);
        }

        /// <summary>
        /// Nullペインの作成
        /// </summary>
        private void Event_MniObjectCreatePaneNull_Click(object sender, System.EventArgs e)
        {
            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);
            IPane pane = _subSceneManipulator.AddNullPane(AppSetting.ProjectSettings.GetNewNullPaneName());

            // "子階層に透明度の影響を伝える"にツール環境設定で設定された値を設定する
            PaneManipulator paneMnp = new PaneManipulator();
            paneMnp.BindTarget(pane);
            paneMnp.InfluenceChildrenTransparencyWithoutCmdMaking = AppSetting.ConveyTransparencyInfluenceOfNull;

            // コンテキストメニューからの呼び出しならば、マウスの位置に、ペインを設定します。
            SetNewPanePositionToContextMenuPos_(pane);
        }

        /// <summary>
        /// シーンに読み込まれた、フォント名の列挙
        /// </summary>
        IEnumerable<string> GetCurrentSceneLoadedFontNames_()
        {
            if (_TargetActiveSubScene == null)
            {
                return new string[0];
            }

            return _TargetActiveSubScene.ILEFontManager.ILEFontSet.Select<ILEFont, string>((font) => font.FontName);
        }

        IEnumerable<string> GetFontNamesSpecifiedInProject()
        {
            if (_TargetActiveSubScene == null)
            {
                return new string[0];
            }

            return _TargetActiveSubScene.ILEFontManager.ILEFontSet.Where(x => x.FontSettings != null && !x.IsComplexFont())
                .Select<ILEFont, string>((font) => font.FontName);
        }

        /// <summary>
        /// テキストボックスペインの作成
        /// </summary>
        private void Event_MniObjectCreatePaneTextbox_Click(object sender, System.EventArgs e)
        {
            _createTextBoxDlg.Setup(AppSetting.LastLoadedFontFilePath, GetCurrentSceneLoadedFontNames_(), GetFontNamesSpecifiedInProject());

            if (_createTextBoxDlg.ShowDialog(this) == DialogResult.OK)
            {
                ILEFont font = null;
                // フォントの読み込み
                try
                {
                    if (_createTextBoxDlg.FontFilePath != string.Empty)
                    {
                        font = _TargetActiveSubScene.ILEFontManager.CreateILEFontFromBRFNT(_createTextBoxDlg.FontFilePath);
                        AppSetting.LastLoadedFontFilePath = _createTextBoxDlg.FontFilePath;

                        if (!string.IsNullOrEmpty(font.InitializationErrorMessage))
                        {
                            // プロパティウインドウ - エラー
                            string title = LayoutEditor.StringResMgr.Get("PROP_ERROR_DLG_TITLE");
                            LECore.LayoutEditorCore.MsgReporter.ReportError(title, font.InitializationErrorMessage);
                        }
                        else if ((LEFontHelper.IsBitmapFontFile(font.FontPath) || LEFontHelper.IsComplexFont(font)) &&
                            !LEFontHelper.IsAcceptableBntxPlatform(font, LECore.LayoutEditorCore.PlatformDetail.PlatformPreference))
                        {
                            // プロパティウインドウ - エラー
                            string title = LayoutEditor.StringResMgr.Get("PROP_ERROR_DLG_TITLE");
                            LECore.LayoutEditorCore.MsgReporter.ReportError(title, LECoreStringResMgr.Get("LECORE_UNACCEPTABLE_PLATFORM",
                                Path.GetFullPath(font.FontPath), font.BntxPlatform, LECore.LayoutEditorCore.PlatformDetail.UIPlatformName));
                        }
                    }
                    else if (_createTextBoxDlg.FontName != string.Empty)
                    {
                        font = _TargetActiveSubScene.ILEFontManager.FindFontByName(_createTextBoxDlg.FontName);
                    }
                }
                catch (Exception exception)
                {
                    // プロパティウインドウ - エラー
                    // フォントの読み込みに失敗しました
                    string title = LayoutEditor.StringResMgr.Get("PROP_ERROR_DLG_TITLE");
                    string msg = LayoutEditor.StringResMgr.Get("PROP_ERROR_FAIL_LOADFONT");

                    LECore.LayoutEditorCore.MsgReporter.ReportError(title, msg + "\r\n" + exception.Message);
                    return;
                }

                // フォントが正しく生成できれば...
                if (font != null)
                {
                    // シーン操作クラスを初期化します。
                    SubSceneManipulator subSceneMnp = new SubSceneManipulator();
                    subSceneMnp.BindTarget(LayoutEditorCore.Scene.CurrentISubScene);


                    // シーンにペインを生成します。
                    IPane newTextBox = subSceneMnp.AddTextBoxPane(
                        AppSetting.ProjectSettings.GetNewTextBoxPaneName(),
                        font,
                        _createTextBoxDlg.TextBoxContentsText);
                    if (newTextBox != null)
                    {
                        // 正しく作成された
                        // コンテキストメニューからの呼び出しならば、マウスの位置に、ペインを設定します。
                        SetNewPanePositionToContextMenuPos_(newTextBox);
                    }
                    else
                    {
                        // エラー
                        MessageBox.Show(this, "Failure in Createing PaneModify.\n");
                    }
                }
            }
        }

        /// <summary>
        /// ピクチャペインの作成
        /// </summary>
        private void Event_MniObjectCreatePanePicture_Click(object sender, System.EventArgs e)
        {
            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);
            IPane pane = _subSceneManipulator.AddPicturePaneWithoutTexture(AppSetting.ProjectSettings.GetNewPicturePaneName());
            // コンテキストメニューからの呼び出しならば、マウスの位置に、ペインを設定します。
            SetNewPanePositionToContextMenuPos_(pane);
        }

        /// <summary>
        /// ウインドウペインの作成
        /// </summary>
        private void Event_MniObjectCreatePaneWindow_Click(object sender, System.EventArgs e)
        {
            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);
            IPane pane = _subSceneManipulator.AddWindowPane(AppSetting.ProjectSettings.GetNewWindowPaneName());
            // コンテキストメニューからの呼び出しならば、マウスの位置に、ペインを設定します。
            SetNewPanePositionToContextMenuPos_(pane);
        }

        /// <summary>
        /// 境界領域ペインの新規作成。
        /// </summary>
        private void Event_MniObjectCreatePaneBounding_Click(object sender, System.EventArgs e)
        {
            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);
            IPane pane = _subSceneManipulator.AddBoudingPane(AppSetting.ProjectSettings.GetNewBoundingPaneName());
            // コンテキストメニューからの呼び出しならば、マウスの位置に、ペインを設定します。
            SetNewPanePositionToContextMenuPos_(pane);
        }

        /// <summary>
        /// 整列ペインの新規作成。
        /// </summary>
        private void Event_MniObjectCreatePaneAddAlignment_Click(object sender, System.EventArgs e)
        {
            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);
            IPane pane = _subSceneManipulator.AddAlignmentPane(AppSetting.ProjectSettings.GetNewAlignmentPaneName());
            // コンテキストメニューからの呼び出しならば、マウスの位置に、ペインを設定します。
            SetNewPanePositionToContextMenuPos_(pane);
        }

        /// <summary>
        /// シザーペインの新規作成。
        /// </summary>
        private void Event_MniObjectCreatePaneScissor_Click(object sender, System.EventArgs e)
        {
            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);
            IPane pane = _subSceneManipulator.AddScissorPane(AppSetting.ProjectSettings.GetNewScissorPaneName());
            // コンテキストメニューからの呼び出しならば、マウスの位置に、ペインを設定します。
            SetNewPanePositionToContextMenuPos_(pane);
        }

        /// <summary>
        /// キャプチャペインの新規作成。
        /// </summary>
        private void Event_MniObjectCreatePaneCapture_Click(object sender, System.EventArgs e)
        {
            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);
            IPane pane = _subSceneManipulator.AddCapturePane(AppSetting.ProjectSettings.GetNewCapturePaneName());

            // コンテキストメニューからの呼び出しならば、マウスの位置に、ペインを設定します。
            SetNewPanePositionToContextMenuPos_(pane);
        }

        /// <summary>
        /// ヌルペインを新規作成し、選択ペインを子として追加します。
        /// </summary>
        public void AddPaneAsNullPaneChild(IEnumerable<IPane> childPaneSet)
        {
            if (!_tmiCreateNullPaneAndAddChild.Enabled)
            {
                return;
            }

            // 選択ペインセットからRootPaneを除外します
            var targetPaneSet = childPaneSet.Where(pane => !pane.IsRootPane());
            if (targetPaneSet.Count() == 0)
            {
                return;
            }

            _Scene.CurrentISubScene.BeginMassiveModify();

            // 選択ペインセットから親となるペインを決定します
            float nullPaneX;
            float nullPaneY;
            IPane parent = GetCommonParentPane_(targetPaneSet);

            if (IsMultipleParent(targetPaneSet))
            {
                // 親が複数いる場合はレイアウトの原点位置にする
                nullPaneX = 0;
                nullPaneY = 0;
            }
            else if (parent != null)
            {
                // 単独の親が見つかった場合は親ペインの中心を利用する
                nullPaneX = parent.XInWorld;
                nullPaneY = parent.YInWorld;
            }
            else
            {
                // 親が見つからない場合は選択ペインから座標を求める
                // ペインを作成するとISelectedSetの内容が変化してしまうので、事前に境界矩形を取得する
                RectangleF globalRect = _Scene.CurrentISubScene.ISelectedSet.BoundingVolumeInWorld;
                nullPaneX = globalRect.X + globalRect.Width / 2;
                nullPaneY = globalRect.Y + globalRect.Height / 2;
            }

            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);
            IPane nullPane = _subSceneManipulator.AddNullPane(AppSetting.ProjectSettings.GetNewNullPaneName());

            // "子階層に透明度の影響を伝える"にツール環境設定で設定された値を設定する
            PaneManipulator paneMnp = new PaneManipulator();
            paneMnp.BindTarget(nullPane);
            paneMnp.InfluenceChildrenTransparencyWithoutCmdMaking = AppSetting.ConveyTransparencyInfluenceOfNull;

            // ヌルペインの位置を選択範囲の中心に移動します
            paneMnp.TransWithoutCmdMaking = new FVec3(nullPaneX, nullPaneY, 0);

            // ヌルペインの子として選択ペインを追加します
            foreach (IPane pane in targetPaneSet)
            {
                HierarchyManipulator.SetHierarchyToPanePair(nullPane, pane);
            }

            // ヌルペインの親子階層を設定します
            if (parent != null)
            {
                HierarchyManipulator.SetHierarchyToPanePair(parent, nullPane);
            }

            _Scene.CurrentISubScene.EndMassiveModify();
        }

        /// <summary>
        /// 共通の親(祖先)ペインを取得します。
        /// 見つからない場合はヌルを返します。
        /// </summary>
        private IPane GetCommonParentPane_(IEnumerable<IPane> childPaneSet)
        {
            if (childPaneSet.Count() == 1)
            {
                IPane pane = childPaneSet.ElementAt(0).Parent as IPane;
                return pane.IsRootPane() ? null : pane;
            }

            // ペイン毎に親を辿っていく
            List<IEnumerable<IPane>> hierarchyList = new List<IEnumerable<IPane>>();
            foreach (IPane pane in childPaneSet)
            {
                var hierarchy = GetAllParent(pane).Where<IPane>(p => !p.IsRootPane());
                hierarchyList.Add(hierarchy);
            }

            // 共通の親(祖先)を探す
            var commonList = hierarchyList.First();
            for (int i = 1; i < hierarchyList.Count; i++)
            {
                var targetList = hierarchyList.ElementAt(i);
                commonList = commonList.Intersect(targetList);
            }

            // 最初に見つかったペインを返す
            return commonList.FirstOrDefault();
        }

        private IEnumerable<IPane> GetAllParent(IPane pane)
        {
            IPane parent = pane.Parent as IPane;
            yield return parent;

            if (parent != null && !parent.IsRootPane())
            {
                foreach (var nextParent in GetAllParent(parent))
                {
                    yield return nextParent;
                }
            }
        }

        /// <summary>
        /// 対象ペインセットの親が全てが同じか調べる
        /// <summary>
        private bool IsMultipleParent(IEnumerable<IPane> paneSet)
        {
            IPane targetParent = paneSet.First().Parent as IPane;
            var hitPanes = paneSet.Where(p => (p.Parent as IPane) == targetParent);

            return hitPanes.Count() != paneSet.Count();
        }

        /// <summary>
        /// 部品ペインのリロード
        /// </summary>
        private void Event_TmiReloatPartsPane_Click(object sender, EventArgs e)
        {
            using (WaitCursor w = new WaitCursor())
            {
                SubSceneHelper.ReloadAllPartsPanes(_Scene.CurrentISubScene);

                TargetSubSceneSaveState currentState = FindSubSceneState_(_Scene.CurrentISubScene);
                if (currentState != null)
                {
                    currentState.SetStateReloaded();
                }
            }
        }

        /// <summary>
        /// 選択ペインの部品レイアウトを開く
        /// </summary>
        private void Event_TmiOpenPartsLayout_Click(object sender, EventArgs e)
        {
            var selectedParts = _TargetActiveSubScene.ISelectedSet.IPaneArray[0].IPartsLayout;
            Ensure.Operation.ObjectNotNull(selectedParts);

            try
            {
                LayoutEditorCore.MsgReporter.BeginPacking(LECore.LECoreStringResMgr.Get("LECORE_CATEGORY_PARTSLAYOUTLOADING"));

                // 内部データを読み込みます。
                // 編集用に別途シーンを読み込みます。
                IPartsSubScene partsSubScene = LayoutEditorCore.Scene.FindPartsSubSceneByFileName(selectedParts.PartsLayoutName);
                if (partsSubScene != null)
                {
                    string partsFilePath = partsSubScene.FilePath;

                    LayoutEditorCore.Scene.LoadAndCachePartsSubSceneIfNeeded(partsFilePath);
                    SendMessageToViewManager_(new ViewManagerMessage(ViewManagerMessageKind.OpenLayout, partsFilePath));
                }
                else
                {
                    LayoutEditorCore.MsgReporter.ReportError(
                        "",
                        StringResMgr.Get("ERROR_PARTS_NOT_LOADED", selectedParts.PartsLayoutName)
                        );
                }
            }
            finally
            {
                LayoutEditorCore.MsgReporter.EndPacking();
            }
        }

        /// <summary>
        /// メッセージを送信します。
        /// </summary>
        /// <param name="msg"></param>
        private void SendMessageToViewManager_(ViewManagerMessage msg)
        {
            if (SendMessageToViewManager != null)
            {
                SendMessageToViewManager(msg);
            }
        }

        /// <summary>
        /// 選択を部品化
        /// </summary>
        private void Event_TmiCreatePartsBySelectedNull_Click(object sender, EventArgs e)
        {
            IPane nullPane = _TargetActiveSubScene.ISelectedSet.IPaneArray[0];

            SaveFileDialog dlg = new SaveFileDialog();
            dlg.AddExtension = true;
            dlg.Filter = SaveLoadHelper.GetFliterString(LayoutEditorCore.GetExporter(ImportExportFileKind.Rlyt, new ExportOption()));
            dlg.FileName = nullPane.PaneName;
            dlg.InitialDirectory = LayoutEditorCore.Scene.PartsRootPath;

            if (dlg.ShowDialog() == DialogResult.OK)
            {
                // ダイアログを表示する。
                // 結果を受けて、PartsSettingを初期化する処理を実行する。
                SetPartsKindDialog setPartsKindDialog = new SetPartsKindDialog();
                setPartsKindDialog.Owner = this;
                setPartsKindDialog.Initialize(string.Empty, string.Empty);
                DialogResult result = setPartsKindDialog.ShowDialog();
                if (result != DialogResult.OK)
                {
                    return;
                }

                // 設定変更を実際に反映します。
                var template = setPartsKindDialog.PartsControlSetting;
                if (template == null)
                {
                    return;
                }

                var subScene = nullPane.OwnerSubScene;
                try
                {
                    subScene.BeginMassiveModify();

                    // 部品レイアウトを生成します。
                    PartsSettingsManipulator.CreatePartsBySelectedNull(
                        nullPane,
                        dlg.FileName,
                        setPartsKindDialog.PartsDescriptionName,
                        string.Empty,
                        template);

                    var basePane = nullPane.Parent as IPane;
                    int nullPaneIndex = basePane.Children.ToList().IndexOf(nullPane);
                    // 選択ペインを削除します。
                    SubSceneManipulator mnp = new SubSceneManipulator();
                    mnp.BindTarget(nullPane.OwnerSubScene);
                    mnp.DeleteSelectedPanes();

                    // 部品ペインを生成して起点ペインの子供に登録します(表示位置は変わらないはず)。
                    string partsFileName = Path.GetFileName(dlg.FileName);
                    string partsName = Path.GetFileNameWithoutExtension(partsFileName);

                    var partsSubScene = LayoutEditorCore.Scene.FindPartsSubSceneByFileName(partsFileName);
                    Ensure.Operation.ObjectNotNull(partsSubScene);

                    IPane newPartsPane = mnp.AddPartsPane(partsName, partsFileName, partsSubScene.SubScene);
                    HierarchyManipulator.SetHierarchyToPanePair(basePane, newPartsPane);
                    HierarchyManipulator.ChangeChildOrder(basePane, newPartsPane, nullPaneIndex);

                    // 名前と階層構造が確定したのちにリロードしたパーツペインのキャプチャテクスチャ参照情報を更新します。
                    SubSceneHelper.ResolvePartsLayoutCaptureTextureReference(newPartsPane);
                }
                finally
                {
                    subScene.EndMassiveModify();
                }
            }
        }

        #endregion ペイン生成

        /// <summary>
        /// 親子階層の操作
        /// </summary>
        private void HierarchyControl_(Keys key)
        {
            var arg = new KeyCmdViewManagerMessage(ViewManagerMessageKind.KeyCmd, key, _TargetActiveSubScene.ISelectedSet.IPaneArray);
            SendMessageToViewManager_(arg);
        }

        void SetPaneLockedRecursicve_(PaneManipulator paneMnp, bool bLocked)
        {
            // 設定
            paneMnp.Locked = bLocked;


            // 子供に対して再帰処理
            IPane pane = paneMnp.IPane;
            foreach (IPane chilePane in pane.Children)
            {
                paneMnp.BindTarget(chilePane);
                SetPaneLockedRecursicve_(paneMnp, bLocked);
            }
            paneMnp.BindTarget(pane);
        }

        /// <summary>
        /// 選択をロックするハンドラ
        /// </summary>
        private void Event_MniObjectLock_Click(object sender, System.EventArgs e)
        {
            PaneManipulator paneMnp = new PaneManipulator();
            IPane[] selectedSet = _subSceneManipulator.ISubScene.ISelectedSet.IPaneArray;
            foreach (IPane pane in selectedSet)
            {
                paneMnp.BindTarget(pane);
                paneMnp.Locked = true;
            }
            _subSceneManipulator.ResetSelectedSet();
        }

        /// <summary>
        /// ロックを解除するハンドラ
        /// </summary>
        private void Event_MniObjectShowLocked_Click(object sender, System.EventArgs e)
        {
            PaneManipulator paneMnp = new PaneManipulator();
            foreach (IPane pane in _subSceneManipulator.ISubScene.IPaneArray)
            {
                paneMnp.BindTarget(pane);
                paneMnp.Locked = false;
            }
        }

        /// <summary>
        /// ロックされたアイテムを隠す
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Event_MniObjectLockedToHidden_Click(object sender, System.EventArgs e)
        {
            PaneManipulator paneMnp = new PaneManipulator();
            foreach (IPane pane in _subSceneManipulator.ISubScene.IPaneArray)
            {
                if (pane.Locked)
                {
                    paneMnp.BindTarget(pane);
                    paneMnp.Hidden = true;
                }
            }
        }

        /// <summary>
        /// 境界領域ペインをロックする。
        /// </summary>
        private void Event_MniObjectLockBoundingPane_Click(object sender, System.EventArgs e)
        {
            PaneManipulator paneMnp = new PaneManipulator();
            foreach (IPane pane in _subSceneManipulator.ISubScene.IPaneArray)
            {
                if (pane.PaneKind == PaneKind.Bounding)
                {
                    paneMnp.BindTarget(pane);
                    paneMnp.Locked = true;
                }
            }
        }

        /// <summary>
        /// 選択を隠す
        /// </summary>
        private void Event_MniObjectHide_Click(object sender, System.EventArgs e)
        {
            PaneManipulator paneMnp = new PaneManipulator();
            IPane[] selectedSet = _subSceneManipulator.ISubScene.ISelectedSet.IPaneArray;
            foreach (IPane pane in selectedSet)
            {
                paneMnp.BindTarget(pane);
                paneMnp.Hidden = true;
            }
            _subSceneManipulator.ResetSelectedSet();
        }

        /// <summary>
        /// 隠されたアイテムをすべてあらわす。
        /// </summary>
        private void Event_MniObjectResetHidden_Click(object sender, System.EventArgs e)
        {
            PaneManipulator paneMnp = new PaneManipulator();
            foreach (IPane pane in _subSceneManipulator.ISubScene.IPaneArray)
            {
                if (pane.Hidden)
                {
                    paneMnp.BindTarget(pane);
                    paneMnp.Hidden = false;
                }
            }
        }

        /// <summary>
        /// 隠されたアイテムをすべてロック状態にします。
        /// </summary>
        private void Event_MniObjectHiddenToLocked_Click(object sender, System.EventArgs e)
        {
            PaneManipulator paneMnp = new PaneManipulator();
            foreach (IPane pane in _subSceneManipulator.ISubScene.IPaneArray)
            {
                if (pane.Hidden)
                {
                    paneMnp.BindTarget(pane);
                    paneMnp.Locked = true;
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_TmiPane_Paint(object sender, PaintEventArgs e)
        {
            UpdateObjectMenuItemState_();
        }

        #endregion メニューハンドラ:オブジェクト

        #region メニューハンドラ:編集
        /// <summary>
        ///
        /// </summary>
        private void Event_MniEdit_Paint(object sender, PaintEventArgs e)
        {
            if (_tmiEditCopyAnimation.Checked != _mainView.GetAppSetting().PasteAnimation)
            {
                _tmiEditCopyAnimation.Checked = _mainView.GetAppSetting().PasteAnimation;
            }
        }

        /// <summary>
        /// 選択の反転
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Event_MniSelectInv(object sender, System.EventArgs e)
        {
            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);

            _subSceneManipulator.BeginSelectSetChange();
            InvertSelectionAll_();
            _subSceneManipulator.EndSelectSetChange();
        }

        /// <summary>
        /// 選択の解除
        /// </summary>
        private void Event_MniSelectReset_Click(object sender, System.EventArgs e)
        {
            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);
            _subSceneManipulator.ResetSelectedSet();
        }

        /// <summary>
        /// コピー
        /// </summary>
        private void Event_MniEditCopy(object sender, System.EventArgs e)
        {
            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);
            _subSceneManipulator.CopySelectedPanes();
        }

        /// <summary>
        /// 貼り付け
        /// </summary>
        private void Event_MniEditPaste(object sender, System.EventArgs e)
        {
            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);
            _subSceneManipulator.PastePanes(_mainView.GetAppSetting().PasteAnimation, IsPaneValidToPaste_);
        }

        /// <summary>
        /// 複製
        /// </summary>
        private void Event_MniEditDuplicate(object sender, System.EventArgs e)
        {
            DuplicateSelectedPanes(null);
        }

        /// <summary>
        /// 選択中のペインを複製します
        /// </summary>
        public void DuplicateSelectedPanes(IPane parent)
        {
            _Scene.CurrentISubScene.BeginMassiveModify();

            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);

            // ペインを複製します
            var selectedState = _subSceneManipulator.CopySelectedPanesRecursive();
            _subSceneManipulator.PastePanes(_mainView.GetAppSetting().PasteAnimation, IsPaneValidToPaste_);

            // 選択状態を変更します
            var dupPaneSet = _TargetActiveSubScene.ISelectedSet.IPaneArray;
            _subSceneManipulator.SelectedChangeByOrder(dupPaneSet, selectedState.ToArray());

            // 親子階層を設定します
            if (parent != null)
            {
                foreach (IPane dupPane in dupPaneSet)
                {
                    var pane_ = dupPane.Parent as IPane;
                    if (PaneHelper.IsRootPane(pane_))
                    {
                        HierarchyManipulator.SetHierarchyToPanePair(parent, dupPane);
                    }
                }
            }

            _Scene.CurrentISubScene.EndMassiveModify();
        }

        /// <summary>
        /// 貼り付け対象として有効か判断します。
        /// </summary>
        private bool IsPaneValidToPaste_(IPane newPane)
        {
            // 貼り付けるペインが部品ペインでなければ特にチェックは不要
            if (newPane.IPartsLayout == null)
            {
                return true;
            }

            // 貼り付けるシーンがファイル保存されている(部品レイアウトかもしれない)
            if (this.FilePath != null)
            {
                IPartsSubScene newPartsSubScene = LECore.LayoutEditorCore.Scene.FindPartsSubSceneByFileName(newPane.IPartsLayout.PartsLayoutName);
                if (newPartsSubScene == null)
                {
                    return true;
                }

                // NG! 自分自身に貼り付けている
                if (newPartsSubScene.FilePath == this.FilePath)
                {
                    // 警告：処理をキャンセルしました：無限ループを生む不正な部品ペインの追加
                    this.SendMessageToViewManager(new ViewManagerMessage(ViewManagerMessageKind.WriteMessage, StringResMgr.Get("PARTS_PANE_WANING_ADD_INVALID")));
                    return false;
                }

                // NG! 部品レイアウトの依存ファイルにに貼り付けている
                var relatedPartsNames = PartsSubSceneHelper.GetDependsPartsNameRecurcively(newPane.IPartsLayout.PartsSubScene);
                if (relatedPartsNames.Any((relatedPartsName) => Path.GetFileName(relatedPartsName) == Path.GetFileName(this.FilePath)))
                {
                    // 警告：処理をキャンセルしました：無限ループを生む不正な部品ペインの追加
                    this.SendMessageToViewManager(new ViewManagerMessage(ViewManagerMessageKind.WriteMessage, StringResMgr.Get("PARTS_PANE_WANING_ADD_INVALID")));
                    return false;
                }
            }

            return true;
        }

        /// <summary>
        /// 削除
        /// </summary>
        private void Event_MniEditDelete(object sender, System.EventArgs e)
        {
            if (_GrbTime.IsPlaying != false)
            {
                return;
            }

            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);
            _subSceneManipulator.DeleteSelectedPanes();
        }

        /// <summary>
        /// 切り取り
        /// </summary>
        private void Event_MniEditCut(object sender, System.EventArgs e)
        {
            if (_GrbTime.IsPlaying != false)
            {
                return;
            }

            _subSceneManipulator.BindTarget(_Scene.CurrentISubScene);
            _subSceneManipulator.CopySelectedPanes();
            _subSceneManipulator.DeleteSelectedPanes();
        }

        /// <summary>
        /// アニメーションのコピー・貼り付けをおこなう
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Event_MniCopyAnimation_Click(object sender, EventArgs e)
        {
            _mainView.GetAppSetting().PasteAnimation = !_mainView.GetAppSetting().PasteAnimation;
        }

        #endregion 編集

        #region メニューハンドラ:表示関連

        /// <summary>
        /// 表示関連 ドロップダウン
        /// </summary>
        private void Event_TmiView_DropDownOpened(object sender, EventArgs e)
        {
            UpdateProperty_();
        }

        /// <summary>
        /// グリッドの表示・非表示
        /// </summary>
        private void Event_MniViewGrid_Click(object sender, System.EventArgs e)
        {
            ToolStripMenuItem mi = sender as ToolStripMenuItem;
            mi.Checked = !mi.Checked;

            _mainView.BackGround.GridVisible = mi.Checked;
            UpdateProperty_();
        }

        /// <summary>
        /// グリッドに吸着ハンドラ
        /// </summary>
        private void Event_MniViewGridSnap_Click(object sender, System.EventArgs e)
        {
            ToolStripMenuItem mi = sender as ToolStripMenuItem;
            mi.Checked = !mi.Checked;

            _mainView.BackGround.GridSnapEnalbed = mi.Checked;
        }

        /// <summary>
        /// ズームイン
        /// </summary>
        private void Event_MniViewZoomIn_Click(object sender, System.EventArgs e)
        {
            _mainView.ZoomIn();
        }
        /// <summary>
        /// ズームアウト
        /// </summary>
        private void Event_MniViewZoomOut_Click(object sender, System.EventArgs e)
        {
            _mainView.ZoomOut();
        }

        /// <summary>
        /// ウインドウサイズをレイアウトサイズに設定する。
        /// </summary>
        void FitWindowSizeToLayoutScreenSize_(Form form, float magnity)
        {
            FVec2 layoutScrnSize = _TargetActiveSubScene.BackGround.ScreenSize;
            layoutScrnSize.Scale(1.2f);

            // サイズは、_mainView の拡大率を 乗算して求める
            float scaleX = (layoutScrnSize.X * magnity) / _mainView.Size.Width;
            float scaleY = (layoutScrnSize.Y * magnity) / _mainView.Size.Height;

            form.Size = new Size((int)(form.Size.Width * scaleX), (int)(form.Size.Height * scaleY));
        }

        /// <summary>
        /// ウインドウ拡大
        /// </summary>
        private void Event_MniWindowExpand_Click(object sender, EventArgs e)
        {
            _mainView.ZoomForm(this, true);
        }

        /// <summary>
        /// ウインドウ縮小
        /// </summary>
        private void Event_MniWindowShrink_Click(object sender, EventArgs e)
        {
            _mainView.ZoomForm(this, false);
        }

        /// <summary>
        /// アウトライン表示
        /// </summary>
        private void Event_MniViewOutline_Click(object sender, System.EventArgs e)
        {
            _mainView.Renderer.ToggleOptionFlag(IRenderOptionFlag.DrawOutline);
            UpdateProperty_();
        }

        /// <summary>
        /// 全体表示
        /// </summary>
        private void Event_MniAdjustView_Click(object sender, System.EventArgs e)
        {
            SetViewDefalut();
        }

        /// <summary>
        /// 選択部分を全体表示
        /// </summary>
        private void Event_MniAdjustViewToSelected_Click(object sender, EventArgs e)
        {
            RectangleF rect = _TargetActiveSubScene.ISelectedSet.BoundingVolumeInWorld;
            if (rect != RectangleF.Empty)
            {
                // 少し拡大する
                rect.Inflate(rect.Width * 0.2f, rect.Height * 0.2f);

                PointF pCenter = LayoutWindowHelper.GetRectangleFCenter(rect);

                _mainView.SetView(pCenter.X, pCenter.Y, rect.Width, rect.Height);

            }
        }

        /// <summary>
        /// TmiViewBoundingBoxDisabled 描画 ハンドラ
        /// </summary>
        private void Event_TmiViewBoundingBoxDisabled_Paint(object sender, PaintEventArgs e)
        {
            UpdateProperty_();
        }

        /// <summary>
        /// 境界矩形を表示
        /// </summary>
        private void Event_MniViewBV_Click(object sender, System.EventArgs e)
        {
            DrawableOption option = _mainView.DrawableOption;
            DrawableOptionFlag mask = DrawableOptionFlag.IgnoreBVDrawing | DrawableOptionFlag.IgnoreDummyObjectDrawing;
            DrawableOptionFlag optionFlag = option.DrawableOptionFlag;

            optionFlag = mask & optionFlag;

            if (optionFlag == DrawableOptionFlag.None)
            {
                optionFlag |= DrawableOptionFlag.IgnoreBVDrawing;
            }
            else if (optionFlag == DrawableOptionFlag.IgnoreBVDrawing)
            {
                optionFlag |= DrawableOptionFlag.IgnoreDummyObjectDrawing;
            }
            else if (optionFlag == mask)
            {
                optionFlag = DrawableOptionFlag.None;
            }

            option.DrawableOptionFlag = (option.DrawableOptionFlag & ~mask) | optionFlag;
            _mainView.DrawableOption = option;

            UpdateProperty_();
        }

        /// <summary>
        /// 境界矩形を表示
        /// </summary>
        private void Event_MniViewBoundingPane_Click(object sender, System.EventArgs e)
        {
            var option = _mainView.DrawableOption;

            option.ToggleFlag(DrawableOptionFlag.IgnoreBoundingPaneDrawing);

            _mainView.DrawableOption = option;

            UpdateProperty_();
        }

        /// <summary>
        /// 部品ペインを強調表示
        /// </summary>
        private void Event_MniViewPartsPane_Click(object sender, System.EventArgs e)
        {
            var option = _mainView.DrawableOption;

            option.ToggleFlag(DrawableOptionFlag.IgnorePartsPaneRectDrawing);

            _mainView.DrawableOption = option;

            UpdateProperty_();
        }

        /// <summary>
        /// キャプチャペインを表示
        /// </summary>
        private void Event_tmiViewCapturePaneEnabled_Click(object sender, EventArgs e)
        {
            var option = _mainView.DrawableOption;

            option.ToggleFlag(DrawableOptionFlag.IgnoreCapturePaneDrawing);

            _mainView.DrawableOption = option;

            UpdateProperty_();
        }
        #endregion 表示関連

        #region メニューハンドラ:デバック
        /// <summary>
        /// デバック情報を描画する
        /// </summary>
        private void Event_MniDebugShowDbgDraw_Click(object sender, System.EventArgs e)
        {
            _mainView.Renderer.ToggleOptionFlag(IRenderOptionFlag.DrawDebugInfo);
            UpdateProperty_();
        }

        /// <summary>
        /// デバック項目：ポップアップハンドラ
        /// </summary>
        private void Event_MniDebug_Popup(object sender, System.EventArgs e)
        {
            _tmiDebugShowDebugDraw.Checked = (_mainView.Renderer.OptionFlag & IRenderOptionFlag.DrawDebugInfo) != 0;
        }

        /// <summary>
        /// 連番テクスチャ読み込み
        /// </summary>
        private void Event_TmiTextureFileSetImport_Click(object sender, EventArgs e)
        {
            _textureFileSetImporterDlg.ShowDialog(this);
        }

        /// <summary>
        /// 実機プレビューハンドラ
        /// </summary>
        private void Event_MniRunPreviewer_Click(object sender, System.EventArgs e)
        {
            if (AppSetting.SendViewerAnimation)
            {
                AppSetting.SendViewerAnimation = false;
                AppSetting.RaiseModifyEvent();
            }
            SendMessageToViewManager_(new ViewManagerMessage(ViewManagerMessageKind.SendViewer));
        }

        /// <summary>
        /// 実機プレビュー(強制アニメーションモード)ハンドラ
        /// </summary>
        private void Event_TmiToolTransportToViewerForceAnimMode_Click(object sender, EventArgs e)
        {
            if (!AppSetting.SendViewerAnimation)
            {
                AppSetting.SendViewerAnimation = true;
                AppSetting.RaiseModifyEvent();
            }
            SendMessageToViewManager_(new ViewManagerMessage(ViewManagerMessageKind.SendViewer));
        }

        /// <summary>
        /// ターゲットビューアの選択
        /// </summary>
        private ViewerPreviewParam.TransferDestination GetTransferDestination_()
        {
            switch (AppSetting.TargetScreenKind)
            {
                case AppSetting.TargetScreen.Auto: return ViewerPreviewParam.TransferDestination.NoSpecify;
                case AppSetting.TargetScreen.Lower: return ViewerPreviewParam.TransferDestination.Lower;
                case AppSetting.TargetScreen.Upper: return ViewerPreviewParam.TransferDestination.Upper;
                default: return ViewerPreviewParam.TransferDestination.Upper;
            }
        }

        /// <summary>
        /// 実機ビューアを起動
        /// </summary>
        private void Event_TmiLaunchAEViewer_Click(object sender, EventArgs e)
        {
            ViewerExecuter.LaunchTargetViewer(this.AppSetting.GetPreviewSettings().GetLaunchTargetViewerCommand());
        }

        /// <summary>
        /// 自動転送を止める
        /// </summary>
        private void StopAutoUpdatePreviewer()
        {
            if (AppSetting.AutoUpdateViewer)
            {
                AppSetting.AutoUpdateViewer = false;
                AppSetting.RaiseModifyEvent();
            }
        }

        /// <summary>
        /// プレビュー
        /// </summary>
        private void RunPreviewer_(
            ViewerPreviewParam.TransferDestination destination,
            ViewerPreviewParam.PreviewMode mode,
            bool IsAutoReload)
        {
            try
            {
                var setting = this.AppSetting.GetPreviewSettings();
                setting.IsPerspectiveProjection = _mainView?.Renderer?.PersepectiveRendering ?? setting.IsPerspectiveProjection;
                setting.ErrorDialogOwner = this;
                setting.IsAutoReload = IsAutoReload;

                setting.LayoutSize = _TargetActiveSubScene.BackGround.ScreenSize.AsSizeF.ToSize();
                setting.CaptureFrameCount = GlobalTime.Inst.Time;

                setting.OnPreviewWarningAction += new Action<string>((msg) =>
                {
                    this.SendMessageToViewManager(new ViewManagerMessage(ViewManagerMessageKind.WriteWarning, msg));
                });

                if (!string.IsNullOrWhiteSpace(setting.CombinerEditorPath) && !File.Exists(setting.CombinerEditorPath))
                {
                    // プロジェクト設定ファイルのコンバイナエディタへのパスが利用状態にあるとき、実行ファイルが見つからなければメッセージを伝えプレビューアをキャンセルします。
                    StopAutoUpdatePreviewer();
                    LayoutEditorCore.MsgReporter.ReportError(StringResMgr.Get("USERCOMBINERSHADER_PROJECT_TITLE"), StringResMgr.Get("USERCOMBINERSHADER_PROJECT_EXENONE", setting.CombinerEditorPath));
                    return;
                }

                // コンバイナエディタからの受信がある場合はファイルの入れ替えを行います。
                setting.CombinerReplaceFile = _combinerReplaceFile;
                setting.CombinerReceivedTempFile = _combinerReceivedTempFile;

                if (!ViewerExecuter.RunPreviewer(
                    setting,
                    _InitialSubSceneState.ISubScene, _InitialSubSceneState.LastSavedFileNameWithoutExtension,
                    _CurrentSubSceneState.ISubScene, _CurrentSubSceneState.LastSavedFileNameWithoutExtension,
                    destination, mode))
                {
                    // 転送用のファイル出力に失敗したら自動転送を止める
                    StopAutoUpdatePreviewer();
                }

            }
            finally
            {
                // 一時変数の破棄処理
                _combinerReplaceFile = string.Empty;
                _combinerReceivedTempFile = string.Empty;
            }
        }

        /// <summary>
        /// ビューアへ転送
        /// </summary>
        public void SendViewer()
        {
            SendMessageToViewManager_(new ViewManagerMessage(ViewManagerMessageKind.SendViewer));
        }

        public void RunPreviewer(ViewerPreviewParam.PreviewMode mode, bool isAutoReload)
        {
            RunPreviewer_(GetTransferDestination_(), mode, isAutoReload);
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_MniTrargetViewerIsPCViewer_Click(object sender, EventArgs e)
        {
            AppSetting.TargetViewerKind = AppSetting.TargetViewerType.PCViewer;
            UpdateProperty_();
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_MniTrargetViewerIsAEViewer_Click(object sender, EventArgs e)
        {
            AppSetting.TargetViewerKind = AppSetting.TargetViewerType.AEViewer;
            UpdateProperty_();
        }

        /// <summary>
        /// ビューアのキャプチャ
        /// </summary>
        private void Event_TmiCapturePCViewer_Click(object sender, EventArgs e)
        {
            RunPreviewer_(
                    ViewerPreviewParam.TransferDestination.NoSpecify,
                    ViewerPreviewParam.PreviewMode.PCViewerScreenCapture,
                    false);
        }

        /// <summary>
        /// ペインツリーの圧縮
        /// </summary>
        public void Event_TmiPaneTreeCompression_Click(object sender, EventArgs e)
        {
            // 保存されているか
            if (_CurrentSubSceneState.IsUpdated)
            {
                ViewManager.ShowMessageBox(this, StringResMgr.Get("PANETREE_COMP_CONFIRMSAVE"), StringResMgr.Get("PANETREE_COMP_TAG"), MessageBoxButtons.OK);
                return;
            }

            // 処理開始を確認
            if (ViewManager.ShowMessageBox(this, StringResMgr.Get("PANETREE_COMP_CONFIRMOPERATION"), StringResMgr.Get("PANETREE_COMP_TAG"), MessageBoxButtons.OKCancel) == DialogResult.OK)
            {
                PaneTreeCompressionHelper paneTreeCompressionHelper = new PaneTreeCompressionHelper();
                List<string> compressedPaneNames = paneTreeCompressionHelper.Compress(_TargetActiveSubScene);

                // 最後にリポートする
                StringBuilder report = new StringBuilder();
                report.AppendLine(StringResMgr.Get("PANETREE_COMP_REPORT", compressedPaneNames.Count));
                report.AppendLine("");

                foreach (var compressedPaneName in compressedPaneNames)
                {
                    report.AppendLine("    " + compressedPaneName);
                }

                ViewManager.ShowMessageBox(this, report.ToString(), StringResMgr.Get("PANETREE_COMP_TAG"), MessageBoxButtons.OK);
            }
        }

        /// <summary>
        /// テクスチャ・フォントの集約
        /// </summary>
        private void Event_TmiSetTextureFontPath_Click_(object sender, EventArgs e)
        {
            ResourcePathSettingDlg dlg = new ResourcePathSettingDlg(Path.GetFileNameWithoutExtension(_CurrentSubSceneState.LastSavedFilePath));
            dlg.ShowDialog(this);
        }

        #endregion デバック



        #endregion メニュー関連

        #region ドラッグ&ドロップ
        /// <summary>
        /// DragEnter
        /// </summary>
        private void Event_MainView_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                // ファイルドラッグ
                string[] filePathSet = (string[])e.Data.GetData(DataFormats.FileDrop);
                foreach (string filePath in filePathSet)
                {
                    if (!SaveLoadUIHelper.IsFileExtValidForDrop(filePath))
                    {
                        e.Effect = DragDropEffects.None;
                        return;
                    }
                }
                // すべてが適正なら許可します。
                e.Effect = DragDropEffects.All;
            }
            else if (e.Data.GetDataPresent(typeof(TextureMgrWindow.TextureMgrWindow.DragDropItem)))
            {
                // テクスチャウインドウからのドラッグ
                var item = (TextureMgrWindow.TextureMgrWindow.DragDropItem)e.Data.GetData(typeof(TextureMgrWindow.TextureMgrWindow.DragDropItem));
                if (item.SubScene == _TargetActiveSubScene)
                {
                    e.Effect = DragDropEffects.Copy;
                }
                else
                {
                    e.Effect = DragDropEffects.None;
                }
            }
            else
            {
                e.Effect = DragDropEffects.None;
            }
        }

        /// <summary>
        /// TODO:共通ルーチン化
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        bool IsFilePathValid_(string name)
        {
            return File.Exists(name);
        }

        /// <summary>
        /// DragDrop
        /// </summary>
        private void Event_MainView_DragDrop(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                // ファイルドロップ
                string[] files = e.Data.GetData(DataFormats.FileDrop) as string[];

                List<string> loadedFileNameSet = new List<string>();

                foreach (string fileName in files)
                {
                    string fileNameWithoutExt = Path.GetFileNameWithoutExtension(fileName);
                    if (!loadedFileNameSet.Contains(fileNameWithoutExt))
                    {
                        AdditionalLoadFile(fileName);
                        loadedFileNameSet.Add(fileNameWithoutExt);
                    }
                }
            }
            else if (e.Data.GetDataPresent(typeof(TextureMgrWindow.TextureMgrWindow.DragDropItem)))
            {
                // ドロップ情報からテクスチャの取得を試みます。
                var item = (TextureMgrWindow.TextureMgrWindow.DragDropItem)e.Data.GetData(typeof(TextureMgrWindow.TextureMgrWindow.DragDropItem));
                if (item.SubScene == _TargetActiveSubScene)
                {
                    _TargetActiveSubScene.BeginMassiveModify();

                    ITextureImage droppedTexImg = null;
                    if (item.InSubScne)
                    {
                        string texDataName = item.TextureName;
                        droppedTexImg = _TargetActiveSubScene.ITextureMgr.FindITextureImageByName(texDataName);
                    }
                    else
                    {
                        // ロードを行います。
                        var manipulator = new TextureMgrManipulator();
                        manipulator.BindTarget(_TargetActiveSubScene.ITextureMgr);
                        var images = manipulator.RegisterITextureImageSetFromFile(new[] { item.FilePath });
                        if (images.Length > 0)
                        {
                            Debug.Assert(images.Length == 1);
                            droppedTexImg = images[0];
                        }
                        else
                        {
                            // エラーメッセージ
                            MessageReportDlg dlg = new MessageReportDlg(LayoutEditor.Forms.MessageReportDlg.ButtonTypes.Ok, false);
                            dlg.Title = StringResMgr.Get("ADDTEXTURE");
                            dlg.Message = StringResMgr.Get("SAMENAMETEXTURE") + "\r\n\r\n" + item.FilePath;
                            dlg.ShowDialog(this);
                        }
                    }

                    // 正しくテクスチャが取得できたら、ペインを生成します。
                    // また、生成したペインを操作できるように、設定します。
                    if (droppedTexImg != null)
                    {
                        Debug.Assert(_TargetActiveSubScene == _subSceneManipulator.ISubScene);

                        IPane dropedPane = _subSceneManipulator.AddPicturePane(
                            AppSetting.ProjectSettings.GetNewPicturePaneName(),
                            droppedTexImg.Name,
                            AppSetting.ProjectSettings.DefaultPaneNames.UseTextureNameAsPicturePaneName);

                        var dropedPaneMnp = new PaneManipulator();
                        dropedPaneMnp.BindTarget(dropedPane);

                        // 現在のマウス位置を更新します。
                        Point pos = _mainView.PointToClient(new Point(e.X, e.Y));
                        PointF scenePos = _mainView.ScreenToScene(pos);

                        // Undoコマンドを生成しない方法で、ペイン位置を更新します。
                        dropedPaneMnp.TransWithoutCmdMaking = new FVec3(scenePos);

                        // 新規作成ペインのみを選択した状態にします。
                        _subSceneManipulator.ResetSelectedSet();
                        _subSceneManipulator.SelectPanesByPaneRef(dropedPaneMnp.IPane);
                    }

                    _TargetActiveSubScene.EndMassiveModify();
                }
            }
        }
        #endregion ドラッグ&ドロップ

        /// <summary>
        /// アクティブ化ハンドラ
        /// </summary>
        private void LayoutWindow_Activated(object sender, System.EventArgs e)
        {
            // MDI 以外のときは Activated されないことがある
            if (ViewManager.DockPanel.DocumentStyle == WeifenLuo.WinFormsUI.Docking.DocumentStyle.SystemMdi)
            {
                SetCurrentISubScene();
            }
        }

        public void SetCurrentISubScene()
        {
            SceneManipulator sceneMnp = new SceneManipulator();
            sceneMnp.BindTarget(_Scene);

            // カレントサブシーンを自身のターゲットであるサブシーンに変更します。
            sceneMnp.CurrentISubScene = this._TargetActiveSubScene;

            SendMessageToViewManager_(new ViewManagerMessage(ViewManagerMessageKind.SaveStateChanged, _CurrentSubSceneState));
        }

        /// <summary>
        /// オーナーフォームから呼び出すためのラッパー。
        /// </summary>
        public void LayoutWindow_Deactivate()
        {
            LayoutWindow_Deactivate(this, null);
        }

        /// <summary>
        /// 非アクティブ化ハンドラ
        /// </summary>
        private void LayoutWindow_Deactivate(object sender, EventArgs e)
        {
            this.TransAffectsChildrenFlip = false;
        }

        /// <summary>
        /// 閉じる
        /// </summary>
        private void Event_LayoutWindow_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            // ファイル保存無視フラグが立っていたら何もしない。
            if (_closeIgnoreSaving)
            {
                return;
            }

            // いずれか変更があったら...
            if (_targetSubSceneStates.Any((saveState) => saveState.IsUpdated))
            {
                List<string> lastSavedPathSet = new List<string>();
                _targetSubSceneStates.ForEach((saveState) =>
                {
                    if (saveState.IsUpdated)
                    {
                        lastSavedPathSet.Add(saveState.LastSavedFilePath);
                    }
                });

                _closeDlg.SetFiles(lastSavedPathSet.ToArray());

                DialogResult result = _closeDlg.ShowDialog(this);

                switch (result)
                {
                    case DialogResult.OK:
                        if (_closeDlg.SaveFileNameSet.Length > 0)
                        {
                            bool bSaveResult = SaveAllFiles_(_targetSubSceneStates, _closeDlg.SaveFileNameSet);

                            // セーブに失敗した場合は、ウインドウを閉じません。
                            if (bSaveResult == false)
                            {
                                e.Cancel = true;
                            }
                        }
                        break;
                    case DialogResult.Cancel: e.Cancel = true; break;
                }
            }

            // キャンセルされずに閉じられる場合、ドキュメントのアンロードを試行する。
            if (!e.Cancel)
            {
                foreach (var targetSubSceneState in _targetSubSceneStates)
                {
                    if (!targetSubSceneState.TryUnloadDocument())
                    {
                        e.Cancel = true;
                    }
                }
            }
        }

        /// <summary>
        /// ウインドウ移動
        /// </summary>
        private void LayoutWindow_Move(object sender, EventArgs e)
        {
            // 対症療法。
            // モニタの 1更新フレーム位、待ってから Invalidate()
            // Windows7 Aero有効環境で、再描画時に、ウインドウが DirectX描画と干渉するのを防ぐ。
            // Windows7 Aeroが有効かは、DwmApi.dll の DwmIsCompositionEnabled() を使えば　判定できるが
            // WinXPでは、DwmApi.dllの有無を判定する必要があるなど、煩雑になるのでやっていない。
            int milliSecOfOneFrame = 17;
            System.Threading.Thread.Sleep(milliSecOfOneFrame);

            this.Invalidate();
        }

        #endregion イベントハンドラ

        #region ILECmdKeyAccepter メンバ

        public bool DoProcessCmdKey(ref Message msg, Keys keyData)
        {
            // DEL は 処理しません。
            if (keyData == Keys.Delete)
            {
                return false;
            }

            // 既定の処理
            if (base.ProcessCmdKey(ref msg, keyData))
            {
                return true;
            }

            // オーナーが ILECmdKeyAccepter ならメッセージを伝播します。
            ILECmdKeyAcceptor accepter = this.OwnerCmdKeyAcceptor;
            if (accepter != null)
            {
                if (accepter.DoProcessCmdKey(ref msg, keyData))
                {
                    return true;
                }
            }

            return false;
        }

        #endregion ILECmdKeyAccepter メンバ

        protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
        {
            switch (msg.Msg)
            {
                // ユーザーコマンドのショートカット
                case LECore.Win32.WM.WM_SYSKEYDOWN:
                case LECore.Win32.WM.WM_KEYDOWN:
                    Action action;
                    if (_userCommandShortCutKeyActions.TryGetValue(keyData, out action))
                    {
                        action();
                        return true;
                    }
                    break;
            }

            return base.ProcessCmdKey(ref msg, keyData);
        }

        #region IViewManagerMessageSender メンバ

        public event Action<ViewManagerMessage> SendMessageToViewManager;

        #endregion

        #region ILEToolWindow メンバ
        public bool AllowToChangeVisible { get { return false; } }
        public bool IsNeededToHide { get { return false; } }

        public string LEWindowName { get { return "LayoutWindow"; } }
        public string Description { get { return "LayoutWindow"; } }
        public Keys CustomShortcut { get { return Keys.None; } }

        /// <summary>
        /// ビューマネージャです。
        /// </summary>
        public IViewManager ViewManager { get; set; }

        /// <summary>
        /// コマンドキー処理の委譲先です。
        /// </summary>
        public ILECmdKeyAcceptor OwnerCmdKeyAcceptor { get; set; }

        #region ISceneModifyListener メンバ
        /// <summary>
        /// シーン変更ハンドラ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void OnSceneModifyHandler(object sender, SceneModifyEventArgs e)
        {
            ISubScene subScene = sender as ISubScene;
            switch (e.Target)
            {
                // テクスチャマネージャの更新
                case SceneModifyEventArgs.Kind.TextureManager:
                case SceneModifyEventArgs.Kind.CurrentSubSceneChanged:
                case SceneModifyEventArgs.Kind.PlatformChanged:
                    {
                        UpdateProperty_();
                        break;
                    }
                case SceneModifyEventArgs.Kind.ClipBoardModify:
                case SceneModifyEventArgs.Kind.PaneAnimModify:
                case SceneModifyEventArgs.Kind.PaneAnimAddRemove:
                    {
                        // 何もしません。
                        break;
                    }
                case SceneModifyEventArgs.Kind.CurrentPaneModify:
                    this._mainView.Invalidate();
                    break;
                // それ以外
                default:
                    {
                        if (this.Targets(subScene))
                        {
                            UpdateProperty_();
                        }
                        break;
                    }
            }

            // 子コントロールへの伝播
            _mainView.OnSceneModifyHandler(sender, e);
        }

        #endregion ISceneModifyListener メンバ

        #region ITimeChageEventListener メンバ
        public void OnTimeChangedHandler(int time, TimeChageEventType type)
        {
            if (type == TimeChageEventType.Tick)
            {
                UpdateProperty_();
            }
        }
        #endregion ITimeChageEventListener メンバ

        #region IAppEventListener メンバ

        public void OnAppEvent(object sender, AppEventArgs args)
        {
            if (args.Kind == AppEventKind.AppSettingChanged)
            {
                UpdateTransModePanel_();
            }

            if (args.Kind == AppEventKind.RedrawAllLayout)
            {
                _mainView.Invalidate();
            }
        }

        #endregion AppEventListener

        #region 設定保存関連

        /// <summary>
        /// 自身の設定データかチェックします。
        ///
        /// 現状は、ILEDataSerializebleWindow の
        /// 公開インタフェースではありません。
        /// </summary>
        public bool IsSelfSetting(LEToolFormSetting setting)
        {
            string path;
            if (setting.TryToFindUserDataStrByName("RlytInputPath", out path))
            {
                return path == this.FilePath;
            }
            return false;
        }

        /// <summary>
        /// 状態を保存します。
        /// 最小化状態のウインドウの状態は保存しません。
        /// </summary>
        public void SaveSetting(LEToolFormSetting setting, SaveSettingOption option)
        {
            if (option.AlsoSaveOtherThanWorkspace)
            {
                // ファイル出力先情報
                setting.AddUserData("RlytInputPath", this._CurrentSubSceneState.LastSavedFilePath);
            }

            if (ViewManager.DockPanel.DocumentStyle == WeifenLuo.WinFormsUI.Docking.DocumentStyle.SystemMdi)
            {
                LEToolWindow.SaveToBasicData(this, setting);
            }

            setting.Name = this.Name;


            // ビュー設定
            setting.AddUserData("Magnity", this._mainView.Magnify.ToString());
            setting.AddUserData("ViewPosX", this._mainView.ScreenOrigInScene.X.ToString());
            setting.AddUserData("ViewPosY", this._mainView.ScreenOrigInScene.Y.ToString());

            // ファイルを閉じるダイアログのサイズ
            setting.AddUserData("CloseDlgW", this._closeDlg.Width.ToString());
            setting.AddUserData("CloseDlgH", this._closeDlg.Height.ToString());
        }

        /// <summary>
        /// 状態を読み込みます。
        /// </summary>
        public void LoadSetting(LEToolFormSetting setting, LoadSettingOption option)
        {
            if (ViewManager.DockPanel.DocumentStyle == WeifenLuo.WinFormsUI.Docking.DocumentStyle.SystemMdi)
            {
                LEToolWindow.LoadFormBasicData(this, setting);

                // 変な位置に出ないようにクランプします。
                this.Location = new Point(Math.Max(0, this.Location.X), Math.Max(0, this.Location.Y));
            }

            // 倍率
            float userData = 0.0f;
            if (setting.TryToFindUserFloatDataByName("Magnity", out userData))
            {
                this._mainView.Magnify = userData;
            }

            // ビュー原点
            PointF vOrig = PointF.Empty;
            if (setting.TryToFindUserFloatDataByName("ViewPosX", out userData))
            {
                vOrig.X = userData;
            }
            if (setting.TryToFindUserFloatDataByName("ViewPosY", out userData))
            {
                vOrig.Y = userData;
            }
            this._mainView.ScreenOrigInScene = vOrig;

            // ファイルを閉じるダイアログのサイズ
            {
                int userInt = 0;
                if (setting.TryToFindUserIntDataByName("CloseDlgW", out userInt))
                {
                    this._closeDlg.Width = userInt;
                }
                if (setting.TryToFindUserIntDataByName("CloseDlgH", out userInt))
                {
                    this._closeDlg.Height = userInt;
                }
            }
        }
        #endregion 設定保存関連

        #endregion ILEToolWindow メンバ

        /// <summary>
        /// 部品レイアウトを編集対象として開く
        /// </summary>
        private void OpenPartsAsCurrentEditTargetByFilePath_(string partsFilePath)
        {
            if (string.IsNullOrEmpty(partsFilePath))
            {
                return;
            }

            // すでに開かれていなか探し、アクティブにする。
            TargetSubSceneSaveState opendSceneState = _targetSubSceneStates.Find((s) => s.LastSavedFilePath == partsFilePath);
            if (opendSceneState != null)
            {
                this.SetCurrentSubScene_(opendSceneState);
            }
            else
            {
                // 開かれていない場合は新規にロードしてアクティブにする。
                var result = LayoutEditorCore.LoadLayoutFile(partsFilePath, LayoutEditorCore.LoadOption.TryToOpenRlan);
                if (result != null)
                {
                    opendSceneState = AddTargetSubScene(result);
                }
            }

            // 初期表示レイアウトに戻るボタンを表示する。
            if (opendSceneState != null && !object.ReferenceEquals(opendSceneState, _InitialSubSceneState))
            {
                var image = _selectSubPartsDlg.GetThumnailImage(_InitialSubSceneState.LastSavedFilePath);
                if (image != null)
                {
                    PictureBoxHelper.SetImageWithDispose(_pnlOriginalLayout, image);
                }
                _pnlOriginalLayout.Visible = true;
            }
            else
            {
                _pnlOriginalLayout.Visible = false;
            }
        }

        /// <summary>
        /// 部品レイアウトを編集対象として開く
        /// </summary>
        public void OpenPartsAsCurrentEditTargetByFilePath(string partsFilePath)
        {
            OpenPartsAsCurrentEditTargetByFilePath_(partsFilePath);
        }

        /// <summary>
        /// 部品一覧ダイアログで部品が選択された
        /// </summary>
        private void OpenPartsDlgOnPartsSelect_(object sender, EventArgs e)
        {
            Debug.Assert(!_selectSubPartsDlg.Visible);
            OpenPartsAsCurrentEditTargetByFilePath_(_selectSubPartsDlg.SelectedPartsFilePath);
        }

        /// <summary>
        /// 部品一覧
        /// </summary>
        private void Event_btnParts_MouseEnter(object sender, EventArgs e)
        {
            if (_selectSubPartsDlg.Visible)
            {
                return;
            }

            var btn = sender as Button;
            var posScrn = btn.Parent.PointToScreen(new Point(btn.Bounds.Right, btn.Bounds.Top));

            // 最初のサブシーンで設定する。
            using (WaitCursor wc = new WaitCursor())
            {
                _selectSubPartsDlg.Setup(_targetSubSceneStates, _CurrentSubSceneState.LastSavedFilePath, AppSetting);
                _selectSubPartsDlg.Show();
                _selectSubPartsDlg.Location = new Point(posScrn.X, Math.Max(0, posScrn.Y - _selectSubPartsDlg.Height));
            }
        }

        /// <summary>
        /// 最初に開いたレイアウトに戻るパネル
        /// </summary>
        private void Event_pnlOriginalLayout_Click(object sender, EventArgs e)
        {
            this.SetCurrentSubScene_(_InitialSubSceneState);
            _pnlOriginalLayout.Visible = false;
            PictureBoxHelper.SetImageWithDispose(_pnlOriginalLayout, null);
        }

        /// <summary>
        /// 最初に開いたレイアウトに戻るパネル
        /// </summary>
        void Event_pnlOriginalLayout_MouseLeave(object sender, EventArgs e)
        {
            _pnlOriginalLayout.BackColor = Color.White;
        }

        /// <summary>
        /// 最初に開いたレイアウトに戻るパネル
        /// </summary>
        void Event_pnlOriginalLayout_MouseEnter(object sender, EventArgs e)
        {
            _pnlOriginalLayout.BackColor = Color.FromArgb(70, 230, 70);
        }

        /// <summary>
        /// 最初に開いたレイアウトに戻るパネルのカスタム描画
        /// </summary>
        void Event_pnlOriginalLayout_OnCustumPaint(LayoutEditor.Controls.UIPictureBox box, PaintEventArgs pe)
        {
            if (box.Image != null)
            {
                pe.Graphics.Clear(this.BackColor);

                int imgW = Math.Max(1, box.Width);
                int imgH = Math.Max(1, box.Height);
                pe.Graphics.DrawImage(box.Image, 0, 0, imgW, imgH);

                pe.Graphics.DrawRectangle(new Pen(_pnlOriginalLayout.BackColor, 2), 1, 1, imgW - 2, imgH - 2);
                pe.Graphics.DrawRectangle(new Pen(Color.Black), 0, 0, imgW - 1, imgH - 1);

                var img = ImageResMgr.GetManifestResourcePng("GoLtrHS.png");
                pe.Graphics.DrawImage(img, imgW - img.Width - 4, +4, img.Width, img.Height);
            }
        }

        /// <summary>
        /// 統計メッセージを得る
        /// </summary>
        string GetMetricsMessage_(SubSceneMetrics metrics)
        {
            string content1 = string.Format("{10} \t={0} \t(Nu={1} Bo={2} Pi={3} Te={4} Wi={5} Ca={6} Al={7} Sc={8} Pa={9})", metrics.GetTotalPaneCount(), metrics.NullPaneCount, metrics.BoundingPaneCount, metrics.PicturePaneCount, metrics.TextBoxPaneCount, metrics.WindowPaneCount, metrics.CapturePaneCount, metrics.AligmentPaneCount, metrics.ScissorPaneCount, metrics.PartsPaneCount, StringResMgr.Get("PARTS_LISTVIEW_PANENUM"));
            string content2 = string.Format("{7} \t={0} \t(0Tex={1} 1Tex={2} 2Tex={3} 3Tex={4}) ({5} = {6}) ", metrics.GetTotalPixcelCount(), metrics.TotalPixcel0Tex, metrics.TotalPixcel1Tex, metrics.TotalPixcel2Tex, metrics.TotalPixcel3Tex, StringResMgr.Get("METRICS_REPORT_SCREEN"), (float)metrics.GetTotalPixcelCount() / (float)(metrics.ScreenW * metrics.ScreenH), StringResMgr.Get("PARTS_LISTVIEW_PIXELNUM"));
            string descriptions = StringResMgr.Get("METRICS_REPORT_PARAMDESC", metrics.ScreenW, metrics.ScreenH);

            return string.Format(
                "{0}" + Environment.NewLine +
                "================================================================" + Environment.NewLine +
                "{1}" + Environment.NewLine +
                "----------------------------------------------------------------" + Environment.NewLine +
                "{2}",
                StringResMgr.Get("METRICS_REPORT_TITLE"), content1 + Environment.NewLine + content2, descriptions);
        }

        /// <summary>
        /// マウスエンターで統計をツールチップ表示
        /// </summary>
        private void Event_btnMetrics_MouseEnter(object sender, EventArgs e)
        {
            if (CurrentSubScene == null)
            {
                return;
            }

            SubSceneMetrics metrics = new SubSceneMetrics();
            SubSceneHelper.CalcSubsceneMetrics(CurrentSubScene, metrics);

            _ttpMain.SetToolTip(_btnMetrics, GetMetricsMessage_(metrics));
        }

        /// <summary>
        /// ボタン押しで、統計をダイアログ表示
        /// </summary>
        private void Event_mainViewBar_Click(object sender, EventArgs e)
        {
            MessageReportDlg dlg = new MessageReportDlg(LayoutEditor.Forms.MessageReportDlg.ButtonTypes.Ok, false);
            dlg.Title = StringResMgr.Get("METRICS_REPORT_TITLE");
            dlg.Message = _ttpMain.GetToolTip(_btnMetrics);
            dlg.ShowDialog(this);
        }

        /// <summary>
        /// ステータスバーサイズ変更
        /// </summary>
        private void Event_stbMainView_SizeChanged(object sender, EventArgs e)
        {
            int minStatusBarW = _mainViewBar.Width + _pnlMouseMode.Width + _pnlPaneState.MinWidth + (32 + 4) * 4;
            bool statusInfoVisible = _stbMainView.Size.Width >= minStatusBarW;

            _btnMetrics.Visible = statusInfoVisible;
            _btnParts.Visible = statusInfoVisible;
            _btnPersepective.Visible = statusInfoVisible;
            _stbMainView.ShowPanels = statusInfoVisible;
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_btnPersepective_Click(object sender, EventArgs e)
        {
            _mainView.Renderer.PersepectiveRendering = !_mainView.Renderer.PersepectiveRendering;
            _mainView.Invalidate();

            _btnPersepective.Image = _mainView.Renderer.PersepectiveRendering ? _pserpectiveIcon : _orthoIcon;
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_tmiAlignmentL_Click(object sender, EventArgs e)
        {
            PaneHelper.AlignPanes(_TargetActiveSubScene.ISelectedSet.IPaneArray, (orig, mod) => new FVec3(orig.GetBoundingVolumeInWorld().Left - mod.GetBoundingVolumeInWorld().Left, 0.0f, 0.0f));
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_tmiAlignmentHC_Click(object sender, EventArgs e)
        {
            PaneHelper.AlignPanes(_TargetActiveSubScene.ISelectedSet.IPaneArray, (orig, mod) => new FVec3(RectangleHelper.CalcCenter(orig.GetBoundingVolumeInWorld()).X - RectangleHelper.CalcCenter(mod.GetBoundingVolumeInWorld()).X, 0.0f, 0.0f));
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_tmiAlignmentR_Click(object sender, EventArgs e)
        {
            PaneHelper.AlignPanes(_TargetActiveSubScene.ISelectedSet.IPaneArray, (orig, mod) => new FVec3(orig.GetBoundingVolumeInWorld().Right - mod.GetBoundingVolumeInWorld().Right, 0.0f, 0.0f));
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_tmiAlignmentT_Click(object sender, EventArgs e)
        {
            PaneHelper.AlignPanes(_TargetActiveSubScene.ISelectedSet.IPaneArray, (orig, mod) => new FVec3(0.0f, orig.GetBoundingVolumeInWorld().Bottom - mod.GetBoundingVolumeInWorld().Bottom, 0.0f));
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_tmiAlignmentVC_Click(object sender, EventArgs e)
        {
            PaneHelper.AlignPanes(_TargetActiveSubScene.ISelectedSet.IPaneArray, (orig, mod) => new FVec3(0.0f, RectangleHelper.CalcCenter(orig.GetBoundingVolumeInWorld()).Y - RectangleHelper.CalcCenter(mod.GetBoundingVolumeInWorld()).Y, 0.0f));
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_tmiAlignmentB_Click(object sender, EventArgs e)
        {
            PaneHelper.AlignPanes(_TargetActiveSubScene.ISelectedSet.IPaneArray, (orig, mod) => new FVec3(0.0f, orig.GetBoundingVolumeInWorld().Top - mod.GetBoundingVolumeInWorld().Top, 0.0f));
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_tmiAlignmentTrimH_Click(object sender, EventArgs e)
        {
            PaneHelper.DistributePanes(_TargetActiveSubScene.ISelectedSet.IPaneArray, (orig, mod) => new FVec3(orig.GetBoundingVolumeInWorld().Left - mod.GetBoundingVolumeInWorld().Left, 0.0f, 0.0f));
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_tmiAlignmentTrimV_Click(object sender, EventArgs e)
        {
            PaneHelper.DistributePanes(_TargetActiveSubScene.ISelectedSet.IPaneArray, (orig, mod) => new FVec3(0.0f, orig.GetBoundingVolumeInWorld().Bottom - mod.GetBoundingVolumeInWorld().Bottom, 0.0f));
        }

        private void Event_tmiResizeToTextureSize_Click(object sender, EventArgs e)
        {
            PaneHelper.ResizePanesToTexutureSize(_TargetActiveSubScene.ISelectedSet.IPaneArray);
        }

        private void Event_tmiCreateCapturePaneWithChildren_Click(object sender, EventArgs e)
        {
            SubSceneHelper.AddCapturePaneWithSelectedPanesAsChild(
                _TargetActiveSubScene,
                AppSetting.ProjectSettings.GetNewCapturePaneName(),
                (errorPaneList) =>
                {
                    string errorMsg = LayoutEditor.StringResMgr.Get("CREATE_CAPTURE_PANE_ERROR");
                    errorMsg += "\n\n";
                    foreach (var errorPane in errorPaneList)
                    {
                        errorMsg += errorPane.PaneName + "\n";
                    }

                    // TEXTURE_MSG_DLG_TITLE  テクスチャ - メッセージ
                    MessageBox.Show(this, errorMsg, LayoutEditor.StringResMgr.Get("TEXTURE_MSG_DLG_TITLE"), MessageBoxButtons.OK);
                }
            );
        }

        private void Event_tmiAsChild_Click(object sender, EventArgs e)
        {
            HierarchyControl_(Keys.P);
        }

        private void Event_tmiAsParent_Click(object sender, EventArgs e)
        {
            HierarchyControl_(Keys.Shift | Keys.P);
        }

        private void Event_tmiCreateNullPaneAndAddChild_Click(object sender, EventArgs e)
        {
            AddPaneAsNullPaneChild(_TargetActiveSubScene.ISelectedSet.IPaneArray);
        }

        #region CombinerEditor からの受信

        private string _combinerReplaceFile = string.Empty;
        private string _combinerReceivedTempFile = string.Empty;

        /// <summary>
        /// コンバイナエディタからが送信されてきたらビュワーに転送します。
        /// </summary>
        /// <param name="sender">nullが飛んできます。</param>
        /// <param name="e">受信したシェーダの情報が入ります。</param>
        void OnShaderChanged(object sender, LayoutEditor.src.CombinerEditor.CombinerShaderChangedEventArgs e)
        {
            if (!AppSetting.ProjectSettings.IsCombinerUserShaderEnabled)
            {
                return;
            }

            if (CurrentSubScene == null || _Scene.CurrentISubScene == null || CurrentSubScene != _Scene.CurrentISubScene)
            {
                return;
            }

            // コンバイナエディタは終了時に作業ファイルが無い状態で送信を送る為、無視します。
            if (string.IsNullOrEmpty(e.WorkFilePath))
            {
                return;
            }

            if (!System.IO.File.Exists(e.WorkFilePath))
            {
                Debug.Assert(false, "CombinerEditor work file not found.");
            }
            if (!System.IO.File.Exists(e.ProjectPath))
            {
                Debug.Assert(false, "CombinerEditor project file not found.");
                return;
            }

            // 通信は別タスク（スレッド）で行われる為、Invoke を行い親スレッドで処理します。
            Invoke(new Action(() => {
                _combinerReceivedTempFile = e.WorkFilePath;
                _combinerReplaceFile = e.ProjectPath;
                SendMessageToViewManager_(new ViewManagerMessage(ViewManagerMessageKind.SendViewer));
            }));
        }

        #endregion

        private void tmiLaunchCombinerEditor_Click(Object sender, EventArgs e)
        {
            CombinerEditorHelper.LaunchCombinerEditor(AppSetting.ProjectSettings.UserCombinerShaderSettings.CombinerEditorPath, false, string.Empty);
        }
    }
}
