﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml.Serialization;

namespace LayoutEditor.Forms.ToolWindows.AnimSectionTagWindow
{
    using common;
    using Controls;
    using LayoutEditor.Structures.SerializableObject;
    using LECore;
    using LECore.Manipulator;
    using LECore.Save_Load;
    using LECore.Structures;
    using LECore.Structures.Core;
    using LECore.Structures.LECoreInterface;
    using CoreData = LECore.Structures;
    using FileFmt = LECore.Structures.SerializableObject.Lan;
    using WinForm = System.Windows.Forms;

    /// <summary>
    /// アニメーション区間タグ編集ウインドウ
    /// </summary>
    public class AnimSectionTagWindow : LEToolWindow
    {

        #region デザイナ生成コード
        private System.Windows.Forms.GroupBox _grpFrameSection;
        private System.Windows.Forms.CheckBox _chkOutBinaryActive;
        private LayoutEditor.Forms.ToolWindows.AnimSectionTagWindow.AnimSectionBasicPanel _pnlAnimSectionBasic;
        private ColumnHeader _cmhName;
        private ColumnHeader _cmhComment;
        private ColumnHeader _cmhStart;
        private ColumnHeader _cmhEnd;
        private GroupBox _grpExportBinary;
        private ColumnHeader _cmhTargetGroup;
        private GroupBox _grpTargetGroup;
        private Button _btnHideOtherPane;
        private CheckBox _chkBindAnimationRecursively;
        private TextBox _tbxGroup;
        private Button _btnSetTargetGroup;
        private LayoutEditor.Controls.CollapsiblePanel _cpnBinaryExport;
        private FlowLayoutPanel _flpAnimTag;
        private LayoutEditor.Controls.CollapsiblePanel _cpnTargetGroup;
        private LayoutEditor.Controls.CollapsiblePanel _cpnAnimSectionBasic;
        private ToolStrip _tspMain;
        private ToolStripButton _tsbAddFrameOffset;
        private ToolStripButton _tsbFileExport;
        private ToolStripButton _tsbFileImport;
        private LayoutEditor.src.Controls.VSplitPanelFolder _spfSettings;
        private Panel _pnlFrameSection;
        private GroupBox _grpLoopType;
        private UIRadioButton _radLoopTypeOneTime;
        private UIRadioButton _radLoopTypeLoop;
        private GroupBox _grpOutAnmType;
        private UICheckBox _chkOutRlts;
        private UICheckBox _chkOutRltp;
        private UICheckBox _chkOutRlmc;
        private UICheckBox _chkOutRlvi;
        private UICheckBox _chkOutRlvc;
        private UICheckBox _chkOutRlpa;
        private UIRadioButton _radLoopTypeWait;
        private LayoutEditor.Controls.DockContentToolTip _ttpMain;
        private System.ComponentModel.IContainer components;
        private ToolStripButton _btnAdd2;
        private ToolStripButton _btnRemove2;
        private ToolStripSeparator toolStripSeparator1;
        private ToolStripButton _btnDown2;
        private ToolStripButton _btnUp2;
        private ToolStripSeparator toolStripSeparator2;
        private ToolStripButton _btnCloneSelected;
        private ToolStripSeparator toolStripSeparator3;
        private ColumnHeader _cmhId;
        private ToolStripLabel _lblUpDownNotice;
        private Button _btnCheckAuto;
        private UICheckBox _chkOutRlIndirectTexture;
        private UICheckBox _chkOutRlAlphaTest;
        private UICheckBox _chkOutEvalTimeOffset;
        private UICheckBox _chkOutRlud;
        private UserDataPanel _pnlUserData;
        private ColumnHeader _cmhUserData;
        private CollapsiblePanel _cpnUserData;
        private ToolStripButton _btnUseTargetFrameSectionRangeAsPlayRange;
        private ToolStripSeparator toolStripSeparator4;
        private ErrorProvider _erpMain;
        private ToolStripButton _tsbAnimEditMode;
        private UICheckBox _chkOutRlWindow;
        private ToolStripButton _btnAutoAdjustPlayRange;
        private ToolStripButton _btnAutoFocus;
        private UICheckBox _chkOutRlma;
        private UICheckBox _chkOutRlds;
        private UICheckBox _chkOutRlps;
        private InPlaceEditListView _lvwFrameSectionSet;

        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(AnimSectionTagWindow));
            this._ttpMain = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this._radLoopTypeWait = new LayoutEditor.Controls.UIRadioButton();
            this._btnCheckAuto = new System.Windows.Forms.Button();
            this._tsbAnimEditMode = new System.Windows.Forms.ToolStripButton();
            this._pnlFrameSection = new System.Windows.Forms.Panel();
            this._lvwFrameSectionSet = new LayoutEditor.Controls.InPlaceEditListView();
            this._cmhId = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this._cmhName = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this._cmhStart = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this._cmhEnd = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this._cmhComment = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this._cmhTargetGroup = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this._cmhUserData = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this._spfSettings = new LayoutEditor.src.Controls.VSplitPanelFolder();
            this._flpAnimTag = new System.Windows.Forms.FlowLayoutPanel();
            this._cpnAnimSectionBasic = new LayoutEditor.Controls.CollapsiblePanel();
            this._grpFrameSection = new System.Windows.Forms.GroupBox();
            this._pnlAnimSectionBasic = new LayoutEditor.Forms.ToolWindows.AnimSectionTagWindow.AnimSectionBasicPanel();
            this._cpnTargetGroup = new LayoutEditor.Controls.CollapsiblePanel();
            this._grpTargetGroup = new System.Windows.Forms.GroupBox();
            this._btnHideOtherPane = new System.Windows.Forms.Button();
            this._chkBindAnimationRecursively = new System.Windows.Forms.CheckBox();
            this._tbxGroup = new System.Windows.Forms.TextBox();
            this._btnSetTargetGroup = new System.Windows.Forms.Button();
            this._cpnBinaryExport = new LayoutEditor.Controls.CollapsiblePanel();
            this._grpExportBinary = new System.Windows.Forms.GroupBox();
            this._grpLoopType = new System.Windows.Forms.GroupBox();
            this._radLoopTypeOneTime = new LayoutEditor.Controls.UIRadioButton();
            this._radLoopTypeLoop = new LayoutEditor.Controls.UIRadioButton();
            this._grpOutAnmType = new System.Windows.Forms.GroupBox();
            this._chkOutRlds = new LayoutEditor.Controls.UICheckBox();
            this._chkOutRlma = new LayoutEditor.Controls.UICheckBox();
            this._chkOutRlWindow = new LayoutEditor.Controls.UICheckBox();
            this._chkOutRlud = new LayoutEditor.Controls.UICheckBox();
            this._chkOutEvalTimeOffset = new LayoutEditor.Controls.UICheckBox();
            this._chkOutRlIndirectTexture = new LayoutEditor.Controls.UICheckBox();
            this._chkOutRlts = new LayoutEditor.Controls.UICheckBox();
            this._chkOutRltp = new LayoutEditor.Controls.UICheckBox();
            this._chkOutRlAlphaTest = new LayoutEditor.Controls.UICheckBox();
            this._chkOutRlmc = new LayoutEditor.Controls.UICheckBox();
            this._chkOutRlvi = new LayoutEditor.Controls.UICheckBox();
            this._chkOutRlvc = new LayoutEditor.Controls.UICheckBox();
            this._chkOutRlpa = new LayoutEditor.Controls.UICheckBox();
            this._chkOutBinaryActive = new System.Windows.Forms.CheckBox();
            this._cpnUserData = new LayoutEditor.Controls.CollapsiblePanel();
            this._pnlUserData = new LayoutEditor.Forms.ToolWindows.UserDataPanel();
            this._tspMain = new System.Windows.Forms.ToolStrip();
            this._btnAdd2 = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator3 = new System.Windows.Forms.ToolStripSeparator();
            this._btnRemove2 = new System.Windows.Forms.ToolStripButton();
            this._btnCloneSelected = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this._lblUpDownNotice = new System.Windows.Forms.ToolStripLabel();
            this._btnDown2 = new System.Windows.Forms.ToolStripButton();
            this._btnUp2 = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
            this._btnAutoFocus = new System.Windows.Forms.ToolStripButton();
            this._btnUseTargetFrameSectionRangeAsPlayRange = new System.Windows.Forms.ToolStripButton();
            this._btnAutoAdjustPlayRange = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator4 = new System.Windows.Forms.ToolStripSeparator();
            this._tsbAddFrameOffset = new System.Windows.Forms.ToolStripButton();
            this._tsbFileExport = new System.Windows.Forms.ToolStripButton();
            this._tsbFileImport = new System.Windows.Forms.ToolStripButton();
            this._erpMain = new System.Windows.Forms.ErrorProvider(this.components);
            this._chkOutRlps = new LayoutEditor.Controls.UICheckBox();
            this._pnlFrameSection.SuspendLayout();
            this._flpAnimTag.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._cpnAnimSectionBasic)).BeginInit();
            this._cpnAnimSectionBasic.Panel2.SuspendLayout();
            this._cpnAnimSectionBasic.SuspendLayout();
            this._grpFrameSection.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._cpnTargetGroup)).BeginInit();
            this._cpnTargetGroup.Panel2.SuspendLayout();
            this._cpnTargetGroup.SuspendLayout();
            this._grpTargetGroup.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._cpnBinaryExport)).BeginInit();
            this._cpnBinaryExport.Panel2.SuspendLayout();
            this._cpnBinaryExport.SuspendLayout();
            this._grpExportBinary.SuspendLayout();
            this._grpLoopType.SuspendLayout();
            this._grpOutAnmType.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._cpnUserData)).BeginInit();
            this._cpnUserData.Panel2.SuspendLayout();
            this._cpnUserData.SuspendLayout();
            this._tspMain.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._erpMain)).BeginInit();
            this.SuspendLayout();
            //
            // _radLoopTypeWait
            //
            resources.ApplyResources(this._radLoopTypeWait, "_radLoopTypeWait");
            this._radLoopTypeWait.Name = "_radLoopTypeWait";
            this._radLoopTypeWait.TabStop = true;
            this._ttpMain.SetToolTip(this._radLoopTypeWait, resources.GetString("_radLoopTypeWait.ToolTip"));
            this._radLoopTypeWait.UseVisualStyleBackColor = true;
            this._radLoopTypeWait.CheckedChanged += new System.EventHandler(this.Event_RadLoopTypeOneTime_CheckedChanged);
            //
            // _btnCheckAuto
            //
            resources.ApplyResources(this._btnCheckAuto, "_btnCheckAuto");
            this._btnCheckAuto.Name = "_btnCheckAuto";
            this._ttpMain.SetToolTip(this._btnCheckAuto, resources.GetString("_btnCheckAuto.ToolTip"));
            this._btnCheckAuto.UseVisualStyleBackColor = true;
            this._btnCheckAuto.Click += new System.EventHandler(this.Event_BtnCheckAuto_Click);
            //
            // _tsbAnimEditMode
            //
            this._tsbAnimEditMode.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this._tsbAnimEditMode.Image = global::LayoutEditor.Properties.Resources.Animation_CombiningMode;
            resources.ApplyResources(this._tsbAnimEditMode, "_tsbAnimEditMode");
            this._tsbAnimEditMode.Name = "_tsbAnimEditMode";
            this._tsbAnimEditMode.Click += new System.EventHandler(this.Event_TsbAnimationEditMode_Click);
            //
            // _pnlFrameSection
            //
            this._pnlFrameSection.Controls.Add(this._lvwFrameSectionSet);
            resources.ApplyResources(this._pnlFrameSection, "_pnlFrameSection");
            this._pnlFrameSection.Name = "_pnlFrameSection";
            //
            // _lvwFrameSectionSet
            //
            this._lvwFrameSectionSet.AllowColumnReorder = true;
            this._lvwFrameSectionSet.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this._cmhId,
            this._cmhName,
            this._cmhStart,
            this._cmhEnd,
            this._cmhComment,
            this._cmhTargetGroup,
            this._cmhUserData});
            resources.ApplyResources(this._lvwFrameSectionSet, "_lvwFrameSectionSet");
            this._lvwFrameSectionSet.GridLines = true;
            this._lvwFrameSectionSet.MultiSelect = true;
            this._lvwFrameSectionSet.Name = "_lvwFrameSectionSet";
            this._lvwFrameSectionSet.UseCompatibleStateImageBehavior = false;
            this._lvwFrameSectionSet.View = System.Windows.Forms.View.Details;
            this._lvwFrameSectionSet.AfterLabelEdit += new System.Windows.Forms.LabelEditEventHandler(this.Event_LvwFrameSectionSet_AfterLabelEdit);
            this._lvwFrameSectionSet.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.Event_lvwFrameSectionSet_ColumnClick);
            this._lvwFrameSectionSet.SelectedIndexChanged += new System.EventHandler(this.Event_LvwFrameSectionSet_SelectedIndexChanged);
            //
            // _cmhId
            //
            resources.ApplyResources(this._cmhId, "_cmhId");
            //
            // _cmhName
            //
            resources.ApplyResources(this._cmhName, "_cmhName");
            //
            // _cmhStart
            //
            resources.ApplyResources(this._cmhStart, "_cmhStart");
            //
            // _cmhEnd
            //
            resources.ApplyResources(this._cmhEnd, "_cmhEnd");
            //
            // _cmhComment
            //
            resources.ApplyResources(this._cmhComment, "_cmhComment");
            //
            // _cmhTargetGroup
            //
            resources.ApplyResources(this._cmhTargetGroup, "_cmhTargetGroup");
            //
            // _cmhUserData
            //
            resources.ApplyResources(this._cmhUserData, "_cmhUserData");
            //
            // _spfSettings
            //
            resources.ApplyResources(this._spfSettings, "_spfSettings");
            this._spfSettings.Name = "_spfSettings";
            this._spfSettings.TabStop = false;
            this._spfSettings.TargetPanel = this._flpAnimTag;
            //
            // _flpAnimTag
            //
            resources.ApplyResources(this._flpAnimTag, "_flpAnimTag");
            this._flpAnimTag.BackColor = System.Drawing.SystemColors.Control;
            this._flpAnimTag.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this._flpAnimTag.Controls.Add(this._cpnAnimSectionBasic);
            this._flpAnimTag.Controls.Add(this._cpnTargetGroup);
            this._flpAnimTag.Controls.Add(this._cpnBinaryExport);
            this._flpAnimTag.Controls.Add(this._cpnUserData);
            this._flpAnimTag.Name = "_flpAnimTag";
            //
            // _cpnAnimSectionBasic
            //
            this._cpnAnimSectionBasic.FixedPanel = System.Windows.Forms.FixedPanel.Panel1;
            resources.ApplyResources(this._cpnAnimSectionBasic, "_cpnAnimSectionBasic");
            this._cpnAnimSectionBasic.Name = "_cpnAnimSectionBasic";
            //
            // _cpnAnimSectionBasic.Panel1
            //
            this._cpnAnimSectionBasic.Panel1.BackColor = System.Drawing.SystemColors.GradientInactiveCaption;
            this._cpnAnimSectionBasic.Panel1Size = new System.Drawing.Size(390, 18);
            //
            // _cpnAnimSectionBasic.Panel2
            //
            this._cpnAnimSectionBasic.Panel2.BackColor = System.Drawing.SystemColors.Control;
            this._cpnAnimSectionBasic.Panel2.Controls.Add(this._grpFrameSection);
            //
            // _grpFrameSection
            //
            this._grpFrameSection.Controls.Add(this._pnlAnimSectionBasic);
            resources.ApplyResources(this._grpFrameSection, "_grpFrameSection");
            this._grpFrameSection.Name = "_grpFrameSection";
            this._grpFrameSection.TabStop = false;
            //
            // _pnlAnimSectionBasic
            //
            resources.ApplyResources(this._pnlAnimSectionBasic, "_pnlAnimSectionBasic");
            this._pnlAnimSectionBasic.Name = "_pnlAnimSectionBasic";
            this._pnlAnimSectionBasic.Target = null;
            this._pnlAnimSectionBasic.TragetName = "";
            //
            // _cpnTargetGroup
            //
            this._cpnTargetGroup.FixedPanel = System.Windows.Forms.FixedPanel.Panel1;
            resources.ApplyResources(this._cpnTargetGroup, "_cpnTargetGroup");
            this._cpnTargetGroup.Name = "_cpnTargetGroup";
            //
            // _cpnTargetGroup.Panel1
            //
            this._cpnTargetGroup.Panel1.BackColor = System.Drawing.SystemColors.GradientInactiveCaption;
            this._cpnTargetGroup.Panel1Size = new System.Drawing.Size(390, 18);
            //
            // _cpnTargetGroup.Panel2
            //
            this._cpnTargetGroup.Panel2.Controls.Add(this._grpTargetGroup);
            //
            // _grpTargetGroup
            //
            this._grpTargetGroup.BackColor = System.Drawing.SystemColors.Control;
            this._grpTargetGroup.Controls.Add(this._btnHideOtherPane);
            this._grpTargetGroup.Controls.Add(this._chkBindAnimationRecursively);
            this._grpTargetGroup.Controls.Add(this._tbxGroup);
            this._grpTargetGroup.Controls.Add(this._btnSetTargetGroup);
            resources.ApplyResources(this._grpTargetGroup, "_grpTargetGroup");
            this._erpMain.SetError(this._grpTargetGroup, resources.GetString("_grpTargetGroup.Error"));
            this._grpTargetGroup.Name = "_grpTargetGroup";
            this._grpTargetGroup.TabStop = false;
            //
            // _btnHideOtherPane
            //
            resources.ApplyResources(this._btnHideOtherPane, "_btnHideOtherPane");
            this._btnHideOtherPane.Name = "_btnHideOtherPane";
            this._btnHideOtherPane.UseVisualStyleBackColor = true;
            this._btnHideOtherPane.Click += new System.EventHandler(this.Event_BtnHideOtherPane_Click);
            //
            // _chkBindAnimationRecursively
            //
            resources.ApplyResources(this._chkBindAnimationRecursively, "_chkBindAnimationRecursively");
            this._chkBindAnimationRecursively.Name = "_chkBindAnimationRecursively";
            this._chkBindAnimationRecursively.UseVisualStyleBackColor = true;
            this._chkBindAnimationRecursively.CheckedChanged += new System.EventHandler(this.Event_ChkBindAnimationRecursively_CheckedChanged);
            //
            // _tbxGroup
            //
            resources.ApplyResources(this._tbxGroup, "_tbxGroup");
            this._erpMain.SetIconAlignment(this._tbxGroup, ((System.Windows.Forms.ErrorIconAlignment)(resources.GetObject("_tbxGroup.IconAlignment"))));
            this._erpMain.SetIconPadding(this._tbxGroup, ((int)(resources.GetObject("_tbxGroup.IconPadding"))));
            this._tbxGroup.Name = "_tbxGroup";
            this._tbxGroup.ReadOnly = true;
            //
            // _btnSetTargetGroup
            //
            resources.ApplyResources(this._btnSetTargetGroup, "_btnSetTargetGroup");
            this._btnSetTargetGroup.Name = "_btnSetTargetGroup";
            this._btnSetTargetGroup.UseVisualStyleBackColor = true;
            this._btnSetTargetGroup.Click += new System.EventHandler(this.Event_BtnSetTargetGroup_Click);
            //
            // _cpnBinaryExport
            //
            this._cpnBinaryExport.FixedPanel = System.Windows.Forms.FixedPanel.Panel1;
            resources.ApplyResources(this._cpnBinaryExport, "_cpnBinaryExport");
            this._cpnBinaryExport.Name = "_cpnBinaryExport";
            //
            // _cpnBinaryExport.Panel1
            //
            this._cpnBinaryExport.Panel1.BackColor = System.Drawing.SystemColors.GradientInactiveCaption;
            this._cpnBinaryExport.Panel1Size = new System.Drawing.Size(390, 18);
            //
            // _cpnBinaryExport.Panel2
            //
            this._cpnBinaryExport.Panel2.Controls.Add(this._grpExportBinary);
            //
            // _grpExportBinary
            //
            this._grpExportBinary.BackColor = System.Drawing.SystemColors.Control;
            this._grpExportBinary.Controls.Add(this._grpLoopType);
            this._grpExportBinary.Controls.Add(this._grpOutAnmType);
            this._grpExportBinary.Controls.Add(this._chkOutBinaryActive);
            resources.ApplyResources(this._grpExportBinary, "_grpExportBinary");
            this._grpExportBinary.Name = "_grpExportBinary";
            this._grpExportBinary.TabStop = false;
            //
            // _grpLoopType
            //
            this._grpLoopType.Controls.Add(this._radLoopTypeWait);
            this._grpLoopType.Controls.Add(this._radLoopTypeOneTime);
            this._grpLoopType.Controls.Add(this._radLoopTypeLoop);
            resources.ApplyResources(this._grpLoopType, "_grpLoopType");
            this._grpLoopType.Name = "_grpLoopType";
            this._grpLoopType.TabStop = false;
            //
            // _radLoopTypeOneTime
            //
            resources.ApplyResources(this._radLoopTypeOneTime, "_radLoopTypeOneTime");
            this._radLoopTypeOneTime.Name = "_radLoopTypeOneTime";
            this._radLoopTypeOneTime.TabStop = true;
            this._radLoopTypeOneTime.UseVisualStyleBackColor = true;
            this._radLoopTypeOneTime.CheckedChanged += new System.EventHandler(this.Event_RadLoopTypeOneTime_CheckedChanged);
            //
            // _radLoopTypeLoop
            //
            resources.ApplyResources(this._radLoopTypeLoop, "_radLoopTypeLoop");
            this._radLoopTypeLoop.Name = "_radLoopTypeLoop";
            this._radLoopTypeLoop.TabStop = true;
            this._radLoopTypeLoop.UseVisualStyleBackColor = true;
            this._radLoopTypeLoop.CheckedChanged += new System.EventHandler(this.Event_RadLoopTypeOneTime_CheckedChanged);
            //
            // _grpOutAnmType
            //
            this._grpOutAnmType.Controls.Add(this._chkOutRlps);
            this._grpOutAnmType.Controls.Add(this._chkOutRlds);
            this._grpOutAnmType.Controls.Add(this._chkOutRlma);
            this._grpOutAnmType.Controls.Add(this._chkOutRlWindow);
            this._grpOutAnmType.Controls.Add(this._chkOutRlud);
            this._grpOutAnmType.Controls.Add(this._btnCheckAuto);
            this._grpOutAnmType.Controls.Add(this._chkOutEvalTimeOffset);
            this._grpOutAnmType.Controls.Add(this._chkOutRlIndirectTexture);
            this._grpOutAnmType.Controls.Add(this._chkOutRlts);
            this._grpOutAnmType.Controls.Add(this._chkOutRltp);
            this._grpOutAnmType.Controls.Add(this._chkOutRlAlphaTest);
            this._grpOutAnmType.Controls.Add(this._chkOutRlmc);
            this._grpOutAnmType.Controls.Add(this._chkOutRlvi);
            this._grpOutAnmType.Controls.Add(this._chkOutRlvc);
            this._grpOutAnmType.Controls.Add(this._chkOutRlpa);
            resources.ApplyResources(this._grpOutAnmType, "_grpOutAnmType");
            this._grpOutAnmType.Name = "_grpOutAnmType";
            this._grpOutAnmType.TabStop = false;
            //
            // _chkOutRlds
            //
            resources.ApplyResources(this._chkOutRlds, "_chkOutRlds");
            this._chkOutRlds.Name = "_chkOutRlds";
            this._chkOutRlds.UseVisualStyleBackColor = true;
            //
            // _chkOutRlma
            //
            resources.ApplyResources(this._chkOutRlma, "_chkOutRlma");
            this._chkOutRlma.Name = "_chkOutRlma";
            this._chkOutRlma.UseVisualStyleBackColor = true;
            this._chkOutRlma.CheckStateChanged += new System.EventHandler(this.Event_ChkOutRlpa_CheckedChanged);
            //
            // _chkOutRlWindow
            //
            resources.ApplyResources(this._chkOutRlWindow, "_chkOutRlWindow");
            this._chkOutRlWindow.Name = "_chkOutRlWindow";
            this._chkOutRlWindow.UseVisualStyleBackColor = true;
            this._chkOutRlWindow.CheckStateChanged += new System.EventHandler(this.Event_ChkOutRlpa_CheckedChanged);
            //
            // _chkOutRlud
            //
            resources.ApplyResources(this._chkOutRlud, "_chkOutRlud");
            this._chkOutRlud.Name = "_chkOutRlud";
            this._chkOutRlud.UseVisualStyleBackColor = true;
            this._chkOutRlud.CheckStateChanged += new System.EventHandler(this.Event_ChkOutRlpa_CheckedChanged);
            //
            // _chkOutEvalTimeOffset
            //
            resources.ApplyResources(this._chkOutEvalTimeOffset, "_chkOutEvalTimeOffset");
            this._chkOutEvalTimeOffset.Name = "_chkOutEvalTimeOffset";
            this._chkOutEvalTimeOffset.UseVisualStyleBackColor = true;
            this._chkOutEvalTimeOffset.CheckStateChanged += new System.EventHandler(this.Event_ChkOutRlpa_CheckedChanged);
            //
            // _chkOutRlIndirectTexture
            //
            resources.ApplyResources(this._chkOutRlIndirectTexture, "_chkOutRlIndirectTexture");
            this._chkOutRlIndirectTexture.Name = "_chkOutRlIndirectTexture";
            this._chkOutRlIndirectTexture.UseVisualStyleBackColor = true;
            this._chkOutRlIndirectTexture.CheckStateChanged += new System.EventHandler(this.Event_ChkOutRlpa_CheckedChanged);
            //
            // _chkOutRlts
            //
            resources.ApplyResources(this._chkOutRlts, "_chkOutRlts");
            this._chkOutRlts.Name = "_chkOutRlts";
            this._chkOutRlts.UseVisualStyleBackColor = true;
            this._chkOutRlts.CheckStateChanged += new System.EventHandler(this.Event_ChkOutRlpa_CheckedChanged);
            //
            // _chkOutRltp
            //
            resources.ApplyResources(this._chkOutRltp, "_chkOutRltp");
            this._chkOutRltp.Name = "_chkOutRltp";
            this._chkOutRltp.UseVisualStyleBackColor = true;
            this._chkOutRltp.CheckStateChanged += new System.EventHandler(this.Event_ChkOutRlpa_CheckedChanged);
            //
            // _chkOutRlAlphaTest
            //
            resources.ApplyResources(this._chkOutRlAlphaTest, "_chkOutRlAlphaTest");
            this._chkOutRlAlphaTest.Name = "_chkOutRlAlphaTest";
            this._chkOutRlAlphaTest.UseVisualStyleBackColor = true;
            this._chkOutRlAlphaTest.CheckStateChanged += new System.EventHandler(this.Event_ChkOutRlpa_CheckedChanged);
            //
            // _chkOutRlmc
            //
            resources.ApplyResources(this._chkOutRlmc, "_chkOutRlmc");
            this._chkOutRlmc.Name = "_chkOutRlmc";
            this._chkOutRlmc.UseVisualStyleBackColor = true;
            this._chkOutRlmc.CheckStateChanged += new System.EventHandler(this.Event_ChkOutRlpa_CheckedChanged);
            //
            // _chkOutRlvi
            //
            resources.ApplyResources(this._chkOutRlvi, "_chkOutRlvi");
            this._chkOutRlvi.Name = "_chkOutRlvi";
            this._chkOutRlvi.UseVisualStyleBackColor = true;
            this._chkOutRlvi.CheckStateChanged += new System.EventHandler(this.Event_ChkOutRlpa_CheckedChanged);
            //
            // _chkOutRlvc
            //
            resources.ApplyResources(this._chkOutRlvc, "_chkOutRlvc");
            this._chkOutRlvc.Name = "_chkOutRlvc";
            this._chkOutRlvc.UseVisualStyleBackColor = true;
            this._chkOutRlvc.CheckStateChanged += new System.EventHandler(this.Event_ChkOutRlpa_CheckedChanged);
            //
            // _chkOutRlpa
            //
            resources.ApplyResources(this._chkOutRlpa, "_chkOutRlpa");
            this._chkOutRlpa.Name = "_chkOutRlpa";
            this._chkOutRlpa.UseVisualStyleBackColor = true;
            this._chkOutRlpa.CheckedChanged += new System.EventHandler(this.Event_ChkOutRlpa_CheckedChanged);
            this._chkOutRlpa.CheckStateChanged += new System.EventHandler(this.Event_ChkOutRlpa_CheckedChanged);
            //
            // _chkOutBinaryActive
            //
            resources.ApplyResources(this._chkOutBinaryActive, "_chkOutBinaryActive");
            this._chkOutBinaryActive.Name = "_chkOutBinaryActive";
            this._chkOutBinaryActive.UseVisualStyleBackColor = true;
            this._chkOutBinaryActive.CheckedChanged += new System.EventHandler(this.Event_ChkOutBinaryActive_CheckedChanged);
            //
            // _cpnUserData
            //
            this._cpnUserData.FixedPanel = System.Windows.Forms.FixedPanel.Panel1;
            resources.ApplyResources(this._cpnUserData, "_cpnUserData");
            this._cpnUserData.Name = "_cpnUserData";
            //
            // _cpnUserData.Panel1
            //
            this._cpnUserData.Panel1.BackColor = System.Drawing.SystemColors.GradientInactiveCaption;
            this._cpnUserData.Panel1Size = new System.Drawing.Size(390, 18);
            //
            // _cpnUserData.Panel2
            //
            this._cpnUserData.Panel2.Controls.Add(this._pnlUserData);
            //
            // _pnlUserData
            //
            resources.ApplyResources(this._pnlUserData, "_pnlUserData");
            this._pnlUserData.Name = "_pnlUserData";
            //
            // _tspMain
            //
            resources.ApplyResources(this._tspMain, "_tspMain");
            this._tspMain.GripMargin = new System.Windows.Forms.Padding(4, 2, 4, 2);
            this._tspMain.GripStyle = System.Windows.Forms.ToolStripGripStyle.Hidden;
            this._tspMain.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._btnAdd2,
            this.toolStripSeparator3,
            this._btnRemove2,
            this._btnCloneSelected,
            this.toolStripSeparator1,
            this._lblUpDownNotice,
            this._btnDown2,
            this._btnUp2,
            this.toolStripSeparator2,
            this._btnAutoFocus,
            this._btnUseTargetFrameSectionRangeAsPlayRange,
            this._btnAutoAdjustPlayRange,
            this.toolStripSeparator4,
            this._tsbAddFrameOffset,
            this._tsbFileExport,
            this._tsbFileImport,
            this._tsbAnimEditMode});
            this._tspMain.Name = "_tspMain";
            //
            // _btnAdd2
            //
            this._btnAdd2.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._btnAdd2, "_btnAdd2");
            this._btnAdd2.Name = "_btnAdd2";
            this._btnAdd2.Click += new System.EventHandler(this.Event_BtnAdd_Click);
            //
            // toolStripSeparator3
            //
            this.toolStripSeparator3.Margin = new System.Windows.Forms.Padding(4, 0, 4, 0);
            this.toolStripSeparator3.Name = "toolStripSeparator3";
            resources.ApplyResources(this.toolStripSeparator3, "toolStripSeparator3");
            //
            // _btnRemove2
            //
            this._btnRemove2.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._btnRemove2, "_btnRemove2");
            this._btnRemove2.Name = "_btnRemove2";
            this._btnRemove2.Click += new System.EventHandler(this.Event_BtnRemove_Click);
            //
            // _btnCloneSelected
            //
            this._btnCloneSelected.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._btnCloneSelected, "_btnCloneSelected");
            this._btnCloneSelected.Name = "_btnCloneSelected";
            this._btnCloneSelected.Click += new System.EventHandler(this.Event_btnCloneSelected_Click);
            //
            // toolStripSeparator1
            //
            this.toolStripSeparator1.Margin = new System.Windows.Forms.Padding(4, 0, 4, 0);
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            resources.ApplyResources(this.toolStripSeparator1, "toolStripSeparator1");
            //
            // _lblUpDownNotice
            //
            this._lblUpDownNotice.BackColor = System.Drawing.SystemColors.Control;
            this._lblUpDownNotice.ForeColor = System.Drawing.SystemColors.InactiveCaptionText;
            this._lblUpDownNotice.Name = "_lblUpDownNotice";
            resources.ApplyResources(this._lblUpDownNotice, "_lblUpDownNotice");
            //
            // _btnDown2
            //
            this._btnDown2.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._btnDown2, "_btnDown2");
            this._btnDown2.Name = "_btnDown2";
            this._btnDown2.Click += new System.EventHandler(this.Event_BtnDown_Click);
            //
            // _btnUp2
            //
            this._btnUp2.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._btnUp2, "_btnUp2");
            this._btnUp2.Name = "_btnUp2";
            this._btnUp2.Click += new System.EventHandler(this.Event_BtnUp_Click);
            //
            // toolStripSeparator2
            //
            this.toolStripSeparator2.Margin = new System.Windows.Forms.Padding(4, 0, 4, 0);
            this.toolStripSeparator2.Name = "toolStripSeparator2";
            resources.ApplyResources(this.toolStripSeparator2, "toolStripSeparator2");
            //
            // _btnAutoFocus
            //
            this._btnAutoFocus.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this._btnAutoFocus.Image = global::LayoutEditor.Properties.Resources.Icon_PreviewAllKey;
            resources.ApplyResources(this._btnAutoFocus, "_btnAutoFocus");
            this._btnAutoFocus.Name = "_btnAutoFocus";
            this._btnAutoFocus.Click += new System.EventHandler(this.Event_btnAutoFocus_Click);
            //
            // _btnUseTargetFrameSectionRangeAsPlayRange
            //
            this._btnUseTargetFrameSectionRangeAsPlayRange.BackColor = System.Drawing.SystemColors.Control;
            this._btnUseTargetFrameSectionRangeAsPlayRange.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this._btnUseTargetFrameSectionRangeAsPlayRange.Image = global::LayoutEditor.Properties.Resources.AnimTag_PlayRange;
            resources.ApplyResources(this._btnUseTargetFrameSectionRangeAsPlayRange, "_btnUseTargetFrameSectionRangeAsPlayRange");
            this._btnUseTargetFrameSectionRangeAsPlayRange.Margin = new System.Windows.Forms.Padding(2, 1, 2, 2);
            this._btnUseTargetFrameSectionRangeAsPlayRange.Name = "_btnUseTargetFrameSectionRangeAsPlayRange";
            this._btnUseTargetFrameSectionRangeAsPlayRange.TextDirection = System.Windows.Forms.ToolStripTextDirection.Horizontal;
            this._btnUseTargetFrameSectionRangeAsPlayRange.Click += new System.EventHandler(this._btnUseTargetFrameSectionRangeAsPlayRange_Click);
            //
            // _btnAutoAdjustPlayRange
            //
            this._btnAutoAdjustPlayRange.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this._btnAutoAdjustPlayRange.Image = global::LayoutEditor.Properties.Resources.Icon_CalculateRange_Off;
            resources.ApplyResources(this._btnAutoAdjustPlayRange, "_btnAutoAdjustPlayRange");
            this._btnAutoAdjustPlayRange.Name = "_btnAutoAdjustPlayRange";
            this._btnAutoAdjustPlayRange.Click += new System.EventHandler(this.Event_btnAutoAdjustPlayRange_Click);
            //
            // toolStripSeparator4
            //
            this.toolStripSeparator4.Margin = new System.Windows.Forms.Padding(4, 0, 4, 0);
            this.toolStripSeparator4.Name = "toolStripSeparator4";
            resources.ApplyResources(this.toolStripSeparator4, "toolStripSeparator4");
            //
            // _tsbAddFrameOffset
            //
            this._tsbAddFrameOffset.BackColor = System.Drawing.SystemColors.Control;
            this._tsbAddFrameOffset.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbAddFrameOffset, "_tsbAddFrameOffset");
            this._tsbAddFrameOffset.Margin = new System.Windows.Forms.Padding(2, 1, 2, 2);
            this._tsbAddFrameOffset.Name = "_tsbAddFrameOffset";
            this._tsbAddFrameOffset.TextDirection = System.Windows.Forms.ToolStripTextDirection.Vertical270;
            this._tsbAddFrameOffset.Click += new System.EventHandler(this.Event_TsbAddFrameOffset_Click);
            //
            // _tsbFileExport
            //
            this._tsbFileExport.BackColor = System.Drawing.SystemColors.Control;
            this._tsbFileExport.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbFileExport, "_tsbFileExport");
            this._tsbFileExport.Margin = new System.Windows.Forms.Padding(2, 1, 2, 2);
            this._tsbFileExport.Name = "_tsbFileExport";
            this._tsbFileExport.Click += new System.EventHandler(this.Event_TsbFileExport_Click);
            //
            // _tsbFileImport
            //
            this._tsbFileImport.BackColor = System.Drawing.SystemColors.Control;
            this._tsbFileImport.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            resources.ApplyResources(this._tsbFileImport, "_tsbFileImport");
            this._tsbFileImport.Name = "_tsbFileImport";
            this._tsbFileImport.Click += new System.EventHandler(this.Event_TsbFileImport_Click);
            //
            // _erpMain
            //
            this._erpMain.ContainerControl = this;
            //
            // _chkOutRlps
            //
            resources.ApplyResources(this._chkOutRlps, "_chkOutRlps");
            this._chkOutRlps.Name = "_chkOutRlps";
            this._chkOutRlps.UseVisualStyleBackColor = true;
            //
            // AnimSectionTagWindow
            //
            resources.ApplyResources(this, "$this");
            this.Controls.Add(this._pnlFrameSection);
            this.Controls.Add(this._spfSettings);
            this.Controls.Add(this._flpAnimTag);
            this.Controls.Add(this._tspMain);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
            this.Name = "AnimSectionTagWindow";
            this.Deactivate += new System.EventHandler(this.AnimSectionTagWindow_Deactivate);
            this._pnlFrameSection.ResumeLayout(false);
            this._flpAnimTag.ResumeLayout(false);
            this._cpnAnimSectionBasic.Panel2.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this._cpnAnimSectionBasic)).EndInit();
            this._cpnAnimSectionBasic.ResumeLayout(false);
            this._grpFrameSection.ResumeLayout(false);
            this._cpnTargetGroup.Panel2.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this._cpnTargetGroup)).EndInit();
            this._cpnTargetGroup.ResumeLayout(false);
            this._grpTargetGroup.ResumeLayout(false);
            this._grpTargetGroup.PerformLayout();
            this._cpnBinaryExport.Panel2.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this._cpnBinaryExport)).EndInit();
            this._cpnBinaryExport.ResumeLayout(false);
            this._grpExportBinary.ResumeLayout(false);
            this._grpExportBinary.PerformLayout();
            this._grpLoopType.ResumeLayout(false);
            this._grpLoopType.PerformLayout();
            this._grpOutAnmType.ResumeLayout(false);
            this._grpOutAnmType.PerformLayout();
            this._cpnUserData.Panel2.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this._cpnUserData)).EndInit();
            this._cpnUserData.ResumeLayout(false);
            this._tspMain.ResumeLayout(false);
            this._tspMain.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this._erpMain)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion デザイナ生成コード

        #region フィールド
        const string _FileDlgFilterString = "animation frame tag (*.xml)|*.xml";
        const int _AnimTagNameListSubItemIdx = 1;

        /// <summary>
        /// サブシーン
        /// </summary>
        ISubScene _subScene = null;
        // 操作対象フレーム区間
        IAnimFrameSection _targetFrameSection = null;
        List<ListViewItem> _targetFrameSections = new List<ListViewItem>();

        TextBox _inplaceEditTextBox = new TextBox();

        /// <summary>
        /// アニメーション区間タグ編集クラス。
        /// </summary>
        AnimFrameSectionSetManipulator _animFrameSectionSetMnp = new AnimFrameSectionSetManipulator();

        /// <summary>
        /// アニメーション編集モード。
        /// </summary>
        bool _animEditSeparate = false;

        /// <summary>
        /// サブシーン編集クラス。
        /// </summary>
        SubSceneManipulator _subSceneMnp = new SubSceneManipulator();

        /// <summary>
        /// プログラムからUpdateが呼び出されたか。
        /// </summary>
        bool _isSystemCalledUpdate = false;

        /// <summary>
        /// 隠したペイン。
        /// </summary>
        HashSet<IPane> _hiddenPaneSet = null;

        #endregion フィールド

        #region プロパティ
        /// <summary>
        /// 操作対象フレーム範囲
        /// </summary>
        IAnimFrameSection _TargetFrameSection
        {
            get { return _targetFrameSection; }
            set
            {
                if( _targetFrameSection != value )
                {
                    _targetFrameSection = value;
                    UpdateToolStripButton_();
                    UpdateState_FrameSection_();
                    UpdateState_TargetGroup_();

                    _AnimFrameSectionSetMnp.SetTargetAnimFrameSection(_targetFrameSection);
                }
            }
        }

        /// <summary>
        /// 操作対象フレーム範囲(複数選択)
        /// </summary>
        List<ListViewItem> _TargetFrameSections
        {
            get { return _targetFrameSections; }
            set
            {
                if (_targetFrameSections != value)
                {
                    _targetFrameSections = value;
                }
            }
        }

        /// <summary>
        /// 複数選択中かどうか。
        /// </summary>
        bool IsMulti
        {
            get;
            set;
        }

        /// <summary>
        /// アニメーション区間タグ編集クラス。
        /// </summary>
        AnimFrameSectionSetManipulator _AnimFrameSectionSetMnp
        {
            get
            {
                _animFrameSectionSetMnp.BindTarget( _AnimFrameSectionSet );
                return _animFrameSectionSetMnp;
            }
        }

        /// サブシーン編集クラス。
        /// </summary>
        SubSceneManipulator _SubSceneMnp
        {
            get
            {
                _subSceneMnp.BindTarget(_ISubScene);
                return _subSceneMnp;
            }
        }

        /// <summary>
        /// 操作対象サブシーンを取得します。
        /// </summary>
        ISubScene _ISubScene
        {
            get { return _subScene; }
            set
            {
                if (_subScene != value)
                {
                    _TargetFrameSection = null;
                    _TargetFrameSections.Clear();
                    _subScene = value;
                }
            }
        }

        /// <summary>
        /// 操作対象フレーム範囲セットを取得します。
        /// </summary>
        IAnimFrameSectionSet _AnimFrameSectionSet
        {
            get { return _ISubScene.IAnimFrameSectionSet; }
        }

        /// <summary>
        /// フレーム範囲を編集可能か？
        /// </summary>
        bool _ReadyToModifyFrameSection
        {
            get { return _subScene != null && _TargetFrameSection != null; }
        }

        /// <summary>
        /// ペインが隠されているか
        /// </summary>
        bool _IsPaneHidden
        {
            get { return _hiddenPaneSet != null; }
        }

        /// <summary>
        /// 選択された区間を再生範囲とするか
        /// </summary>
        bool _UseTargetFrameSectionRangeAsPlayRange
        {
            get
            {
                if (_ISubScene.IsAnimEditSeparateMode())
                {
                    // ViewManager が設定される前にも呼ばれる
                    return ViewManager?.AppSetting?.UseTargetFrameSectionRangeAsPlayRangeForSeparateMode ?? false;
                }

                // ViewManager が設定される前にも呼ばれる
                return ViewManager?.AppSetting?.UseTargetFrameSectionRangeAsPlayRange ?? false;
            }
            set
            {
                if (_ISubScene.IsAnimEditSeparateMode())
                {
                    ViewManager.AppSetting.UseTargetFrameSectionRangeAsPlayRangeForSeparateMode = value;
                }
                else
                {
                    ViewManager.AppSetting.UseTargetFrameSectionRangeAsPlayRange = value;
                }
            }
        }

        /// <summary>
        /// ビューア転送時に再生範囲を自動的に調整するか
        /// </summary>
        bool _AutoAdjustPlayRange
        {
            get
            {
                // ViewManager が設定される前にも呼ばれる
                return ViewManager?.AppSetting?.AutoAdjustPlayRange ?? false;
            }
            set
            {
                ViewManager.AppSetting.AutoAdjustPlayRange = value;
            }
        }

        /// <summary>
        /// 関連グループの指定なしを許容するかどうか
        /// </summary>
        bool _AllowNoGroupAnimationTag
        {
            get
            {
                return ViewManager?.AppSetting?.ProjectSettings?.AllowNoGroupAnimationTag ?? false;
            }
        }

        /// <summary>
        /// アニメーション編集が分割モードか
        /// </summary>
        bool _IsAnimEditSeparate
        {
            get
            {
                return _animEditSeparate;
            }
        }

        #endregion プロパティ


        /// <summary>
        /// GUI関連のユーザ独自の初期化処理をおこないます。
        /// </summary>
        void InitializeProperty_()
        {
            _pnlAnimSectionBasic.OnChanged += new EventHandler( Event_PnlAnimSectionBasic_OnChanged );


            _cmhId.Text = StringResMgr.Get("LISTVIEW_ANMTAG_ID");
            _cmhName.Text = StringResMgr.Get( "LISTVIEW_ANMTAG_NAME" );
            _cmhStart.Text = StringResMgr.Get( "LISTVIEW_ANMTAG_STARTFRM" );
            _cmhEnd.Text = StringResMgr.Get( "LISTVIEW_ANMTAG_ENDFRM" );
            _cmhComment.Text = StringResMgr.Get("TAG_COMMENT");
            _cmhTargetGroup.Text = StringResMgr.Get( "LISTVIEW_ANMTAG_TARGETGROUP" );
            _cmhUserData.Text = StringResMgr.Get("LISTVIEW_ANMTAG_USERDATA");

            // 互換性を維持するためには、対象グループを指定しないようにしてください。
            //_capTargetGroup.ToolTipText = StringResMgr.Get( "ANIMTAG_COMPATIVILITY_TOOLTIP_GROUP" );

            _cpnAnimSectionBasic.TitleString = _grpFrameSection.Text;
            _cpnBinaryExport.TitleString = _grpExportBinary.Text;
            _cpnTargetGroup.TitleString = _grpTargetGroup.Text;
            _cpnUserData.TitleString = StringResMgr.Get("LISTVIEW_ANMTAG_USERDATA");

            _chkOutRlpa.Tag = ParamaterKind.Animation_PaneSRT;
            _chkOutRlvc.Tag = ParamaterKind.Animation_VertexColors;
            _chkOutRlvi.Tag = ParamaterKind.Animation_Visivility;
            _chkOutRlmc.Tag = ParamaterKind.Animation_MaterialColors | ParamaterKind.Animation_FontShadowColor;
            _chkOutRlAlphaTest.Tag = ParamaterKind.Animation_AlphaTest;
            _chkOutRltp.Tag = ParamaterKind.Animation_TexturePattern;
            _chkOutRlts.Tag = ParamaterKind.Animation_TextureSRT;
            _chkOutEvalTimeOffset.Tag = ParamaterKind.Animation_PerCharacterTransform;
            _chkOutRlWindow.Tag = ParamaterKind.Animation_Window;

            _chkOutRlIndirectTexture.Tag = ParamaterKind.Animation_IndirectTextureSRT;
            _chkOutRlIndirectTexture.Visible = LayoutEditorCore.PlatformDetail.IndirectTextureEnabled;
            _chkOutRlud.Tag = ParamaterKind.Animation_ExtUserData;
            _chkOutRlma.Tag = ParamaterKind.Animation_MaskTextureSRT;
            _chkOutRlds.Tag = ParamaterKind.Animation_DropShadow;
            _chkOutRlps.Tag = ParamaterKind.Animation_ProceduralShape;

            _radLoopTypeOneTime.Tag = AnimationLoopType.OneTime;
            _radLoopTypeLoop.Tag = AnimationLoopType.Loop;
            _radLoopTypeWait.Tag = AnimationLoopType.Wiat;

            _inplaceEditTextBox.Parent = _lvwFrameSectionSet.Parent;
            _lvwFrameSectionSet.SubItemBeginEditing += (obj, e) =>
                {
                    // アニメーション区間名だけ編集させる
                    if (e.SubItem == _AnimTagNameListSubItemIdx)
                    {
                        _lvwFrameSectionSet.StartEditing(_inplaceEditTextBox, e.Item, e.SubItem);
                    }
                };
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public AnimSectionTagWindow()
        {
            InitializeComponent();
            InitializeProperty_();
            UpdateProperty_();

            // メッセージフィルタの設定
            ToolStripMenuItemHelper.ToolStripMessageFilter.BindMessageFilter(_tspMain);
        }

        #region GUIの状態の更新
        #region リストビュー更新

        /// <summary>
        /// 複数行文字列を1行に変換します。
        /// </summary>
        string ConvertMultiLineStringToSingleLine_( string srcStr )
        {
            return srcStr.Replace( "\r\n", "--" );
        }

        /// <summary>
        /// 対象グループを表現する文字列を取得します。
        /// </summary>
        string GetTargetGroupSetString_( ILEGroup[] targetGroup )
        {
            StringBuilder sb = new StringBuilder();
            foreach( ILEGroup group in targetGroup )
            {
                sb.Append( group.GrouprName + ";" );
            }

            return sb.ToString();
        }

        string GetUserDataString_(IUserDataHolder userDataHolder)
        {
            return UserDataElementHelper.ToOneLineString(userDataHolder.UserDataElementSet);
        }

        /// <summary>
        /// リストビューにリストビュー項目を追加します。
        /// </summary>
        ListViewItem MakeNewListViewItem_(IAnimFrameSection fs, int idx)
        {
            ListViewItem newLvi = new ListViewItem(idx.ToString());

            newLvi.Tag = fs;
            newLvi.SubItems.Add("");
            newLvi.SubItems.Add("");
            newLvi.SubItems.Add("");
            newLvi.SubItems.Add("");
            newLvi.SubItems.Add("");
            newLvi.SubItems.Add("");

            UpdateListViewItem_(newLvi, fs, idx);

            return newLvi;
        }

        /// <summary>
        /// リストビュー項目を更新します。
        /// </summary>
        void UpdateListViewItem_(ListViewItem lvi, IAnimFrameSection fs, int idx)
        {
            Debug.Assert( lvi.Tag == fs );

            // ---------------- 各サブ項目について、更新を試みます。
            // Name
            int index = 0;
            if (lvi.SubItems[index].Text != idx.ToString())
            {
                lvi.SubItems[index].Text = idx.ToString();
            }

            // Name
            index++;
            if (lvi.SubItems[index].Text != fs.Name)
            {
                lvi.SubItems[index].Text = fs.Name;
            }

            // StartFrame
            index++;
            if (lvi.SubItems[index].Text != fs.StartFrame.ToString())
            {
                lvi.SubItems[index].Text = fs.StartFrame.ToString();
            }

            // EndFrame
            index++;
            if (lvi.SubItems[index].Text != fs.EndFrame.ToString())
            {
                lvi.SubItems[index].Text = fs.EndFrame.ToString();
            }

            // コメント
            index++;
            string commnet = ConvertMultiLineStringToSingleLine_( fs.Comment );
            if (lvi.SubItems[index].Text != commnet)
            {
                lvi.SubItems[index].Text = commnet;
            }

            // ターゲットグループ
            index++;
            string targetGroupStr = GetTargetGroupSetString_( fs.TargetGroup );
            if (lvi.SubItems[index].Text != targetGroupStr)
            {
                lvi.SubItems[index].Text = targetGroupStr;
            }

            index++;
            string userDataStr = GetUserDataString_(fs.UserDataHolder);
            if (lvi.SubItems[index].Text != userDataStr)
            {
                lvi.SubItems[index].Text = userDataStr;
            }

            lvi.ForeColor = (fs.IsReadOnlyLocked) ? LECore.AppConstants.InactiveForeColor : LECore.AppConstants.ActiveForeColor;
            lvi.BackColor = (fs.IsReadOnlyLocked) ? LECore.AppConstants.InactiveBackColor : LECore.AppConstants.ActiveBackColor;
        }

        /// <summary>
        /// ListViewItem の検索
        /// </summary>
        ListViewItem FindListViewItemFromTagValue_( IAnimFrameSection section )
        {
            foreach( ListViewItem lvi in _lvwFrameSectionSet.Items )
            {
                if( lvi.Tag == section )
                {
                    return lvi;
                }
            }
            return null;
        }

        /// <summary>
        /// リストビューを更新する。
        /// </summary>
        void UpdateListView_()
        {
            _lvwFrameSectionSet.BeginUpdate();

            var targetFrameSections = _TargetFrameSections.ToArray();

            int selectedIndex = _lvwFrameSectionSet.SelectedIndices.Count > 0 ? _lvwFrameSectionSet.SelectedIndices[0] : -1;
            if( _ISubScene != null )
            {
                List<ListViewItem> listViewItemSet = new List<ListViewItem>();
                IAnimFrameSection[] frameSectionSet = _AnimFrameSectionSet.IAnimFrameSectionSet.ToArray();


                // ------------------未使用リスト項目を消去します。
                List<ListViewItem> unusedItemSet = new List<ListViewItem>();
                foreach( ListViewItem vi in _lvwFrameSectionSet.Items )
                {
                    if( Array.IndexOf( frameSectionSet, vi.Tag ) == -1 )
                    {
                        unusedItemSet.Add( vi );
                    }
                }
                foreach( ListViewItem unused in unusedItemSet )
                {
                    // Remove対象のindexが選択状態の場合、SelectedIndexChangedイベントが呼び出されます
                    _lvwFrameSectionSet.Items.Remove( unused );
                }

                // ------------------対象シーンの全ての範囲について
                int count = 0;
                foreach( IAnimFrameSection fs in frameSectionSet )
                {
                    // リストに含まれなければ、新規登録する。
                    ListViewItem lvi = FindListViewItemFromTagValue_( fs );
                    if( lvi == null )
                    {
                        lvi = MakeNewListViewItem_(fs, count);
                    }
                    else
                    {
                        // ふくまれれば、同一内容か確認し、同一でなければ変更する。
                        UpdateListViewItem_(lvi, fs, count);
                    }
                    listViewItemSet.Add( lvi );
                    count++;
                }

                // 登録順に再整列します。
                DisableInvokeIndexChanged();
                _lvwFrameSectionSet.Items.Clear();
                foreach( ListViewItem item in listViewItemSet )
                {
                    item.Selected = ( item.Tag == _TargetFrameSection );
                    // Add対象のindexが選択状態の場合、SelectedIndexChangedイベントが呼び出されてしまうため、
                    // DisableInvokeIndexChangedで通知を無効にします
                    _lvwFrameSectionSet.Items.Add( item );
                }
                EnableInvokeIndexChanged();
            }
            else
            {
                // 要素をすべて消去します。
                _lvwFrameSectionSet.Items.Clear();
            }

            // 選択の復元
            DisableInvokeIndexChanged();
            foreach (ListViewItem item in targetFrameSections)
            {
                // SelectedIndexChangedイベントが呼び出されてしまうため、
                // DisableInvokeIndexChangedで通知を無効にします
                item.Selected = true;
            }
            EnableInvokeIndexChanged();

            _lvwFrameSectionSet.EndUpdate();
        }

        /// <summary>
        /// 選択インデックスの変更通知を有効にします。
        /// </summary>
        private void EnableInvokeIndexChanged()
        {
            _isSystemCalledUpdate = false;
        }

        /// <summary>
        /// 選択インデックスの変更通知を無効にします。
        /// </summary>
        private void DisableInvokeIndexChanged()
        {
            _isSystemCalledUpdate = true;
        }

        #endregion リストビュー更新

        /// <summary>
        /// 出力アニメーション種類チェックボックスを更新します。
        /// </summary>
        void UpdateOutAnimKindCheckBox_( UICheckBox cb )
        {
            ParamaterKind targetAnimKind = _TargetFrameSection.BinarySettings.TargetAnimKind;
            ParamaterKind cbKind = (ParamaterKind)cb.Tag;

            cb.SetChecked((targetAnimKind & cbKind) != 0);
        }

        /// <summary>
        /// _targetFrameSection のGUI表示内容を更新します。
        /// </summary>
        void UpdateState_FrameSection_()
        {
            if( _TargetFrameSection != null )
            {
                bool isEditable = !_TargetFrameSection.IsReadOnlyLocked;

                _grpFrameSection.Enabled = isEditable;
                _grpExportBinary.Enabled = isEditable;
                _grpTargetGroup.Enabled = isEditable;
                _pnlUserData.Enabled = isEditable;

                _pnlAnimSectionBasic.Target = _TargetFrameSection;

                _chkOutBinaryActive.Checked = _TargetFrameSection.BinarySettings.Active;

                _radLoopTypeOneTime.SetCheckedByTag( _TargetFrameSection.BinarySettings.LoopType );
                _radLoopTypeLoop.SetCheckedByTag( _TargetFrameSection.BinarySettings.LoopType );
                _radLoopTypeWait.SetCheckedByTag(_TargetFrameSection.BinarySettings.LoopType);

                _pnlAnimSectionBasic.UpdataProperty();

                IEnumerable<ExUserDataPreset> presets = ViewManager != null ? ViewManager.AppSetting.ProjectSettings.ExUserDataPresets : new List<ExUserDataPreset>();
                _pnlUserData.Initialize(_TargetFrameSection.UserDataHolder, false, false, false, presets, (preset) => preset.IsTargetAnimTag());
                _pnlUserData.UpdateProperty();

                // アニメーションチェック状態
                UpdateOutAnimKindCheckBox_(_chkOutRlpa);
                UpdateOutAnimKindCheckBox_(_chkOutRlvc);
                UpdateOutAnimKindCheckBox_(_chkOutRlvi);
                UpdateOutAnimKindCheckBox_(_chkOutRlmc);
                UpdateOutAnimKindCheckBox_(_chkOutRltp);
                UpdateOutAnimKindCheckBox_(_chkOutRlts);
                UpdateOutAnimKindCheckBox_(_chkOutRlAlphaTest);
                UpdateOutAnimKindCheckBox_(_chkOutRlts);
                UpdateOutAnimKindCheckBox_(_chkOutEvalTimeOffset);
                UpdateOutAnimKindCheckBox_(_chkOutRlWindow);
                UpdateOutAnimKindCheckBox_(_chkOutRlIndirectTexture);
                UpdateOutAnimKindCheckBox_(_chkOutRlud);
                UpdateOutAnimKindCheckBox_(_chkOutRlma);
                UpdateOutAnimKindCheckBox_(_chkOutRlds);
                UpdateOutAnimKindCheckBox_(_chkOutRlps);
            }
            else
            {
                _grpFrameSection.Enabled = false;
                _grpExportBinary.Enabled = false;
                _grpTargetGroup.Enabled = false;
                _pnlUserData.Enabled = false;
            }

            _btnSetTargetGroup.BackColor = GetMultiEditColor();
            _btnSetTargetGroup.UseVisualStyleBackColor = !IsMulti;
        }

        /// <summary>
        /// 対象グループセットGUI表示内容を更新します。
        /// </summary>
        void UpdateState_TargetGroup_(bool bHiddenCheck = true)
        {
            bool error = false;
            if (_TargetFrameSection != null)
            {
                string newText = GetTargetGroupSetString_(_TargetFrameSection.TargetGroup);
                if (_tbxGroup.Text != newText)
                {
                    _tbxGroup.Text = newText;
                }

                var paneSet = _subScene.FindPanesByKeyFrame(_TargetFrameSection.StartFrame, _TargetFrameSection.EndFrame, _TargetFrameSection.Name);
                if (paneSet.Count() > 0)
                {
                    _tbxGroup.Text += "\r\n\r\n" + StringResMgr.Get("ANIMTAG_PANE_LIST") + "\r\n";
                }
                foreach (IPane pane in paneSet)
                {
                    _tbxGroup.Text += pane.PaneName + ";";
                }

                if (_chkBindAnimationRecursively.Checked != _TargetFrameSection.BindAnimationRecursively)
                {
                    _chkBindAnimationRecursively.Checked = _TargetFrameSection.BindAnimationRecursively;
                }

                // 関連グループが設定されていない場合
                if(!_AllowNoGroupAnimationTag && !_TargetFrameSection.TargetGroup.Any())
                {
                    error = true;
                    _erpMain.SetError(_tbxGroup, StringResMgr.Get("ERROR_NOGROUP"));
                }
            }

            if (!error)
            {
                _erpMain.SetError(_tbxGroup, string.Empty);
            }

            // 隠されたペインがあれば、表示状態にもどします。
            if( bHiddenCheck && _IsPaneHidden )
            {
                Event_BtnHideOtherPane_Click( null, null );
            }
        }

        /// <summary>
        /// 上下ボタンの状態を更新します。
        /// </summary>
        void UpdateUpDownButton_()
        {
            // 移動可能な対処を一つだけ選択していなければ無効
            if (_lvwFrameSectionSet.SelectedIndices.Count != 1 ||
                _TargetFrameSection == null ||
                _TargetFrameSection.IsReadOnlyLocked)
            {
                _btnUp2.Enabled = false;
                _btnDown2.Enabled = false;
                return;
            }

            // 番号が昇順でソートされていなければ無効
            {
                if (_lvwFrameSectionSet.SortedColumnIndex != 0 || _lvwFrameSectionSet.SortedColumnAscent)
                {
                    _lblUpDownNotice.Visible = true;
                    _btnUp2.Enabled = false;
                    _btnDown2.Enabled = false;
                    return;
                }
                _lblUpDownNotice.Visible = false;
            }

            int index = _lvwFrameSectionSet.SelectedIndices[0];
            _btnUp2.Enabled = index > 0;
            _btnDown2.Enabled = index + 1 < _lvwFrameSectionSet.Items.Count;

            // 前後がReadOnlyだった場合の対処
            {
                int prevIndex = index - 1;
                if (prevIndex >= 0)
                {
                    var prevSection = _lvwFrameSectionSet.Items[prevIndex].Tag as IAnimFrameSection;
                    if (prevSection.IsReadOnlyLocked)
                    {
                        _btnUp2.Enabled = false;
                    }
                }

                int newxtIndex = index + 1;
                if (newxtIndex < _lvwFrameSectionSet.Items.Count - 1)
                {
                    var nextSection = _lvwFrameSectionSet.Items[newxtIndex].Tag as IAnimFrameSection;
                    if (nextSection.IsReadOnlyLocked)
                    {
                        _btnDown2.Enabled = false;
                    }
                }
            }
        }

        /// <summary>
        /// ツールストリップの状態を更新します。
        /// </summary>
        void UpdateToolStripButton_()
        {
            {
                bool bValid = false;
                if (_subScene != null && _ISubScene.IAnimFrameSectionSet != null)
                {
                    bValid = _AnimFrameSectionSet.IAnimFrameSectionSet.Count() != 0;
                }
                _tsbAddFrameOffset.Enabled = bValid;
            }

            {
                bool isSelected = _TargetFrameSections.Count > 0;
                _btnCloneSelected.Enabled = isSelected;
                _btnRemove2.Enabled = isSelected;
            }

            {
                _btnUseTargetFrameSectionRangeAsPlayRange.Checked = _UseTargetFrameSectionRangeAsPlayRange;
                _btnAutoAdjustPlayRange.Image = _AutoAdjustPlayRange ? Properties.Resources.Icon_CalculateRange_On : Properties.Resources.Icon_CalculateRange_Off;
                _btnAutoFocus.Enabled = _targetFrameSections.Count == 1;
            }
        }

        /// <summary>
        /// GUIを更新します。
        /// SceneModifyEventArgs.Kind.CurrentSubSceneChanged のタイミングで 実行されます。
        /// </summary>
        void UpdateProperty_()
        {
            LEToolWindow.DbgReportUpdate( this );

            bool bEnable = _ISubScene != null;

            _pnlFrameSection.Enabled = bEnable ;
            _btnAdd2.Enabled = bEnable;
            _btnUseTargetFrameSectionRangeAsPlayRange.Enabled = bEnable;
            _btnAutoAdjustPlayRange.Visible = _ISubScene.IsAnimEditSeparateMode();
            _btnAutoFocus.Visible = _ISubScene.IsAnimEditSeparateMode();
            _tsbFileExport.Enabled = bEnable;
            _tsbFileImport.Enabled = bEnable;

            UpdateListView_();
            UpdateState_FrameSection_();
            UpdateState_TargetGroup_();
            UpdateUpDownButton_();
            UpdateToolStripButton_();
            UpdateAnimModeButton_();

            _pnlAnimSectionBasic.UpdateFrameEditBox();
        }

        void UpdateAnimModeButton_()
        {
            bool bEnable = (_ISubScene != null) &&
                !(_ISubScene.IAnimFrameSectionSet as IAnimFrameSectionSet).ModeReadOnly;
            _tsbAnimEditMode.Enabled = bEnable;

            if (_ISubScene.IsAnimEditSeparateMode())
            {
                this._tsbAnimEditMode.Image = Properties.Resources.Animation_SplitMode;
                _tsbAnimEditMode.ToolTipText = StringResMgr.Get("LISTVIEW_TOOLTIP_ANMCONV_MULTI");
            }
            else
            {
                this._tsbAnimEditMode.Image = Properties.Resources.Animation_CombiningMode;
                _tsbAnimEditMode.ToolTipText = StringResMgr.Get("LISTVIEW_TOOLTIP_ANMCONV_SINGLE");
            }
        }

        #endregion GUIの状態の更新

        #region ILEToolWindow メンバ

        /// <summary>
        /// シーン更新イベントハンドラ
        /// </summary>
        public override void OnSceneModifyHandler(
            object sender,
            CoreData.SceneModifyEventArgs e )
        {
            switch (e.Target)
            {
                case SceneModifyEventArgs.Kind.GroupRemove:
                    // グループが削除された
                    UpdateState_TargetGroup_();
                    break;
                case SceneModifyEventArgs.Kind.AnimSectionTagSet:
                    // アニメーション区間タグセットの更新
                    UpdateProperty_();
                    break;
                case SceneModifyEventArgs.Kind.CurrentSubSceneChanged:
                    // カレントサブシーンの更新
                    // 親子階層ビューの更新
                    // サブシーン固有のデータを表示しているViewは更新する必要があります。
                    _ISubScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;

                    UpdateProperty_();
                    break;
                case SceneModifyEventArgs.Kind.PaneModify:
                case SceneModifyEventArgs.Kind.PaneAnimModify:
                    // ペインアニメーションが変更された
                    UpdateState_TargetGroup_(false);
                    break;
                case SceneModifyEventArgs.Kind.PaneAnimModeModify:
                    this.UpdateAnimModeButton_();
                    break;

                default:
                    // 何も反応しません。
                    break;
            }
            base.OnSceneModifyHandler( sender, e );
        }

        /// <summary>
        /// 設定書き出し
        /// </summary>
        public sealed override void SaveSetting(LEToolFormSetting setting, SaveSettingOption option)
        {
            // リスト行の幅の書き出し
            setting.SaveColumnPotisionSettings(_lvwFrameSectionSet);
            base.SaveSetting(setting, option);
        }

        /// <summary>
        /// 設定読み込み
        /// </summary>
        public sealed override void LoadSetting(LEToolFormSetting setting , LoadSettingOption option)
        {
            // リスト行の幅の読み込み
            setting.LoadColumnPotisionSettings(_lvwFrameSectionSet);
            base.LoadSetting(setting , option);
        }

        public override Keys CustomShortcut { get { return Keys.F12; } }

        #endregion ILEToolWindow メンバ



        #region GUI イベントハンドラ
        #region ツールストリップ関連
        /// <summary>
        /// ファイルに出力します。
        /// </summary>
        private void Event_TsbFileExport_Click( object sender, EventArgs e )
        {
            SaveFileDialog fdlg = new SaveFileDialog();
            fdlg.Filter = _FileDlgFilterString;

            // 出力対象を選んでもらう。
            SelectFromListDlg selectTag = new SelectFromListDlg();
            selectTag.Text = StringResMgr.Get("DLG_TITLE_SELECT_ANIMTAG");
            selectTag.Setup<IAnimFrameSection>(
                _AnimFrameSectionSet.IAnimFrameSectionSet,
                (animSect) => true,
                (animSect) =>
                {
                    var item = new ListViewItem(animSect.Name);
                    item.Tag = animSect;
                    return item;
                });

            if (selectTag.ShowDialog() != DialogResult.OK)
            {
                return;
            }

            if( fdlg.ShowDialog() == DialogResult.OK )
            {
                RlanConverter rlanConverter = new RlanConverter( LECore.LayoutEditorCore.MsgReporter );
                IAnimFrameSection[] exportTargets = selectTag.GetSelectedSet<IAnimFrameSection>();
                FileFmt.AnimTag[] animTagSet = rlanConverter.SetTagDataToFileFmt(exportTargets);

                StreamWriter writer = null;
                XmlSerializer xmlSerializer = null;
                try
                {
                    xmlSerializer = XmlSerializerCache.GetXmlSerializer(typeof(FileFmt.AnimTag[]));
                    writer = new StreamWriter( fdlg.FileName, false );
                    xmlSerializer.Serialize( writer, animTagSet );
                }
                catch( Exception ex )
                {
                    if( ex is UnauthorizedAccessException )
                    {
                        MessageBox.Show( StringResMgr.Get( "ANIMTAG_ERROR_FILEIO" ) );
                    }
                }
                finally
                {
                    if( writer != null )
                    {
                        writer.Close();
                    }
                }
            }
        }

        /// <summary>
        /// 新しいタグを作る
        /// </summary>
        private IAnimFrameSection CreateNewAnimTag_(string name, string comment, int startFrame, int endFrame, ISubScene target)
        {
            return _AnimFrameSectionSetMnp.AddNewFrameSection(name, comment, startFrame, endFrame, target);
        }

        /// <summary>
        /// 新しいタグを登録する。
        /// </summary>
        private void RegisterNewAnimTag_(IAnimFrameSection frameSection, ILEGroup[] groups, bool descendingBind)
        {
            _AnimFrameSectionSetMnp.SetTagTargetGroup(frameSection, groups, descendingBind);
        }

        /// <summary>
        /// 新しいセクションをアトリビュートに追加する。
        /// </summary>
        private void CreateNewSection_(string animTagName)
        {
            _SubSceneMnp.AddAnimSection(animTagName);
        }

        /// <summary>
        /// ファイル入力します。
        /// </summary>
        private void Event_TsbFileImport_Click(object sender, EventArgs e)
        {
            OpenFileDialog fdlg = new OpenFileDialog();
            fdlg.Filter = _FileDlgFilterString;
            if (fdlg.ShowDialog() != DialogResult.OK)
            {
                return;
            }

            try
            {
                RlanConverter rlanConverter = new RlanConverter(LECore.LayoutEditorCore.MsgReporter);
                XmlSerializer serializer = XmlSerializerCache.GetXmlSerializer(typeof(FileFmt.AnimTag[]));

                using (FileStream fs = new FileStream(fdlg.FileName, FileMode.Open, FileAccess.Read))
                {
                    FileFmt.AnimTag[] animTagSet = XmlSerializerCache.Deserialize(serializer, fs) as FileFmt.AnimTag[];
                    List<string> errorTagMessage = new List<string>();

                    // 分割モードの場合、開始時間が0以外の区間タグを含むxmlをインポートできません
                    if (_ISubScene.IsAnimEditSeparateMode())
                    {
                        foreach (FileFmt.AnimTag animTag in animTagSet)
                        {
                            if (animTag.startFrame != 0)
                            {
                                MessageBox.Show(StringResMgr.Get("ANIMTAG_ERROR_FILEIO_SEPARATEMODE"));
                                return;
                            }
                        }
                    }

                    rlanConverter.AddFrameSection(_ISubScene, animTagSet, errorTagMessage, CreateNewAnimTag_, RegisterNewAnimTag_, CreateNewSection_);
                    if (errorTagMessage.Count > 0)
                    {
                        StringBuilder sb = new StringBuilder();
                        foreach (string line in errorTagMessage)
                        {
                            sb = sb.Append(line);
                        }
                        MessageBox.Show(StringResMgr.Get("ANIMTAG_WARNING_FILEIMPORT", sb.ToString()));
                    }
                }
            }
            catch
            {
                MessageBox.Show(StringResMgr.Get("ANIMTAG_ERROR_FILEIO"));
            }
        }

        /// <summary>
        /// アニメーション編集モードを切り替えます。
        /// </summary>
        private void Event_TsbAnimationEditMode_Click(object sender, EventArgs e)
        {
            // 警告を表示する
            string msg;
            if (_ISubScene.IsAnimEditSeparateMode())
            {
                msg = StringResMgr.Get("ANIMTAG_PUSH_MULTI_TEXT");
            }
            else
            {
                msg = StringResMgr.Get("ANIMTAG_PUSH_SINGLE_TEXT");
            }

            LayoutEditorMessageArgs args = new LayoutEditorMessageArgs()
            {
                title = StringResMgr.Get("TAG_WARNING"),
                msg = msg,
                messageType = MessageReportDlg.MessageTypes.AnimConvert,
                chkIgnoreSimilarMessageEnabled = true,
                buttonType = MessageReportDlg.ButtonTypes.OkCancel
            };
            LayoutEditorCore.MsgReporter.ReportError(this, args);

            if (args.dialogResult == DialogResult.OK)
            {
                _subSceneMnp.BindTarget(_ISubScene);

                // ウェイトダイアログを表示
                Cursor.Current = System.Windows.Forms.Cursors.WaitCursor;
                MessageReportDlg　reportDlg = new MessageReportDlg(MessageReportDlg.ButtonTypes.None, false);
                reportDlg.Title = StringResMgr.Get("ANIMTAG_CHANGEDLG_TITLE");
                reportDlg.Message = StringResMgr.Get("ANIMTAG_CHANGEDLG_MESSAGE");
                reportDlg.MessageTabStop = false; // ダイアログのRefresh時にメッセージが選択状態になる現象を抑制します
                reportDlg.Show();
                reportDlg.Refresh(); // ダイアログが正しく表示されないため、DoEventsを呼び出します

                var timer = Stopwatch.StartNew();

                // アニメーションの変換を行ないます
                _subSceneMnp.AnmConvert();

                do
                {
                    // 最低でも2秒間ダイアログを表示する
                    if (timer.ElapsedMilliseconds > 2000)
                    {
                        timer.Stop();
                        Cursor.Current = System.Windows.Forms.Cursors.Default;
                        break;
                    }
                } while (true);

                // ウェイトダイアログを閉じる
                reportDlg.Close();

                // 区間タグパネルを更新
                _pnlAnimSectionBasic.UpdateFrameEditBox();

                // 再生範囲の自動設定
                SetUseTargetFrameSectionRangeAsPlayRange_();
                SetAutoAdjustPlayRange_();
                UpdateProperty_();
            }
        }

        /// <summary>
        /// オフセットを加算する
        /// </summary>
        private void Event_TsbAddFrameOffset_Click( object sender, EventArgs e )
        {
            AnimSectionEditDlg animSectionEditDlg = new AnimSectionEditDlg();
            animSectionEditDlg.IAnimFrameSectionSet = _ISubScene.IAnimFrameSectionSet;
            animSectionEditDlg.ChkAddFrameOffsetEnable = !_ISubScene.IsAnimEditSeparateMode();

            DialogResult result = animSectionEditDlg.ShowDialog( this );

            if( result == DialogResult.OK )
            {
                // 設定して、GUI更新
                UpdateProperty_();
            }
        }
        #endregion ツールストリップ関連

        /// <summary>
        /// 追加ボタン
        /// </summary>
        private void Event_BtnAdd_Click( object sender, EventArgs e )
        {
            AnimSectionAddDlg addDlg = new AnimSectionAddDlg( _AnimFrameSectionSet );
            addDlg.AnimSectionBasicPanel.DialogDispMode = _ISubScene.IsAnimEditSeparateMode();

            if ( addDlg.ShowDialog( this ) == WinForm.DialogResult.OK )
            {
                AnimSectionBasicPanel pnlSection = addDlg.AnimSectionBasicPanel;
                string name = pnlSection.TragetName;
                string comment = pnlSection.Comment;
                int startFrame = pnlSection.StartFrame;
                int endFrame = pnlSection.EndFrame;

                _ISubScene.BeginMassiveModify();

                IAnimFrameSection fs = _AnimFrameSectionSetMnp.AddNewFrameSection(
                    name,
                    comment,
                    startFrame,
                    endFrame,
                    _ISubScene);

                if( fs != null )
                {
                    bool result = _AnimFrameSectionSetMnp.SetOutBinayFileName( fs, name );

                    //------------------------------------
                    // 現在利用しているループタイプがワンタイムのほうが多ければ、ワンタイムにします。
                    int oneTimeTypeCount = 0;
                    foreach( IAnimFrameSection section in _AnimFrameSectionSet.IAnimFrameSectionSet )
                    {
                        if( section.BinarySettings.LoopType == AnimationLoopType.OneTime )
                        {
                            oneTimeTypeCount++;
                        }
                    }

                    if( oneTimeTypeCount > _AnimFrameSectionSet.IAnimFrameSectionSet.Count() / 2 )
                    {
                        _AnimFrameSectionSetMnp.SetOutBinayLoopType( fs, AnimationLoopType.OneTime );
                    }
                }

                _ISubScene.EndMassiveModify();
            }
        }

        /// <summary>
        /// 削除ボタン
        /// </summary>
        private void Event_BtnRemove_Click( object sender, EventArgs e )
        {
            if(_TargetFrameSections.Count > 0 )
            {
                if( _ISubScene != null )
                {
                    _ISubScene.BeginMassiveModify();
                    foreach ( ListViewItem lvi in _TargetFrameSections)
                    {
                        IAnimFrameSection frameSection = lvi.Tag as IAnimFrameSection;
                        _AnimFrameSectionSetMnp.Remove( frameSection, _ISubScene);
                    }

                    _ISubScene.EndMassiveModify();
                }
            }
        }

        /// <summary>
        /// 選択を複製ボタン
        /// </summary>
        private void Event_btnCloneSelected_Click(object sender, EventArgs e)
        {
            if (_TargetFrameSections.Count > 0)
            {
                _ISubScene.BeginMassiveModify();

                IAnimFrameSection srcFs = _TargetFrameSections[0].Tag as IAnimFrameSection;
                IAnimFrameSection newFs = _AnimFrameSectionSetMnp.AddNewFrameSection(
                    _AnimFrameSectionSet.GetUniqueFrameSectionName(srcFs.Name),
                    srcFs.Comment,
                    srcFs.StartFrame,
                    srcFs.EndFrame,
                    _ISubScene);

                if (newFs != null)
                {
                    _AnimFrameSectionSetMnp.SetOutBinayFileName(newFs, newFs.Name);
                    _AnimFrameSectionSetMnp.SetTagTargetGroup(newFs, srcFs.TargetGroup, srcFs.BindAnimationRecursively);
                    _AnimFrameSectionSetMnp.SetOutBinayParamaterKind(newFs, srcFs.BinarySettings.TargetAnimKind);
                    _AnimFrameSectionSetMnp.SetOutBinayLoopType(newFs, srcFs.BinarySettings.LoopType);
                    _AnimFrameSectionSetMnp.SetUserData(newFs, srcFs.UserDataHolder);
                }

                _ISubScene.EndMassiveModify();
            }
        }

        /// <summary>
        /// 上に移動ボタン
        /// </summary>
        private void Event_BtnUp_Click( object sender, EventArgs e )
        {
            Debug.Assert( _lvwFrameSectionSet.SelectedIndices.Count == 1 );

            ListViewItem lvi = _TargetFrameSections[0];
            int idx = _lvwFrameSectionSet.SelectedIndices[0];

            bool bSucccess = _AnimFrameSectionSetMnp.SetTagIndex( lvi.Tag as IAnimFrameSection, idx - 1 );
            Debug.Assert( bSucccess );

            UpdateProperty_();

            lvi.Selected = true;
        }

        /// <summary>
        /// 下に移動ボタン
        /// </summary>
        private void Event_BtnDown_Click( object sender, EventArgs e )
        {
            Debug.Assert( _lvwFrameSectionSet.SelectedIndices.Count == 1 );

            ListViewItem lvi = _TargetFrameSections[0];
            int idx = _lvwFrameSectionSet.SelectedIndices[0];

            bool bSucccess = _AnimFrameSectionSetMnp.SetTagIndex( lvi.Tag as IAnimFrameSection, idx + 2 );
            Debug.Assert( bSucccess );

            UpdateProperty_();

            lvi.Selected = true;
        }

        /// <summary>
        /// リストビュー、ラベル編集
        /// </summary>
        private void Event_LvwFrameSectionSet_AfterLabelEdit( object sender, LabelEditEventArgs e )
        {
            // 実はよばれない？
            Debug.Assert(false);

            if( AnimFrameSectionSetHelper.CheckFrameSectionNameValid( e.Label ) &&
                !_AnimFrameSectionSet.CheckExistsByName( e.Label ) &&
                !_AnimFrameSectionSet.CheckExistsByOutputBinaryName( e.Label ) )
            {
                // 有効なら設定
                bool bResult = _AnimFrameSectionSetMnp.SetTagBasic(
                    _TargetFrameSection,
                    e.Label,
                    _TargetFrameSection.Comment,
                    _TargetFrameSection.StartFrame,
                    _TargetFrameSection.EndFrame );

                Debug.Assert( bResult );
            }
            else
            {
                e.CancelEdit = true;
            }
        }

        /// <summary>
        /// 選択インデックス変更
        /// </summary>
        private void Event_LvwFrameSectionSet_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (_isSystemCalledUpdate) return;

            // 複数選択を行なった場合IndexChangedが複数回呼び出される場合があり、
            // ListViewの選択の確定を待つために、BeginInvokeで遅延処理します
            BeginInvoke((Action)(() =>
            {
                if (_lvwFrameSectionSet.SelectedItems.Count > 0)
                {
                    if (_TargetFrameSection == ((_lvwFrameSectionSet.FocusedItem ?? _lvwFrameSectionSet.SelectedItems[0]).Tag as IAnimFrameSection) &&
                        _TargetFrameSections.SequenceEqual(_lvwFrameSectionSet.SelectedItems.OfType<ListViewItem>()))
                    {
                        return;
                    }

                    // 複数選択用リストを作成
                    List<ListViewItem> items = new List<ListViewItem>();
                    foreach (ListViewItem item in _lvwFrameSectionSet.SelectedItems)
                    {
                        items.Add(item);
                    }
                    _TargetFrameSections = items;
                    IsMulti = _lvwFrameSectionSet.SelectedItems.Count >= 2 ? true : false;

                    // リスト項目から、参照を取得
                    // 参照を現在の操作対象に設定。
                    IAnimFrameSection frameSection =
                        (_lvwFrameSectionSet.FocusedItem ?? _lvwFrameSectionSet.SelectedItems[0]).Tag as IAnimFrameSection;
                    if (!_lvwFrameSectionSet.SelectedItems.Contains(_lvwFrameSectionSet.FocusedItem))
                    {
                        frameSection = _lvwFrameSectionSet.SelectedItems[0].Tag as IAnimFrameSection;
                    }
                    _TargetFrameSection = frameSection;
                }
                else
                {
                    if (_TargetFrameSection == null &&
                        _TargetFrameSections.Count() <= 0)
                    {
                        return;
                    }

                    // 完全な選択解除なので、編集対象を空に設定。
                    _TargetFrameSection = null;
                    _TargetFrameSections.Clear();
                    IsMulti = false;
                }

                // 分割モードの場合
                if (_ISubScene.IsAnimEditSeparateMode())
                {
                    // ペイン情報貼り付け制御の更新を行う
                    var arg = new ViewManagerMessage(ViewManagerMessageKind.UpdatePanePasteControlWindow);
                    DoSendMessageToViewManager(arg);
                }

                UpdateUpDownButton_();
                UpdateToolStripButton_();
                UpdateState_FrameSection_();
            }));
        }

        /// <summary>
        /// アニメーション範囲パネル更新イベントハンドラ
        /// </summary>
        void Event_PnlAnimSectionBasic_OnChanged( object sender, EventArgs e )
        {
            if( _ReadyToModifyFrameSection )
            {
                int oldEndFrame = _TargetFrameSection.EndFrame;
                string oldTagName = _TargetFrameSection.Name;
                string inputTagName = _pnlAnimSectionBasic.TragetName;
                if (_TargetFrameSection.Name != inputTagName)
                {
                    inputTagName = _AnimFrameSectionSet.GetUniqueFrameSectionName(inputTagName);
                }

                _ISubScene.BeginMassiveModify();

                bool bResult = _AnimFrameSectionSetMnp.SetTagBasic(
                    _TargetFrameSection,
                    inputTagName,
                    _pnlAnimSectionBasic.Comment,
                    _pnlAnimSectionBasic.StartFrame,
                    _pnlAnimSectionBasic.EndFrame);

                // 更新できなければ元に戻します。
                if( !bResult )
                {
                    _pnlAnimSectionBasic.UpdataProperty();
                }
                else
                {
                    // 更新できた場合はカーブが保持するタグ名の変更を試みます
                    _subSceneMnp.BindTarget(_ISubScene);
                    _subSceneMnp.ModifyTagName(oldTagName, inputTagName);

                    // 区間幅の変更があった場合、スケールを調整します
                    if (oldEndFrame != _TargetFrameSection.EndFrame)
                    {
                        if (_pnlAnimSectionBasic.ScaleLink == AnimSectionBasicPanel.ScaleType.Scale_Float)
                        {
                            _subSceneMnp.AdjustAnimCurveFloat(inputTagName, (float)_TargetFrameSection.EndFrame / (float)oldEndFrame);
                        }
                        else if (_pnlAnimSectionBasic.ScaleLink == AnimSectionBasicPanel.ScaleType.Scale_Int)
                        {
                            _subSceneMnp.AdjustAnimCurveInt(inputTagName, (float)_TargetFrameSection.EndFrame / (float)oldEndFrame);
                        }
                    }
                }

                _ISubScene.EndMassiveModify();
            }
        }



        /// <summary>
        /// チェックボックス更新ハンドラ
        /// </summary>
        private void Event_ChkOutRlXX_CheckedChanged( object sender, EventArgs e )
        {
            if( _ReadyToModifyFrameSection )
            {
                CheckBox cb = sender as CheckBox;
                ParamaterKind mask = (ParamaterKind)cb.Tag;
                ParamaterKind flag = cb.Checked ? mask : ParamaterKind.None;
                ParamaterKind currentFlag = _TargetFrameSection.BinarySettings.TargetAnimKind;

                currentFlag = ( currentFlag & ~mask ) | flag;

                // _AnimFrameSectionSet.SetOutBinayParamaterKind( _TargetFrameSection, currentFlag );
                _AnimFrameSectionSetMnp.SetOutBinayParamaterKind( _TargetFrameSection, currentFlag );
            }
        }

        /// <summary>
        /// バイナリファイル名ハンドラ
        /// </summary>
        private void Event_TbxBinName_TextChanged( object sender, EventArgs e )
        {
            if( _ReadyToModifyFrameSection )
            {
                TextBox tbx = sender as TextBox;
                // bool result = _AnimFrameSectionSet.SetOutBinayFileName( _TargetFrameSection, tbx.Text );
                bool result = _AnimFrameSectionSetMnp.SetOutBinayFileName( _TargetFrameSection, tbx.Text );


                // 設定に失敗した場合は、内容を戻します。
                if( !result )
                {
                    tbx.Text = _TargetFrameSection.BinarySettings.FileName;
                }
            }
        }

        /// <summary>
        /// バイナリ出力チェックハンドラ
        /// </summary>
        private void Event_ChkOutBinaryActive_CheckedChanged( object sender, EventArgs e )
        {
            if( _ReadyToModifyFrameSection )
            {
                CheckBox cb = sender as CheckBox;
                bool result = _AnimFrameSectionSetMnp.SetOutBinayActive( _TargetFrameSection, cb.Checked );
            }
        }

        /// <summary>
        /// ループ種類
        /// </summary>
        private void Event_RadLoopType_CheckedChanged( object sender, EventArgs e )
        {
            if( _ReadyToModifyFrameSection )
            {
                LayoutEditor.Controls.UIRadioButton rb = sender as LayoutEditor.Controls.UIRadioButton;
                bool result = _AnimFrameSectionSetMnp.SetOutBinayLoopType( _TargetFrameSection, (AnimationLoopType)rb.Tag );
                // Debug.Assert( result );
            }
        }

        /// <summary>
        /// 対象グループを指定します。
        /// </summary>
        private void Event_BtnSetTargetGroup_Click( object sender, EventArgs e )
        {
            if( _TargetFrameSection != null && _TargetFrameSections != null)
            {
                var detectCheckedFunc = new Func<ILEGroup, bool>(
                    (group) => _TargetFrameSection.ExistTargetByName(group.GrouprName));

                var createListItemFunc = new Func<ILEGroup, ListViewItem>(
                    (group) =>
                    {
                        ListViewItem lvi = new ListViewItem();
                        lvi.Text = group.GrouprName;
                        lvi.Tag = group;
                        return lvi;
                    });

                SelectFromListDlg groupSelectDlg = new SelectFromListDlg();
                groupSelectDlg.Setup(_subScene.ILEGroupMgr.GroupSet, detectCheckedFunc, createListItemFunc);
                if (_subScene.ILEGroupMgr.GroupSet.Count() <= 0)
                {
                    groupSelectDlg.Text += StringResMgr.Get("ANIMTAG_LVW_EMPTYGROUP");
                }

                if( groupSelectDlg.ShowDialog( this ) == DialogResult.OK )
                {
                    List<ILEGroup> selectedGroupSet = new List<ILEGroup>();

                    foreach (ILEGroup targetItem in groupSelectDlg.GetSelectedSet<ILEGroup>())
                    {
                        ILEGroup group = _subScene.ILEGroupMgr.FindGroupByName(targetItem.GrouprName);
                        if (group != null)
                        {
                            selectedGroupSet.Add(group);
                        }
                    }

                    ISubScene subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
                    subScene.BeginMassiveModify();

                    foreach (ListViewItem item in _TargetFrameSections)
                    {
                        IAnimFrameSection section = item.Tag as IAnimFrameSection;

                        _AnimFrameSectionSetMnp.SetTagTargetGroup(
                            section,
                            selectedGroupSet.ToArray(),
                            _chkBindAnimationRecursively.Checked);
                    }

                    subScene.EndMassiveModify();
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_TbxGroup_Validated( object sender, EventArgs e )
        {
            // 文字列を解釈する
            string[] groupNameSet = _tbxGroup.Text.Split( ';' );

            // 解釈結果から、グループを列挙
            List<ILEGroup> groupSet = new List<ILEGroup>();
            foreach( string groupName in groupNameSet )
            {
                ILEGroup group = _subScene.ILEGroupMgr.FindGroupByName( groupName.Trim() );
                if( group != null && !groupSet.Contains( group ) )
                {
                    groupSet.Add( group );
                }
            }

            // 列挙したグループを設定
            _AnimFrameSectionSetMnp.SetTagTargetGroup(
                _TargetFrameSection,
                groupSet.ToArray(),
                _chkBindAnimationRecursively.Checked );
        }

        /// <summary>
        /// 再帰的に関連付ける
        /// </summary>
        private void Event_ChkBindAnimationRecursively_CheckedChanged( object sender, EventArgs e )
        {
            bool bBindAnimationRecursively = _chkBindAnimationRecursively.Checked;
            if( _TargetFrameSection.BindAnimationRecursively != bBindAnimationRecursively )
            {
                _AnimFrameSectionSetMnp.SetTagTargetGroup(
                    _TargetFrameSection,
                    _TargetFrameSection.TargetGroup,
                    bBindAnimationRecursively );
            }
        }

        /// <summary>
        /// 隠すフラグを再帰的にリセットします。
        /// </summary>
        void ResetHiddenFlagRecursive_( PaneManipulator paneMnp, IPane pane )
        {
            paneMnp.BindTarget( pane );
            paneMnp.Hidden = false;

            foreach( IPane child in pane.Children )
            {
                ResetHiddenFlagRecursive_( paneMnp, child );
            }
        }

        /// <summary>
        /// 対象グループ以外を隠す。
        /// </summary>
        private void Event_BtnHideOtherPane_Click( object sender, EventArgs e )
        {

            PaneManipulator paneMnp = new PaneManipulator();

            // 現在、隠されていないなら...
            if( !_IsPaneHidden )
            {
                // 対象以外のペインを隠します。
                if( _TargetFrameSection == null ||
                    _TargetFrameSection.TargetGroup.Length <= 0 )
                {
                    return;
                }

                // 現在の隠されたペインを記憶します。
                HashSet<IPane> hiddenPaneSet = new HashSet<IPane>();
                foreach ( IPane pane in _subScene.IPaneArray )
                {
                    if( pane.Hidden )
                    {
                        hiddenPaneSet.Add( pane );
                    }
                }

                // 対象ペインだけ表示状態にします。
                _subScene.BeginMassiveModify();
                foreach( IPane pane in _subScene.IPaneArray )
                {
                    paneMnp.BindTarget( pane );
                    paneMnp.Hidden = true;
                }
                foreach( ILEGroup group in _TargetFrameSection.TargetGroup )
                {
                    foreach( IPane pane in group.Member )
                    {
                        if( _TargetFrameSection.BindAnimationRecursively )
                        {
                            ResetHiddenFlagRecursive_( paneMnp, pane );
                        }
                        else
                        {
                            paneMnp.BindTarget( pane );
                            paneMnp.Hidden = false;
                        }
                    }
                }
                _subScene.EndMassiveModify();

                _hiddenPaneSet = hiddenPaneSet;
                _btnHideOtherPane.Text = StringResMgr.Get( "ANIMTAG_BTN_RESTORE_OTHERGROUP" );
            }
            else
            {
                // 隠したペインを元に戻します。
                HashSet<IPane> hiddenPaneSet = _hiddenPaneSet;
                Debug.Assert( hiddenPaneSet != null );

                _subScene.BeginMassiveModify();

                foreach( IPane pane in _subScene.IPaneArray )
                {
                    paneMnp.BindTarget( pane );
                    paneMnp.Hidden = hiddenPaneSet.Contains(pane);
                }

                _subScene.EndMassiveModify();

                _hiddenPaneSet = null;
                _btnHideOtherPane.Text = StringResMgr.Get( "ANIMTAG_BTN_HIDE_OTHERGROUP" );
            }
        }

        /// <summary>
        /// スプリットコンテナ・ダブルクリック
        /// </summary>
        private void Event_SplitContainer_DoubleClick( object sender, EventArgs e )
        {
            SplitContainer splitContainer = sender as SplitContainer;
            if( splitContainer == null )
            {
                return;
            }

            if( splitContainer.Panel1Collapsed )
            {
                splitContainer.Panel1Collapsed = false;
            }
            else if( sender == splitContainer.Panel2 )
            {
                splitContainer.Panel2Collapsed = !splitContainer.Panel2Collapsed;
            }
        }

        /// <summary>
        /// キーから自動設定ボタンハンドラ
        /// </summary>
        private void Event_BtnCheckAuto_Click(object sender, EventArgs e)
        {
            // 全てのアニメーション種類をチェックします。
            AnimFrameSectionSetHelper.SetOutBinayParamaterKindFromKeys(_ISubScene, _targetFrameSection);
        }

        /// <summary>
        /// 出力アニメーションループ種類チェック変更ハンドラ
        /// </summary>
        private void Event_RadLoopTypeOneTime_CheckedChanged( object sender, EventArgs e )
        {
            RadioButton rb = sender as RadioButton;

            if( rb.Checked )
            {
                _AnimFrameSectionSetMnp.SetOutBinayLoopType( _targetFrameSection, (AnimationLoopType)rb.Tag );
            }
        }

        /// <summary>
        /// 出力アニメーション種類チェック変更ハンドラ
        /// </summary>
        private void Event_ChkOutRlpa_CheckedChanged( object sender, EventArgs e )
        {
            if( _ReadyToModifyFrameSection )
            {
                CheckBox cb = sender as CheckBox;
                ParamaterKind mask = (ParamaterKind)cb.Tag;
                ParamaterKind flag = cb.Checked ? mask : ParamaterKind.None;
                ParamaterKind currentFlag = _TargetFrameSection.BinarySettings.TargetAnimKind;

                currentFlag = ( currentFlag & ~mask ) | flag;

                _AnimFrameSectionSetMnp.SetOutBinayParamaterKind( _targetFrameSection, currentFlag );
            }
        }

        /// <summary>
        /// 行ヘッダクリック
        /// </summary>
        private void Event_lvwFrameSectionSet_ColumnClick(object sender, ColumnClickEventArgs e)
        {
            UpdateUpDownButton_();
        }

        /// <summary>
        /// 非アクティブ
        /// </summary>
        private void AnimSectionTagWindow_Deactivate(object sender, EventArgs e)
        {
            // 編集を確定させる。
            _pnlAnimSectionBasic.ApplayChanges();
        }


        private void _btnUseTargetFrameSectionRangeAsPlayRange_Click(object sender, EventArgs e)
        {
            _UseTargetFrameSectionRangeAsPlayRange =
                !_UseTargetFrameSectionRangeAsPlayRange;
            SetUseTargetFrameSectionRangeAsPlayRange_();
            UpdateToolStripButton_();
        }

        /// <summary>
        /// ビューア転送時に再生範囲を自動的に調整する
        /// </summary>
        private void Event_btnAutoAdjustPlayRange_Click(object sender, EventArgs e)
        {
            _AutoAdjustPlayRange = !_AutoAdjustPlayRange;
            SetAutoAdjustPlayRange_();
            UpdateToolStripButton_();
        }

        /// <summary>
        /// 選択した区間に含まれるすべてのカーブをカーブエディタに表示する
        /// </summary>
        private void Event_btnAutoFocus_Click(object sender, EventArgs e)
        {
            if (_TargetFrameSections.Count != 1) return;

            // 選択された区間にカーブを持つペインを抽出
            var paneSet = _subScene.FindPanesByKeyFrame(int.MinValue, int.MaxValue, _TargetFrameSection.Name);

            // イベント通知
            var arg = new ViewManagerMessage(ViewManagerMessageKind.PreviewCurveInTargetTag, paneSet);
            DoSendMessageToViewManager(arg);
        }
        #endregion GUI イベントハンドラ

        protected override void OnVisibleChanged(EventArgs e)
        {
            SetUseTargetFrameSectionRangeAsPlayRange_();
            SetAutoAdjustPlayRange_();
            base.OnVisibleChanged(e);
        }

        private void SetUseTargetFrameSectionRangeAsPlayRange_()
        {
            // 分割モード中またはウインドウの表示中だけタグの範囲を再生範囲にできる
            LECore.Structures.Core.GlobalTime.Inst.UseTargetFrameSectionRangeAsPlayRange =
                Visible &&
                _UseTargetFrameSectionRangeAsPlayRange;
        }

        private void SetAutoAdjustPlayRange_()
        {
            LECore.Structures.Core.GlobalTime.Inst.AutoAdjustPlayRange = _AutoAdjustPlayRange && _subScene.IsAnimEditSeparateMode();
        }

        protected Color GetMultiEditColor()
        {
            return IsMulti != false ? Color.MintCream : SystemColors.Control;
        }
    }
}
