﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using LECore;

namespace LayoutEditor.Forms
{
    /// <summary>
    /// PreviewWaitingDlg の概要の説明です。
    /// </summary>
    public class MessageReportDlg : System.Windows.Forms.Form
    {
        #region デザイナ生成コード

        private Panel _pnlOKCancel;
        private Button _btnOkCancekCancel;
        private Button _btnOkCancelOk;
        private Panel _pnlOK;
        private Button _btnOkOk;
        private CheckBox _chkIgnoreSimilarMessage;
        private Panel _pnlCancel;
        private Button _btnCancel2;
        private TextBox _tbxMessage;

        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(MessageReportDlg));
            this._pnlOKCancel = new System.Windows.Forms.Panel();
            this._btnOkCancekCancel = new System.Windows.Forms.Button();
            this._btnOkCancelOk = new System.Windows.Forms.Button();
            this._pnlOK = new System.Windows.Forms.Panel();
            this._btnOkOk = new System.Windows.Forms.Button();
            this._tbxMessage = new System.Windows.Forms.TextBox();
            this._chkIgnoreSimilarMessage = new System.Windows.Forms.CheckBox();
            this._pnlCancel = new System.Windows.Forms.Panel();
            this._btnCancel2 = new System.Windows.Forms.Button();
            this._pnlOKCancel.SuspendLayout();
            this._pnlOK.SuspendLayout();
            this._pnlCancel.SuspendLayout();
            this.SuspendLayout();
            //
            // _pnlOKCancel
            //
            resources.ApplyResources(this._pnlOKCancel, "_pnlOKCancel");
            this._pnlOKCancel.Controls.Add(this._btnOkCancekCancel);
            this._pnlOKCancel.Controls.Add(this._btnOkCancelOk);
            this._pnlOKCancel.Name = "_pnlOKCancel";
            //
            // _btnOkCancekCancel
            //
            resources.ApplyResources(this._btnOkCancekCancel, "_btnOkCancekCancel");
            this._btnOkCancekCancel.Name = "_btnOkCancekCancel";
            this._btnOkCancekCancel.UseVisualStyleBackColor = true;
            this._btnOkCancekCancel.Click += new System.EventHandler(this.Event_BtnCancek_Click);
            //
            // _btnOkCancelOk
            //
            resources.ApplyResources(this._btnOkCancelOk, "_btnOkCancelOk");
            this._btnOkCancelOk.Name = "_btnOkCancelOk";
            this._btnOkCancelOk.UseVisualStyleBackColor = true;
            this._btnOkCancelOk.Click += new System.EventHandler(this.Event_BtnOk_Click);
            //
            // _pnlOK
            //
            resources.ApplyResources(this._pnlOK, "_pnlOK");
            this._pnlOK.Controls.Add(this._btnOkOk);
            this._pnlOK.Name = "_pnlOK";
            //
            // _btnOkOk
            //
            resources.ApplyResources(this._btnOkOk, "_btnOkOk");
            this._btnOkOk.Name = "_btnOkOk";
            this._btnOkOk.UseVisualStyleBackColor = true;
            this._btnOkOk.Click += new System.EventHandler(this.Event_BtnOk_Click);
            //
            // _tbxMessage
            //
            resources.ApplyResources(this._tbxMessage, "_tbxMessage");
            this._tbxMessage.Name = "_tbxMessage";
            this._tbxMessage.ReadOnly = true;
            //
            // _chkIgnoreSimilarMessage
            //
            resources.ApplyResources(this._chkIgnoreSimilarMessage, "_chkIgnoreSimilarMessage");
            this._chkIgnoreSimilarMessage.Name = "_chkIgnoreSimilarMessage";
            this._chkIgnoreSimilarMessage.UseVisualStyleBackColor = true;
            //
            // _pnlCancel
            //
            resources.ApplyResources(this._pnlCancel, "_pnlCancel");
            this._pnlCancel.Controls.Add(this._btnCancel2);
            this._pnlCancel.Name = "_pnlCancel";
            this._pnlCancel.Click += new System.EventHandler(this.Event_BtnCancek_Click);
            //
            // _btnCancel2
            //
            resources.ApplyResources(this._btnCancel2, "_btnCancel2");
            this._btnCancel2.Name = "_btnCancel2";
            this._btnCancel2.UseVisualStyleBackColor = true;
            this._btnCancel2.Click += new System.EventHandler(this.Event_BtnCancek_Click);
            //
            // MessageReportDlg
            //
            resources.ApplyResources(this, "$this");
            this.ControlBox = false;
            this.Controls.Add(this._chkIgnoreSimilarMessage);
            this.Controls.Add(this._tbxMessage);
            this.Controls.Add(this._pnlCancel);
            this.Controls.Add(this._pnlOK);
            this.Controls.Add(this._pnlOKCancel);
            this.Name = "MessageReportDlg";
            this.ShowIcon = false;
            this.ShowInTaskbar = false;
            this.Shown += new System.EventHandler(this.MessageReportDlg_Shown);
            this._pnlOKCancel.ResumeLayout(false);
            this._pnlOK.ResumeLayout(false);
            this._pnlCancel.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion デザイナ生成コード

        /// <summary>
        /// 表示ボタン種類
        /// </summary>
        public enum ButtonTypes
        {
            None,
            Ok,
            Cancel,
            OkCancel
        }

        /// <summary>
        /// メッセージ種類
        /// </summary>
        public enum MessageTypes
        {
            Always = 0,
            AnimConvert,
        }

        #region フィールド

        ButtonTypes _buttonType = ButtonTypes.Ok;
        ButtonTypes _defaultButtontype;

        #endregion フィールド

        #region プロパティ
        /// <summary>
        /// メッセージタイトル
        /// </summary>
        public string Title
        {
            set { this.Text = value; }
            get { return this.Text; }
        }

        /// <summary>
        /// メッセージ
        /// </summary>
        public string Message
        {
            set { _tbxMessage.Text = value; }
            get { return _tbxMessage.Text; }
        }

        /// <summary>
        /// メッセージ領域のTabStop
        /// </summary>
        public bool MessageTabStop
        {
            set { _tbxMessage.TabStop = value; }
        }

        /// <summary>
        /// メッセージ
        /// </summary>
        public string OKButtonText
        {
            set
            {
                _btnOkCancelOk.Text = value;
                _btnOkOk.Text = value;
            }

            get
            {
                return _btnOkCancelOk.Text;
            }
        }

        /// <summary>
        /// 以降同様のメッセージを無視する。
        /// </summary>
        public bool IgnoreSimilarMessage
        {
            get { return _chkIgnoreSimilarMessage.Checked; }
        }

        /// <summary>
        /// チェックボックス(有効/無効)
        /// </summary>
        public bool ChkIgnoreSimilarMessageEnabled
        {
            set { _chkIgnoreSimilarMessage.Enabled = value; }
        }

        /// <summary>
        /// チェックボックス(On/Off)
        /// </summary>
        public bool ChkIgnoreSimilarMessageChecked
        {
            set { _chkIgnoreSimilarMessage.Checked = value; }
        }

        /// <summary>
        /// ボタンの種類
        /// </summary>
        public ButtonTypes ButtonType
        {
            get
            {
                return _buttonType;
            }

            set
            {
                _buttonType = value;

                switch (_buttonType)
                {
                    case ButtonTypes.None:
                        _pnlOK.Visible = false;
                        _pnlCancel.Visible = false;
                        _pnlOKCancel.Visible = false;
                        break;
                    case ButtonTypes.Ok:
                        _pnlOK.Visible = true;
                        _pnlCancel.Visible = false;
                        _pnlOKCancel.Visible = false;
                        break;
                    case ButtonTypes.Cancel:
                        _pnlOK.Visible = false;
                        _pnlCancel.Visible = true;
                        _pnlOKCancel.Visible = false;
                        break;
                    case ButtonTypes.OkCancel:
                        _pnlOK.Visible = false;
                        _pnlCancel.Visible = false;
                        _pnlOKCancel.Visible = true;
                        break;
                }
            }
        }

        #endregion プロパティ


        #region コンストラクタ
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public MessageReportDlg( ButtonTypes buttonType, bool bShowIgnoreSimilarMessageCheckBox )
        {
            InitializeComponent();

            _pnlOK.Visible = false;
            _pnlCancel.Visible = false;
            _pnlOKCancel.Visible = false;
            this._defaultButtontype = buttonType;
            this.ButtonType = buttonType;


            _chkIgnoreSimilarMessage.Visible = bShowIgnoreSimilarMessageCheckBox;
        }
        #endregion コンストラクタ

        #region ボタンハンドラ
        /// <summary>
        /// OK
        /// </summary>
        private void Event_BtnOk_Click( object sender, EventArgs e )
        {
            DialogResult = DialogResult.OK;
        }

        /// <summary>
        /// Cancel
        /// </summary>
        private void Event_BtnCancek_Click( object sender, EventArgs e )
        {
            DialogResult = DialogResult.Cancel;
        }
        #endregion ボタンハンドラ

        private void MessageReportDlg_Shown(object sender, EventArgs e)
        {
            _tbxMessage.Select(0, 0);

            string[] lines = _tbxMessage.Text.Split(Environment.NewLine.ToCharArray());

            var gfx = Graphics.FromHwnd(this.Handle);

            float maxW = 0.0f;
            float maxH = 0.0f;

            foreach(var line in lines)
            {
                SizeF lineRect = gfx.MeasureString(line, _tbxMessage.Font);
                maxW = Math.Max(maxW, lineRect.Width);
                maxH = Math.Max(maxH, lineRect.Height);
            }

            float BottomSize = this.Height - _tbxMessage.Bottom;

            this.Width = (int)Math.Min(Screen.PrimaryScreen.WorkingArea.Width * 0.5f, maxW * 1.1f);
            this.Height = (int)Math.Min(Screen.PrimaryScreen.WorkingArea.Height * 0.5f, (maxH * lines.Length * 1.1f) + BottomSize);
        }

    }

    public class LayoutEditorMessageArgs : MessageArgs
    {
        public MessageReportDlg.MessageTypes messageType;
        public MessageReportDlg.ButtonTypes buttonType;
        public bool chkIgnoreSimilarMessageEnabled;
    }
}
