﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace LayoutEditor.Controls
{
    using LECore.Structures;

    /// <summary>
    /// カラーデータ
    /// </summary>
    public class ColorData
    {
        FloatColor _color;
        string _comment;

        public FloatColor Color
        {
            get { return _color; }
            set { _color = value; }
        }

        public string ColorString
        {
            get { return string.Format( "{0, 3}, {1, 3}, {2, 3}, {3, 3}", _color.R, _color.G, _color.B, _color.A ); }
        }

        public string Comment
        {
            get { return _comment; }
            set { _comment = value; }
        }


        static public bool CheckDropItemHasColorData( DragEventArgs e )
        {
            ColorData dummy;
            return TryToGetColorDataFromDropItem( e, out dummy );
        }

        static public bool CheckDropItemHasColorData( DragEventArgs e, ColorEditPanel.DragDropAction action )
        {
            Tuple<ColorData, ColorEditPanel.DragDropAction> dummy;
            if ( !TryToGetColorDataFromDropItem( e, out dummy ) )
            {
                return false;
            }

            return (dummy.Item2 == action);
        }

        static public bool CheckDropItemHasColorDataWithAction(DragEventArgs e)
        {
            Tuple<ColorData, ColorEditPanel.DragDropAction> dummy;
            return TryToGetColorDataFromDropItem( e, out dummy );
        }

        static public bool TryToGetColorDataFromDropItem( DragEventArgs e, out ColorData colorData )
        {
            colorData = e.Data.GetData( typeof( ColorData ) ) as ColorData;
            return colorData != null;
        }

        static public bool TryToGetColorDataFromDropItem( DragEventArgs e, out Tuple<ColorData, ColorEditPanel.DragDropAction> data )
        {
            data = e.Data.GetData( typeof( Tuple<ColorData, ColorEditPanel.DragDropAction> ) ) as Tuple<ColorData, ColorEditPanel.DragDropAction>;
            return data != null;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ColorData()
            : this( FloatColor.Empty, string.Empty )
        {

        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ColorData(FloatColor color, string commnet )
        {
            _color = color;
            _comment = commnet;
        }
    }
}
