﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace LayoutEditor.Controls.UI
{
    /// <summary>
    /// ＵＩコンテキストメニューストリップクラス。
    /// </summary>
    [ToolboxBitmap(typeof(ContextMenuStrip))]
    public class UIContextMenuStrip : ContextMenuStrip
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UIContextMenuStrip()
        {
        }
    }

    /// <summary>
    /// フォーカスが無い場合も、クリックを処理できるツールストリップ
    /// (参考：How to enable "click through" for .NET 2.0 ToolStrip and MenuStrip
    /// http://blogs.msdn.com/b/rickbrew/archive/2006/01/09/511003.aspx)
    /// </summary>
    public class UIToolStrip : ToolStrip
    {
        /// <summary>
        /// フォーカスが無い場合も、クリックを処理するかどうか。false なら通常の ToolStrip と同じ処理。
        /// </summary>
        public bool ClickThrough { get; set; }

        protected override void WndProc(ref Message m)
        {
            base.WndProc(ref m);

            if (this.ClickThrough && m.Msg == LECore.Win32.WM.WM_MOUSEACTIVATE && m.Result == (IntPtr)LECore.Win32.MA.MA_ACTIVATEANDEAT)
            {
                m.Result = (IntPtr)LECore.Win32.MA.MA_ACTIVATE;
            }
        }
    }
}
