﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LayoutEditor.src.Controls
{
    public partial class BindAnimationCheckBox : CheckBox
        , IAnimationMarkUsable
    {
        #region フィールド

        private ContextMenuStrip contextMenuStrip1;
        private AnimationMark _ownerPanel;

        private bool _useContextMenu = false;

        /// <summary>
        /// 必要なデザイナー変数です。
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        #endregion

        #region プロパティ

        /// <summary>
        /// コンテキストメニューを表示するか。
        /// </summary>
        public bool UseContextMenu
        {
            get { return _useContextMenu; }
            set
            {
                _useContextMenu = value;
                ContextMenuStrip = _useContextMenu ? contextMenuStrip1 : null;
            }
        }

        #endregion

        #region IAnimationMarkUsableメンバ

        /// <summary>
        /// アニメーションマークを利用するか
        /// </summary>
        public bool UseAnimationMark
        {
            get { return UseContextMenu; }
            set { UseContextMenu = value; }
        }

        /// <summary>
        /// アニメーションマークを更新します
        /// </summary>
        public void UpdateAnimationMark() { }

        #endregion

        public BindAnimationCheckBox()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 使用中のリソースをすべてクリーンアップします。
        /// </summary>
        /// <param name="disposing">マネージ リソースを破棄する場合は true を指定し、その他の場合は false を指定します。</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        #region コンポーネント デザイナーで生成されたコード

        /// <summary>
        /// デザイナー サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディターで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            this.contextMenuStrip1 = new System.Windows.Forms.ContextMenuStrip(this.components);
            this.SuspendLayout();
            //
            // contextMenuStrip1
            //
            this.contextMenuStrip1.Name = "contextMenuStrip1";
            this.ResumeLayout(false);

        }

        #endregion

        /// <summary>
        /// AnimationMarkを関連付けます。
        /// </summary>
        public void BindAnimationMark(AnimationMark owner)
        {
            _ownerPanel = owner;
            BindContextMenuStrip(_ownerPanel.ContextMenuStripInst);
        }

        /// <summary>
        /// コンテキストメニューを関連付けます。
        /// </summary>
        private void BindContextMenuStrip(ContextMenuStrip menuStrip)
        {
            contextMenuStrip1 = menuStrip;
            ContextMenuStrip = contextMenuStrip1;
        }

        #region オーバーライド

        protected override void OnMouseEnter(EventArgs e)
        {
            base.OnMouseEnter(e);

            if (_useContextMenu)
            {
                this.Cursor = AnimationMark.MouseOverCursor;
            }
        }

        protected override void OnMouseLeave(EventArgs e)
        {
            base.OnMouseLeave(e);

            this.Cursor = System.Windows.Forms.Cursors.Default;
        }

        #endregion
    }
}
